/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.NoSubscriptionServersAvailableException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.SubscriptionNotEnabledException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.AuthenticateUserOp;
import org.apache.geode.cache.client.internal.AutoConnectionSourceImpl;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionFactoryImpl;
import org.apache.geode.cache.client.internal.ConnectionSource;
import org.apache.geode.cache.client.internal.DataSerializerRecoveryListener;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.EndpointManagerImpl;
import org.apache.geode.cache.client.internal.ExplicitConnectionSourceImpl;
import org.apache.geode.cache.client.internal.InstantiatorRecoveryListener;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.LiveServerPinger;
import org.apache.geode.cache.client.internal.LocatorDiscoveryCallback;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.OpExecutorImpl;
import org.apache.geode.cache.client.internal.PdxRegistryRecoveryListener;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.client.internal.QueueManager;
import org.apache.geode.cache.client.internal.QueueManagerImpl;
import org.apache.geode.cache.client.internal.QueueStateImpl;
import org.apache.geode.cache.client.internal.RegisterInterestTracker;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.client.internal.pooling.ConnectionManager;
import org.apache.geode.cache.client.internal.pooling.ConnectionManagerImpl;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.PoolCancelledException;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.gms.membership.HostAddress;
import org.apache.geode.internal.ScheduledThreadPoolExecutorWithKeepAlive;
import org.apache.geode.internal.admin.ClientStatsManager;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PoolFactoryImpl;
import org.apache.geode.internal.cache.PoolManagerImpl;
import org.apache.geode.internal.cache.PoolStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.statistics.DummyStatisticsFactory;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class PoolImpl
implements InternalPool {
    public static final String ON_DISCONNECT_CLEAR_PDXTYPEIDS = "gemfire.ON_DISCONNECT_CLEAR_PDXTYPEIDS";
    private static final Logger logger = LogService.getLogger();
    public static final long SHUTDOWN_TIMEOUT = Long.getLong("gemfire.PoolImpl.SHUTDOWN_TIMEOUT", 30000L);
    private static final int BACKGROUND_TASK_POOL_SIZE = Integer.getInteger("gemfire.PoolImpl.BACKGROUND_TASK_POOL_SIZE", 20);
    private static final int BACKGROUND_TASK_POOL_KEEP_ALIVE = Integer.getInteger("gemfire.PoolImpl.BACKGROUND_TASK_POOL_KEEP_ALIVE", 1000);
    public static volatile boolean TEST_DURABLE_IS_NET_DOWN = false;
    private final String name;
    private final int socketConnectTimeout;
    private final int freeConnectionTimeout;
    private final int loadConditioningInterval;
    private final int socketBufferSize;
    private final boolean threadLocalConnections;
    private final int readTimeout;
    private final boolean subscriptionEnabled;
    private final boolean prSingleHopEnabled;
    private final int subscriptionRedundancyLevel;
    private final int subscriptionMessageTrackingTimeout;
    private final int subscriptionAckInterval;
    private final String serverGroup;
    private final List<HostAddress> locatorAddresses;
    private final List<InetSocketAddress> locators;
    private final List<InetSocketAddress> servers;
    private final boolean startDisabled;
    private final boolean usedByGateway;
    private final int maxConnections;
    private final int minConnections;
    private final int retryAttempts;
    private final long idleTimeout;
    private final long pingInterval;
    private final int statisticInterval;
    private final boolean multiuserSecureModeEnabled;
    private final ConnectionSource source;
    private final ConnectionManager manager;
    private QueueManager queueManager;
    protected final EndpointManager endpointManager;
    private final PoolManagerImpl pm;
    protected final InternalLogWriter securityLogWriter;
    protected volatile boolean destroyed;
    private final PoolStats stats;
    private ScheduledExecutorService backgroundProcessor;
    private final OpExecutorImpl executor;
    private final RegisterInterestTracker riTracker = new RegisterInterestTracker();
    private final InternalDistributedSystem dsys;
    private final ClientProxyMembershipID proxyId;
    protected final CancelCriterion cancelCriterion;
    private final ConnectionFactoryImpl connectionFactory;
    private final ArrayList<ProxyCache> proxyCacheList;
    private final GatewaySender gatewaySender;
    private boolean keepAlive = false;
    private static Object simpleLock = new Object();
    public static final int PRIMARY_QUEUE_NOT_AVAILABLE = -2;
    public static final int PRIMARY_QUEUE_TIMED_OUT = -1;
    private AtomicInteger primaryQueueSize = new AtomicInteger(-2);
    private boolean declaredInXML;
    private boolean readyForEventsCalled;
    private final AtomicInteger attachCount = new AtomicInteger();
    public static volatile boolean IS_INSTANTIATOR_CALLBACK = false;
    public static volatile boolean AFTER_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG = false;
    public static volatile boolean BEFORE_REGISTER_CALLBACK_FLAG = false;
    public static volatile boolean BEFORE_RECOVER_INTEREST_CALLBACK_FLAG = false;
    public static volatile boolean AFTER_REGISTER_CALLBACK_FLAG = false;
    public static volatile boolean BEFORE_PRIMARY_IDENTIFICATION_FROM_BACKUP_CALLBACK_FLAG = false;
    public static volatile boolean BEFORE_SENDING_CLIENT_ACK_CALLBACK_FLAG = false;
    public static volatile boolean AFTER_QUEUE_DESTROY_MESSAGE_FLAG = false;
    public static volatile boolean AFTER_PRIMARY_RECOVERED_CALLBACK_FLAG = false;
    private volatile CancelCriterion cacheCriterion = null;

    public static PoolImpl create(PoolManagerImpl pm, String name, Pool attributes, List<HostAddress> locatorAddresses) {
        PoolImpl pool = new PoolImpl(pm, name, attributes, locatorAddresses);
        pool.finishCreate(pm);
        return pool;
    }

    public boolean isUsedByGateway() {
        return this.usedByGateway;
    }

    protected void finishCreate(PoolManagerImpl pm) {
        pm.register(this);
        try {
            this.start();
        }
        catch (RuntimeException e) {
            try {
                this.destroy(false);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw e;
        }
    }

    protected PoolImpl(PoolManagerImpl pm, String name, Pool attributes, List<HostAddress> locAddresses) {
        this.pm = pm;
        this.name = name;
        this.socketConnectTimeout = attributes.getSocketConnectTimeout();
        this.freeConnectionTimeout = attributes.getFreeConnectionTimeout();
        this.loadConditioningInterval = attributes.getLoadConditioningInterval();
        this.socketBufferSize = attributes.getSocketBufferSize();
        this.threadLocalConnections = attributes.getThreadLocalConnections();
        this.readTimeout = attributes.getReadTimeout();
        this.minConnections = attributes.getMinConnections();
        this.maxConnections = attributes.getMaxConnections();
        this.retryAttempts = attributes.getRetryAttempts();
        this.idleTimeout = attributes.getIdleTimeout();
        this.pingInterval = attributes.getPingInterval();
        this.statisticInterval = attributes.getStatisticInterval();
        this.subscriptionEnabled = attributes.getSubscriptionEnabled();
        this.prSingleHopEnabled = attributes.getPRSingleHopEnabled();
        this.subscriptionRedundancyLevel = attributes.getSubscriptionRedundancy();
        this.subscriptionMessageTrackingTimeout = attributes.getSubscriptionMessageTrackingTimeout();
        this.subscriptionAckInterval = attributes.getSubscriptionAckInterval();
        this.serverGroup = attributes.getServerGroup();
        this.multiuserSecureModeEnabled = attributes.getMultiuserAuthentication();
        this.locatorAddresses = locAddresses;
        this.locators = attributes.getLocators();
        this.servers = attributes.getServers();
        this.startDisabled = ((PoolFactoryImpl.PoolAttributes)attributes).startDisabled || !pm.isNormal();
        this.usedByGateway = ((PoolFactoryImpl.PoolAttributes)attributes).isGateway();
        this.gatewaySender = ((PoolFactoryImpl.PoolAttributes)attributes).getGatewaySender();
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        if (ds == null) {
            throw new IllegalStateException(LocalizedStrings.PoolImpl_DISTRIBUTED_SYSTEM_MUST_BE_CREATED_BEFORE_CREATING_POOL.toLocalizedString());
        }
        this.securityLogWriter = ds.getSecurityInternalLogWriter();
        if (!ds.getConfig().getStatisticSamplingEnabled() && this.statisticInterval > 0) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.PoolImpl_STATISTIC_SAMPLING_MUST_BE_ENABLED_FOR_SAMPLING_RATE_OF_0_TO_TAKE_AFFECT, this.statisticInterval));
        }
        this.dsys = ds;
        this.cancelCriterion = new Stopper();
        if (Boolean.getBoolean("gemfire.SPECIAL_DURABLE")) {
            ClientProxyMembershipID.setPoolName(name);
            this.proxyId = ClientProxyMembershipID.getNewProxyMembership(ds);
            ClientProxyMembershipID.setPoolName(null);
        } else {
            this.proxyId = ClientProxyMembershipID.getNewProxyMembership(ds);
        }
        StatisticsFactory statFactory = null;
        statFactory = this.gatewaySender != null ? new DummyStatisticsFactory() : ds;
        this.stats = this.startDisabled ? null : new PoolStats(statFactory, this.getName() + "->" + (StringUtils.isEmpty((String)this.serverGroup) ? "[any servers]" : "[" + this.getServerGroup() + "]"));
        this.source = this.getSourceImpl(((PoolFactoryImpl.PoolAttributes)attributes).locatorCallback);
        this.endpointManager = new EndpointManagerImpl(name, ds, this.cancelCriterion, this.stats);
        this.connectionFactory = new ConnectionFactoryImpl(this.source, this.endpointManager, ds, this.socketBufferSize, this.socketConnectTimeout, this.readTimeout, this.proxyId, this.cancelCriterion, this.usedByGateway, this.gatewaySender, this.pingInterval, this.multiuserSecureModeEnabled, this);
        if (this.subscriptionEnabled) {
            this.queueManager = new QueueManagerImpl(this, this.endpointManager, this.source, this.connectionFactory, this.subscriptionRedundancyLevel, this.pingInterval, this.securityLogWriter, this.proxyId);
        }
        this.manager = new ConnectionManagerImpl(name, this.connectionFactory, this.endpointManager, this.maxConnections, this.minConnections, this.idleTimeout, this.loadConditioningInterval, this.securityLogWriter, this.pingInterval, this.cancelCriterion, this.getStats());
        this.executor = new OpExecutorImpl(this.manager, this.queueManager, this.endpointManager, this.riTracker, this.retryAttempts, this.freeConnectionTimeout, this.threadLocalConnections, new PoolOrCacheStopper(), this);
        this.proxyCacheList = this.multiuserSecureModeEnabled ? new ArrayList() : null;
    }

    public boolean isCompatible(Pool p) {
        if (p == null) {
            return false;
        }
        return this.getFreeConnectionTimeout() == p.getFreeConnectionTimeout() && this.getSocketConnectTimeout() == p.getSocketConnectTimeout() && this.getLoadConditioningInterval() == p.getLoadConditioningInterval() && this.getSocketBufferSize() == p.getSocketBufferSize() && this.getMinConnections() == p.getMinConnections() && this.getMaxConnections() == p.getMaxConnections() && this.getIdleTimeout() == p.getIdleTimeout() && this.getPingInterval() == p.getPingInterval() && this.getStatisticInterval() == p.getStatisticInterval() && this.getRetryAttempts() == p.getRetryAttempts() && this.getThreadLocalConnections() == p.getThreadLocalConnections() && this.getReadTimeout() == p.getReadTimeout() && this.getSubscriptionEnabled() == p.getSubscriptionEnabled() && this.getPRSingleHopEnabled() == p.getPRSingleHopEnabled() && this.getSubscriptionRedundancy() == p.getSubscriptionRedundancy() && this.getSubscriptionMessageTrackingTimeout() == p.getSubscriptionMessageTrackingTimeout() && this.getSubscriptionAckInterval() == p.getSubscriptionAckInterval() && this.getServerGroup().equals(p.getServerGroup()) && this.getMultiuserAuthentication() == p.getMultiuserAuthentication() && this.getLocators().equals(p.getLocators()) && this.getServers().equals(p.getServers());
    }

    private void start() {
        if (this.startDisabled) {
            return;
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            List<InetSocketAddress> locators = this.getLocators();
            if (!locators.isEmpty()) {
                logger.debug("PoolImpl - starting pool with locators: {}", locators);
            } else {
                logger.debug("PoolImpl -starting pool with servers: {}", this.getServers());
            }
        }
        final String timerName = "poolTimer-" + this.getName() + "-";
        this.backgroundProcessor = new ScheduledThreadPoolExecutorWithKeepAlive(BACKGROUND_TASK_POOL_SIZE, BACKGROUND_TASK_POOL_KEEP_ALIVE, TimeUnit.MILLISECONDS, new ThreadFactory(){
            AtomicInteger threadNum = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread result = new Thread(r, timerName + this.threadNum.incrementAndGet());
                result.setDaemon(true);
                return result;
            }
        });
        ((ScheduledThreadPoolExecutorWithKeepAlive)this.backgroundProcessor).setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        ((ScheduledThreadPoolExecutorWithKeepAlive)this.backgroundProcessor).setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.source.start(this);
        this.connectionFactory.start(this.backgroundProcessor);
        this.endpointManager.addListener(new InstantiatorRecoveryListener(this.backgroundProcessor, this));
        this.endpointManager.addListener(new DataSerializerRecoveryListener(this.backgroundProcessor, this));
        if (Boolean.getBoolean(ON_DISCONNECT_CLEAR_PDXTYPEIDS)) {
            this.endpointManager.addListener(new PdxRegistryRecoveryListener(this));
        }
        this.endpointManager.addListener(new LiveServerPinger(this));
        this.manager.start(this.backgroundProcessor);
        if (this.queueManager != null) {
            if (isDebugEnabled) {
                logger.debug("starting queueManager");
            }
            this.queueManager.start(this.backgroundProcessor);
        }
        if (isDebugEnabled) {
            logger.debug("scheduling pings every {} milliseconds", (Object)this.pingInterval);
        }
        if (this.statisticInterval > 0 && this.dsys.getConfig().getStatisticSamplingEnabled()) {
            this.backgroundProcessor.scheduleWithFixedDelay(new PublishClientStatsTask(), this.statisticInterval, this.statisticInterval, TimeUnit.MILLISECONDS);
        }
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.PoolImpl_POOL_0_STARTED_WITH_MULTIUSER_SECURE_MODE_ENABLED_1, new Object[]{this.name, this.multiuserSecureModeEnabled}));
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.cancelCriterion;
    }

    @Override
    public void releaseThreadLocalConnection() {
        this.executor.releaseThreadLocalConnection();
    }

    @Override
    public void setupServerAffinity(boolean allowFailover) {
        this.executor.setupServerAffinity(allowFailover);
    }

    @Override
    public void releaseServerAffinity() {
        this.executor.releaseServerAffinity();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSocketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    @Override
    public int getFreeConnectionTimeout() {
        return this.freeConnectionTimeout;
    }

    @Override
    public int getLoadConditioningInterval() {
        return this.loadConditioningInterval;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public int getMinConnections() {
        return this.minConnections;
    }

    @Override
    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public long getPingInterval() {
        return this.pingInterval;
    }

    @Override
    public int getStatisticInterval() {
        return this.statisticInterval;
    }

    @Override
    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    @Override
    public boolean getThreadLocalConnections() {
        return this.threadLocalConnections;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public boolean getSubscriptionEnabled() {
        return this.subscriptionEnabled;
    }

    @Override
    public boolean getPRSingleHopEnabled() {
        return this.prSingleHopEnabled;
    }

    @Override
    public int getSubscriptionRedundancy() {
        return this.subscriptionRedundancyLevel;
    }

    @Override
    public int getSubscriptionMessageTrackingTimeout() {
        return this.subscriptionMessageTrackingTimeout;
    }

    @Override
    public int getSubscriptionAckInterval() {
        return this.subscriptionAckInterval;
    }

    @Override
    public String getServerGroup() {
        return this.serverGroup;
    }

    @Override
    public boolean getMultiuserAuthentication() {
        return this.multiuserSecureModeEnabled;
    }

    @Override
    public List<InetSocketAddress> getLocators() {
        return this.locators;
    }

    @Override
    public List<InetSocketAddress> getOnlineLocators() {
        return this.source.getOnlineLocators();
    }

    @Override
    public List<InetSocketAddress> getServers() {
        return this.servers;
    }

    public GatewaySender getGatewaySender() {
        return this.gatewaySender;
    }

    public InternalLogWriter getSecurityInternalLogWriter() {
        return this.securityLogWriter;
    }

    @Override
    public void destroy() {
        this.destroy(false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.getClass().getSimpleName()).append('@').append(System.identityHashCode(this)).append(" name=").append(this.getName());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(boolean keepAlive) {
        int cnt = this.getAttachCount();
        this.keepAlive = keepAlive;
        boolean SPECIAL_DURABLE = Boolean.getBoolean("gemfire.SPECIAL_DURABLE");
        if (cnt > 0) {
            if (SPECIAL_DURABLE) {
                Object object = simpleLock;
                synchronized (object) {
                    block16: {
                        try {
                            if (!CacheFactory.getAnyInstance().isClosed() && this.getPoolOrCacheCancelInProgress() == null) {
                                Set<Region<?, ?>> regions = CacheFactory.getInstance(this.dsys).rootRegions();
                                for (Region<?, ?> roots : regions) {
                                    Set<Region<?, ?>> subregions = roots.subregions(true);
                                    for (Region<?, ?> subroots : subregions) {
                                        if (subroots.isDestroyed() || subroots.getAttributes().getPoolName() == null || !subroots.getAttributes().getPoolName().equals(this.name)) continue;
                                        if (logger.isDebugEnabled()) {
                                            logger.debug("PoolImpl.destroy[ Region connected count:{} Region subroot closing:{} Pool Name:{} ]", (Object)cnt, (Object)subroots.getName(), (Object)this.name);
                                        }
                                        subroots.close();
                                    }
                                    if (roots.isDestroyed() || roots.getAttributes().getPoolName() == null || !roots.getAttributes().getPoolName().equals(this.name)) continue;
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("PoolImpl.destroy[ Region connected count:{} Region root closing:{} Pool Name:{} ]", (Object)cnt, (Object)roots.getName(), (Object)this.name);
                                    }
                                    roots.close();
                                }
                            }
                        }
                        catch (CacheClosedException ccex) {
                            if (logger.isDebugEnabled()) {
                                logger.debug(ccex.getMessage(), (Throwable)ccex);
                            }
                        }
                        catch (Exception ex) {
                            if (!logger.isDebugEnabled()) break block16;
                            logger.debug(ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
            }
            if ((cnt = this.getAttachCount()) > 0) {
                throw new IllegalStateException(LocalizedStrings.PoolImpl_POOL_COULD_NOT_BE_DESTROYED_BECAUSE_IT_IS_STILL_IN_USE_BY_0_REGIONS.toLocalizedString(cnt));
            }
        }
        if (this.pm.unregister(this)) {
            this.basicDestroy(keepAlive);
        }
    }

    public synchronized void basicDestroy(boolean keepAlive) {
        if (!this.isDestroyed()) {
            this.destroyed = true;
            this.keepAlive = keepAlive;
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.PoolImpl_DESTROYING_CONNECTION_POOL_0, this.name));
            try {
                if (this.backgroundProcessor != null) {
                    this.backgroundProcessor.shutdown();
                    if (!this.backgroundProcessor.awaitTermination(SHUTDOWN_TIMEOUT, TimeUnit.MILLISECONDS)) {
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.PoolImpl_TIMEOUT_WAITING_FOR_BACKGROUND_TASKS_TO_COMPLETE));
                    }
                }
            }
            catch (RuntimeException e) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.PoolImpl_ERROR_ENCOUNTERED_WHILE_STOPPING_BACKGROUNDPROCESSOR), (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.PoolImpl_INTERRUPTED_WHILE_STOPPING_BACKGROUNDPROCESSOR), (Throwable)e);
            }
            try {
                if (this.source != null) {
                    this.source.stop();
                }
            }
            catch (RuntimeException e) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.PoolImpl_ERROR_ENCOUNTERED_WHILE_STOPPING_CONNECTION_SOURCE), (Throwable)e);
            }
            try {
                if (this.queueManager != null) {
                    this.queueManager.close(keepAlive);
                }
            }
            catch (RuntimeException e) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.PoolImpl_ERROR_ENCOUNTERED_WHILE_STOPPING_SUBSCRIPTION_MANAGER), (Throwable)e);
            }
            try {
                if (this.manager != null) {
                    this.manager.close(keepAlive);
                }
            }
            catch (RuntimeException e) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.PoolImpl_ERROR_ENCOUNTERED_WHILE_STOPPING_CONNECTION_MANAGER), (Throwable)e);
            }
            try {
                this.endpointManager.close();
            }
            catch (RuntimeException e) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.PoolImpl_ERROR_ENCOUNTERED_WHILE_STOPPING_ENDPOINT_MANAGER), (Throwable)e);
            }
            try {
                if (this.stats != null) {
                    this.stats.close();
                }
            }
            catch (RuntimeException e) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.PoolImpl_ERROR_WHILE_CLOSING_STATISTICS), (Throwable)e);
            }
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private ConnectionSource getSourceImpl(LocatorDiscoveryCallback locatorDiscoveryCallback) {
        List<InetSocketAddress> locators = this.getLocators();
        if (locators.isEmpty()) {
            return new ExplicitConnectionSourceImpl(this.getServers());
        }
        AutoConnectionSourceImpl source = new AutoConnectionSourceImpl(locators, this.locatorAddresses, this.getServerGroup(), this.socketConnectTimeout);
        if (locatorDiscoveryCallback != null) {
            source.setLocatorDiscoveryCallback(locatorDiscoveryCallback);
        }
        return source;
    }

    public void sameAs(Object obj) {
        if (!(obj instanceof PoolImpl)) {
            throw new RuntimeException(LocalizedStrings.PoolImpl__0_IS_NOT_THE_SAME_AS_1_BECAUSE_IT_SHOULD_HAVE_BEEN_A_POOLIMPL.toLocalizedString(this, obj));
        }
        PoolImpl other = (PoolImpl)obj;
        if (!this.getName().equals(other.getName())) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_ARE_DIFFERENT.toLocalizedString("names"));
        }
        if (this.getSocketConnectTimeout() != other.getSocketConnectTimeout()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("socketConnectimeout"));
        }
        if (this.getFreeConnectionTimeout() != other.getFreeConnectionTimeout()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("connectionTimeout"));
        }
        if (this.getLoadConditioningInterval() != other.getLoadConditioningInterval()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("connectionLifetime"));
        }
        if (this.getSocketBufferSize() != other.getSocketBufferSize()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("socketBufferSize"));
        }
        if (this.getThreadLocalConnections() != other.getThreadLocalConnections()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("threadLocalConnections"));
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("readTimeout"));
        }
        if (this.getMinConnections() != other.getMinConnections()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("MinConnections"));
        }
        if (this.getMaxConnections() != other.getMaxConnections()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("MaxConnections"));
        }
        if (this.getRetryAttempts() != other.getRetryAttempts()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("RetryAttempts"));
        }
        if (this.getIdleTimeout() != other.getIdleTimeout()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("IdleTimeout"));
        }
        if (this.getPingInterval() != other.getPingInterval()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("PingInterval"));
        }
        if (this.getStatisticInterval() != other.getStatisticInterval()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("StatisticInterval"));
        }
        if (this.getSubscriptionAckInterval() != other.getSubscriptionAckInterval()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("subscriptionAckInterval"));
        }
        if (this.getSubscriptionEnabled() != other.getSubscriptionEnabled()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("subscriptionEnabled"));
        }
        if (this.getSubscriptionMessageTrackingTimeout() != other.getSubscriptionMessageTrackingTimeout()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("subscriptionMessageTrackingTimeout"));
        }
        if (this.getSubscriptionRedundancy() != other.getSubscriptionRedundancy()) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("subscriptionRedundancyLevel"));
        }
        if (!this.getServerGroup().equals(other.getServerGroup())) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_IS_DIFFERENT.toLocalizedString("serverGroup"));
        }
        if (!this.getLocators().equals(other.getLocators())) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_ARE_DIFFERENT.toLocalizedString("locators"));
        }
        if (!this.getServers().equals(other.getServers())) {
            throw new RuntimeException(LocalizedStrings.PoolImpl_0_ARE_DIFFERENT.toLocalizedString("servers"));
        }
    }

    @Override
    public PoolStats getStats() {
        return this.stats;
    }

    @Override
    public Object execute(Op op) {
        this.authenticateIfRequired(op);
        return this.executor.execute(op);
    }

    @Override
    public Object execute(Op op, int retries) {
        this.authenticateIfRequired(op);
        return this.executor.execute(op, retries);
    }

    @Override
    public Object executeOn(ServerLocation server, Op op) {
        this.authenticateIfRequired(server, op);
        return this.executor.executeOn(server, op);
    }

    @Override
    public Object executeOn(ServerLocation server, Op op, boolean accessed, boolean onlyUseExistingCnx) {
        this.authenticateIfRequired(server, op);
        return this.executor.executeOn(server, op, accessed, onlyUseExistingCnx);
    }

    @Override
    public Object executeOn(Connection con, Op op) {
        this.authenticateIfRequired(con.getServer(), op);
        return this.executor.executeOn(con, op);
    }

    @Override
    public Object executeOn(Connection con, Op op, boolean timeoutFatal) {
        return this.executor.executeOn(con, op, timeoutFatal);
    }

    @Override
    public Object executeOnQueuesAndReturnPrimaryResult(Op op) {
        this.authenticateOnAllServers(op);
        return this.executor.executeOnQueuesAndReturnPrimaryResult(op);
    }

    @Override
    public void executeOnAllQueueServers(Op op) throws NoSubscriptionServersAvailableException, SubscriptionNotEnabledException {
        this.authenticateOnAllServers(op);
        this.executor.executeOnAllQueueServers(op);
    }

    @Override
    public Object executeOnPrimary(Op op) {
        return this.executor.executeOnPrimary(op);
    }

    @Override
    public Map<ServerLocation, Endpoint> getEndpointMap() {
        return this.endpointManager.getEndpointMap();
    }

    @Override
    public ScheduledExecutorService getBackgroundProcessor() {
        return this.backgroundProcessor;
    }

    @Override
    public RegisterInterestTracker getRITracker() {
        return this.riTracker;
    }

    public int getConnectedServerCount() {
        return this.endpointManager.getConnectedServerCount();
    }

    public boolean verifyIfDuplicate(EventID eventId) {
        return ((QueueStateImpl)this.queueManager.getState()).verifyIfDuplicate(eventId);
    }

    public boolean verifyIfDuplicate(EventID eventId, boolean addToMap) {
        return ((QueueStateImpl)this.queueManager.getState()).verifyIfDuplicate(eventId);
    }

    public Connection acquireConnection() {
        return this.manager.borrowConnection(45000L);
    }

    public void returnConnection(Connection conn) {
        this.manager.returnConnection(conn);
    }

    public Connection acquireConnection(ServerLocation loc) {
        return this.manager.borrowConnection(loc, 15000L, false);
    }

    public Set getBlacklistedServers() {
        return this.connectionFactory.getBlackList().getBadServers();
    }

    public void processException(Throwable e, Connection con) {
        this.executor.handleException(e, con, 0, false);
    }

    public Map getThreadIdToSequenceIdMap() {
        if (this.queueManager == null) {
            return Collections.emptyMap();
        }
        if (this.queueManager.getState() == null) {
            return Collections.emptyMap();
        }
        return this.queueManager.getState().getThreadIdToSequenceIdMap();
    }

    public boolean isPrimaryUpdaterAlive() {
        return ((QueueManagerImpl)this.queueManager).isPrimaryUpdaterAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killPrimaryEndpoint() {
        QueueManager.QueueConnections cons;
        Connection con;
        boolean ok = false;
        if (this.queueManager != null && (con = (cons = this.queueManager.getAllConnections()).getPrimary()) != null) {
            String msg = "killing primary endpoint";
            logger.info("<ExpectedException action=add>{}</ExpectedException>", (Object)"killing primary endpoint");
            Exception e = new Exception("killing primary endpoint");
            try {
                this.processException(e, con);
            }
            catch (ServerConnectivityException serverConnectivityException) {
            }
            finally {
                logger.info("<ExpectedException action=remove>{}</ExpectedException>", (Object)"killing primary endpoint");
            }
            ok = true;
        }
        if (!ok) {
            throw new IllegalStateException("primaryEndpoint was null");
        }
    }

    public void setDeclaredInXML(boolean v) {
        this.declaredInXML = v;
    }

    public boolean getDeclaredInXML() {
        return this.declaredInXML;
    }

    public boolean getReadyForEventsCalled() {
        return this.readyForEventsCalled;
    }

    public void readyForEvents(InternalDistributedSystem system) {
        if (!this.isDurableClient() || this.queueManager == null) {
            return;
        }
        this.readyForEventsCalled = true;
        this.queueManager.readyForEvents(system);
    }

    @Override
    public boolean isDurableClient() {
        boolean isDurable = false;
        InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
        DistributionConfig config = system.getConfig();
        String durableClientId = config.getDurableClientId();
        isDurable = durableClientId != null && durableClientId.length() > 0;
        return isDurable;
    }

    public String getPrimaryName() {
        String result = null;
        ServerLocation sl = this.getPrimary();
        if (sl != null) {
            result = sl.getHostName() + sl.getPort();
        }
        return result;
    }

    public int getPrimaryPort() {
        int result = -1;
        ServerLocation sl = this.getPrimary();
        if (sl != null) {
            result = sl.getPort();
        }
        return result;
    }

    public ServerLocation getPrimary() {
        ServerLocation result = null;
        if (this.queueManager != null) {
            QueueManager.QueueConnections cons = this.queueManager.getAllConnections();
            Connection con = cons.getPrimary();
            result = con.getServer();
        }
        return result;
    }

    public Connection getPrimaryConnection() {
        if (this.queueManager != null) {
            QueueManager.QueueConnections cons = this.queueManager.getAllConnections();
            return cons.getPrimary();
        }
        return null;
    }

    public List<String> getRedundantNames() {
        QueueManager.QueueConnections cons;
        List backupCons;
        List<String> result = Collections.emptyList();
        if (this.queueManager != null && (backupCons = (cons = this.queueManager.getAllConnections()).getBackups()).size() > 0) {
            result = new ArrayList<String>(backupCons.size());
            for (Connection con : backupCons) {
                ServerLocation sl = con.getServer();
                result.add(sl.getHostName() + sl.getPort());
            }
        }
        return result;
    }

    public List<ServerLocation> getRedundants() {
        QueueManager.QueueConnections cons;
        List backupCons;
        List<ServerLocation> result = Collections.emptyList();
        if (this.queueManager != null && (backupCons = (cons = this.queueManager.getAllConnections()).getBackups()).size() > 0) {
            result = new ArrayList<ServerLocation>(backupCons.size());
            for (Connection con : backupCons) {
                result.add(con.getServer());
            }
        }
        return result;
    }

    public int getConnectionCount() {
        return this.manager.getConnectionCount();
    }

    public int getAttachCount() {
        return this.attachCount.get();
    }

    public void attach() {
        this.attachCount.getAndIncrement();
    }

    @Override
    public void detach() {
        this.attachCount.getAndDecrement();
    }

    public Connection getThreadLocalConnection() {
        return this.executor.getThreadLocalConnection();
    }

    public List<ServerLocation> getCurrentServers() {
        ArrayList<ServerLocation> result = new ArrayList<ServerLocation>();
        Map<ServerLocation, Endpoint> endpointMap = this.endpointManager.getEndpointMap();
        result.addAll(endpointMap.keySet());
        return result;
    }

    public List<String> getCurrentServerNames() {
        List<ServerLocation> servers = this.getCurrentServers();
        ArrayList<String> result = new ArrayList<String>(servers.size());
        for (ServerLocation sl : servers) {
            String name = sl.getHostName() + sl.getPort();
            result.add(name);
        }
        return result;
    }

    @Override
    public EndpointManager getEndpointManager() {
        return this.endpointManager;
    }

    public ConnectionSource getConnectionSource() {
        return this.source;
    }

    private static void setTEST_DURABLE_IS_NET_DOWN(boolean v) {
        TEST_DURABLE_IS_NET_DOWN = v;
    }

    public void endpointsNetDownForDUnitTest() {
        logger.debug("PoolImpl - endpointsNetDownForDUnitTest");
        PoolImpl.setTEST_DURABLE_IS_NET_DOWN(true);
        try {
            Thread.sleep(this.pingInterval * 2L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Map<ServerLocation, Endpoint> endpoints = this.endpointManager.getEndpointMap();
        for (Endpoint endpoint : endpoints.values()) {
            logger.debug("PoolImpl Simulating crash of endpoint {}", (Object)endpoint);
            this.endpointManager.serverCrashed(endpoint);
        }
    }

    public void endpointsNetUpForDUnitTest() {
        PoolImpl.setTEST_DURABLE_IS_NET_DOWN(false);
        try {
            Thread.sleep(this.pingInterval * 2L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getInvalidateCount() {
        return ((QueueStateImpl)this.queueManager.getState()).getInvalidateCount();
    }

    public void setThreadLocalConnection(Connection conn) {
        this.executor.setThreadLocalConnection(conn);
    }

    @Override
    public ServerLocation getServerAffinityLocation() {
        return this.executor.getServerAffinityLocation();
    }

    @Override
    public void setServerAffinityLocation(ServerLocation serverLocation) {
        this.executor.setServerAffinityLocation(serverLocation);
    }

    public ServerLocation getNextOpServerLocation() {
        return this.executor.getNextOpServerLocation();
    }

    public ClientProxyMembershipID getProxyID() {
        return this.proxyId;
    }

    public void emergencyClose() {
        this.destroyed = true;
        this.manager.emergencyClose();
        this.queueManager.emergencyClose();
    }

    public static void loadEmergencyClasses() {
        QueueManagerImpl.loadEmergencyClasses();
        ConnectionManagerImpl.loadEmergencyClasses();
        EndpointManagerImpl.loadEmergencyClasses();
    }

    @Override
    public QueryService getQueryService() {
        Cache cache = CacheFactory.getInstance(InternalDistributedSystem.getAnyInstance());
        DefaultQueryService queryService = new DefaultQueryService((InternalCache)cache);
        queryService.setPool(this);
        return queryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionService createAuthenticatedCacheView(Properties properties) {
        if (!this.multiuserSecureModeEnabled) {
            throw new UnsupportedOperationException("Operation not supported when multiuser-authentication is false.");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Security properties cannot be empty.");
        }
        Cache cache = CacheFactory.getInstance(InternalDistributedSystem.getAnyInstance());
        Properties props = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        ProxyCache proxy = new ProxyCache(props, (InternalCache)cache, this);
        ArrayList<ProxyCache> arrayList = this.proxyCacheList;
        synchronized (arrayList) {
            this.proxyCacheList.add(proxy);
        }
        return proxy;
    }

    private RuntimeException generatePoolOrCacheCancelledException(Throwable e) {
        RuntimeException re = this.getCancelCriterion().generateCancelledException(e);
        if (re != null) {
            return re;
        }
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            if (this.cacheCriterion != null) {
                return this.cacheCriterion.generateCancelledException(e);
            }
        } else {
            if (this.cacheCriterion == null || this.cacheCriterion != cache.getCancelCriterion()) {
                this.cacheCriterion = cache.getCancelCriterion();
            }
            return this.cacheCriterion.generateCancelledException(e);
        }
        return null;
    }

    @Override
    public String getPoolOrCacheCancelInProgress() {
        String reason = null;
        try {
            reason = this.getCancelCriterion().cancelInProgress();
            if (reason != null) {
                return reason;
            }
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache == null) {
                if (this.cacheCriterion != null) {
                    return this.cacheCriterion.cancelInProgress();
                }
                return null;
            }
            if (this.cacheCriterion == null) {
                this.cacheCriterion = cache.getCancelCriterion();
            } else if (this.cacheCriterion != cache.getCancelCriterion()) {
                this.cacheCriterion = cache.getCancelCriterion();
            }
            return this.cacheCriterion.cancelInProgress();
        }
        catch (CancelException cce) {
            if (cce.getMessage() != null) {
                return cce.getMessage();
            }
            return "cache is closed";
        }
    }

    @Override
    public boolean getKeepAlive() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            return this.keepAlive;
        }
        return cache.keepDurableSubscriptionsAlive();
    }

    public ArrayList<ProxyCache> getProxyCacheList() {
        return this.proxyCacheList;
    }

    private void authenticateIfRequired(Op op) {
        this.authenticateIfRequired(null, op);
    }

    private void authenticateIfRequired(ServerLocation serverLocation, Op op) {
        if (this.multiuserSecureModeEnabled && op instanceof AbstractOp && ((AbstractOp)op).needsUserId()) {
            Long userId;
            UserAttributes userAttributes = UserAttributes.userAttributes.get();
            if (userAttributes == null) {
                throw new UnsupportedOperationException(LocalizedStrings.MultiUserSecurityEnabled_USE_POOL_API.toLocalizedString());
            }
            if (serverLocation != null && !userAttributes.getServerToId().containsKey(serverLocation) && (userId = (Long)AuthenticateUserOp.executeOn(serverLocation, this, userAttributes.getCredentials())) != null) {
                userAttributes.setServerToId(serverLocation, userId);
            }
        }
    }

    private void authenticateOnAllServers(Op op) {
        if (this.multiuserSecureModeEnabled && ((AbstractOp)op).needsUserId()) {
            UserAttributes userAttributes = UserAttributes.userAttributes.get();
            if (userAttributes != null) {
                Long userId;
                ConcurrentHashMap<ServerLocation, Long> map = userAttributes.getServerToId();
                if (this.queueManager == null) {
                    throw new SubscriptionNotEnabledException();
                }
                Connection primary = this.queueManager.getAllConnectionsNoWait().getPrimary();
                if (primary != null && !map.containsKey(primary.getServer()) && (userId = (Long)AuthenticateUserOp.executeOn(primary.getServer(), this, userAttributes.getCredentials())) != null) {
                    map.put(primary.getServer(), userId);
                }
                List backups = this.queueManager.getAllConnectionsNoWait().getBackups();
                for (int i = 0; i < backups.size(); ++i) {
                    Long userId2;
                    Connection conn = (Connection)backups.get(i);
                    if (map.containsKey(conn.getServer()) || (userId2 = (Long)AuthenticateUserOp.executeOn(conn.getServer(), this, userAttributes.getCredentials())) == null) continue;
                    map.put(conn.getServer(), userId2);
                }
            } else {
                throw new UnsupportedOperationException(LocalizedStrings.MultiUserSecurityEnabled_USE_POOL_API.toLocalizedString());
            }
        }
    }

    public void setPendingEventCount(int count) {
        this.primaryQueueSize.set(count);
    }

    @Override
    public int getPendingEventCount() {
        if (!this.isDurableClient() || this.queueManager == null) {
            throw new IllegalStateException(LocalizedStrings.PoolManagerImpl_ONLY_DURABLE_CLIENTS_SHOULD_CALL_GETPENDINGEVENTCOUNT.toLocalizedString());
        }
        if (this.readyForEventsCalled) {
            throw new IllegalStateException(LocalizedStrings.PoolManagerImpl_GETPENDINGEVENTCOUNT_SHOULD_BE_CALLED_BEFORE_INVOKING_READYFOREVENTS.toLocalizedString());
        }
        return this.primaryQueueSize.get();
    }

    protected class Stopper
    extends CancelCriterion {
        protected Stopper() {
        }

        @Override
        public String cancelInProgress() {
            if (PoolImpl.this.destroyed) {
                return "Pool " + PoolImpl.this + " is shut down";
            }
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable t) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            return new PoolCancelledException(reason, t);
        }
    }

    protected class PoolOrCacheStopper
    extends CancelCriterion {
        protected PoolOrCacheStopper() {
        }

        @Override
        public String cancelInProgress() {
            return PoolImpl.this.getPoolOrCacheCancelInProgress();
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            return PoolImpl.this.generatePoolOrCacheCancelledException(e);
        }
    }

    protected class PublishClientStatsTask
    extends PoolTask {
        protected PublishClientStatsTask() {
        }

        @Override
        public void run2() {
            ClientStatsManager.publishClientStats(PoolImpl.this);
        }
    }

    public static abstract class PoolTask
    implements Runnable {
        @Override
        public void run() {
            try {
                this.run2();
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (CancelException ignore) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Pool task <{}> cancelled", (Object)this);
                }
            }
            catch (Throwable t) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.PoolImpl_UNEXPECTED_ERROR_IN_POOL_TASK_0, this), t);
            }
        }

        public abstract void run2();
    }
}

