/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messenger;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.geode.DataSerializer;
import org.apache.geode.ForcedDisconnectException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.SystemConnectException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.DurableClientAttributes;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.MemberAttributes;
import org.apache.geode.distributed.internal.membership.NetView;
import org.apache.geode.distributed.internal.membership.QuorumChecker;
import org.apache.geode.distributed.internal.membership.gms.GMSMember;
import org.apache.geode.distributed.internal.membership.gms.GMSUtil;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.interfaces.MessageHandler;
import org.apache.geode.distributed.internal.membership.gms.interfaces.Messenger;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorRequest;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorResponse;
import org.apache.geode.distributed.internal.membership.gms.messages.JoinRequestMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.JoinResponseMessage;
import org.apache.geode.distributed.internal.membership.gms.messenger.GMSEncrypt;
import org.apache.geode.distributed.internal.membership.gms.messenger.GMSPingPonger;
import org.apache.geode.distributed.internal.membership.gms.messenger.GMSQuorumChecker;
import org.apache.geode.distributed.internal.membership.gms.messenger.JGAddress;
import org.apache.geode.distributed.internal.membership.gms.messenger.StatRecorder;
import org.apache.geode.distributed.internal.membership.gms.messenger.Transport;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedDataInputStream;
import org.apache.geode.internal.admin.remote.RemoteTransportConfig;
import org.apache.geode.internal.cache.DirectReplyMessage;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.AlertAppender;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.tcp.MemberShunnedException;
import org.apache.logging.log4j.Logger;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.UDP;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.protocols.pbcast.NakAckHeader2;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Digest;
import org.jgroups.util.StackType;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class JGroupsMessenger
implements Messenger {
    private static final Logger logger = Services.getLogger();
    private static final String DEFAULT_JGROUPS_TCP_CONFIG = "org/apache/geode/distributed/internal/membership/gms/messenger/jgroups-config.xml";
    private static final String JGROUPS_MCAST_CONFIG_FILE_NAME = "org/apache/geode/distributed/internal/membership/gms/messenger/jgroups-mcast.xml";
    private static final short JGROUPS_TYPE_JGADDRESS = 2000;
    private static final short JGROUPS_PROTOCOL_TRANSPORT = 1000;
    public static boolean THROW_EXCEPTION_ON_START_HOOK;
    private String jgStackConfig;
    JChannel myChannel;
    InternalDistributedMember localAddress;
    JGAddress jgAddress;
    private Services services;
    private final Map<Class, MessageHandler> handlers = new ConcurrentHashMap<Class, MessageHandler>();
    private volatile NetView view;
    private final GMSPingPonger pingPonger = new GMSPingPonger();
    protected final AtomicLong pongsReceived = new AtomicLong(0L);
    protected final Map<DistributedMember, MessageTracker> scheduledMcastSeqnos = new HashMap<DistributedMember, MessageTracker>();
    protected short nackack2HeaderId;
    private final Set<Address> addressesWithIoExceptionsProcessed = Collections.synchronizedSet(new HashSet());
    private GMSEncrypt encrypt;
    private AtomicInteger requestId = new AtomicInteger(new Random().nextInt());
    private HashMap<Integer, InternalDistributedMember> requestIdVsRecipients = new HashMap();

    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void init(Services s) {
        String properties;
        this.services = s;
        RemoteTransportConfig transport = this.services.getConfig().getTransport();
        DistributionConfig dc = this.services.getConfig().getDistributionConfig();
        boolean b = dc.getEnableNetworkPartitionDetection();
        System.setProperty("jgroups.resolve_dns", String.valueOf(!b));
        String r = transport.isMcastEnabled() ? JGROUPS_MCAST_CONFIG_FILE_NAME : DEFAULT_JGROUPS_TCP_CONFIG;
        InputStream is = ClassPathLoader.getLatest().getResourceAsStream(this.getClass(), r);
        if (is == null) {
            throw new GemFireConfigException(LocalizedStrings.GroupMembershipService_CANNOT_FIND_0.toLocalizedString(r));
        }
        try {
            String input;
            StringBuilder sb = new StringBuilder(3000);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "US-ASCII"));
            while ((input = br.readLine()) != null) {
                sb.append(input);
            }
            br.close();
            properties = sb.toString();
        }
        catch (Exception ex) {
            throw new GemFireConfigException(LocalizedStrings.GroupMembershipService_AN_EXCEPTION_WAS_THROWN_WHILE_READING_JGROUPS_CONFIG.toLocalizedString(), ex);
        }
        if (properties.startsWith("<!--")) {
            int commentEnd = properties.indexOf("-->");
            properties = properties.substring(commentEnd + 3);
        }
        if (transport.isMcastEnabled()) {
            properties = GMSUtil.replaceStrings(properties, "MCAST_PORT", String.valueOf(transport.getMcastId().getPort()));
            properties = GMSUtil.replaceStrings(properties, "MCAST_ADDRESS", dc.getMcastAddress().getHostAddress());
            properties = GMSUtil.replaceStrings(properties, "MCAST_TTL", String.valueOf(dc.getMcastTtl()));
            properties = GMSUtil.replaceStrings(properties, "MCAST_SEND_BUFFER_SIZE", String.valueOf(dc.getMcastSendBufferSize()));
            properties = GMSUtil.replaceStrings(properties, "MCAST_RECV_BUFFER_SIZE", String.valueOf(dc.getMcastRecvBufferSize()));
            properties = GMSUtil.replaceStrings(properties, "MCAST_RETRANSMIT_INTERVAL", "" + Integer.getInteger("gemfire.mcast-retransmit-interval", 500));
            properties = GMSUtil.replaceStrings(properties, "RETRANSMIT_LIMIT", String.valueOf(dc.getUdpFragmentSize() - 256));
        }
        properties = transport.isMcastEnabled() || transport.isTcpDisabled() || dc.getUdpRecvBufferSize() != 0x100000 ? GMSUtil.replaceStrings(properties, "UDP_RECV_BUFFER_SIZE", "" + dc.getUdpRecvBufferSize()) : GMSUtil.replaceStrings(properties, "UDP_RECV_BUFFER_SIZE", "65535");
        properties = GMSUtil.replaceStrings(properties, "UDP_SEND_BUFFER_SIZE", "" + dc.getUdpSendBufferSize());
        String str = transport.getBindAddress();
        if (str == null || str.length() == 0) {
            try {
                str = SocketCreator.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new GemFireConfigException(e.getMessage(), e);
            }
        }
        properties = GMSUtil.replaceStrings(properties, "BIND_ADDR_SETTING", "bind_addr=\"" + str + "\"");
        int port = Integer.getInteger("gemfire.jg-bind-port", 0);
        if (port != 0) {
            properties = GMSUtil.replaceStrings(properties, "MEMBERSHIP_PORT_RANGE_START", "" + port);
            properties = GMSUtil.replaceStrings(properties, "MEMBERSHIP_PORT_RANGE", "0");
        } else {
            int[] ports = dc.getMembershipPortRange();
            properties = GMSUtil.replaceStrings(properties, "MEMBERSHIP_PORT_RANGE_START", "" + ports[0]);
            properties = GMSUtil.replaceStrings(properties, "MEMBERSHIP_PORT_RANGE", "" + (ports[1] - ports[0]));
        }
        properties = GMSUtil.replaceStrings(properties, "UDP_FRAGMENT_SIZE", "" + dc.getUdpFragmentSize());
        properties = GMSUtil.replaceStrings(properties, "FC_MAX_CREDITS", "" + dc.getMcastFlowControl().getByteAllowance());
        properties = GMSUtil.replaceStrings(properties, "FC_THRESHOLD", "" + dc.getMcastFlowControl().getRechargeThreshold());
        this.jgStackConfig = properties = GMSUtil.replaceStrings(properties, "FC_MAX_BLOCK", "" + dc.getMcastFlowControl().getRechargeBlockMs());
        if (!dc.getSecurityUDPDHAlgo().isEmpty()) {
            try {
                this.encrypt = new GMSEncrypt(this.services);
                logger.info("Initializing GMSEncrypt ");
            }
            catch (Exception e) {
                throw new GemFireConfigException("problem initializing encryption protocol", e);
            }
        }
    }

    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void start() {
        String properties = this.jgStackConfig;
        long start = System.currentTimeMillis();
        boolean reconnecting = false;
        try {
            Object oldChannel = this.services.getConfig().getTransport().getOldDSMembershipInfo();
            if (oldChannel != null) {
                logger.debug("Reusing JGroups channel from previous system", (Object)properties);
                this.myChannel = (JChannel)oldChannel;
                ViewId vid = new ViewId((Address)new JGAddress(), 0L);
                ArrayList<UUID> members = new ArrayList<UUID>();
                members.add(new UUID(0L, 0L));
                View jgv = new View(vid, members);
                this.myChannel.down(new Event(6, (Object)jgv));
                UUID logicalAddress = (UUID)this.myChannel.getAddress();
                if (logicalAddress instanceof JGAddress) {
                    ((JGAddress)logicalAddress).setVmViewId(-1);
                }
                reconnecting = true;
            } else {
                logger.debug("JGroups configuration: {}", (Object)properties);
                this.checkForIPv6();
                ByteArrayInputStream is = new ByteArrayInputStream(properties.getBytes("UTF-8"));
                this.myChannel = new JChannel((InputStream)is);
            }
        }
        catch (Exception e) {
            throw new GemFireConfigException("unable to create jgroups channel", e);
        }
        StatRecorder sr = (StatRecorder)this.myChannel.getProtocolStack().findProtocol(StatRecorder.class);
        if (sr != null) {
            sr.setServices(this.services);
        }
        Transport transport = (Transport)this.myChannel.getProtocolStack().getTransport();
        transport.setMessenger(this);
        this.nackack2HeaderId = ClassConfigurator.getProtocolId(NAKACK2.class);
        try {
            this.myChannel.setReceiver(null);
            this.myChannel.setReceiver((Receiver)new JGroupsReceiver());
            if (!reconnecting) {
                this.myChannel.connect("AG");
            }
        }
        catch (Exception e) {
            this.myChannel.close();
            throw new SystemConnectException("unable to create jgroups channel", e);
        }
        if (THROW_EXCEPTION_ON_START_HOOK) {
            THROW_EXCEPTION_ON_START_HOOK = false;
            throw new SystemConnectException("failing for test");
        }
        this.establishLocalAddress();
        logger.info("JGroups channel {} (took {}ms)", (Object)(reconnecting ? "reinitialized" : "created"), (Object)(System.currentTimeMillis() - start));
    }

    private void checkForIPv6() throws Exception {
        boolean preferIpV6Addr = Boolean.getBoolean("java.net.preferIPv6Addresses");
        if (!preferIpV6Addr) {
            logger.debug("forcing JGroups to think IPv4 is being used so it will choose an IPv4 address");
            Field m = Util.class.getDeclaredField("ip_stack_type");
            m.setAccessible(true);
            m.set(null, StackType.IPv4);
        }
    }

    @Override
    public void started() {
    }

    @Override
    public void stop() {
        if (!(this.myChannel == null || this.services.isShutdownDueToForcedDisconnect() && this.services.isAutoReconnectEnabled() || this.services.getManager().isReconnectingDS())) {
            this.myChannel.close();
        }
    }

    @Override
    public void stopped() {
    }

    @Override
    public void memberSuspected(InternalDistributedMember initiator, InternalDistributedMember suspect, String reason) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installView(NetView v) {
        this.view = v;
        if (this.jgAddress.getVmViewId() < 0) {
            this.jgAddress.setVmViewId(this.localAddress.getVmViewId());
        }
        ArrayList mbrs = new ArrayList(v.size());
        mbrs.addAll(v.getMembers().stream().map(JGAddress::new).collect(Collectors.toList()));
        ViewId vid = new ViewId((Address)new JGAddress(v.getCoordinator()), (long)v.getViewId());
        View jgv = new View(vid, new ArrayList(mbrs));
        logger.trace("installing JGroups view: {}", (Object)jgv);
        this.myChannel.down(new Event(6, (Object)jgv));
        this.addressesWithIoExceptionsProcessed.clear();
        if (this.encrypt != null) {
            this.encrypt.installView(v);
        }
        Map<DistributedMember, MessageTracker> map = this.scheduledMcastSeqnos;
        synchronized (map) {
            for (DistributedMember distributedMember : v.getCrashedMembers()) {
                this.scheduledMcastSeqnos.remove(distributedMember);
            }
            for (DistributedMember distributedMember : v.getShutdownMembers()) {
                this.scheduledMcastSeqnos.remove(distributedMember);
            }
        }
    }

    public void handleJGroupsIOException(IOException e, Address dest) {
        if (this.services.getManager().shutdownInProgress()) {
            return;
        }
        if (this.addressesWithIoExceptionsProcessed.contains(dest)) {
            return;
        }
        this.addressesWithIoExceptionsProcessed.add(dest);
        NetView v = this.view;
        JGAddress jgMbr = (JGAddress)dest;
        if (jgMbr != null && v != null) {
            List<InternalDistributedMember> members = v.getMembers();
            InternalDistributedMember recipient = null;
            for (InternalDistributedMember mbr : members) {
                GMSMember gmsMbr = (GMSMember)mbr.getNetMember();
                if (jgMbr.getUUIDLsbs() != gmsMbr.getUuidLSBs() || jgMbr.getUUIDMsbs() != gmsMbr.getUuidMSBs() || jgMbr.getVmViewId() != gmsMbr.getVmViewId()) continue;
                recipient = mbr;
                break;
            }
            if (recipient != null) {
                logger.warn("Unable to send message to " + recipient, (Throwable)e);
                this.services.getHealthMonitor().suspect(recipient, "Unable to send messages to this member via JGroups");
            }
        }
    }

    private void establishLocalAddress() {
        UUID logicalAddress = (UUID)this.myChannel.getAddress();
        logicalAddress = logicalAddress.copy();
        IpAddress ipaddr = (IpAddress)this.myChannel.down(new Event(87));
        if (ipaddr != null) {
            this.jgAddress = new JGAddress(logicalAddress, ipaddr);
        } else {
            UDP udp = (UDP)this.myChannel.getProtocolStack().getTransport();
            try {
                Method getAddress = UDP.class.getDeclaredMethod("getPhysicalAddress", new Class[0]);
                getAddress.setAccessible(true);
                ipaddr = (IpAddress)getAddress.invoke((Object)udp, new Object[0]);
                this.jgAddress = new JGAddress(logicalAddress, ipaddr);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.info("Unable to find getPhysicallAddress method in UDP - parsing its address instead");
            }
        }
        this.myChannel.down(new Event(8, (Object)this.jgAddress));
        DistributionConfig config = this.services.getConfig().getDistributionConfig();
        boolean isLocator = this.services.getConfig().getTransport().getVmKind() == 11 || !this.services.getConfig().getDistributionConfig().getStartLocator().isEmpty();
        DurableClientAttributes dca = null;
        if (config.getDurableClientId() != null) {
            dca = new DurableClientAttributes(config.getDurableClientId(), config.getDurableClientTimeout());
        }
        MemberAttributes attr = new MemberAttributes(-1, OSProcess.getId(), this.services.getConfig().getTransport().getVmKind(), -1, config.getName(), MemberAttributes.parseGroups(config.getRoles(), config.getGroups()), dca);
        this.localAddress = new InternalDistributedMember(this.jgAddress.getInetAddress(), this.jgAddress.getPort(), config.getEnableNetworkPartitionDetection(), isLocator, attr);
        JGAddress uuid = this.jgAddress;
        GMSMember gmsMember = (GMSMember)this.localAddress.getNetMember();
        gmsMember.setUUID(uuid);
        gmsMember.setMemberWeight((byte)(this.services.getConfig().getMemberWeight() & 0xFF));
        gmsMember.setNetworkPartitionDetectionEnabled(this.services.getConfig().getDistributionConfig().getEnableNetworkPartitionDetection());
    }

    @Override
    public void beSick() {
    }

    @Override
    public void playDead() {
    }

    @Override
    public void beHealthy() {
    }

    @Override
    public void addHandler(Class c, MessageHandler h) {
        this.handlers.put(c, h);
    }

    @Override
    public boolean testMulticast(long timeout) throws InterruptedException {
        long pongsSnapshot = this.pongsReceived.longValue();
        JGAddress dest = null;
        try {
            this.pingPonger.sendPingMessage(this.myChannel, (Address)this.jgAddress, dest);
        }
        catch (Exception e) {
            logger.warn("unable to send multicast message: {}", this.jgAddress == null ? "multicast recipients" : this.jgAddress, (Object)e.getMessage());
            return false;
        }
        long giveupTime = System.currentTimeMillis() + timeout;
        while (this.pongsReceived.longValue() == pongsSnapshot && System.currentTimeMillis() < giveupTime) {
            Thread.sleep(100L);
        }
        return this.pongsReceived.longValue() > pongsSnapshot;
    }

    @Override
    public void getMessageState(InternalDistributedMember target, Map state, boolean includeMulticast) {
        NAKACK2 nakack;
        if (includeMulticast && (nakack = (NAKACK2)this.myChannel.getProtocolStack().findProtocol("NAKACK2")) != null) {
            long seqno = nakack.getCurrentSeqno();
            state.put("JGroups.mcastState", seqno);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForMessageState(InternalDistributedMember sender, Map state) throws InterruptedException {
        Long seqno = (Long)state.get("JGroups.mcastState");
        if (seqno == null) {
            return;
        }
        long timeout = (long)this.services.getConfig().getDistributionConfig().getAckWaitThreshold() * 1000L;
        long startTime = System.currentTimeMillis();
        long warnTime = startTime + timeout;
        long quitTime = warnTime + timeout - 1000L;
        boolean warned = false;
        while (true) {
            String received = "none";
            long highSeqno = 0L;
            Map<DistributedMember, MessageTracker> map = this.scheduledMcastSeqnos;
            synchronized (map) {
                MessageTracker tracker = this.scheduledMcastSeqnos.get(sender);
                if (tracker == null) {
                    break;
                }
                highSeqno = tracker.get();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("waiting for multicast messages from {}.  Current seqno={} and expected seqno={}", (Object)sender, (Object)highSeqno, (Object)seqno);
            }
            if (highSeqno >= seqno) break;
            long now = System.currentTimeMillis();
            if (!warned && now >= warnTime) {
                warned = true;
                received = String.valueOf(highSeqno);
                logger.warn("{} seconds have elapsed while waiting for multicast messages from {}.  Received {} but expecting at least {}.", (Object)Long.toString((warnTime - startTime) / 1000L), (Object)sender, (Object)received, (Object)seqno);
            }
            if (now >= quitTime) {
                throw new GemFireIOException("Multicast operations from " + sender + " did not distribute within " + (now - startTime) + " milliseconds");
            }
            Thread.sleep(50L);
        }
    }

    @Override
    public Set<InternalDistributedMember> sendUnreliably(DistributionMessage msg) {
        return this.send(msg, false);
    }

    @Override
    public Set<InternalDistributedMember> send(DistributionMessage msg) {
        return this.send(msg, true);
    }

    private Set<InternalDistributedMember> send(DistributionMessage msg, boolean reliably) {
        LinkedList<GMSMember> calculatedMembers;
        int calculatedLen;
        DMStats theStats = this.services.getStatistics();
        NetView oldView = this.view;
        if (!this.myChannel.isConnected()) {
            logger.info("JGroupsMessenger channel is closed - messaging is not possible");
            throw new DistributedSystemDisconnectedException("Distributed System is shutting down");
        }
        this.filterOutgoingMessage(msg);
        if (msg instanceof DirectReplyMessage && msg.isDirectAck() && msg.getProcessorId() <= 0) {
            ((DirectReplyMessage)((Object)msg)).registerProcessor();
        }
        InternalDistributedMember[] destinations = msg.getRecipients();
        boolean allDestinations = msg.forAll();
        boolean useMcast = false;
        if (this.services.getConfig().getTransport().isMcastEnabled() && (msg.getMulticast() || allDestinations)) {
            useMcast = this.services.getManager().isMulticastAllowed();
        }
        if (logger.isDebugEnabled() && reliably) {
            String recips = useMcast ? "multicast" : Arrays.toString(msg.getRecipients());
            logger.debug("sending via JGroups: [{}] recipients: {}", (Object)msg, (Object)recips);
        }
        JGAddress local = this.jgAddress;
        if (useMcast) {
            long startSer = theStats.startMsgSerialization();
            Message jmsg = this.createJGMessage(msg, local, Version.CURRENT_ORDINAL);
            theStats.endMsgSerialization(startSer);
            try {
                jmsg.setTransientFlag(new Message.TransientFlag[]{Message.TransientFlag.DONT_LOOPBACK});
                if (!reliably) {
                    jmsg.setFlag(new Message.Flag[]{Message.Flag.NO_RELIABILITY});
                }
                theStats.incSentBytes(jmsg.getLength());
                logger.trace("Sending JGroups message: {}", (Object)jmsg);
                this.myChannel.send(jmsg);
            }
            catch (Exception e) {
                logger.debug("caught unexpected exception", (Throwable)e);
                Throwable cause = e.getCause();
                Exception problem = cause instanceof ForcedDisconnectException ? (Exception)cause : e;
                if (this.services.getShutdownCause() != null) {
                    Exception shutdownCause = this.services.getShutdownCause();
                    if (shutdownCause instanceof ForcedDisconnectException) {
                        problem = shutdownCause;
                    } else {
                        Throwable ne = problem;
                        while (ne.getCause() != null) {
                            ne = ne.getCause();
                        }
                        ne.initCause(this.services.getShutdownCause());
                    }
                }
                String channelClosed = LocalizedStrings.GroupMembershipService_CHANNEL_CLOSED.toLocalizedString();
                throw new DistributedSystemDisconnectedException(channelClosed, problem);
            }
        }
        int len = destinations.length;
        if (len == 1 && destinations[0] == DistributionMessage.ALL_RECIPIENTS) {
            NetView v = this.services.getJoinLeave().getView();
            calculatedLen = v.size();
            calculatedMembers = new LinkedList();
            for (int i = 0; i < calculatedLen; ++i) {
                InternalDistributedMember m = (InternalDistributedMember)v.get(i);
                calculatedMembers.add((GMSMember)m.getNetMember());
            }
        } else {
            calculatedLen = len;
            calculatedMembers = new LinkedList<GMSMember>();
            for (int i = 0; i < calculatedLen; ++i) {
                calculatedMembers.add((GMSMember)destinations[i].getNetMember());
            }
        }
        Int2ObjectOpenHashMap messages = new Int2ObjectOpenHashMap();
        long startSer = theStats.startMsgSerialization();
        boolean firstMessage = true;
        for (GMSMember mbr : calculatedMembers) {
            short version = mbr.getVersionOrdinal();
            if (messages.containsKey((int)version)) continue;
            Message jmsg = this.createJGMessage(msg, local, version);
            messages.put((int)version, (Object)jmsg);
            if (!firstMessage) continue;
            theStats.incSentBytes(jmsg.getLength());
            firstMessage = false;
        }
        theStats.endMsgSerialization(startSer);
        Collections.shuffle(calculatedMembers);
        int i = 0;
        for (GMSMember mbr : calculatedMembers) {
            JGAddress to = new JGAddress(mbr);
            short version = mbr.getVersionOrdinal();
            Message jmsg = (Message)messages.get((int)version);
            Exception problem = null;
            try {
                Message tmp;
                Message message = tmp = i < calculatedLen - 1 ? jmsg.copy(true) : jmsg;
                if (!reliably) {
                    jmsg.setFlag(new Message.Flag[]{Message.Flag.NO_RELIABILITY});
                }
                tmp.setDest((Address)to);
                tmp.setSrc((Address)this.jgAddress);
                logger.trace("Unicasting to {}", (Object)to);
                this.myChannel.send(tmp);
            }
            catch (Exception e) {
                problem = e;
            }
            if (problem == null) continue;
            Exception cause = this.services.getShutdownCause();
            if (cause != null) {
                if (cause instanceof ForcedDisconnectException) {
                    problem = cause;
                } else {
                    Throwable ne = problem;
                    while (ne.getCause() != null) {
                        ne = ne.getCause();
                    }
                    ne.initCause(cause);
                }
            }
            String channelClosed = LocalizedStrings.GroupMembershipService_CHANNEL_CLOSED.toLocalizedString();
            throw new DistributedSystemDisconnectedException(channelClosed, problem);
        }
        if (msg.forAll()) {
            return Collections.emptySet();
        }
        HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>();
        NetView newView = this.view;
        if (newView != null && newView != oldView) {
            for (InternalDistributedMember d : destinations) {
                if (newView.contains(d)) continue;
                logger.debug("messenger: member has left the view: {}  view is now {}", (Object)d, (Object)newView);
                result.add(d);
            }
        }
        return result;
    }

    Message createJGMessage(DistributionMessage gfmsg, JGAddress src, short version) {
        if (gfmsg instanceof DirectReplyMessage) {
            ((DirectReplyMessage)((Object)gfmsg)).registerProcessor();
        }
        Message msg = new Message();
        msg.setDest(null);
        msg.setSrc((Address)src);
        this.setMessageFlags(gfmsg, msg);
        try {
            long start = this.services.getStatistics().startMsgSerialization();
            HeapDataOutputStream out_stream = new HeapDataOutputStream(Version.fromOrdinalOrCurrent(version));
            Version.CURRENT.writeOrdinal(out_stream, true);
            if (this.encrypt != null) {
                out_stream.writeBoolean(true);
                this.writeEncryptedMessage(gfmsg, version, out_stream);
            } else {
                out_stream.writeBoolean(false);
                this.serializeMessage(gfmsg, out_stream);
            }
            msg.setBuffer(out_stream.toByteArray());
            this.services.getStatistics().endMsgSerialization(start);
        }
        catch (IOException | GemFireIOException ex) {
            logger.warn("Error serializing message", (Throwable)ex);
            if (ex instanceof GemFireIOException) {
                throw (GemFireIOException)ex;
            }
            GemFireIOException ioe = new GemFireIOException("Error serializing message");
            ioe.initCause(ex);
            throw ioe;
        }
        catch (Exception ex) {
            logger.warn("Error serializing message", (Throwable)ex);
            GemFireIOException ioe = new GemFireIOException("Error serializing message");
            ioe.initCause(ex.getCause());
            throw ioe;
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeEncryptedMessage(DistributionMessage gfmsg, short version, HeapDataOutputStream out) throws Exception {
        long start = this.services.getStatistics().startUDPMsgEncryption();
        try {
            InternalDataSerializer.writeDSFIDHeader(gfmsg.getDSFID(), out);
            byte[] pk = null;
            int requestId = 0;
            InternalDistributedMember pkMbr = null;
            switch (gfmsg.getDSFID()) {
                case -145: 
                case -142: {
                    pk = this.encrypt.getPublicKey(this.localAddress);
                    pkMbr = gfmsg.getRecipients()[0];
                    requestId = this.getRequestId(gfmsg, true);
                    break;
                }
                case -144: 
                case -143: {
                    pkMbr = gfmsg.getRecipients()[0];
                    requestId = this.getRequestId(gfmsg, false);
                }
            }
            logger.debug("writeEncryptedMessage gfmsg.getDSFID() = {}  for {} with requestid  {}", (Object)gfmsg.getDSFID(), (Object)pkMbr, (Object)requestId);
            out.writeInt(requestId);
            if (pk != null) {
                InternalDataSerializer.writeByteArray(pk, out);
            }
            HeapDataOutputStream out_stream = new HeapDataOutputStream(Version.fromOrdinalOrCurrent(version));
            byte[] messageBytes = this.serializeMessage(gfmsg, out_stream);
            messageBytes = pkMbr != null ? this.encrypt.encryptData(messageBytes, pkMbr) : this.encrypt.encryptData(messageBytes);
            InternalDataSerializer.writeByteArray(messageBytes, out);
        }
        finally {
            this.services.getStatistics().endUDPMsgEncryption(start);
        }
    }

    int getRequestId(DistributionMessage gfmsg, boolean add) {
        int requestId = 0;
        if (gfmsg instanceof FindCoordinatorRequest) {
            requestId = ((FindCoordinatorRequest)gfmsg).getRequestId();
        } else if (gfmsg instanceof JoinRequestMessage) {
            requestId = ((JoinRequestMessage)gfmsg).getRequestId();
        } else if (gfmsg instanceof FindCoordinatorResponse) {
            requestId = ((FindCoordinatorResponse)gfmsg).getRequestId();
        } else if (gfmsg instanceof JoinResponseMessage) {
            requestId = ((JoinResponseMessage)gfmsg).getRequestId();
        }
        if (add) {
            this.addRequestId(requestId, gfmsg.getRecipients()[0]);
        }
        return requestId;
    }

    byte[] serializeMessage(DistributionMessage gfmsg, HeapDataOutputStream out_stream) throws IOException {
        GMSMember m = (GMSMember)this.localAddress.getNetMember();
        m.writeEssentialData(out_stream);
        DataSerializer.writeObject(gfmsg, out_stream);
        return out_stream.toByteArray();
    }

    void setMessageFlags(DistributionMessage gfmsg, Message msg) {
        msg.setFlag(new Message.Flag[]{Message.Flag.DONT_BUNDLE});
        if (gfmsg.getProcessorType() == 75 || gfmsg instanceof HighPriorityDistributionMessage || AlertAppender.isThreadAlerting()) {
            msg.setFlag(new Message.Flag[]{Message.Flag.OOB});
            msg.setFlag(new Message.Flag[]{Message.Flag.NO_FC});
            msg.setFlag(new Message.Flag[]{Message.Flag.SKIP_BARRIER});
        }
        if (gfmsg instanceof DistributedCacheOperation.CacheOperationMessage) {
            msg.setTransientFlag(new Message.TransientFlag[]{Message.TransientFlag.DONT_LOOPBACK});
        }
    }

    Object readJGMessage(Message jgmsg) {
        DistributionMessage result = null;
        int messageLength = jgmsg.getLength();
        if (logger.isTraceEnabled()) {
            logger.trace("deserializing a message of length " + messageLength);
        }
        if (messageLength == 0) {
            logger.trace("message length is zero - ignoring");
            return null;
        }
        Exception problem = null;
        byte[] buf = jgmsg.getRawBuffer();
        try {
            boolean isEncrypted;
            long start = this.services.getStatistics().startMsgDeserialization();
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf, jgmsg.getOffset(), jgmsg.getLength()));
            short ordinal = Version.readOrdinal(dis);
            if (ordinal < Version.CURRENT_ORDINAL) {
                dis = new VersionedDataInputStream(dis, Version.fromOrdinalNoThrow(ordinal, true));
            }
            if ((isEncrypted = dis.readBoolean()) && this.encrypt == null) {
                throw new GemFireConfigException("Got remote message as encrypted");
            }
            result = isEncrypted ? this.readEncryptedMessage(dis, ordinal, this.encrypt) : this.deserializeMessage(dis, ordinal);
            this.services.getStatistics().endMsgDeserialization(start);
        }
        catch (IOException | ClassNotFoundException | RuntimeException e) {
            problem = e;
        }
        catch (Exception e) {
            problem = e;
        }
        if (problem != null) {
            logger.error((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_EXCEPTION_DESERIALIZING_MESSAGE_PAYLOAD_0, jgmsg), (Throwable)problem);
            return null;
        }
        return result;
    }

    void setSender(DistributionMessage dm, GMSMember m, short ordinal) {
        InternalDistributedMember sender = null;
        sender = dm.getDSFID() == -142 ? ((JoinRequestMessage)dm).getMemberID() : this.getMemberFromView(m, ordinal);
        dm.setSender(sender);
    }

    DistributionMessage readEncryptedMessage(DataInputStream dis, short ordinal, GMSEncrypt encryptLocal) throws Exception {
        int dfsid = InternalDataSerializer.readDSFIDHeader(dis);
        int requestId = dis.readInt();
        long start = this.services.getStatistics().startUDPMsgDecryption();
        try {
            byte[] data;
            logger.debug("readEncryptedMessage Reading Request id " + dfsid + " and requestid is " + requestId + " myid " + this.localAddress);
            InternalDistributedMember pkMbr = null;
            boolean readPK = false;
            switch (dfsid) {
                case -145: 
                case -142: {
                    readPK = true;
                    break;
                }
                case -144: 
                case -143: {
                    pkMbr = this.getRequestedMember(requestId);
                }
            }
            byte[] pk = null;
            if (readPK) {
                pk = InternalDataSerializer.readByteArray(dis);
                data = InternalDataSerializer.readByteArray(dis);
                data = encryptLocal.decryptData(data, pk);
            } else {
                data = InternalDataSerializer.readByteArray(dis);
                data = pkMbr != null ? encryptLocal.decryptData(data, pkMbr) : encryptLocal.decryptData(data);
            }
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            if (ordinal < Version.CURRENT_ORDINAL) {
                in = new VersionedDataInputStream(in, Version.fromOrdinalNoThrow(ordinal, true));
            }
            DistributionMessage result = this.deserializeMessage(in, ordinal);
            if (pk != null) {
                logger.info("Setting public key for " + result.getSender() + " len " + pk.length);
                this.setPublicKey(pk, result.getSender());
            }
            DistributionMessage distributionMessage = result;
            return distributionMessage;
        }
        catch (Exception e) {
            throw new Exception("Message id is " + dfsid, e);
        }
        finally {
            this.services.getStatistics().endUDPMsgDecryption(start);
        }
    }

    DistributionMessage deserializeMessage(DataInputStream in, short ordinal) throws ClassNotFoundException, IOException {
        GMSMember m = new GMSMember();
        m.readEssentialData(in);
        DistributionMessage result = (DistributionMessage)DataSerializer.readObject(in);
        this.setSender(result, m, ordinal);
        return result;
    }

    void filterOutgoingMessage(DistributionMessage m) {
        switch (m.getDSFID()) {
            case -143: {
                JoinResponseMessage jrsp = (JoinResponseMessage)m;
                if (jrsp.getRejectionMessage() != null || !this.services.getConfig().getTransport().isMcastEnabled()) break;
                Digest digest = (Digest)this.myChannel.getProtocolStack().getTopProtocol().down(Event.GET_DIGEST_EVT);
                HeapDataOutputStream hdos = new HeapDataOutputStream(500, Version.CURRENT);
                try {
                    digest.writeTo((DataOutput)hdos);
                }
                catch (Exception e) {
                    logger.fatal("Unable to serialize JGroups messaging digest", (Throwable)e);
                }
                jrsp.setMessengerData(hdos.toByteArray());
                break;
            }
        }
    }

    void filterIncomingMessage(DistributionMessage m) {
        switch (m.getDSFID()) {
            case -143: {
                JoinResponseMessage jrsp = (JoinResponseMessage)m;
                if (jrsp.getRejectionMessage() != null || !this.services.getConfig().getTransport().isMcastEnabled()) break;
                byte[] serializedDigest = jrsp.getMessengerData();
                ByteArrayInputStream bis = new ByteArrayInputStream(serializedDigest);
                DataInputStream dis = new DataInputStream(bis);
                try {
                    Digest digest = new Digest();
                    digest.readFrom((DataInput)dis);
                    logger.trace("installing JGroups message digest {}", (Object)digest);
                    this.myChannel.getProtocolStack().getTopProtocol().down(new Event(53, (Object)digest));
                    jrsp.setMessengerData(null);
                }
                catch (Exception e) {
                    logger.fatal("Unable to read JGroups messaging digest", (Throwable)e);
                }
                break;
            }
        }
    }

    @Override
    public InternalDistributedMember getMemberID() {
        return this.localAddress;
    }

    public String getJGroupsStackConfig() {
        return this.jgStackConfig;
    }

    public GMSPingPonger getPingPonger() {
        return this.pingPonger;
    }

    public void setJGroupsStackConfigForTesting(String config) {
        this.jgStackConfig = config;
    }

    private InternalDistributedMember getMemberFromView(GMSMember jgId, short version) {
        return this.services.getJoinLeave().getMemberID(jgId);
    }

    @Override
    public void emergencyClose() {
        this.view = null;
        if (!(this.myChannel == null || this.services.isShutdownDueToForcedDisconnect() && this.services.isAutoReconnectEnabled() || this.services.getManager().isReconnectingDS())) {
            this.myChannel.disconnect();
        }
    }

    @Override
    public QuorumChecker getQuorumChecker() {
        NetView view = this.view;
        if (view == null && (view = this.services.getJoinLeave().getView()) == null && (view = this.services.getJoinLeave().getPreviousView()) == null) {
            return null;
        }
        GMSQuorumChecker qc = new GMSQuorumChecker(view, this.services.getConfig().getLossThreshold(), this.myChannel);
        qc.initialize();
        return qc;
    }

    @Override
    public Set<InternalDistributedMember> send(DistributionMessage msg, NetView alternateView) {
        if (this.encrypt != null) {
            this.encrypt.installView(alternateView);
        }
        return this.send(msg, true);
    }

    @Override
    public byte[] getPublicKey(InternalDistributedMember mbr) {
        if (this.encrypt != null) {
            return this.encrypt.getPublicKey(mbr);
        }
        return null;
    }

    @Override
    public void setPublicKey(byte[] publickey, InternalDistributedMember mbr) {
        if (this.encrypt != null) {
            logger.debug("Setting PK for member " + mbr);
            this.encrypt.setPublicKey(publickey, mbr);
        }
    }

    @Override
    public void setClusterSecretKey(byte[] clusterSecretKey) {
        if (this.encrypt != null) {
            logger.debug("Setting cluster key");
            this.encrypt.addClusterKey(clusterSecretKey);
        }
    }

    @Override
    public byte[] getClusterSecretKey() {
        if (this.encrypt != null) {
            return this.encrypt.getClusterSecretKey();
        }
        return null;
    }

    InternalDistributedMember getRequestedMember(int requestId) {
        return this.requestIdVsRecipients.remove(requestId);
    }

    void addRequestId(int requestId, InternalDistributedMember mbr) {
        this.requestIdVsRecipients.put(requestId, mbr);
    }

    @Override
    public int getRequestId() {
        return this.requestId.incrementAndGet();
    }

    @Override
    public void initClusterKey() {
        if (this.encrypt != null) {
            try {
                logger.info("Initializing cluster key");
                this.encrypt.initClusterSecretKey();
            }
            catch (Exception e) {
                throw new RuntimeException("unable to create cluster key ", e);
            }
        }
    }

    static {
        ClassConfigurator.add((short)2000, JGAddress.class);
        ClassConfigurator.addProtocol((short)1000, Transport.class);
    }

    static class MessageTracker {
        long highestSeqno;

        MessageTracker(long seqno) {
            this.highestSeqno = seqno;
        }

        long get() {
            return this.highestSeqno;
        }

        void record(long seqno) {
            if (seqno > this.highestSeqno) {
                this.highestSeqno = seqno;
            }
        }
    }

    class JGroupsReceiver
    extends ReceiverAdapter {
        JGroupsReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(Message jgmsg) {
            long startTime = DistributionStats.getStatTime();
            try {
                byte[] contents;
                if (JGroupsMessenger.this.services.getManager().shutdownInProgress()) {
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("JGroupsMessenger received {} headers: {}", (Object)jgmsg, (Object)jgmsg.getHeaders());
                }
                if ((contents = jgmsg.getBuffer()) == null) {
                    return;
                }
                if (JGroupsMessenger.this.pingPonger.isPingMessage(contents)) {
                    try {
                        JGroupsMessenger.this.pingPonger.sendPongMessage(JGroupsMessenger.this.myChannel, (Address)JGroupsMessenger.this.jgAddress, jgmsg.getSrc());
                    }
                    catch (Exception e) {
                        logger.info("Failed sending Pong response to " + jgmsg.getSrc());
                    }
                    return;
                }
                if (JGroupsMessenger.this.pingPonger.isPongMessage(contents)) {
                    JGroupsMessenger.this.pongsReceived.incrementAndGet();
                    return;
                }
                Object o = JGroupsMessenger.this.readJGMessage(jgmsg);
                if (o == null) {
                    return;
                }
                DistributionMessage msg = (DistributionMessage)o;
                assert (msg.getSender() != null);
                if (JGroupsMessenger.this.services.getConfig().getTransport().getVmKind() == 12 && msg instanceof DistributedCacheOperation.CacheOperationMessage) {
                    return;
                }
                msg.resetTimestamp();
                msg.setBytesRead(jgmsg.getLength());
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace("JGroupsMessenger dispatching {} from {}", (Object)msg, (Object)msg.getSender());
                    }
                    JGroupsMessenger.this.filterIncomingMessage(msg);
                    this.getMessageHandler(msg).processMessage(msg);
                    NakAckHeader2 header = (NakAckHeader2)jgmsg.getHeader(JGroupsMessenger.this.nackack2HeaderId);
                    if (header != null && !jgmsg.isFlagSet(Message.Flag.OOB)) {
                        this.recordScheduledSeqno(msg.getSender(), header.getSeqno());
                    }
                }
                catch (MemberShunnedException memberShunnedException) {
                    // empty catch block
                }
            }
            finally {
                long delta = DistributionStats.getStatTime() - startTime;
                JGroupsMessenger.this.services.getStatistics().incUDPDispatchRequestTime(delta);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recordScheduledSeqno(DistributedMember member, long seqno) {
            Map<DistributedMember, MessageTracker> map = JGroupsMessenger.this.scheduledMcastSeqnos;
            synchronized (map) {
                MessageTracker counter = JGroupsMessenger.this.scheduledMcastSeqnos.get(member);
                if (counter == null) {
                    counter = new MessageTracker(seqno);
                    JGroupsMessenger.this.scheduledMcastSeqnos.put(member, counter);
                }
                counter.record(seqno);
            }
        }

        private MessageHandler getMessageHandler(DistributionMessage msg) {
            Class<?> msgClazz = msg.getClass();
            MessageHandler h = (MessageHandler)JGroupsMessenger.this.handlers.get(msgClazz);
            if (h == null) {
                for (Class clazz : JGroupsMessenger.this.handlers.keySet()) {
                    if (!clazz.isAssignableFrom(msgClazz)) continue;
                    h = (MessageHandler)JGroupsMessenger.this.handlers.get(clazz);
                    JGroupsMessenger.this.handlers.put(msg.getClass(), h);
                    break;
                }
            }
            if (h == null) {
                h = JGroupsMessenger.this.services.getManager();
            }
            return h;
        }
    }
}

