/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.util.ArgumentRedactor;

public class Banner {
    private Banner() {
    }

    private static void prettyPrintPath(String path, PrintWriter out) {
        if (path != null) {
            StringTokenizer st = new StringTokenizer(path, System.getProperty("path.separator"));
            while (st.hasMoreTokens()) {
                out.println("  " + st.nextToken());
            }
        }
    }

    static void print(PrintWriter out, String[] args) {
        TreeMap<Object, Object> sp = new TreeMap<Object, Object>((Properties)System.getProperties().clone());
        int processId = -1;
        String SEPARATOR = "---------------------------------------------------------------------------";
        try {
            processId = OSProcess.getId();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
        }
        out.println();
        String productName = GemFireVersion.getProductName();
        out.println("---------------------------------------------------------------------------");
        out.println("  ");
        out.println("  Licensed to the Apache Software Foundation (ASF) under one or more");
        out.println("  contributor license agreements.  See the NOTICE file distributed with this");
        out.println("  work for additional information regarding copyright ownership.");
        out.println("   ");
        out.println("  The ASF licenses this file to You under the Apache License, Version 2.0");
        out.println("  (the \"License\"); you may not use this file except in compliance with the");
        out.println("  License.  You may obtain a copy of the License at");
        out.println("  ");
        out.println("  http://www.apache.org/licenses/LICENSE-2.0");
        out.println("  ");
        out.println("  Unless required by applicable law or agreed to in writing, software");
        out.println("  distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT");
        out.println("  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the");
        out.println("  License for the specific language governing permissions and limitations");
        out.println("  under the License.");
        out.println("  ");
        out.println("---------------------------------------------------------------------------");
        GemFireVersion.print(out);
        out.println("Communications version: " + Version.CURRENT_ORDINAL);
        out.println("Process ID: " + processId);
        out.println("User: " + sp.get("user.name"));
        sp.remove("user.name");
        sp.remove("os.name");
        sp.remove("os.arch");
        out.println("Current dir: " + sp.get("user.dir"));
        sp.remove("user.dir");
        out.println("Home dir: " + sp.get("user.home"));
        sp.remove("user.home");
        ArrayList<String> allArgs = new ArrayList<String>();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        if (runtimeBean != null) {
            allArgs.addAll(runtimeBean.getInputArguments());
        }
        if (args != null && args.length != 0) {
            Collections.addAll(allArgs, args);
        }
        if (!allArgs.isEmpty()) {
            out.println("Command Line Parameters:");
            for (String arg : allArgs) {
                out.println("  " + ArgumentRedactor.redact(arg));
            }
        }
        out.println("Class Path:");
        Banner.prettyPrintPath((String)sp.get("java.class.path"), out);
        sp.remove("java.class.path");
        out.println("Library Path:");
        Banner.prettyPrintPath((String)sp.get("java.library.path"), out);
        sp.remove("java.library.path");
        if (Boolean.getBoolean("gemfire.disableSystemPropertyLogging")) {
            out.println("System property logging disabled.");
        } else {
            out.println("System Properties:");
            for (Map.Entry me : sp.entrySet()) {
                String key = me.getKey().toString();
                out.println("    " + key + " = " + ArgumentRedactor.redact(String.valueOf(me.getValue())));
            }
            out.println("Log4J 2 Configuration:");
            out.println("    " + LogService.getConfigInformation());
        }
        out.println("---------------------------------------------------------------------------");
    }

    public static String getString(String[] args) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Banner.print(pw, args);
        pw.close();
        return sw.toString();
    }
}

