/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipInputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.deployment.FunctionScanner;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.logging.log4j.Logger;

public class DeployedJar {
    private static final Logger logger = LogService.getLogger();
    private static final MessageDigest messageDigest = DeployedJar.getMessageDigest();
    private static final byte[] ZERO_BYTES = new byte[0];
    private static final Pattern PATTERN_SLASH = Pattern.compile("/");
    private final String jarName;
    private final File file;
    private final byte[] md5hash;
    private final Collection<Function> registeredFunctions = new ArrayList<Function>();

    private static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getVersion() {
        return JarDeployer.extractVersionFromFilename(this.file.getName());
    }

    public DeployedJar(File versionedJarFile, String jarName) throws IOException {
        this(versionedJarFile, jarName, Files.readAllBytes(versionedJarFile.toPath()));
    }

    public DeployedJar(File versionedJarFile, String jarName, byte[] jarBytes) throws FileNotFoundException {
        Assert.assertTrue(jarBytes != null, "jarBytes cannot be null");
        Assert.assertTrue(jarName != null, "jarName cannot be null");
        Assert.assertTrue(versionedJarFile != null, "versionedJarFile cannot be null");
        this.file = versionedJarFile;
        this.jarName = jarName;
        byte[] fileContent = this.getJarContent();
        if (!Arrays.equals(fileContent, jarBytes)) {
            throw new IllegalStateException("JAR file: " + versionedJarFile.getAbsolutePath() + ", does not have the expected content.");
        }
        if (!DeployedJar.hasValidJarContent(fileContent)) {
            throw new IllegalArgumentException("File does not contain valid JAR content: " + versionedJarFile.getAbsolutePath());
        }
        this.md5hash = (byte[])(messageDigest != null ? messageDigest.digest(jarBytes) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasValidJarContent(InputStream inputStream) {
        JarInputStream jarInputStream = null;
        boolean valid = false;
        try {
            jarInputStream = new JarInputStream(inputStream);
            valid = jarInputStream.getNextJarEntry() != null;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                jarInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return valid;
    }

    static boolean hasValidJarContent(byte[] jarBytes) {
        return DeployedJar.hasValidJarContent(new ByteArrayInputStream(jarBytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerFunctions() throws ClassNotFoundException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Registering functions with DeployedJar: {}", (Object)this);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getJarContent());
        ZipInputStream jarInputStream = null;
        try {
            Collection<String> functionClasses = this.findFunctionsInThisJar();
            jarInputStream = new JarInputStream(byteArrayInputStream);
            JarEntry jarEntry = ((JarInputStream)jarInputStream).getNextJarEntry();
            while (jarEntry != null) {
                if (jarEntry.getName().endsWith(".class")) {
                    String className = PATTERN_SLASH.matcher(jarEntry.getName()).replaceAll("\\.").substring(0, jarEntry.getName().length() - 6);
                    if (functionClasses.contains(className)) {
                        if (isDebugEnabled) {
                            logger.debug("Attempting to load class: {}, from JAR file: {}", (Object)jarEntry.getName(), (Object)this.file.getAbsolutePath());
                        }
                        try {
                            Class<?> clazz = ClassPathLoader.getLatest().forName(className);
                            Collection<Function> registerableFunctions = this.getRegisterableFunctionsFromClass(clazz);
                            for (Function function : registerableFunctions) {
                                FunctionService.registerFunction(function);
                                if (isDebugEnabled) {
                                    logger.debug("Registering function class: {}, from JAR file: {}", (Object)className, (Object)this.file.getAbsolutePath());
                                }
                                this.registeredFunctions.add(function);
                            }
                        }
                        catch (ClassNotFoundException | NoClassDefFoundError cnfex) {
                            logger.error("Unable to load all classes from JAR file: {}", (Object)this.file.getAbsolutePath(), (Object)cnfex);
                            throw cnfex;
                        }
                    } else if (isDebugEnabled) {
                        logger.debug("No functions found in class: {}, from JAR file: {}", (Object)jarEntry.getName(), (Object)this.file.getAbsolutePath());
                    }
                }
                jarEntry = ((JarInputStream)jarInputStream).getNextJarEntry();
            }
        }
        catch (IOException ioex) {
            logger.error("Exception when trying to read class from ByteArrayInputStream", (Throwable)ioex);
        }
        finally {
            if (jarInputStream != null) {
                try {
                    jarInputStream.close();
                }
                catch (IOException ioex) {
                    logger.error("Exception attempting to close JAR input stream", (Throwable)ioex);
                }
            }
        }
    }

    protected synchronized void cleanUp(DeployedJar newVersion) {
        Stream<String> removedFunctions;
        Stream<String> oldFunctions = this.registeredFunctions.stream().map(Function::getId);
        if (newVersion == null) {
            removedFunctions = oldFunctions;
        } else {
            Predicate<String> isRemoved = oldFunctionId -> !newVersion.hasFunctionWithId((String)oldFunctionId);
            removedFunctions = oldFunctions.filter(isRemoved);
        }
        removedFunctions.forEach(FunctionService::unregisterFunction);
        this.registeredFunctions.clear();
        try {
            TypeRegistry typeRegistry = ((InternalCache)CacheFactory.getAnyInstance()).getPdxRegistry();
            if (typeRegistry != null) {
                typeRegistry.flushCache();
            }
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
    }

    boolean hasSameContentAs(byte[] compareToBytes) {
        if (messageDigest == null || this.md5hash == null) {
            return Arrays.equals(compareToBytes, this.getJarContent());
        }
        byte[] compareToMd5 = messageDigest.digest(compareToBytes);
        if (logger.isDebugEnabled()) {
            logger.debug("For JAR file: {}, Comparing MD5 hash {} to {}", (Object)this.file.getAbsolutePath(), (Object)new String(this.md5hash), (Object)new String(compareToMd5));
        }
        return Arrays.equals(this.md5hash, compareToMd5);
    }

    private Collection<Function> getRegisterableFunctionsFromClass(Class<?> clazz) {
        ArrayList<Function> registerableFunctions;
        block8: {
            registerableFunctions = new ArrayList<Function>();
            try {
                Function function;
                if (!Function.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) break block8;
                boolean registerUninitializedFunction = true;
                if (Declarable.class.isAssignableFrom(clazz)) {
                    try {
                        List<Properties> propertiesList = ((InternalCache)CacheFactory.getAnyInstance()).getDeclarableProperties(clazz.getName());
                        if (!propertiesList.isEmpty()) {
                            registerUninitializedFunction = false;
                            for (Properties properties : propertiesList) {
                                Function function2 = this.newFunction(clazz, true);
                                if (function2 == null) continue;
                                ((Declarable)((Object)function2)).init(properties);
                                if (function2.getId() == null) continue;
                                registerableFunctions.add(function2);
                            }
                        }
                    }
                    catch (CacheClosedException propertiesList) {
                        // empty catch block
                    }
                }
                if (registerUninitializedFunction && (function = this.newFunction(clazz, false)) != null && function.getId() != null) {
                    registerableFunctions.add(function);
                }
            }
            catch (Exception ex) {
                logger.error("Attempting to register function from JAR file: {}", (Object)this.file.getAbsolutePath(), (Object)ex);
            }
        }
        return registerableFunctions;
    }

    protected Collection<String> findFunctionsInThisJar() throws IOException {
        return new FunctionScanner().findFunctionsInJar(this.file);
    }

    private Function newFunction(Class<Function> clazz, boolean errorOnNoSuchMethod) {
        try {
            Constructor<Function> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException nsmex) {
            if (errorOnNoSuchMethod) {
                logger.error("Zero-arg constructor is required, but not found for class: {}", (Object)clazz.getName(), (Object)nsmex);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Not registering function because it doesn't have a zero-arg constructor: {}", (Object)clazz.getName());
            }
        }
        catch (Exception ex) {
            logger.error("Error when attempting constructor for function for class: {}", (Object)clazz.getName(), (Object)ex);
        }
        return null;
    }

    private byte[] getJarContent() {
        try {
            int bytesRead;
            FileInputStream channelInputStream = new FileInputStream(this.file);
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            byte[] bytes = new byte[4096];
            while ((bytesRead = ((InputStream)channelInputStream).read(bytes)) != -1) {
                byteOutStream.write(bytes, 0, bytesRead);
            }
            ((InputStream)channelInputStream).close();
            return byteOutStream.toByteArray();
        }
        catch (IOException e) {
            logger.error("Error when attempting to read jar contents: ", (Throwable)e);
            return ZERO_BYTES;
        }
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getFileCanonicalPath() throws IOException {
        return this.file.getCanonicalPath();
    }

    public URL getFileURL() {
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException e) {
            logger.warn((Object)e);
            return null;
        }
    }

    private boolean hasFunctionWithId(String id) {
        if (CollectionUtils.isEmpty(this.registeredFunctions)) {
            return false;
        }
        return this.registeredFunctions.stream().map(Function::getId).anyMatch(functionId -> functionId.equals(id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jarName == null ? 0 : this.jarName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeployedJar other = (DeployedJar)obj;
        return !(this.jarName == null ? other.jarName != null : !this.jarName.equals(other.jarName));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('@').append(System.identityHashCode(this)).append('{');
        sb.append("jarName=").append(this.jarName);
        sb.append(",file=").append(this.file.getAbsolutePath());
        sb.append(",md5hash=").append(Arrays.toString(this.md5hash));
        sb.append(",version=").append(this.getVersion());
        sb.append('}');
        return sb.toString();
    }
}

