/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;

public class ShutdownAllResponse
extends AdminResponse {
    private transient boolean isToShutDown = true;

    public ShutdownAllResponse() {
    }

    @Override
    public boolean getInlineProcess() {
        return true;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    @Override
    public boolean orderedDelivery() {
        return true;
    }

    public ShutdownAllResponse(InternalDistributedMember sender, boolean isToShutDown) {
        this.setRecipient(sender);
        this.isToShutDown = isToShutDown;
    }

    @Override
    public int getDSFID() {
        return 2112;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeBoolean(this.isToShutDown);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.isToShutDown = in.readBoolean();
    }

    @Override
    public String toString() {
        return "ShutdownAllResponse from " + this.getSender() + " msgId=" + this.getMsgId() + " isToShutDown=" + this.isToShutDown;
    }

    public boolean isToShutDown() {
        return this.isToShutDown;
    }
}

