/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.ByteArrayDataInput;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.AbstractDiskRegionEntry;
import org.apache.geode.internal.cache.DiskEntry;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryBits;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.versions.VersionTag;

public abstract class AbstractOplogDiskRegionEntry
extends AbstractDiskRegionEntry {
    protected AbstractOplogDiskRegionEntry(RegionEntryContext context, Object value) {
        super(context, value);
    }

    abstract void setDiskId(RegionEntry var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePhase1(LocalRegion r, boolean isClear) throws RegionClearedException {
        AbstractOplogDiskRegionEntry abstractOplogDiskRegionEntry = this;
        synchronized (abstractOplogDiskRegionEntry) {
            DiskEntry.Helper.removeFromDisk(this, r, isClear);
            this._removePhase1();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePhase2() {
        Object syncObj = this.getDiskId();
        if (syncObj == null) {
            syncObj = this;
        }
        DiskId diskId = syncObj;
        synchronized (diskId) {
            super.removePhase2();
        }
    }

    @Override
    public boolean fillInValue(LocalRegion r, InitialImageOperation.Entry entry, ByteArrayDataInput in, DM mgr, Version version) {
        return DiskEntry.Helper.fillInValue(this, entry, r.getDiskRegion(), mgr, in, r, version);
    }

    @Override
    public boolean isOverflowedToDisk(LocalRegion r, DistributedRegion.DiskPosition dp) {
        return DiskEntry.Helper.isOverflowedToDisk(this, r.getDiskRegion(), dp, r);
    }

    @Override
    public Object getValue(RegionEntryContext context) {
        return DiskEntry.Helper.faultInValue(this, (LocalRegion)context);
    }

    @Override
    public Object getValueRetain(RegionEntryContext context) {
        return DiskEntry.Helper.faultInValueRetain(this, (LocalRegion)context);
    }

    @Override
    public Object getValueInVMOrDiskWithoutFaultIn(LocalRegion owner) {
        return DiskEntry.Helper.getValueInVMOrDiskWithoutFaultIn(this, owner);
    }

    @Override
    public Object getValueOffHeapOrDiskWithoutFaultIn(LocalRegion owner) {
        return DiskEntry.Helper.getValueOffHeapOrDiskWithoutFaultIn(this, owner);
    }

    @Override
    public Object getValueOnDisk(LocalRegion r) throws EntryNotFoundException {
        return DiskEntry.Helper.getValueOnDisk(this, r.getDiskRegion());
    }

    @Override
    public Object getSerializedValueOnDisk(LocalRegion r) throws EntryNotFoundException {
        return DiskEntry.Helper.getSerializedValueOnDisk(this, r.getDiskRegion());
    }

    @Override
    public Object getValueOnDiskOrBuffer(LocalRegion r) throws EntryNotFoundException {
        return DiskEntry.Helper.getValueOnDiskOrBuffer(this, r.getDiskRegion(), r);
    }

    @Override
    public DiskEntry getPrev() {
        return this.getDiskId().getPrev();
    }

    @Override
    public DiskEntry getNext() {
        return this.getDiskId().getNext();
    }

    @Override
    public void setPrev(DiskEntry v) {
        this.getDiskId().setPrev(v);
    }

    @Override
    public void setNext(DiskEntry v) {
        this.getDiskId().setNext(v);
    }

    @Override
    public void persistConflictingTag(LocalRegion region, VersionTag tag) {
        DiskEntry.Helper.updateVersionOnly(this, region, tag);
        this.setRecentlyUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processVersionTag(EntryEvent cacheEvent) {
        LocalRegion lr;
        DiskId did = this.getDiskId();
        boolean checkConflicts = true;
        if (did != null && (lr = (LocalRegion)cacheEvent.getRegion()) != null && lr.getDiskRegion().isReadyForRecovery()) {
            DiskId diskId = did;
            synchronized (diskId) {
                checkConflicts = !EntryBits.isRecoveredFromDisk(did.getUserBits());
            }
        }
        this.processVersionTag(cacheEvent, checkConflicts);
    }

    @Override
    public boolean isRemovedFromDisk() {
        return Token.isRemovedFromDisk(this.getValueAsToken());
    }
}

