/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.GemFireException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.InvalidVersionException;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public abstract class AbstractUpdateOperation
extends DistributedCacheOperation {
    private static final Logger logger = LogService.getLogger();
    public static volatile boolean test_InvalidVersion;
    @SuppressWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="test hook that is unset normally")
    private final long lastModifiedTime;
    private static final boolean ALWAYS_REPLICATE_UPDATES;

    public AbstractUpdateOperation(CacheEvent event, long lastModifiedTime) {
        super(event);
        this.lastModifiedTime = lastModifiedTime;
    }

    @Override
    protected Set getRecipients() {
        CacheDistributionAdvisor advisor = this.getRegion().getCacheDistributionAdvisor();
        return advisor.adviseUpdate(this.getEvent());
    }

    @Override
    protected void initMessage(DistributedCacheOperation.CacheOperationMessage msg, DirectReplyProcessor pr) {
        super.initMessage(msg, pr);
        AbstractUpdateMessage m = (AbstractUpdateMessage)msg;
        DistributedRegion region = this.getRegion();
        DM mgr = region.getDistributionManager();
        m.lastModified = this.lastModifiedTime;
    }

    private static boolean shouldDoRemoteCreate(LocalRegion rgn, EntryEventImpl ev) {
        DataPolicy dp = rgn.getAttributes().getDataPolicy();
        return rgn.isAllEvents() && (!dp.withReplication() || !rgn.isInitialized() || !ev.getOperation().isUpdate() || rgn.concurrencyChecksEnabled || ALWAYS_REPLICATE_UPDATES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean doPutOrCreate(LocalRegion rgn, EntryEventImpl ev, long lastMod) {
        try {
            long startPut;
            boolean updated = false;
            boolean doUpdate = true;
            if (AbstractUpdateOperation.shouldDoRemoteCreate(rgn, ev)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("doPutOrCreate: attempting to create entry");
                }
                startPut = CachePerfStats.getStatTime();
                boolean isBucket = rgn.isUsedForPartitionedRegionBucket();
                if (isBucket) {
                    BucketRegion br = (BucketRegion)rgn;
                    br.getPartitionedRegion().getPrStats().startApplyReplication();
                }
                try {
                    boolean overwriteDestroyed = ev.getOperation().isCreate();
                    if (rgn.basicUpdate(ev, true, false, lastMod, overwriteDestroyed)) {
                        rgn.getCachePerfStats().endPut(startPut, ev.isOriginRemote());
                        doUpdate = false;
                        updated = true;
                    } else if (ev.oldValueIsDestroyedToken()) {
                        if (rgn.getVersionVector() != null && ev.getVersionTag() != null) {
                            rgn.getVersionVector().recordVersion((InternalDistributedMember)ev.getDistributedMember(), ev.getVersionTag());
                        }
                        doUpdate = false;
                    }
                }
                finally {
                    if (isBucket) {
                        BucketRegion br = (BucketRegion)rgn;
                        br.getPartitionedRegion().getPrStats().endApplyReplication(startPut);
                    }
                }
            }
            if (doUpdate) {
                if (!ev.isLocalInvalid()) {
                    BucketRegion br;
                    startPut = CachePerfStats.getStatTime();
                    boolean overwriteDestroyed = ev.getOperation().isCreate();
                    boolean isBucket = rgn.isUsedForPartitionedRegionBucket();
                    if (isBucket) {
                        br = (BucketRegion)rgn;
                        br.getPartitionedRegion().getPrStats().startApplyReplication();
                    }
                    try {
                        if (rgn.basicUpdate(ev, false, true, lastMod, overwriteDestroyed)) {
                            rgn.getCachePerfStats().endPut(startPut, ev.isOriginRemote());
                            if (logger.isTraceEnabled()) {
                                logger.trace("Processing put key {} in region {}", ev.getKey(), (Object)rgn.getFullPath());
                            }
                            updated = true;
                            return true;
                        }
                        if (rgn.isUsedForPartitionedRegionBucket() || rgn.dataPolicy.withReplication() && rgn.getConcurrencyChecksEnabled()) {
                            overwriteDestroyed = true;
                            ev.makeCreate();
                            rgn.basicUpdate(ev, true, false, lastMod, overwriteDestroyed);
                            rgn.getCachePerfStats().endPut(startPut, ev.isOriginRemote());
                            updated = true;
                            return true;
                        }
                        if (rgn.getVersionVector() != null && ev.getVersionTag() != null) {
                            rgn.getVersionVector().recordVersion((InternalDistributedMember)ev.getDistributedMember(), ev.getVersionTag());
                        }
                        if (!logger.isDebugEnabled()) return true;
                        logger.debug("While processing Update message, update not performed because this key is {}", (Object)(ev.oldValueIsDestroyedToken() ? "blocked by DESTROYED/TOMBSTONE token" : "not defined"));
                        return true;
                    }
                    finally {
                        if (isBucket) {
                            br = (BucketRegion)rgn;
                            br.getPartitionedRegion().getPrStats().endApplyReplication(startPut);
                        }
                    }
                } else {
                    if (!logger.isTraceEnabled()) return true;
                    logger.trace("Processing create with null value provided, value not put");
                }
                return true;
            } else {
                if (rgn.getVersionVector() != null && ev.getVersionTag() != null && !ev.getVersionTag().isRecorded()) {
                    rgn.getVersionVector().recordVersion((InternalDistributedMember)ev.getDistributedMember(), ev.getVersionTag());
                }
                if (updated || !logger.isDebugEnabled()) return true;
                logger.debug("While processing Update message, update not performed because key was created but mirroring keys only and value not in update message, OR key was not new for sender and has been destroyed here");
            }
            return true;
        }
        catch (CacheWriterException e) {
            throw new Error(LocalizedStrings.AbstractUpdateOperation_CACHEWRITER_SHOULD_NOT_BE_CALLED.toLocalizedString(), e);
        }
        catch (TimeoutException e) {
            throw new Error(LocalizedStrings.AbstractUpdateOperation_DISTRIBUTEDLOCK_SHOULD_NOT_BE_ACQUIRED.toLocalizedString(), e);
        }
    }

    static {
        ALWAYS_REPLICATE_UPDATES = Boolean.getBoolean("GemFire.ALWAYS_REPLICATE_UPDATES");
    }

    public static abstract class AbstractUpdateMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected long lastModified;

        @Override
        protected boolean operateOnRegion(CacheEvent event, DistributionManager dm) throws EntryNotFoundException {
            EntryEventImpl ev = (EntryEventImpl)event;
            DistributedRegion rgn = (DistributedRegion)ev.region;
            DistributionManager mgr = dm;
            boolean sendReply = true;
            if (!rgn.isCacheContentProxy()) {
                this.basicOperateOnRegion(ev, rgn);
            } else if (logger.isDebugEnabled()) {
                logger.debug("UpdateMessage: this cache has already seen this event {}", (Object)event);
            }
            return sendReply;
        }

        protected void basicOperateOnRegion(EntryEventImpl ev, DistributedRegion rgn) {
            if (logger.isDebugEnabled()) {
                logger.debug("Processing  {}", (Object)this);
            }
            try {
                long time = this.lastModified;
                if (ev.getVersionTag() != null) {
                    this.checkVersionTag(rgn, ev.getVersionTag());
                    time = ev.getVersionTag().getVersionTimeStamp();
                }
                this.appliedOperation = AbstractUpdateOperation.doPutOrCreate(rgn, ev, time);
            }
            catch (ConcurrentCacheModificationException e) {
                this.dispatchElidedEvent(rgn, ev);
                this.appliedOperation = false;
            }
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; lastModified=");
            buff.append(this.lastModified);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.lastModified = in.readLong();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeLong(this.lastModified);
        }

        protected void checkVersionTag(DistributedRegion rgn, VersionTag tag) {
            RegionAttributes attr = rgn.getAttributes();
            if (attr.getConcurrencyChecksEnabled() && attr.getDataPolicy().withPersistence() && attr.getScope() != Scope.GLOBAL && (tag.getMemberID() == null || test_InvalidVersion)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Version tag is missing the memberID: {}", (Object)tag);
                }
                String msg = LocalizedStrings.DistributedPutAllOperation_MISSING_VERSION.toLocalizedString(tag);
                GemFireException ex = this.sender.getVersionObject().compareTo(Version.GFE_80) < 0 ? new InternalGemFireException(msg) : new InvalidVersionException(msg);
                throw ex;
            }
        }

        @Override
        protected boolean mayAddToMultipleSerialGateways(DistributionManager dm) {
            return this._mayAddToMultipleSerialGateways(dm);
        }
    }
}

