/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class BackupLock
extends ReentrantLock {
    private final ThreadLocal<Boolean> isBackupThread = new ThreadLocal();
    boolean isBackingUp;
    Condition backupDone = super.newCondition();
    private BackupLockTestHook hook = null;

    public void setBackupLockTestHook(BackupLockTestHook testHook) {
        this.hook = testHook;
    }

    public void lockForBackup() {
        super.lock();
        this.isBackingUp = true;
        super.unlock();
    }

    public void setBackupThread() {
        this.isBackupThread.set(true);
    }

    public void unlockForBackup() {
        super.lock();
        this.isBackingUp = false;
        this.isBackupThread.set(false);
        this.backupDone.signalAll();
        super.unlock();
    }

    public boolean isCurrentThreadDoingBackup() {
        Boolean result = this.isBackupThread.get();
        return result != null && result != false;
    }

    @Override
    public void unlock() {
        if (!this.isCurrentThreadDoingBackup()) {
            super.unlock();
        }
    }

    @Override
    public void lock() {
        if (!this.isCurrentThreadDoingBackup()) {
            super.lock();
            while (this.isBackingUp) {
                if (this.hook != null) {
                    this.hook.beforeWaitForBackupCompletion();
                }
                this.backupDone.awaitUninterruptibly();
            }
        }
    }

    public static interface BackupLockTestHook {
        public void beforeWaitForBackupCompletion();
    }
}

