/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.FileUtils;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.DeployedJar;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskStoreBackup;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.Oplog;
import org.apache.geode.internal.cache.persistence.BackupInspector;
import org.apache.geode.internal.cache.persistence.RestoreScript;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class BackupManager
implements MembershipListener {
    private static final Logger logger = LogService.getLogger(BackupManager.class);
    static final String INCOMPLETE_BACKUP_FILE = "INCOMPLETE_BACKUP_FILE";
    private static final String BACKUP_DIR_PREFIX = "dir";
    private static final String README_FILE = "README_FILE.txt";
    private static final String DATA_STORES_DIRECTORY = "diskstores";
    private static final String USER_FILES = "user";
    private static final String CONFIG_DIRECTORY = "config";
    private final Map<DiskStoreImpl, DiskStoreBackup> backupByDiskStore = new HashMap<DiskStoreImpl, DiskStoreBackup>();
    private final RestoreScript restoreScript = new RestoreScript();
    private final InternalDistributedMember sender;
    private final InternalCache cache;
    private final CountDownLatch allowDestroys = new CountDownLatch(1);
    private volatile boolean isCancelled = false;

    public BackupManager(InternalDistributedMember sender, InternalCache gemFireCache) {
        this.sender = sender;
        this.cache = gemFireCache;
    }

    public void validateRequestingAdmin() {
        Set allIds = this.getDistributionManager().addAllMembershipListenerAndGetAllIds(this);
        if (!allIds.contains(this.sender)) {
            this.cleanup();
            throw new IllegalStateException("The admin member requesting a backup has already departed");
        }
    }

    public HashSet<PersistentID> prepareForBackup() {
        HashSet<PersistentID> persistentIds = new HashSet<PersistentID>();
        for (DiskStore store : this.cache.listDiskStoresIncludingRegionOwned()) {
            DiskStoreImpl storeImpl = (DiskStoreImpl)store;
            storeImpl.lockStoreBeforeBackup();
            if (!storeImpl.hasPersistedData()) continue;
            persistentIds.add(storeImpl.getPersistentID());
            storeImpl.getStats().startBackup();
        }
        return persistentIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<PersistentID> doBackup(File targetDir, File baselineDir, boolean abort) throws IOException {
        try {
            DiskStoreImpl diskStore;
            if (abort) {
                HashSet<PersistentID> hashSet = new HashSet<PersistentID>();
                return hashSet;
            }
            HashSet<PersistentID> persistentIds = new HashSet<PersistentID>();
            File backupDir = this.getBackupDir(targetDir);
            BackupInspector inspector = (baselineDir = this.checkBaseline(baselineDir)) == null ? null : BackupInspector.createInspector(baselineDir);
            File storesDir = new File(backupDir, DATA_STORES_DIRECTORY);
            Collection<DiskStore> diskStores = this.cache.listDiskStoresIncludingRegionOwned();
            HashMap<DiskStoreImpl, DiskStoreBackup> backupByDiskStore = new HashMap<DiskStoreImpl, DiskStoreBackup>();
            boolean foundPersistentData = false;
            for (DiskStore diskStore2 : diskStores) {
                diskStore = (DiskStoreImpl)diskStore2;
                if (diskStore.hasPersistedData()) {
                    if (!foundPersistentData) {
                        this.createBackupDir(backupDir);
                        foundPersistentData = true;
                    }
                    File diskStoreDir = new File(storesDir, this.getBackupDirName(diskStore));
                    diskStoreDir.mkdir();
                    DiskStoreBackup backup = this.startDiskStoreBackup(diskStore, diskStoreDir, inspector);
                    backupByDiskStore.put(diskStore, backup);
                }
                diskStore.releaseBackupLock();
            }
            this.allowDestroys.countDown();
            for (Map.Entry entry : backupByDiskStore.entrySet()) {
                diskStore = (DiskStoreImpl)entry.getKey();
                this.completeBackup(diskStore, (DiskStoreBackup)entry.getValue());
                diskStore.getStats().endBackup();
                persistentIds.add(diskStore.getPersistentID());
            }
            if (!backupByDiskStore.isEmpty()) {
                this.completeRestoreScript(backupDir);
            }
            HashSet<PersistentID> hashSet = persistentIds;
            return hashSet;
        }
        finally {
            this.cleanup();
        }
    }

    public void abort() {
        this.cleanup();
    }

    private DM getDistributionManager() {
        return this.cache.getInternalDistributedSystem().getDistributionManager();
    }

    private void cleanup() {
        this.isCancelled = true;
        this.allowDestroys.countDown();
        this.releaseBackupLocks();
        this.getDistributionManager().removeAllMembershipListener(this);
        this.cache.clearBackupManager();
    }

    private void releaseBackupLocks() {
        for (DiskStore store : this.cache.listDiskStoresIncludingRegionOwned()) {
            ((DiskStoreImpl)store).releaseBackupLock();
        }
    }

    private File findBaselineForThisMember(File baselineParentDir) {
        File baselineDir = null;
        for (DiskStore diskStore : this.cache.listDiskStoresIncludingRegionOwned()) {
            File[] matchingFiles = baselineParentDir.listFiles((file, name) -> name.endsWith(this.getBackupDirName((DiskStoreImpl)diskStore)));
            if (null == matchingFiles || matchingFiles.length <= 0) continue;
            baselineDir = matchingFiles[0].getParentFile().getParentFile();
        }
        return baselineDir;
    }

    private File checkBaseline(File baselineParentDir) throws IOException {
        File baselineDir = null;
        if (null != baselineParentDir) {
            File incompleteBackup;
            baselineDir = this.getBackupDir(baselineParentDir);
            if (!baselineDir.exists()) {
                baselineDir = this.findBaselineForThisMember(baselineParentDir);
            }
            if (null != baselineDir && (incompleteBackup = new File(baselineDir, INCOMPLETE_BACKUP_FILE)).exists()) {
                baselineDir = null;
            }
        }
        return baselineDir;
    }

    private void completeRestoreScript(File backupDir) throws IOException {
        this.backupConfigFiles(this.restoreScript, backupDir);
        this.backupUserFiles(this.restoreScript, backupDir);
        this.backupDeployedJars(this.restoreScript, backupDir);
        this.restoreScript.generate(backupDir);
        File incompleteFile = new File(backupDir, INCOMPLETE_BACKUP_FILE);
        if (!incompleteFile.delete()) {
            throw new IOException("Could not delete file INCOMPLETE_BACKUP_FILE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeBackup(DiskStoreImpl diskStore, DiskStoreBackup backup) throws IOException {
        if (backup == null) {
            return;
        }
        try {
            diskStore.waitForDelayedWrites();
            for (Oplog oplog : backup.getPendingBackup()) {
                if (this.isCancelled()) {
                    break;
                }
                int index = oplog.getDirectoryHolder().getArrayIndex();
                File backupDir = this.getBackupDir(backup.getTargetDir(), index);
                oplog.copyTo(backupDir);
                backup.backupFinished(oplog);
            }
        }
        finally {
            backup.cleanup();
        }
    }

    private String getBackupDirName(DiskStoreImpl diskStore) {
        String name = diskStore.getName();
        if (name == null) {
            name = GemFireCacheImpl.getDefaultDiskStoreName();
        }
        return name + "_" + diskStore.getDiskStoreID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DiskStoreBackup startDiskStoreBackup(DiskStoreImpl diskStore, File targetDir, BackupInspector baselineInspector) throws IOException {
        diskStore.getBackupLock().setBackupThread();
        DiskStoreBackup backup = null;
        boolean done = false;
        try {
            block12: {
                while (true) {
                    Object childLock;
                    Oplog childOplog;
                    if ((childOplog = diskStore.getPersistentOplogSet().getChild()) == null) {
                        backup = new DiskStoreBackup(new Oplog[0], targetDir);
                        this.backupByDiskStore.put(diskStore, backup);
                        break block12;
                    }
                    Object object = childLock = childOplog.lock;
                    synchronized (object) {
                        if (diskStore.getPersistentOplogSet().getChild() == childOplog) break;
                    }
                }
                {
                    if (logger.isDebugEnabled()) {
                        logger.debug("snapshotting oplogs for disk store {}", (Object)diskStore.getName());
                    }
                    this.createDiskStoreBackupDirs(diskStore, targetDir);
                    this.restoreScript.addExistenceTest(diskStore.getDiskInitFile().getIFFile());
                    Oplog[] allOplogs = null;
                    if (null != baselineInspector) {
                        HashMap<File, File> baselineCopyMap = new HashMap<File, File>();
                        allOplogs = this.filterBaselineOplogs(diskStore, baselineInspector, baselineCopyMap);
                        this.restoreScript.addBaselineFiles(baselineCopyMap);
                    } else {
                        allOplogs = diskStore.getAllOplogsForBackup();
                    }
                    backup = new DiskStoreBackup(allOplogs, targetDir);
                    this.backupByDiskStore.put(diskStore, backup);
                    File firstDir = this.getBackupDir(targetDir, diskStore.getInforFileDirIndex());
                    diskStore.getDiskInitFile().copyTo(firstDir);
                    diskStore.getPersistentOplogSet().forceRoll(null);
                    if (logger.isDebugEnabled()) {
                        logger.debug("done snaphotting for disk store {}", (Object)diskStore.getName());
                    }
                }
            }
            done = true;
            return backup;
        }
        finally {
            if (!done && backup != null) {
                this.backupByDiskStore.remove(diskStore);
                backup.cleanup();
            }
        }
    }

    private void createDiskStoreBackupDirs(DiskStoreImpl diskStore, File targetDir) throws IOException {
        DirectoryHolder[] directories = diskStore.getDirectoryHolders();
        for (int i = 0; i < directories.length; ++i) {
            File dir = this.getBackupDir(targetDir, i);
            if (!dir.mkdirs()) {
                throw new IOException("Could not create directory " + dir);
            }
            this.restoreScript.addFile(directories[i].getDir(), dir);
        }
    }

    private Oplog[] filterBaselineOplogs(DiskStoreImpl diskStore, BackupInspector baselineInspector, Map<File, File> baselineCopyMap) throws IOException {
        Oplog[] allOplogs;
        File baselineDir = new File(baselineInspector.getBackupDir(), DATA_STORES_DIRECTORY);
        baselineDir = new File(baselineDir, this.getBackupDirName(diskStore));
        Collection baselineOplogFiles = FileUtils.listFiles((File)baselineDir, (String[])new String[]{"krf", "drf", "crf"}, (boolean)true);
        LinkedList<Oplog> oplogList = new LinkedList<Oplog>();
        for (Oplog log : allOplogs = diskStore.getAllOplogsForBackup()) {
            Set<String> matchingOplogs;
            Map<File, File> oplogMap = log.mapBaseline(baselineOplogFiles);
            if (oplogMap.isEmpty() && baselineInspector.isIncremental() && !(matchingOplogs = log.gatherMatchingOplogFiles(baselineInspector.getIncrementalOplogFileNames())).isEmpty()) {
                for (String matchingOplog : matchingOplogs) {
                    oplogMap.put(new File(baselineInspector.getCopyFromForOplogFile(matchingOplog)), new File(baselineInspector.getCopyToForOplogFile(matchingOplog)));
                }
            }
            if (oplogMap.isEmpty()) {
                oplogList.add(log);
                continue;
            }
            baselineCopyMap.putAll(oplogMap);
        }
        return oplogList.toArray(new Oplog[oplogList.size()]);
    }

    private File getBackupDir(File targetDir, int index) {
        return new File(targetDir, BACKUP_DIR_PREFIX + index);
    }

    private void backupConfigFiles(RestoreScript restoreScript, File backupDir) throws IOException {
        URL propertyURL;
        File configBackupDir = new File(backupDir, CONFIG_DIRECTORY);
        configBackupDir.mkdirs();
        URL url = this.cache.getCacheXmlURL();
        if (url != null) {
            File cacheXMLBackup = new File(configBackupDir, DistributionConfig.DEFAULT_CACHE_XML_FILE.getName());
            FileUtils.copyFile((File)new File(this.cache.getCacheXmlURL().getFile()), (File)cacheXMLBackup);
        }
        if ((propertyURL = DistributedSystem.getPropertiesFileURL()) != null) {
            File propertyBackup = new File(configBackupDir, "gemfire.properties");
            FileUtils.copyFile((File)new File(DistributedSystem.getPropertiesFile()), (File)propertyBackup);
        }
    }

    private void backupUserFiles(RestoreScript restoreScript, File backupDir) throws IOException {
        List<File> backupFiles = this.cache.getBackupFiles();
        File userBackupDir = new File(backupDir, USER_FILES);
        if (!userBackupDir.exists()) {
            userBackupDir.mkdir();
        }
        for (File original : backupFiles) {
            if (!original.exists()) continue;
            original = original.getAbsoluteFile();
            File dest = new File(userBackupDir, original.getName());
            if (original.isDirectory()) {
                FileUtils.copyDirectory((File)original, (File)dest);
            } else {
                FileUtils.copyFile((File)original, (File)dest);
            }
            restoreScript.addExistenceTest(original);
            restoreScript.addFile(original, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupDeployedJars(RestoreScript restoreScript, File backupDir) throws IOException {
        JarDeployer deployer = null;
        try {
            deployer = ClassPathLoader.getLatest().getJarDeployer();
            deployer.suspendAll();
            List<DeployedJar> jarList = deployer.findDeployedJars();
            if (!jarList.isEmpty()) {
                File userBackupDir = new File(backupDir, USER_FILES);
                if (!userBackupDir.exists()) {
                    userBackupDir.mkdir();
                }
                for (DeployedJar loader : jarList) {
                    File source = new File(loader.getFileCanonicalPath());
                    File dest = new File(userBackupDir, source.getName());
                    if (source.isDirectory()) {
                        FileUtils.copyDirectory((File)source, (File)dest);
                    } else {
                        FileUtils.copyFile((File)source, (File)dest);
                    }
                    restoreScript.addFile(source, dest);
                }
            }
        }
        finally {
            if (null != deployer) {
                deployer.resumeAll();
            }
        }
    }

    private File getBackupDir(File targetDir) throws IOException {
        InternalDistributedMember memberId = this.cache.getInternalDistributedSystem().getDistributedMember();
        String vmId = memberId.toString();
        vmId = this.cleanSpecialCharacters(vmId);
        return new File(targetDir, vmId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBackupDir(File backupDir) throws IOException {
        if (backupDir.exists()) {
            throw new IOException("Backup directory " + backupDir.getAbsolutePath() + " already exists.");
        }
        if (!backupDir.mkdirs()) {
            throw new IOException("Could not create directory: " + backupDir);
        }
        File incompleteFile = new File(backupDir, INCOMPLETE_BACKUP_FILE);
        if (!incompleteFile.createNewFile()) {
            throw new IOException("Could not create file: " + incompleteFile);
        }
        File readme = new File(backupDir, README_FILE);
        try (FileOutputStream fos = new FileOutputStream(readme);){
            String text = LocalizedStrings.BackupManager_README.toLocalizedString();
            fos.write(text.getBytes());
        }
    }

    private String cleanSpecialCharacters(String string) {
        return string.replaceAll("[^\\w]+", "_");
    }

    @Override
    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        this.cleanup();
    }

    @Override
    public void memberJoined(InternalDistributedMember id) {
    }

    @Override
    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    @Override
    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }

    public void waitForBackup() {
        try {
            this.allowDestroys.await();
        }
        catch (InterruptedException e) {
            throw new InternalGemFireError(e);
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public DiskStoreBackup getBackupForDiskStore(DiskStoreImpl diskStore) {
        return this.backupByDiskStore.get(diskStore);
    }
}

