/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CommitIncompleteException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.CommitReplyException;
import org.apache.geode.internal.cache.DistTXCoordinatorInterface;
import org.apache.geode.internal.cache.DistTXStateProxyImplOnCoordinator;
import org.apache.geode.internal.cache.DistTXStateProxyImplOnDatanode;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXMessage;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class DistTXCommitMessage
extends TXMessage {
    private static final Logger logger = LogService.getLogger();
    protected ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> entryStateList = null;

    public DistTXCommitMessage() {
    }

    public DistTXCommitMessage(TXId txUniqId, InternalDistributedMember onBehalfOfClientMember, ReplyProcessor21 processor) {
        super(txUniqId.getUniqId(), onBehalfOfClientMember, processor);
    }

    @Override
    public int getDSFID() {
        return -4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean operateOnTx(TXId txId, DistributionManager dm) throws RemoteOperationException {
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXCommitMessage.operateOnTx: Tx {}", (Object)txId);
        }
        InternalCache cache = dm.getCache();
        TXManagerImpl txMgr = cache.getTXMgr();
        TXStateProxy txStateProxy = txMgr.getTXState();
        TXCommitMessage cmsg = null;
        try {
            if (txMgr.isHostedTxRecentlyCompleted(txId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTXCommitMessage.operateOnTx: found a previously committed transaction:{}", (Object)txId);
                }
                if (txMgr.isExceptionToken(cmsg = txMgr.getRecentlyCompletedMessage(txId))) {
                    throw txMgr.getExceptionForToken(cmsg, txId);
                }
            } else if (txStateProxy != null) {
                if (!txStateProxy.isDistTx() || txStateProxy.isCreatedOnDistTxCoordinator()) {
                    throw new UnsupportedOperationInTransactionException(LocalizedStrings.DISTTX_TX_EXPECTED.toLocalizedString("DistTXStateProxyImplOnDatanode", txStateProxy.getClass().getSimpleName()));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTXCommitMessage.operateOnTx Commiting {}  incoming entryEventList:{} coming from {} ", (Object)txId, (Object)DistTXStateProxyImplOnCoordinator.printEntryEventList(this.entryStateList), (Object)this.getSender().getId());
                }
                String memberID = this.getSender().getId();
                for (ArrayList<TXEntryState.DistTxThinEntryState> esList : this.entryStateList) {
                    for (TXEntryState.DistTxThinEntryState es : esList) {
                        es.setMemberID(memberID);
                    }
                }
                ((DistTXStateProxyImplOnDatanode)txStateProxy).populateDistTxEntryStates(this.entryStateList);
                txStateProxy.setCommitOnBehalfOfRemoteStub(true);
                txMgr.commit();
                cmsg = txStateProxy.getCommitMessage();
            }
        }
        finally {
            txMgr.removeHostedTXState(txId);
        }
        DistTXCommitReplyMessage.send(this.getSender(), this.getProcessorId(), cmsg, this.getReplySender(dm));
        return false;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.entryStateList = DataSerializer.readArrayList(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeArrayList(this.entryStateList, out);
    }

    @Override
    public boolean isTransactionDistributed() {
        return true;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    public void setEntryStateList(ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> entryStateList) {
        this.entryStateList = entryStateList;
    }

    public static class DistTxCommitExceptionCollectingException
    extends ReplyException {
        private static final long serialVersionUID = -2681117727592137893L;
        private final Set<InternalDistributedMember> cacheExceptions = new HashSet<InternalDistributedMember>();
        private final Map<String, Set<InternalDistributedMember>> regionExceptions = new HashMap<String, Set<InternalDistributedMember>>();
        private final Map fatalExceptions = new HashMap();
        private final TXId id;

        public DistTxCommitExceptionCollectingException(TXId txIdent) {
            this.id = txIdent;
        }

        public void handlePotentialCommitFailure(HashMap<DistributedMember, DistTXCoordinatorInterface> msgMap) {
            if (this.fatalExceptions.size() > 0) {
                StringBuilder errorMessage = new StringBuilder("Incomplete commit of transaction ").append(this.id).append(".  Caused by the following exceptions: ");
                for (Map.Entry me : this.fatalExceptions.entrySet()) {
                    DistributedMember mem = (DistributedMember)me.getKey();
                    errorMessage.append(" From member: ").append(mem).append(" ");
                    List exceptions = (List)me.getValue();
                    Iterator ei = exceptions.iterator();
                    while (ei.hasNext()) {
                        Exception e = (Exception)ei.next();
                        errorMessage.append(e);
                        for (StackTraceElement ste : e.getStackTrace()) {
                            errorMessage.append("\n\tat ").append(ste);
                        }
                        if (!ei.hasNext()) continue;
                        errorMessage.append("\nAND\n");
                    }
                    errorMessage.append(".");
                }
                throw new CommitIncompleteException(errorMessage.toString());
            }
        }

        public Set<InternalDistributedMember> getCacheClosedMembers() {
            return this.cacheExceptions;
        }

        public Set getRegionDestroyedMembers(String regionFullPath) {
            Set<InternalDistributedMember> members = this.regionExceptions.get(regionFullPath);
            if (members == null) {
                members = Collections.emptySet();
            }
            return members;
        }

        public void addExceptionsFromMember(InternalDistributedMember member, Set exceptions) {
            for (Exception ex : exceptions) {
                if (ex instanceof CancelException) {
                    this.cacheExceptions.add(member);
                    continue;
                }
                if (ex instanceof RegionDestroyedException) {
                    String r = ((RegionDestroyedException)ex).getRegionFullPath();
                    Set<InternalDistributedMember> members = this.regionExceptions.get(r);
                    if (members == null) {
                        members = new HashSet<InternalDistributedMember>();
                        this.regionExceptions.put(r, members);
                    }
                    members.add(member);
                    continue;
                }
                ArrayList<Exception> el = (ArrayList<Exception>)this.fatalExceptions.get(member);
                if (el == null) {
                    el = new ArrayList<Exception>(2);
                    this.fatalExceptions.put(member, el);
                }
                el.add(ex);
            }
        }
    }

    public static class DistTxCommitReplyProcessor
    extends ReplyProcessor21 {
        private HashMap<DistributedMember, DistTXCoordinatorInterface> msgMap;
        private Map<DistributedMember, TXCommitMessage> commitResponseMap;
        private transient TXId txIdent = null;

        public DistTxCommitReplyProcessor(TXId txUniqId, DM dm, Set initMembers, HashMap<DistributedMember, DistTXCoordinatorInterface> msgMap) {
            super(dm, (Collection)initMembers);
            this.msgMap = msgMap;
            this.commitResponseMap = Collections.synchronizedMap(new HashMap());
            this.txIdent = txUniqId;
        }

        @Override
        public void process(DistributionMessage msg) {
            if (msg instanceof DistTXCommitReplyMessage) {
                DistTXCommitReplyMessage reply = (DistTXCommitReplyMessage)msg;
                this.commitResponseMap.put(reply.getSender(), reply.getCommitMessage());
            }
            super.process(msg);
        }

        public void waitForPrecommitCompletion() {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (DistTxCommitExceptionCollectingException e) {
                e.handlePotentialCommitFailure(this.msgMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processException(DistributionMessage msg, ReplyException ex) {
            if (msg instanceof ReplyMessage) {
                DistTxCommitReplyProcessor distTxCommitReplyProcessor = this;
                synchronized (distTxCommitReplyProcessor) {
                    if (this.exception == null) {
                        this.exception = new DistTxCommitExceptionCollectingException(this.txIdent);
                    }
                    DistTxCommitExceptionCollectingException cce = (DistTxCommitExceptionCollectingException)this.exception;
                    if (ex instanceof CommitReplyException) {
                        CommitReplyException cre = (CommitReplyException)ex;
                        cce.addExceptionsFromMember(msg.getSender(), cre.getExceptions());
                    } else {
                        cce.addExceptionsFromMember(msg.getSender(), Collections.singleton(ex));
                    }
                }
            }
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }

        public Set getCacheClosedMembers() {
            if (this.exception != null) {
                DistTxCommitExceptionCollectingException cce = (DistTxCommitExceptionCollectingException)this.exception;
                return cce.getCacheClosedMembers();
            }
            return Collections.emptySet();
        }

        public Set getRegionDestroyedMembers(String regionFullPath) {
            if (this.exception != null) {
                DistTxCommitExceptionCollectingException cce = (DistTxCommitExceptionCollectingException)this.exception;
                return cce.getRegionDestroyedMembers(regionFullPath);
            }
            return Collections.emptySet();
        }

        public Map<DistributedMember, TXCommitMessage> getCommitResponseMap() {
            return this.commitResponseMap;
        }
    }

    public static class DistTXCommitReplyMessage
    extends ReplyMessage {
        private transient TXCommitMessage commitMessage;

        public DistTXCommitReplyMessage() {
        }

        public DistTXCommitReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private DistTXCommitReplyMessage(int processorId, TXCommitMessage val) {
            this.setProcessorId(processorId);
            this.commitMessage = val;
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public static void send(InternalDistributedMember recipient, int processorId, TXCommitMessage val, ReplySender replySender) throws RemoteOperationException {
            Assert.assertTrue(recipient != null, "DistTXCommitPhaseTwoReplyMessage NULL reply message");
            DistTXCommitReplyMessage m = new DistTXCommitReplyMessage(processorId, val);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "DistTXCommitPhaseTwoReplyMessage process invoking reply processor with processorId:{}", (Object)this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "DistTXCommitPhaseTwoReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
        }

        @Override
        public int getDSFID() {
            return -2;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.commitMessage, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.commitMessage = (TXCommitMessage)DataSerializer.readObject(in);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DistTXCommitPhaseTwoReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }

        public TXCommitMessage getCommitMessage() {
            return this.commitMessage;
        }
    }
}

