/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CommitIncompleteException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.CommitReplyException;
import org.apache.geode.internal.cache.DistTXCoordinatorInterface;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.RemoteOperationMessage;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXMessage;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class DistTXRollbackMessage
extends TXMessage {
    private static final Logger logger = LogService.getLogger();

    public DistTXRollbackMessage() {
    }

    public DistTXRollbackMessage(TXId txUniqId, InternalDistributedMember onBehalfOfClientMember, ReplyProcessor21 processor) {
        super(txUniqId.getUniqId(), onBehalfOfClientMember, processor);
    }

    @Override
    public int getDSFID() {
        return 169;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean operateOnTx(TXId txId, DistributionManager dm) throws RemoteOperationException {
        if (logger.isDebugEnabled()) {
            logger.debug("Dist TX: Rollback: {}", (Object)txId);
        }
        InternalCache cache = dm.getCache();
        TXManagerImpl txMgr = cache.getTXMgr();
        TXStateProxy txState = txMgr.getTXState();
        boolean rollbackSuccessful = false;
        try {
            if (txMgr.isHostedTxRecentlyCompleted(txId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTXRollbackMessage.operateOnTx: found a previously committed transaction:{}", (Object)txId);
                }
            } else if (txState != null) {
                txMgr.rollback();
                rollbackSuccessful = true;
            }
        }
        finally {
            txMgr.removeHostedTXState(txId);
        }
        DistTXRollbackReplyMessage.send(this.getSender(), this.getProcessorId(), rollbackSuccessful, this.getReplySender(dm));
        return false;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
    }

    @Override
    public boolean isTransactionDistributed() {
        return true;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    public static class DistTxRollbackExceptionCollectingException
    extends ReplyException {
        private static final long serialVersionUID = -2681117727592137893L;
        private final Set<InternalDistributedMember> cacheExceptions = new HashSet<InternalDistributedMember>();
        private final Map<String, Set<InternalDistributedMember>> regionExceptions = new HashMap<String, Set<InternalDistributedMember>>();
        private final Map fatalExceptions = new HashMap();
        private final TXId id;

        public DistTxRollbackExceptionCollectingException(TXId txIdent) {
            this.id = txIdent;
        }

        public void handlePotentialCommitFailure(HashMap<DistributedMember, DistTXCoordinatorInterface> msgMap) {
            if (this.fatalExceptions.size() > 0) {
                StringBuilder errorMessage = new StringBuilder("Incomplete commit of transaction ").append(this.id).append(".  Caused by the following exceptions: ");
                for (Map.Entry me : this.fatalExceptions.entrySet()) {
                    DistributedMember mem = (DistributedMember)me.getKey();
                    errorMessage.append(" From member: ").append(mem).append(" ");
                    List exceptions = (List)me.getValue();
                    Iterator ei = exceptions.iterator();
                    while (ei.hasNext()) {
                        Exception e = (Exception)ei.next();
                        errorMessage.append(e);
                        for (StackTraceElement ste : e.getStackTrace()) {
                            errorMessage.append("\n\tat ").append(ste);
                        }
                        if (!ei.hasNext()) continue;
                        errorMessage.append("\nAND\n");
                    }
                    errorMessage.append(".");
                }
                throw new CommitIncompleteException(errorMessage.toString());
            }
        }

        public Set<InternalDistributedMember> getCacheClosedMembers() {
            return this.cacheExceptions;
        }

        public Set getRegionDestroyedMembers(String regionFullPath) {
            Set<InternalDistributedMember> members = this.regionExceptions.get(regionFullPath);
            if (members == null) {
                members = Collections.emptySet();
            }
            return members;
        }

        public void addExceptionsFromMember(InternalDistributedMember member, Set exceptions) {
            for (Exception ex : exceptions) {
                if (ex instanceof CancelException) {
                    this.cacheExceptions.add(member);
                    continue;
                }
                if (ex instanceof RegionDestroyedException) {
                    String r = ((RegionDestroyedException)ex).getRegionFullPath();
                    Set<InternalDistributedMember> members = this.regionExceptions.get(r);
                    if (members == null) {
                        members = new HashSet<InternalDistributedMember>();
                        this.regionExceptions.put(r, members);
                    }
                    members.add(member);
                    continue;
                }
                ArrayList<Exception> el = (ArrayList<Exception>)this.fatalExceptions.get(member);
                if (el == null) {
                    el = new ArrayList<Exception>(2);
                    this.fatalExceptions.put(member, el);
                }
                el.add(ex);
            }
        }
    }

    public static class DistTxRollbackReplyProcessor
    extends ReplyProcessor21 {
        private HashMap<DistributedMember, DistTXCoordinatorInterface> msgMap;
        private Map<DistributedMember, Boolean> rollbackResponseMap;
        private transient TXId txIdent = null;

        public DistTxRollbackReplyProcessor(TXId txUniqId, DM dm, Set initMembers, HashMap<DistributedMember, DistTXCoordinatorInterface> msgMap) {
            super(dm, (Collection)initMembers);
            this.msgMap = msgMap;
            this.rollbackResponseMap = Collections.synchronizedMap(new HashMap());
            this.txIdent = txUniqId;
        }

        @Override
        public void process(DistributionMessage msg) {
            if (msg instanceof DistTXRollbackReplyMessage) {
                DistTXRollbackReplyMessage reply = (DistTXRollbackReplyMessage)msg;
                this.rollbackResponseMap.put(reply.getSender(), reply.getRollbackState());
            }
            super.process(msg);
        }

        public void waitForPrecommitCompletion() {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (DistTxRollbackExceptionCollectingException e) {
                e.handlePotentialCommitFailure(this.msgMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processException(DistributionMessage msg, ReplyException ex) {
            if (msg instanceof ReplyMessage) {
                DistTxRollbackReplyProcessor distTxRollbackReplyProcessor = this;
                synchronized (distTxRollbackReplyProcessor) {
                    if (this.exception == null) {
                        this.exception = new DistTxRollbackExceptionCollectingException(this.txIdent);
                    }
                    DistTxRollbackExceptionCollectingException cce = (DistTxRollbackExceptionCollectingException)this.exception;
                    if (ex instanceof CommitReplyException) {
                        CommitReplyException cre = (CommitReplyException)ex;
                        cce.addExceptionsFromMember(msg.getSender(), cre.getExceptions());
                    } else {
                        cce.addExceptionsFromMember(msg.getSender(), Collections.singleton(ex));
                    }
                }
            }
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }

        public Set getCacheClosedMembers() {
            if (this.exception != null) {
                DistTxRollbackExceptionCollectingException cce = (DistTxRollbackExceptionCollectingException)this.exception;
                return cce.getCacheClosedMembers();
            }
            return Collections.emptySet();
        }

        public Set getRegionDestroyedMembers(String regionFullPath) {
            if (this.exception != null) {
                DistTxRollbackExceptionCollectingException cce = (DistTxRollbackExceptionCollectingException)this.exception;
                return cce.getRegionDestroyedMembers(regionFullPath);
            }
            return Collections.emptySet();
        }

        public Map<DistributedMember, Boolean> getRollbackResponseMap() {
            return this.rollbackResponseMap;
        }
    }

    public static class DistTXRollbackResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile Boolean rollbackState;
        private volatile long start;

        public DistTXRollbackResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients, true);
        }

        public Boolean getRollbackState() {
            return this.rollbackState;
        }

        @Override
        public void process(DistributionMessage msg) {
            if (DistributionStats.enableClockStats) {
                this.start = DistributionStats.getStatTime();
            }
            if (msg instanceof DistTXRollbackReplyMessage) {
                DistTXRollbackReplyMessage reply = (DistTXRollbackReplyMessage)msg;
                this.rollbackState = reply.getRollbackState();
            }
            super.process(msg);
        }

        public Boolean waitForResponse() throws RemoteOperationException {
            try {
                this.waitForCacheException();
                if (DistributionStats.enableClockStats) {
                    this.getDistributionManager().getStats().incReplyHandOffTime(this.start);
                }
            }
            catch (RemoteOperationException e) {
                String msg = "DistTXRollbackResponse got RemoteOperationException; rethrowing";
                logger.debug("DistTXRollbackResponse got RemoteOperationException; rethrowing", (Throwable)e);
                throw e;
            }
            return this.rollbackState;
        }
    }

    public static class DistTXRollbackReplyMessage
    extends ReplyMessage {
        private transient Boolean rollbackState;

        public DistTXRollbackReplyMessage() {
        }

        public DistTXRollbackReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private DistTXRollbackReplyMessage(int processorId, Boolean val) {
            this.setProcessorId(processorId);
            this.rollbackState = val;
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public static void send(InternalDistributedMember recipient, int processorId, Boolean val, ReplySender replySender) throws RemoteOperationException {
            Assert.assertTrue(recipient != null, "DistTXRollbackReplyMessage NULL reply message");
            DistTXRollbackReplyMessage m = new DistTXRollbackReplyMessage(processorId, val);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "DistTXRollbackReplyMessage process invoking reply processor with processorId:{}", (Object)this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "DistTXRollbackReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
        }

        @Override
        public int getDSFID() {
            return 170;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeBoolean(this.rollbackState, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.rollbackState = DataSerializer.readBoolean(in);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DistTXRollbackReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }

        public Boolean getRollbackState() {
            return this.rollbackState;
        }
    }
}

