/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.DistTXCommitMessage;
import org.apache.geode.internal.cache.DistTXCoordinatorInterface;
import org.apache.geode.internal.cache.DistTXPrecommitMessage;
import org.apache.geode.internal.cache.DistTXRollbackMessage;
import org.apache.geode.internal.cache.DistTXState;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.DistTxEntryEvent;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class DistTXStateOnCoordinator
extends DistTXState
implements DistTXCoordinatorInterface {
    private ArrayList<DistTxEntryEvent> primaryTransactionalOperations = new ArrayList();
    private ArrayList<DistTxEntryEvent> secondaryTransactionalOperations = new ArrayList();
    private boolean preCommitResponse = false;
    private boolean rollbackResponse = false;

    public DistTXStateOnCoordinator(TXStateProxy proxy, boolean onBehalfOfRemoteStub) {
        super(proxy, onBehalfOfRemoteStub);
    }

    @Override
    public ArrayList<DistTxEntryEvent> getPrimaryTransactionalOperations() throws UnsupportedOperationInTransactionException {
        return this.primaryTransactionalOperations;
    }

    private void addPrimaryTransactionalOperations(DistTxEntryEvent dtop) {
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateOnCoordinator.addPrimaryTransactionalOperations add " + dtop + " ,stub before=" + this + " ,isUpdatingTxStateDuringPreCommit=" + this.isUpdatingTxStateDuringPreCommit());
        }
        if (!this.isUpdatingTxStateDuringPreCommit()) {
            this.primaryTransactionalOperations.add(dtop);
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateOnCoordinator.addPrimaryTransactionalOperations  add primary op = {}", (Object)dtop);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateOnCoordinator.addPrimaryTransactionalOperations stub after add = " + this);
        }
    }

    @Override
    public void addSecondaryTransactionalOperations(DistTxEntryEvent dtop) throws UnsupportedOperationInTransactionException {
        this.secondaryTransactionalOperations.add(dtop);
    }

    @Override
    public void precommit() {
        boolean retVal = this.applyOpsOnRedundantCopy(this.proxy.getCache().getDistributedSystem().getDistributedMember(), this.secondaryTransactionalOperations);
        if (retVal) {
            super.precommit();
        }
        this.preCommitResponse = retVal;
    }

    @Override
    public void rollback() {
        super.rollback();
        this.rollbackResponse = true;
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateOnCoordinator.putEntry " + event.getKeyInfo().getKey(), new Throwable());
        }
        boolean returnValue = super.putEntry(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
        if (!event.getOperation().isPutAll()) {
            this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
        }
        return returnValue;
    }

    @Override
    public boolean putEntryOnRemote(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws DataLocationException {
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateOnCoordinator.putEntryOnRemote " + event.getKeyInfo().getKey(), new Throwable());
        }
        boolean returnValue = super.putEntryOnRemote(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
        if (!event.getOperation().isPutAll()) {
            this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
        }
        return returnValue;
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException {
        super.destroyExistingEntry(event, cacheWrite, expectedOldValue);
        if (!event.getOperation().isRemoveAll()) {
            this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
        }
    }

    @Override
    public void destroyOnRemote(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws DataLocationException {
        super.destroyOnRemote(event, cacheWrite, expectedOldValue);
        if (!event.getOperation().isRemoveAll()) {
            this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
        }
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        super.invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
        this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
    }

    @Override
    public void invalidateOnRemote(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws DataLocationException {
        super.invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
        this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
    }

    @Override
    public void postPutAll(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts, LocalRegion region) {
        super.postPutAll(putallOp, successfulPuts, region);
        EntryEventImpl event = EntryEventImpl.createPutAllEvent(putallOp, region, Operation.PUTALL_CREATE, putallOp.getBaseEvent().getKey(), putallOp.getBaseEvent().getValue());
        event.setEventId(putallOp.getBaseEvent().getEventId());
        DistTxEntryEvent dtop = new DistTxEntryEvent(event);
        dtop.setPutAllOperation(putallOp);
        this.addPrimaryTransactionalOperations(dtop);
    }

    @Override
    public void postRemoveAll(DistributedRemoveAllOperation removeAllOp, VersionedObjectList successfulOps, LocalRegion region) {
        super.postRemoveAll(removeAllOp, successfulOps, region);
        EntryEventImpl event = EntryEventImpl.createRemoveAllEvent(removeAllOp, region, removeAllOp.getBaseEvent().getKey());
        event.setEventId(removeAllOp.getBaseEvent().getEventId());
        DistTxEntryEvent dtop = new DistTxEntryEvent(event);
        dtop.setRemoveAllOperation(removeAllOp);
        this.addPrimaryTransactionalOperations(dtop);
    }

    @Override
    public boolean getPreCommitResponse() throws UnsupportedOperationInTransactionException {
        return this.preCommitResponse;
    }

    @Override
    public boolean getRollbackResponse() throws UnsupportedOperationInTransactionException {
        return this.rollbackResponse;
    }

    @Override
    public void setPrecommitMessage(DistTXPrecommitMessage precommitMsg, DM dm) throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(LocalizedStrings.Dist_TX_PRECOMMIT_NOT_SUPPORTED_IN_A_TRANSACTION.toLocalizedString("setPrecommitMessage"));
    }

    @Override
    public void setCommitMessage(DistTXCommitMessage commitMsg, DM dm) throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(LocalizedStrings.Dist_TX_PRECOMMIT_NOT_SUPPORTED_IN_A_TRANSACTION.toLocalizedString("setCommitMessage"));
    }

    @Override
    public void setRollbackMessage(DistTXRollbackMessage rollbackMsg, DM dm) throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(LocalizedStrings.Dist_TX_ROLLBACK_NOT_SUPPORTED_IN_A_TRANSACTION.toLocalizedString("setRollbackMessage"));
    }

    @Override
    public void gatherAffectedRegions(HashSet<LocalRegion> regionSet, boolean includePrimaryRegions, boolean includeRedundantRegions) throws UnsupportedOperationInTransactionException {
        if (includePrimaryRegions) {
            for (DistTxEntryEvent dtos : this.primaryTransactionalOperations) {
                regionSet.add(dtos.getRegion());
            }
        }
        if (includeRedundantRegions) {
            for (DistTxEntryEvent dtos : this.secondaryTransactionalOperations) {
                regionSet.add(dtos.getRegion());
            }
        }
    }

    @Override
    public void gatherAffectedRegionsName(TreeSet<String> sortedRegionName, boolean includePrimaryRegions, boolean includeRedundantRegions) throws UnsupportedOperationInTransactionException {
        if (includePrimaryRegions) {
            DistTXStateOnCoordinator.gatherAffectedRegions(sortedRegionName, this.primaryTransactionalOperations);
        }
        if (includeRedundantRegions) {
            DistTXStateOnCoordinator.gatherAffectedRegions(sortedRegionName, this.secondaryTransactionalOperations);
        }
    }

    public static void gatherAffectedRegions(TreeSet<String> sortedRegionName, ArrayList<DistTxEntryEvent> regionOps) {
        for (DistTxEntryEvent dtos : regionOps) {
            LocalRegion lr = dtos.getRegion();
            if (lr instanceof PartitionedRegion) {
                sortedRegionName.add(PartitionedRegionHelper.getBucketFullPath(lr.getFullPath(), dtos.getKeyInfo().getBucketId()));
                continue;
            }
            sortedRegionName.add(lr.getFullPath());
        }
    }

    @Override
    protected boolean applyIndividualOp(DistTxEntryEvent dtop) throws DataLocationException {
        boolean result = true;
        if (dtop.op.isUpdate() || dtop.op.isCreate()) {
            if (dtop.op.isPutAll()) {
                assert (dtop.getPutAllOperation() != null);
                VersionedObjectList versions = new VersionedObjectList(dtop.getPutAllOperation().putAllDataSize, true, dtop.region.concurrencyChecksEnabled);
                this.postPutAll(dtop.getPutAllOperation(), versions, dtop.region);
            } else {
                result = this.putEntry(dtop, false, false, null, false, 0L, true);
            }
        } else if (dtop.op.isDestroy()) {
            if (dtop.op.isRemoveAll()) {
                assert (dtop.getRemoveAllOperation() != null);
                VersionedObjectList versions = new VersionedObjectList(dtop.getRemoveAllOperation().removeAllDataSize, true, dtop.region.concurrencyChecksEnabled);
                this.postRemoveAll(dtop.getRemoveAllOperation(), versions, dtop.region);
            } else {
                this.destroyExistingEntry(dtop, false, null);
            }
        } else if (dtop.op.isInvalidate()) {
            this.invalidateExistingEntry(dtop, true, false);
        } else {
            logger.debug("DistTXCommitPhaseOneMessage: unsupported TX operation {}", (Object)dtop);
            assert (false);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(" ,primary txOps=").append(this.primaryTransactionalOperations);
        builder.append(" ,secondary txOps=").append(this.secondaryTransactionalOperations);
        builder.append(" ,preCommitResponse=").append(this.preCommitResponse);
        builder.append(" ,rollbackResponse=").append(this.rollbackResponse);
        return builder.toString();
    }

    @Override
    public boolean isCreatedOnDistTxCoordinator() {
        return true;
    }

    @Override
    public void finalCleanup() {
        this.cleanup();
    }
}

