/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.locks.Lock;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.ExpiryTask;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class EntryExpiryTask
extends ExpiryTask {
    private static final Logger logger = LogService.getLogger();
    private RegionEntry re;
    public static boolean expireSendsEntryAsCallback = Boolean.getBoolean("gemfire.EXPIRE_SENDS_ENTRY_AS_CALLBACK");

    protected EntryExpiryTask(LocalRegion region, RegionEntry re) {
        super(region);
        this.re = re;
    }

    @Override
    protected ExpirationAttributes getTTLAttributes() {
        return this.getLocalRegion().getAttributes().getEntryTimeToLive();
    }

    @Override
    protected ExpirationAttributes getIdleAttributes() {
        return this.getLocalRegion().getAttributes().getEntryIdleTimeout();
    }

    protected RegionEntry getRegionEntry() {
        return this.re;
    }

    protected RegionEntry getCheckedRegionEntry() throws EntryNotFoundException {
        RegionEntry result = this.re;
        if (this.re == null || this.re.isDestroyedOrRemoved()) {
            throw new EntryNotFoundException("expiration task no longer has access to region entry");
        }
        return result;
    }

    @Override
    protected long getLastAccessedTime() throws EntryNotFoundException {
        RegionEntry re = this.getCheckedRegionEntry();
        try {
            return re.getLastAccessed();
        }
        catch (InternalStatisticsDisabledException e) {
            return 0L;
        }
    }

    @Override
    protected long getLastModifiedTime() throws EntryNotFoundException {
        return this.getCheckedRegionEntry().getLastModified();
    }

    private Object getValueForCallback(LocalRegion r, Object k) {
        Region.Entry e = r.getEntry(k);
        return e != null ? e.getValue() : null;
    }

    private Object createExpireEntryCallback(LocalRegion r, Object k) {
        return expireSendsEntryAsCallback ? this.getValueForCallback(r, k) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean destroy(boolean isPending) throws CacheException {
        RegionEntry re = this.getCheckedRegionEntry();
        Object key = re.getKey();
        LocalRegion lr = this.getLocalRegion();
        EntryEventImpl event = EntryEventImpl.create(lr, Operation.EXPIRE_DESTROY, key, null, this.createExpireEntryCallback(lr, key), false, lr.getMyId());
        try {
            event.setPendingSecondaryExpireDestroy(isPending);
            if (lr.generateEventID()) {
                event.setNewEventId(lr.getCache().getDistributedSystem());
            }
            lr.expireDestroy(event, true);
            boolean bl = true;
            return bl;
        }
        finally {
            event.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean invalidate() throws TimeoutException, EntryNotFoundException {
        RegionEntry re = this.getCheckedRegionEntry();
        Object key = re.getKey();
        LocalRegion lr = this.getLocalRegion();
        EntryEventImpl event = EntryEventImpl.create(lr, Operation.EXPIRE_INVALIDATE, key, null, this.createExpireEntryCallback(lr, key), false, lr.getMyId());
        try {
            if (lr.generateEventID()) {
                event.setNewEventId(lr.getCache().getDistributedSystem());
            }
            lr.expireInvalidate(event);
        }
        finally {
            event.release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean localDestroy() throws CacheException {
        RegionEntry re = this.getCheckedRegionEntry();
        Object key = re.getKey();
        LocalRegion lr = this.getLocalRegion();
        EntryEventImpl event = EntryEventImpl.create(lr, Operation.EXPIRE_LOCAL_DESTROY, key, null, this.createExpireEntryCallback(lr, key), false, lr.getMyId());
        try {
            if (lr.generateEventID()) {
                event.setNewEventId(lr.getCache().getDistributedSystem());
            }
            lr.expireDestroy(event, false);
        }
        finally {
            event.release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean localInvalidate() throws EntryNotFoundException {
        RegionEntry re = this.getCheckedRegionEntry();
        Object key = re.getKey();
        LocalRegion lr = this.getLocalRegion();
        EntryEventImpl event = EntryEventImpl.create(lr, Operation.EXPIRE_LOCAL_INVALIDATE, key, null, this.createExpireEntryCallback(lr, key), false, lr.getMyId());
        try {
            if (lr.generateEventID()) {
                event.setNewEventId(lr.getCache().getDistributedSystem());
            }
            lr.expireInvalidate(event);
        }
        finally {
            event.release();
        }
        return true;
    }

    @Override
    protected void reschedule() throws CacheException {
        if (this.isCacheClosing() || this.getLocalRegion().isClosed() || this.getLocalRegion().isDestroyed() || !this.isExpirationAllowed()) {
            return;
        }
        if (this.getExpirationTime() > 0L) {
            this.addExpiryTask();
            if (expiryTaskListener != null) {
                expiryTaskListener.afterReschedule(this);
            }
        }
    }

    @Override
    protected void addExpiryTask() throws EntryNotFoundException {
        this.getLocalRegion().addExpiryTask(this.getCheckedRegionEntry());
    }

    @Override
    public String toString() {
        String result = super.toString();
        RegionEntry re = this.re;
        if (re != null) {
            result = result + ", " + re.getKey();
        }
        return result;
    }

    @Override
    protected void performTimeout() throws CacheException {
        this.getLocalRegion().cancelExpiryTask(this.re, this);
        this.getLocalRegion().performExpiryTimeout(this);
    }

    @Override
    public boolean isPending() {
        RegionEntry re = this.re;
        if (re == null) {
            return false;
        }
        if (re.isDestroyedOrRemoved()) {
            return false;
        }
        ExpirationAction action = this.getAction();
        if (action == null) {
            return false;
        }
        return !action.isInvalidate() && !action.isLocalInvalidate() || !re.isInvalid();
    }

    @Override
    protected ExpirationAction getAction() {
        long ttl = this.getTTLAttributes().getTimeout();
        long idle = this.getIdleAttributes().getTimeout();
        ExpirationAction action = ttl == 0L ? this.getIdleAttributes().getAction() : (idle != 0L && idle < ttl ? this.getIdleAttributes().getAction() : this.getTTLAttributes().getAction());
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void basicPerformTimeout(boolean isPending) throws CacheException {
        block11: {
            if (!this.isExpirationAllowed()) {
                return;
            }
            if (!this.isExpirationPossible()) {
                this.reschedule();
                return;
            }
            long ttl = this.getTTLAttributes().getTimeout();
            long idle = this.getIdleAttributes().getTimeout();
            ExpirationAction action = ttl == 0L ? this.getIdleAttributes().getAction() : (idle != 0L && idle < ttl ? this.getIdleAttributes().getAction() : this.getTTLAttributes().getAction());
            if (this.getLocalRegion().getScope().isGlobal() && (action.isDestroy() || action.isInvalidate())) {
                Lock lock = this.getLocalRegion().getDistributedLock(this.getCheckedRegionEntry().getKey());
                lock.lock();
                try {
                    long expTime = this.getExpirationTime();
                    if (expTime == 0L) {
                        return;
                    }
                    if (this.getNow() >= expTime) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("{}.performTimeout().getExpirationTime() is {}; {}.expire({}). ttlExpiration: {}, idleExpiration: {}, ttlAttrs: {}, idleAttrs: {} action is: {}", (Object)this, (Object)expTime, (Object)this, (Object)action, (Object)ttl, (Object)idle, (Object)this.getTTLAttributes(), (Object)this.getIdleAttributes());
                        }
                        this.expire(action, isPending);
                        return;
                    }
                    break block11;
                }
                finally {
                    lock.unlock();
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{}..performTimeout().getExpirationTime() is {}", (Object)this, (Object)this.getExpirationTime());
            }
            this.expire(isPending);
            return;
        }
        this.reschedule();
    }

    @Override
    public Object getKey() {
        RegionEntry entry = this.re;
        if (entry == null) {
            throw new EntryDestroyedException();
        }
        return entry.getKey();
    }

    @Override
    public boolean cancel() {
        boolean superCancel = super.cancel();
        if (superCancel) {
            this.re = null;
            if (expiryTaskListener != null) {
                expiryTaskListener.afterCancel(this);
            }
        }
        return superCancel;
    }
}

