/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotSerializableException;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class FunctionStreamingReplyMessage
extends ReplyMessage {
    private static final Logger logger = LogService.getLogger();
    protected int msgNum;
    protected boolean lastMsg;
    protected Object result;

    public static void send(InternalDistributedMember recipient, int processorId, ReplyException exception, DM dm, Object result, int msgNum, boolean lastMsg) {
        FunctionStreamingReplyMessage m = new FunctionStreamingReplyMessage();
        m.processorId = processorId;
        if (exception != null) {
            m.setException(exception);
            if (logger.isDebugEnabled()) {
                logger.debug("Replying with exception: {}", (Object)m, (Object)exception);
            }
        }
        m.setRecipient(recipient);
        m.msgNum = msgNum;
        m.lastMsg = lastMsg;
        m.result = result;
        dm.putOutgoing(m);
    }

    public int getMessageNumber() {
        return this.msgNum;
    }

    public boolean isLastMessage() {
        return this.lastMsg;
    }

    public Object getResult() {
        return this.result;
    }

    @Override
    public int getDSFID() {
        return 1204;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.msgNum = in.readInt();
        this.lastMsg = in.readBoolean();
        this.processorId = in.readInt();
        try {
            this.result = DataSerializer.readObject(in);
        }
        catch (Exception e) {
            NotSerializableException ioEx = new NotSerializableException();
            ioEx.initCause(e);
            throw ioEx;
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.msgNum);
        out.writeBoolean(this.lastMsg);
        out.writeInt(this.processorId);
        try {
            DataSerializer.writeObject(this.result, out);
        }
        catch (Exception ex) {
            if (ex instanceof CancelException) {
                throw new DistributedSystemDisconnectedException(ex);
            }
            NotSerializableException ioEx = new NotSerializableException(this.result.getClass().getName());
            ioEx.initCause(ex);
            throw ioEx;
        }
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getClass().getName());
        buff.append("(processorId=");
        buff.append(this.processorId);
        buff.append(" from ");
        buff.append(this.getSender());
        ReplyException ex = this.getException();
        if (ex != null) {
            buff.append(" with exception ");
            buff.append(ex);
        }
        buff.append(";msgNum ");
        buff.append(this.msgNum);
        buff.append(";lastMsg=");
        buff.append(this.lastMsg);
        buff.append(")");
        return buff.toString();
    }
}

