/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.geode.DataSerializable;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.LoaderHelper;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.CacheDistributionAdvisee;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.Conflatable;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.DummyCachePerfStats;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.event.EventTracker;
import org.apache.geode.internal.cache.event.NonDistributedEventTracker;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.HAEventWrapper;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class HARegion
extends DistributedRegion {
    private static final Logger logger = LogService.getLogger();
    CachePerfStats haRegionStats = new DummyCachePerfStats();
    private volatile HARegionQueue owningQueue;

    @Override
    protected boolean isSecret() {
        return true;
    }

    @Override
    protected boolean isCopyOnRead() {
        return false;
    }

    @Override
    public boolean doesNotDistribute() {
        return true;
    }

    @Override
    protected StringBuilder getStringBuilder() {
        StringBuilder buf = new StringBuilder();
        buf.append("HARegion");
        buf.append("[path='").append(this.getFullPath());
        return buf;
    }

    private HARegion(String regionName, RegionAttributes attrs, LocalRegion parentRegion, InternalCache cache) {
        super(regionName, attrs, parentRegion, cache, new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null));
    }

    @Override
    public boolean allowsPersistence() {
        return false;
    }

    @Override
    protected void distributeUpdate(EntryEventImpl event, long lastModifiedTime, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
    }

    @Override
    public EventTracker createEventTracker() {
        return NonDistributedEventTracker.getInstance();
    }

    @Override
    protected void checkIfReplicatedAndLocalDestroy(EntryEventImpl event) {
    }

    @Override
    void checkEntryTimeoutAction(String mode, ExpirationAction ea) {
    }

    @Override
    public ExpirationAttributes setEntryTimeToLive(ExpirationAttributes timeToLive) {
        if (timeToLive == null) {
            throw new IllegalArgumentException(LocalizedStrings.HARegion_TIMETOLIVE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        if (timeToLive.getAction() == ExpirationAction.LOCAL_DESTROY && this.dataPolicy.withReplication()) {
            throw new IllegalArgumentException(LocalizedStrings.HARegion_TIMETOLIVE_ACTION_IS_INCOMPATIBLE_WITH_THIS_REGIONS_MIRROR_TYPE.toLocalizedString());
        }
        if (!this.statisticsEnabled) {
            throw new IllegalStateException(LocalizedStrings.HARegion_CANNOT_SET_TIME_TO_LIVE_WHEN_STATISTICS_ARE_DISABLED.toLocalizedString());
        }
        ExpirationAttributes oldAttrs = this.getEntryTimeToLive();
        this.entryTimeToLive = timeToLive.getTimeout();
        this.entryTimeToLiveExpirationAction = timeToLive.getAction();
        this.setEntryTimeToLiveAttributes();
        this.updateEntryExpiryPossible();
        this.timeToLiveChanged(oldAttrs);
        return oldAttrs;
    }

    @Override
    protected void basicInvalidate(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws EntryNotFoundException {
        Object key = event.getKey();
        if (key instanceof Long) {
            boolean removedFromAvID = false;
            Conflatable conflatable = null;
            try {
                conflatable = (Conflatable)this.get(key);
                removedFromAvID = !this.owningQueue.isPrimary() && this.owningQueue.destroyFromAvailableIDs((Long)key);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                this.getCancelCriterion().checkCancelInProgress(ie);
                return;
            }
            if (!removedFromAvID) {
                return;
            }
            if (conflatable instanceof HAEventWrapper) {
                this.owningQueue.decAndRemoveFromHAContainer((HAEventWrapper)conflatable);
            }
            this.owningQueue.stats.incEventsExpired();
        }
        this.entries.invalidate(event, invokeCallbacks, forceNewEntry, false);
    }

    @Override
    protected boolean checkEntryNotValid(RegionEntry mapEntry) {
        return super.checkEntryNotValid(mapEntry) || mapEntry.getKey() instanceof ThreadIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value, Object aCallbackArgument) throws TimeoutException, CacheWriterException {
        this.checkReadiness();
        EntryEventImpl event = EntryEventImpl.create((LocalRegion)this, Operation.UPDATE, key, value, aCallbackArgument, false, this.getMyId());
        try {
            Object oldValue = null;
            if (this.basicPut(event, false, false, null, false)) {
                oldValue = event.getOldValue();
            }
            Object object = HARegion.handleNotAvailable(oldValue);
            return object;
        }
        finally {
            event.release();
        }
    }

    public static HARegion getInstance(String regionName, InternalCache cache, HARegionQueue hrq, RegionAttributes ra) throws TimeoutException, RegionExistsException, IOException, ClassNotFoundException {
        HARegion haRegion = new HARegion(regionName, ra, null, cache);
        haRegion.setOwner(hrq);
        Region region = cache.createVMRegion(regionName, ra, new InternalRegionArguments().setInternalMetaRegion(haRegion).setDestroyLockFlag(true).setSnapshotInputStream(null).setInternalRegion(true).setImageTarget(null));
        return (HARegion)region;
    }

    public boolean isPrimaryQueue() {
        if (this.owningQueue != null) {
            return this.owningQueue.isPrimary();
        }
        return false;
    }

    public HARegionQueue getOwner() {
        return this.owningQueue.isQueueInitialized() ? this.owningQueue : null;
    }

    @Override
    public CachePerfStats getCachePerfStats() {
        return this.haRegionStats;
    }

    public void setOwner(HARegionQueue hrq) {
        this.owningQueue = hrq;
    }

    @Override
    protected boolean shouldNotifyBridgeClients() {
        return false;
    }

    protected void notifyGatewayHub(EnumListenerEvent operation, EntryEventImpl event) {
    }

    @Override
    public void destroyRegion(Object aCallbackArgument) throws CacheWriterException, TimeoutException {
        RegionEventImpl event = new RegionEventImpl(this, Operation.REGION_DESTROY, aCallbackArgument, true, this.getMyId());
        this.basicDestroyRegion(event, true);
    }

    @Override
    public boolean generateEventID() {
        return false;
    }

    @Override
    protected void initialize(InputStream snapshotInputStream, InternalDistributedMember imageTarget, InternalRegionArguments internalRegionArgs) throws TimeoutException, IOException, ClassNotFoundException {
        super.initialize(snapshotInputStream, imageTarget, internalRegionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object findObjectInSystem(KeyInfo keyInfo, boolean isCreate, TXStateInterface txState, boolean generateCallbacks, Object localValue, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws CacheLoaderException, TimeoutException {
        LoaderHelper loaderHelper;
        Object value = null;
        Object key = keyInfo.getKey();
        Object aCallbackArgument = keyInfo.getCallbackArg();
        RegionEntry re = null;
        Assert.assertTrue(!this.hasServerProxy());
        CacheLoader loader = this.basicGetLoader();
        if (loader != null && (value = loader.load(loaderHelper = this.loaderHelperFactory.createLoaderHelper(key, aCallbackArgument, false, true, null))) != null) {
            try {
                this.validateKey(key);
                Operation op = isCreate ? Operation.LOCAL_LOAD_CREATE : Operation.LOCAL_LOAD_UPDATE;
                EntryEventImpl event = EntryEventImpl.create(this, op, key, value, aCallbackArgument, false, this.getMyId(), generateCallbacks);
                try {
                    re = this.basicPutEntry(event, 0L);
                }
                finally {
                    event.release();
                }
                if (txState != null) {
                    // empty if block
                }
            }
            catch (CacheWriterException cacheWriterException) {
                // empty catch block
            }
        }
        if (isCreate) {
            this.recordMiss(re, key);
        }
        return value;
    }

    public void startServingGIIRequest() {
        if (this.owningQueue == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("found that owningQueue was null during GII of {} which could lead to event loss (see #41681)", (Object)this);
            }
            return;
        }
        this.owningQueue.startGiiQueueing();
    }

    public void endServingGIIRequest() {
        if (this.owningQueue != null) {
            this.owningQueue.endGiiQueueing();
        }
    }

    @Override
    protected CacheDistributionAdvisor createDistributionAdvisor(InternalRegionArguments internalRegionArgs) {
        return HARegionAdvisor.createHARegionAdvisor(this);
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        super.fillInProfile(profile);
        HARegionAdvisor.HAProfile h = (HARegionAdvisor.HAProfile)profile;
        if (this.owningQueue != null) {
            h.isPrimary = this.owningQueue.isPrimary();
            h.hasRegisteredInterest = this.owningQueue.getHasRegisteredInterest();
        }
    }

    @Override
    public Map<? extends DataSerializable, ? extends DataSerializable> getEventState() {
        if (this.owningQueue != null) {
            return this.owningQueue.getEventMapForGII();
        }
        return null;
    }

    @Override
    public void recordEventState(InternalDistributedMember sender, Map eventState) {
        if (eventState != null && this.owningQueue != null) {
            this.owningQueue.recordEventState(sender, eventState);
        }
    }

    public void sendProfileUpdate() {
        new UpdateAttributesProcessor(this).distribute(false);
    }

    public boolean noPrimaryOrHasRegisteredInterest() {
        return ((HARegionAdvisor)this.distAdvisor).noPrimaryOrHasRegisteredInterest();
    }

    public static class HARegionAdvisor
    extends CacheDistributionAdvisor {
        private HARegionAdvisor(CacheDistributionAdvisee region) {
            super(region);
        }

        public static HARegionAdvisor createHARegionAdvisor(CacheDistributionAdvisee region) {
            HARegionAdvisor advisor = new HARegionAdvisor(region);
            advisor.initialize();
            return advisor;
        }

        @Override
        public CacheDistributionAdvisor.InitialImageAdvice adviseInitialImage(CacheDistributionAdvisor.InitialImageAdvice previousAdvice) {
            CacheDistributionAdvisor.InitialImageAdvice r = super.adviseInitialImage(previousAdvice);
            r.setOthers(this.getAdvisee().getDistributionManager().getOtherDistributionManagerIds());
            return r;
        }

        @Override
        protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
            return new HAProfile(memberId, version);
        }

        public boolean noPrimaryOrHasRegisteredInterest() {
            DistributionAdvisor.Profile[] locProfiles = this.profiles;
            for (int i = 0; i < locProfiles.length; ++i) {
                HAProfile p = (HAProfile)locProfiles[i];
                if (!p.isPrimary) continue;
                return p.hasRegisteredInterest;
            }
            return true;
        }

        public static class HAProfile
        extends CacheDistributionAdvisor.CacheProfile {
            private static int HAS_REGISTERED_INTEREST_BIT = 1;
            private static int IS_PRIMARY_BIT = 2;
            boolean hasRegisteredInterest;
            boolean isPrimary;

            public HAProfile() {
            }

            public HAProfile(InternalDistributedMember memberId, int version) {
                super(memberId, version);
            }

            @Override
            public void fromData(DataInput in) throws IOException, ClassNotFoundException {
                super.fromData(in);
                byte flags = in.readByte();
                this.hasRegisteredInterest = (flags & HAS_REGISTERED_INTEREST_BIT) != 0;
                this.isPrimary = (flags & IS_PRIMARY_BIT) != 0;
            }

            @Override
            public void toData(DataOutput out) throws IOException {
                super.toData(out);
                int flags = 0;
                if (this.hasRegisteredInterest) {
                    flags |= HAS_REGISTERED_INTEREST_BIT;
                }
                if (this.isPrimary) {
                    flags |= IS_PRIMARY_BIT;
                }
                out.writeByte(flags & 0xFF);
            }

            @Override
            public int getDSFID() {
                return 111;
            }

            @Override
            public StringBuilder getToStringHeader() {
                return new StringBuilder("HAProfile");
            }

            @Override
            public void fillInToString(StringBuilder sb) {
                super.fillInToString(sb);
                sb.append("; isPrimary=").append(this.isPrimary);
                sb.append("; hasRegisteredInterest=").append(this.hasRegisteredInterest);
            }
        }
    }
}

