/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.FunctionStreamingOrderedReplyMessage;
import org.apache.geode.internal.cache.FunctionStreamingReplyMessage;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.TransactionMessage;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.MemberFunctionResultSender;
import org.apache.geode.internal.cache.execute.MultiRegionFunctionContextImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class MemberFunctionStreamingMessage
extends DistributionMessage
implements TransactionMessage,
MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    transient int replyMsgNum = 0;
    transient boolean replyLastMsg;
    private Function functionObject;
    private String functionName;
    Object args;
    private int processorId;
    private int txUniqId = -1;
    private InternalDistributedMember txMemberId = null;
    private boolean isFnSerializationReqd;
    private Set<String> regionPathSet;
    private boolean isReExecute;
    private static final short IS_REEXECUTE = 64;

    public MemberFunctionStreamingMessage() {
    }

    public MemberFunctionStreamingMessage(Function function, int procId, Object ar, boolean isFnSerializationReqd, boolean isReExecute) {
        this.functionObject = function;
        this.processorId = procId;
        this.args = ar;
        this.isFnSerializationReqd = isFnSerializationReqd;
        this.isReExecute = isReExecute;
        this.txUniqId = TXManagerImpl.getCurrentTXUniqueId();
        TXStateProxy txState = TXManagerImpl.getCurrentTXState();
        if (txState != null && txState.isMemberIdForwardingRequired()) {
            this.txMemberId = txState.getOriginatingMember();
        }
    }

    public MemberFunctionStreamingMessage(Function function, int procId, Object ar, boolean isFnSerializationReqd, Set<String> regions, boolean isReExecute) {
        this.functionObject = function;
        this.processorId = procId;
        this.args = ar;
        this.isFnSerializationReqd = isFnSerializationReqd;
        this.regionPathSet = regions;
        this.isReExecute = isReExecute;
        this.txUniqId = TXManagerImpl.getCurrentTXUniqueId();
        TXStateProxy txState = TXManagerImpl.getCurrentTXState();
        if (txState != null && txState.isMemberIdForwardingRequired()) {
            this.txMemberId = txState.getOriginatingMember();
        }
    }

    public MemberFunctionStreamingMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    private TXStateProxy prepForTransaction(DistributionManager dm) throws InterruptedException {
        if (this.txUniqId == -1) {
            return null;
        }
        InternalCache cache = dm.getCache();
        if (cache == null) {
            return null;
        }
        TXManagerImpl mgr = cache.getTXMgr();
        return mgr.masqueradeAs(this);
    }

    private void cleanupTransaction(TXStateProxy tx) {
        if (this.txUniqId != -1) {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache == null) {
                return;
            }
            TXManagerImpl mgr = cache.getTXMgr();
            mgr.unmasquerade(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        Throwable thr = null;
        ReplyException rex = null;
        if (this.functionObject == null) {
            rex = new ReplyException(new FunctionException(LocalizedStrings.ExecuteFunction_FUNCTION_NAMED_0_IS_NOT_REGISTERED.toLocalizedString(this.functionName)));
            this.replyWithException(dm, rex);
            return;
        }
        FunctionStats stats = FunctionStats.getFunctionStats(this.functionObject.getId(), dm.getSystem());
        TXStateProxy tx = null;
        InternalCache cache = dm.getCache();
        try {
            tx = this.prepForTransaction(dm);
            MemberFunctionResultSender resultSender = new MemberFunctionResultSender(dm, this, this.functionObject);
            HashSet<Region> regions = new HashSet<Region>();
            if (this.regionPathSet != null) {
                for (String regionPath : this.regionPathSet) {
                    if (this.checkCacheClosing(dm) || this.checkDSClosing(dm)) {
                        thr = new CacheClosedException(LocalizedStrings.PartitionMessage_REMOTE_CACHE_IS_CLOSED_0.toLocalizedString(dm.getId()));
                        return;
                    }
                    regions.add(cache.getRegion(regionPath));
                }
            }
            MultiRegionFunctionContextImpl context = new MultiRegionFunctionContextImpl(cache, this.functionObject.getId(), this.args, resultSender, regions, this.isReExecute);
            long start = stats.startTime();
            stats.startFunctionExecution(this.functionObject.hasResult());
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function: {} on remote member with context: {}", (Object)this.functionObject.getId(), (Object)context.toString());
            }
            this.functionObject.execute(context);
            if (!this.replyLastMsg && this.functionObject.hasResult()) {
                throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(this.functionObject.getId()));
            }
            stats.endFunctionExecution(start, this.functionObject.hasResult());
        }
        catch (FunctionException functionException) {
            if (logger.isDebugEnabled()) {
                logger.debug("FunctionException occurred on remote member while executing Function: {}", (Object)this.functionObject.getId(), (Object)functionException);
            }
            stats.endFunctionExecutionWithException(this.functionObject.hasResult());
            rex = new ReplyException(functionException);
            this.replyWithException(dm, rex);
        }
        catch (CancelException exception) {
            thr = new FunctionInvocationTargetException(exception);
            stats.endFunctionExecutionWithException(this.functionObject.hasResult());
            rex = new ReplyException(thr);
            this.replyWithException(dm, rex);
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception occurred on remote member while executing Function: {}", (Object)this.functionObject.getId(), (Object)exception);
            }
            stats.endFunctionExecutionWithException(this.functionObject.hasResult());
            rex = new ReplyException(exception);
            this.replyWithException(dm, rex);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            thr = t;
        }
        finally {
            this.cleanupTransaction(tx);
            if (thr != null) {
                rex = new ReplyException(thr);
                this.replyWithException(dm, rex);
            }
        }
    }

    private void replyWithException(DistributionManager dm, ReplyException rex) {
        ReplyMessage.send(this.getSender(), this.processorId, rex, (ReplySender)dm);
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public int getDSFID() {
        return 1202;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        Object object;
        super.fromData(in);
        short flags = in.readShort();
        if ((flags & 1) != 0) {
            this.processorId = in.readInt();
            ReplyProcessor21.setMessageRPId(this.processorId);
        }
        if ((flags & 4) != 0) {
            this.txUniqId = in.readInt();
        }
        if ((flags & 2) != 0) {
            this.txMemberId = (InternalDistributedMember)DataSerializer.readObject(in);
        }
        if ((object = DataSerializer.readObject(in)) instanceof String) {
            this.isFnSerializationReqd = false;
            this.functionObject = FunctionService.getFunction((String)object);
            if (this.functionObject == null) {
                this.functionName = (String)object;
            }
        } else {
            this.functionObject = (Function)object;
            this.isFnSerializationReqd = true;
        }
        this.args = DataSerializer.readObject(in);
        this.regionPathSet = (Set)DataSerializer.readObject(in);
        this.isReExecute = (flags & 0x40) != 0;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        short flags = 0;
        if (this.processorId != 0) {
            flags = (short)(flags | 1);
        }
        if (this.txUniqId != -1) {
            flags = (short)(flags | 4);
        }
        if (this.txMemberId != null) {
            flags = (short)(flags | 2);
        }
        if (this.isReExecute) {
            flags = (short)(flags | 0x40);
        }
        out.writeShort(flags);
        if (this.processorId != 0) {
            out.writeInt(this.processorId);
        }
        if (this.txUniqId != -1) {
            out.writeInt(this.txUniqId);
        }
        if (this.txMemberId != null) {
            DataSerializer.writeObject(this.txMemberId, out);
        }
        if (this.isFnSerializationReqd) {
            DataSerializer.writeObject(this.functionObject, out);
        } else {
            DataSerializer.writeObject(this.functionObject.getId(), out);
        }
        DataSerializer.writeObject(this.args, out);
        DataSerializer.writeObject(this.regionPathSet, out);
    }

    public synchronized boolean sendReplyForOneResult(DM dm, Object oneResult, boolean lastResult, boolean sendResultsInOrder) throws CacheException, QueryException, ForceReattemptException, InterruptedException {
        if (this.replyLastMsg) {
            return false;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int msgNum = this.replyMsgNum;
        this.replyLastMsg = lastResult;
        this.sendReply(this.getSender(), this.processorId, dm, oneResult, msgNum, lastResult, sendResultsInOrder);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending reply message count: {} to co-ordinating node", (Object)this.replyMsgNum);
        }
        ++this.replyMsgNum;
        return false;
    }

    protected void sendReply(InternalDistributedMember member, int procId, DM dm, Object oneResult, int msgNum, boolean lastResult, boolean sendResultsInOrder) {
        if (sendResultsInOrder) {
            FunctionStreamingOrderedReplyMessage.send(member, procId, null, dm, oneResult, msgNum, lastResult);
        } else {
            FunctionStreamingReplyMessage.send(member, procId, null, dm, oneResult, msgNum, lastResult);
        }
    }

    @Override
    public int getProcessorType() {
        return 80;
    }

    private boolean checkCacheClosing(DistributionManager dm) {
        InternalCache cache = dm.getCache();
        return cache == null || cache.getCancelCriterion().isCancelInProgress();
    }

    private boolean checkDSClosing(DistributionManager dm) {
        InternalDistributedSystem ds = dm.getSystem();
        return ds == null || ds.isDisconnecting();
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    @Override
    public int getTXUniqId() {
        return this.txUniqId;
    }

    @Override
    public InternalDistributedMember getMemberToMasqueradeAs() {
        if (this.txMemberId == null) {
            return this.getSender();
        }
        return this.txMemberId;
    }

    @Override
    public InternalDistributedMember getTXOriginatorClient() {
        return null;
    }

    @Override
    public boolean canParticipateInTransaction() {
        return true;
    }

    @Override
    public boolean isTransactionDistributed() {
        return false;
    }
}

