/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.SyncFailedException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SerializationException;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.UnsupportedVersionException;
import org.apache.geode.distributed.OplogCancelledException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ByteArrayDataInput;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.Sendable;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.AbstractDiskRegion;
import org.apache.geode.internal.cache.BackupManager;
import org.apache.geode.internal.cache.BytesAndBitsForCompactor;
import org.apache.geode.internal.cache.CacheObserverHolder;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.CompactableOplog;
import org.apache.geode.internal.cache.CountingDataInputStream;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskEntry;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskInitFile;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskStoreBackup;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DiskStoreObserver;
import org.apache.geode.internal.cache.DiskStoreStats;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryBits;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PersistentOplogSet;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.lru.EnableLRU;
import org.apache.geode.internal.cache.lru.NewLRUClockHand;
import org.apache.geode.internal.cache.persistence.BytesAndBits;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.persistence.UninterruptibleFileChannel;
import org.apache.geode.internal.cache.persistence.UninterruptibleRandomAccessFile;
import org.apache.geode.internal.cache.versions.CompactVersionHolder;
import org.apache.geode.internal.cache.versions.RegionVersionHolder;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionHolder;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.offheap.ReferenceCountHelper;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.sequencelog.EntryLogger;
import org.apache.geode.internal.shared.NativeCalls;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.internal.util.TransformUtils;
import org.apache.geode.pdx.internal.PdxWriterImpl;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class Oplog
implements CompactableOplog,
DiskEntry.Helper.Flushable {
    private static final Logger logger = LogService.getLogger();
    public static final String CRF_FILE_EXT = ".crf";
    public static final String DRF_FILE_EXT = ".drf";
    public static final String KRF_FILE_EXT = ".krf";
    private File diskFile;
    private volatile boolean closed;
    private final OplogFile crf = new OplogFile();
    private final OplogFile drf = new OplogFile();
    private final KRFile krf = new KRFile();
    private final DiskStoreStats stats;
    private final DiskStoreImpl parent;
    private final PersistentOplogSet oplogSet;
    protected final long oplogId;
    protected Version gfversion;
    protected Version dataVersion;
    private DirectoryHolder dirHolder;
    private final long maxOplogSize;
    private long maxCrfSize;
    private long maxDrfSize;
    private final AtomicBoolean hasDeletes = new AtomicBoolean();
    private boolean firstRecord = true;
    private static final boolean SYNC_WRITES = Boolean.getBoolean("gemfire.syncWrites");
    private final AtomicLong totalCount = new AtomicLong(0L);
    private final AtomicLong totalLiveCount = new AtomicLong(0L);
    private final ConcurrentMap<Long, DiskRegionInfo> regionMap = new ConcurrentHashMap<Long, DiskRegionInfo>();
    private volatile boolean compacting = false;
    private boolean haveRecoveredDrf = true;
    private boolean haveRecoveredCrf = true;
    private OpState opState;
    private static final byte OPLOG_EOF_ID = 0;
    private static final byte END_OF_RECORD_ID = 21;
    private static final byte OPLOG_DISK_STORE_ID = 62;
    static final int OPLOG_DISK_STORE_REC_SIZE = 18;
    private static final byte OPLOG_NEW_ENTRY_BASE_ID = 63;
    static final int OPLOG_NEW_ENTRY_BASE_REC_SIZE = 10;
    private static final byte OPLOG_NEW_ENTRY_0ID = 64;
    private static final byte OPLOG_MOD_ENTRY_1ID = 65;
    private static final byte OPLOG_MOD_ENTRY_2ID = 66;
    private static final byte OPLOG_MOD_ENTRY_3ID = 67;
    private static final byte OPLOG_MOD_ENTRY_4ID = 68;
    private static final byte OPLOG_MOD_ENTRY_5ID = 69;
    private static final byte OPLOG_MOD_ENTRY_6ID = 70;
    private static final byte OPLOG_MOD_ENTRY_7ID = 71;
    private static final byte OPLOG_MOD_ENTRY_8ID = 72;
    private static final byte OPLOG_MOD_ENTRY_WITH_KEY_1ID = 73;
    private static final byte OPLOG_MOD_ENTRY_WITH_KEY_2ID = 74;
    private static final byte OPLOG_MOD_ENTRY_WITH_KEY_3ID = 75;
    private static final byte OPLOG_MOD_ENTRY_WITH_KEY_4ID = 76;
    private static final byte OPLOG_MOD_ENTRY_WITH_KEY_5ID = 77;
    private static final byte OPLOG_MOD_ENTRY_WITH_KEY_6ID = 78;
    private static final byte OPLOG_MOD_ENTRY_WITH_KEY_7ID = 79;
    private static final byte OPLOG_MOD_ENTRY_WITH_KEY_8ID = 80;
    private static final byte OPLOG_DEL_ENTRY_1ID = 81;
    private static final byte OPLOG_DEL_ENTRY_2ID = 82;
    private static final byte OPLOG_DEL_ENTRY_3ID = 83;
    private static final byte OPLOG_DEL_ENTRY_4ID = 84;
    private static final byte OPLOG_DEL_ENTRY_5ID = 85;
    private static final byte OPLOG_DEL_ENTRY_6ID = 86;
    private static final byte OPLOG_DEL_ENTRY_7ID = 87;
    private static final byte OPLOG_DEL_ENTRY_8ID = 88;
    private static final int MAX_DELETE_ENTRY_RECORD_BYTES = 10;
    private static final byte OPLOG_RVV = 89;
    private static final byte OPLOG_CONFLICT_VERSION = 90;
    private static final byte OPLOG_GEMFIRE_VERSION = 91;
    static final int OPLOG_GEMFIRE_VERSION_REC_SIZE = 5;
    static final byte OPLOG_MAGIC_SEQ_ID = 92;
    public static final int OPLOG_MAGIC_SEQ_REC_SIZE = 1 + OPLOG_TYPE.getLen() + 1;
    private final boolean compactOplogs;
    final Object lock = new Object();
    final ByteBuffer[] bbArray = new ByteBuffer[2];
    private boolean lockedForKRFcreate = false;
    private boolean doneAppending = false;
    private boolean wroteNewEntryBase = false;
    private boolean isRecovering;
    private long recoverNewEntryId = 0L;
    private long writeModEntryId = 0L;
    private long recoverModEntryId = 0L;
    private long recoverModEntryIdHWM = 0L;
    private long recoverDelEntryIdHWM = 0L;
    private long writeDelEntryId = 0L;
    private long recoverDelEntryId = 0L;
    private boolean crashed;
    private OplogEntryIdMap kvMap;
    private OplogEntryIdMap skippedKeyBytes;
    private boolean offlineCompactPhase2 = false;
    private int recordsSkippedDuringRecovery = 0;
    private final AtomicInteger unrecoveredRegionCount = new AtomicInteger();
    private static byte[] TOMBSTONE_BYTES;
    private final AtomicBoolean krfCreated = new AtomicBoolean();
    private static final int MAX_CHANNEL_RETRIES = 5;
    private boolean okToReopen;
    private volatile boolean beingRead;
    private final AtomicBoolean deleted = new AtomicBoolean();
    private static final ThreadLocal isCompactorThread;
    private boolean added = false;
    private final Lock compactorLock = new ReentrantLock();

    Oplog(long oplogId, PersistentOplogSet parent, DirectoryHolder dirHolder) {
        if (oplogId > 0x7FFFFFFFFFFFFFL) {
            throw new IllegalStateException("Too many oplogs. The oplog id can not exceed 36028797018963967");
        }
        this.oplogId = oplogId;
        this.oplogSet = parent;
        this.parent = parent.getParent();
        this.dirHolder = dirHolder;
        this.firstRecord = false;
        this.opState = new OpState();
        long maxOplogSizeParam = this.getParent().getMaxOplogSizeInBytes();
        long availableSpace = this.dirHolder.getAvailableSpace();
        if (availableSpace < maxOplogSizeParam) {
            if (DiskStoreImpl.PREALLOCATE_OPLOGS && !DiskStoreImpl.SET_IGNORE_PREALLOCATE) {
                throw new DiskAccessException(LocalizedStrings.Oplog_PreAllocate_Failure_Init.toLocalizedString(this.dirHolder, maxOplogSizeParam), (Throwable)new IOException("not enough space left to create and pre grow oplog files, available=" + availableSpace + ", required=" + maxOplogSizeParam), this.getParent());
            }
            this.maxOplogSize = availableSpace;
            if (logger.isDebugEnabled()) {
                logger.debug("Reducing maxOplogSize to {} because that is all the room remaining in the directory.", (Object)availableSpace);
            }
        } else {
            this.maxOplogSize = maxOplogSizeParam;
        }
        this.setMaxCrfDrfSize();
        this.stats = this.getParent().getStats();
        this.compactOplogs = this.getParent().getAutoCompact();
        this.closed = false;
        String n = this.getParent().getName();
        this.diskFile = new File(this.dirHolder.getDir(), this.oplogSet.getPrefix() + n + "_" + oplogId);
        try {
            this.createDrf(null);
            this.createCrf(null);
            if (this.getParent().isOfflineCompacting()) {
                this.krfFileCreate();
            }
        }
        catch (Exception ex) {
            this.close();
            this.getParent().getCancelCriterion().checkCancelInProgress(ex);
            if (ex instanceof DiskAccessException) {
                throw (DiskAccessException)ex;
            }
            throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_CREATING_OPERATION_LOG_BECAUSE_0.toLocalizedString(ex), this.getParent());
        }
    }

    private Oplog(long oplogId, DirectoryHolder dirHolder, Oplog prevOplog) {
        if (oplogId > 0x7FFFFFFFFFFFFFL) {
            throw new IllegalStateException("Too many oplogs. The oplog id can not exceed 36028797018963967");
        }
        this.oplogId = oplogId;
        this.parent = prevOplog.parent;
        this.oplogSet = prevOplog.oplogSet;
        this.dirHolder = dirHolder;
        this.opState = new OpState();
        long maxOplogSizeParam = this.getParent().getMaxOplogSizeInBytes();
        long availableSpace = this.dirHolder.getAvailableSpace();
        if (prevOplog.compactOplogs) {
            this.maxOplogSize = maxOplogSizeParam;
        } else if (availableSpace < maxOplogSizeParam) {
            this.maxOplogSize = availableSpace;
            if (logger.isDebugEnabled()) {
                logger.debug("Reducing maxOplogSize to {} because that is all the room remaining in the directory.", (Object)availableSpace);
            }
        } else {
            this.maxOplogSize = maxOplogSizeParam;
        }
        this.setMaxCrfDrfSize();
        this.stats = prevOplog.stats;
        this.compactOplogs = prevOplog.compactOplogs;
        this.dataVersion = prevOplog.getDataVersionIfOld();
        this.closed = false;
        String n = this.getParent().getName();
        this.diskFile = new File(this.dirHolder.getDir(), this.oplogSet.getPrefix() + n + "_" + oplogId);
        try {
            this.createDrf(prevOplog.drf);
            this.createCrf(prevOplog.crf);
            if (this.getParent().isOfflineCompacting()) {
                this.krfFileCreate();
            }
        }
        catch (Exception ex) {
            this.close();
            this.getParent().getCancelCriterion().checkCancelInProgress(ex);
            if (ex instanceof DiskAccessException) {
                throw (DiskAccessException)ex;
            }
            throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_CREATING_OPERATION_LOG_BECAUSE_0.toLocalizedString(ex), this.getParent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceIncompatibleEntry(DiskRegionView dr, DiskEntry old, DiskEntry repl) {
        boolean useNextOplog = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.getOplogSet().getChild() != this) {
                useNextOplog = true;
            } else {
                this.getOrCreateDRI(dr).replaceLive(old, repl);
                if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                    logger.trace(LogMarker.PERSIST_RECOVERY, "replacing incompatible entry key = {} old = {} new = {} oldDiskId = {} new diskId = {} tag = {} in child oplog #{}", old.getKey(), (Object)System.identityHashCode(old), (Object)System.identityHashCode(repl), (Object)old.getDiskId(), (Object)repl.getDiskId(), (Object)old.getVersionStamp(), (Object)this.getOplogId());
                }
            }
        }
        if (useNextOplog) {
            if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                CacheObserverHolder.getInstance().afterSwitchingOplog();
            }
            Assert.assertTrue(this.getOplogSet().getChild() != this);
            this.getOplogSet().getChild().replaceIncompatibleEntry(dr, old, repl);
        }
    }

    private void writeDiskStoreRecord(OplogFile olf, OPLOG_TYPE type) throws IOException {
        this.opState = new OpState();
        this.opState.initialize(type);
        this.writeOpLogBytes(olf, false, true);
        olf.currSize += (long)this.getOpStateSize();
        this.dirHolder.incrementTotalOplogSize(this.getOpStateSize());
        this.clearOpState();
        this.opState.initialize(this.getParent().getDiskStoreID());
        this.writeOpLogBytes(olf, false, true);
        olf.currSize += (long)this.getOpStateSize();
        this.dirHolder.incrementTotalOplogSize(this.getOpStateSize());
    }

    private void writeGemfireVersionRecord(OplogFile olf) throws IOException {
        Version dataVersion;
        if (this.gfversion == null) {
            this.gfversion = Version.CURRENT;
        }
        if ((dataVersion = this.getDataVersionIfOld()) == null) {
            dataVersion = Version.CURRENT;
        }
        this.opState = new OpState();
        if (this.gfversion == dataVersion) {
            this.writeProductVersionRecord(this.gfversion, olf);
        } else {
            this.writeProductVersionRecord(Version.TOKEN, olf);
            this.clearOpState();
            this.writeProductVersionRecord(this.gfversion, olf);
            this.clearOpState();
            this.writeProductVersionRecord(dataVersion, olf);
        }
    }

    private void writeProductVersionRecord(Version version, OplogFile olf) throws IOException {
        this.opState.initialize(version.ordinal());
        this.writeOpLogBytes(olf, false, true);
        olf.currSize += (long)this.getOpStateSize();
        this.dirHolder.incrementTotalOplogSize(this.getOpStateSize());
    }

    public Version currentRecoveredGFVersion() {
        return this.gfversion;
    }

    private void writeRVVRecord(OplogFile olf, boolean writeGCRVV) throws IOException {
        this.writeRVVRecord(olf, this.getParent().getAllDiskRegions(), writeGCRVV);
    }

    private void writeRVVRecord(OplogFile olf, Map<Long, AbstractDiskRegion> diskRegions, boolean writeGCRVV) throws IOException {
        this.opState = new OpState();
        this.opState.initialize(diskRegions, writeGCRVV);
        this.writeOpLogBytes(olf, false, true);
        olf.currSize += (long)this.getOpStateSize();
        this.dirHolder.incrementTotalOplogSize(this.getOpStateSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeNewEntryBaseRecord(boolean async) throws IOException {
        if (this.wroteNewEntryBase) {
            return false;
        }
        this.wroteNewEntryBase = true;
        long newEntryBase = this.getOplogSet().getOplogEntryId();
        OpState saved = this.opState;
        try {
            this.opState = new OpState();
            this.opState.initialize(newEntryBase);
            this.writeOpLogBytes(this.crf, async, false);
            this.dirHolder.incrementTotalOplogSize(this.getOpStateSize());
        }
        finally {
            this.opState = saved;
        }
        return true;
    }

    boolean isDrfOnly() {
        return this.drf.f != null && this.crf.f == null;
    }

    Oplog(long oplogId, PersistentOplogSet parent) {
        if (oplogId > 0x7FFFFFFFFFFFFFL) {
            throw new IllegalStateException("Too many oplogs. The oplog id can not exceed 36028797018963967");
        }
        this.isRecovering = true;
        this.oplogId = oplogId;
        this.parent = parent.getParent();
        this.oplogSet = parent;
        this.opState = new OpState();
        this.maxOplogSize = this.getParent().getMaxOplogSizeInBytes();
        this.setMaxCrfDrfSize();
        this.stats = this.getParent().getStats();
        this.compactOplogs = this.getParent().getAutoCompact();
        this.closed = true;
        this.crf.RAFClosed = true;
        this.deleted.set(true);
        this.haveRecoveredCrf = false;
        this.haveRecoveredDrf = false;
    }

    boolean addRecoveredFile(File f, DirectoryHolder dh) {
        String fname = f.getName();
        if (this.dirHolder != null) {
            if (!dh.equals(this.dirHolder)) {
                throw new DiskAccessException("Oplog#" + this.getOplogId() + " has files in two different directories: \"" + this.dirHolder + "\", and \"" + dh + "\". Both the crf and drf for this oplog should be in the same directory.", this.getParent());
            }
        } else {
            this.dirHolder = dh;
        }
        if (fname.endsWith(CRF_FILE_EXT)) {
            this.crf.f = f;
            return true;
        }
        if (fname.endsWith(DRF_FILE_EXT)) {
            this.drf.f = f;
        } else assert (false) : fname;
        return false;
    }

    void setRecoveredDrfSize(long size) {
        this.drf.currSize += size;
        this.drf.bytesFlushed += size;
    }

    void setRecoveredCrfSize(long size) {
        this.crf.currSize += size;
        this.crf.bytesFlushed += size;
    }

    boolean isRecovering() {
        return this.isRecovering;
    }

    private DiskStoreImpl getParent() {
        return this.parent;
    }

    private PersistentOplogSet getOplogSet() {
        return this.oplogSet;
    }

    void initAfterRecovery(boolean offline) {
        this.isRecovering = false;
        this.closed = false;
        this.deleted.set(false);
        String n = this.getParent().getName();
        this.diskFile = new File(this.drf.f.getParentFile(), this.oplogSet.getPrefix() + n + "_" + this.oplogId);
        try {
            this.doneAppending = true;
            if (this.crf.f != null && !this.hasNoLiveValues()) {
                this.closed = false;
                this.crf.raf = new UninterruptibleRandomAccessFile(this.crf.f, "rw");
                this.crf.RAFClosed = false;
                this.crf.channel = this.crf.raf.getChannel();
                this.unpreblow(this.crf, this.getMaxCrfSize());
                this.crf.raf.close();
                this.crf.raf = new UninterruptibleRandomAccessFile(this.crf.f, "r");
                this.crf.channel = this.crf.raf.getChannel();
                this.stats.incOpenOplogs();
                try {
                    this.drf.raf = new UninterruptibleRandomAccessFile(this.drf.f, "rw");
                    this.drf.RAFClosed = false;
                    this.drf.channel = this.drf.raf.getChannel();
                    this.unpreblow(this.drf, this.getMaxDrfSize());
                }
                finally {
                    this.drf.raf.close();
                    this.drf.raf = null;
                    this.drf.RAFClosed = true;
                }
            } else if (!offline) {
                this.crf.RAFClosed = true;
                this.deleteCRF();
                this.closed = true;
                this.deleted.set(true);
            }
            this.drf.RAFClosed = true;
        }
        catch (IOException ex) {
            this.getParent().getCancelCriterion().checkCancelInProgress(ex);
            throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_CREATING_OPERATION_LOG_BECAUSE_0.toLocalizedString(ex), this.getParent());
        }
        if (this.hasNoLiveValues() && !offline) {
            this.getOplogSet().removeOplog(this.getOplogId(), true, this.getHasDeletes() ? this : null);
            if (!this.getHasDeletes()) {
                this.getOplogSet().drfDelete(this.oplogId);
                this.deleteFile(this.drf);
            }
        } else if (!this.needsCompaction()) {
            this.getOplogSet().removeOplog(this.getOplogId(), true, null);
            this.getOplogSet().addInactive(this);
        }
    }

    boolean getHasDeletes() {
        return this.hasDeletes.get();
    }

    private void setHasDeletes(boolean v) {
        this.hasDeletes.set(v);
    }

    private void closeAndDeleteAfterEx(IOException ex, OplogFile olf) {
        if (olf == null) {
            return;
        }
        if (olf.raf != null) {
            try {
                olf.raf.close();
            }
            catch (IOException e) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.Oplog_Close_Failed, olf.f.getAbsolutePath()), (Throwable)e);
            }
        }
        olf.RAFClosed = true;
        if (!olf.f.delete() && olf.f.exists()) {
            throw new DiskAccessException(LocalizedStrings.Oplog_COULD_NOT_DELETE__0_.toLocalizedString(olf.f.getAbsolutePath()), (Throwable)ex, this.getParent());
        }
    }

    private void preblow(OplogFile olf, long maxSize) throws IOException {
        long availableSpace = this.dirHolder.getAvailableSpace();
        if (availableSpace >= maxSize) {
            try {
                NativeCalls.getInstance().preBlow(olf.f.getAbsolutePath(), maxSize, DiskStoreImpl.PREALLOCATE_OPLOGS && !DiskStoreImpl.SET_IGNORE_PREALLOCATE);
            }
            catch (IOException ioe) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Could not pregrow oplog to {} because: {}", (Object)maxSize, (Object)ioe.getMessage(), (Object)ioe);
                }
                this.closeAndDeleteAfterEx(ioe, olf);
                throw new DiskAccessException(LocalizedStrings.Oplog_PreAllocate_Failure.toLocalizedString(olf.f.getAbsolutePath(), maxSize), (Throwable)ioe, this.getParent());
            }
        } else if (DiskStoreImpl.PREALLOCATE_OPLOGS && !DiskStoreImpl.SET_IGNORE_PREALLOCATE) {
            throw new DiskAccessException(LocalizedStrings.Oplog_PreAllocate_Failure.toLocalizedString(olf.f.getAbsolutePath(), maxSize), (Throwable)new IOException("not enough space left to pre-blow, available=" + availableSpace + ", required=" + maxSize), this.getParent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpreblow(OplogFile olf, long maxSize) {
        Object object = this.lock;
        synchronized (object) {
            if (!olf.RAFClosed && !olf.unpreblown) {
                olf.unpreblown = true;
                if (olf.currSize < maxSize) {
                    try {
                        olf.raf.setLength(olf.currSize);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void createCrf(OplogFile prevOlf) throws IOException {
        File f = new File(this.diskFile.getPath() + CRF_FILE_EXT);
        if (logger.isDebugEnabled()) {
            logger.debug("Creating operation log file {}", (Object)f);
        }
        this.crf.f = f;
        this.preblow(this.crf, this.getMaxCrfSize());
        this.crf.raf = new UninterruptibleRandomAccessFile(f, SYNC_WRITES ? "rwd" : "rw");
        this.crf.RAFClosed = false;
        this.oplogSet.crfCreate(this.oplogId);
        this.crf.writeBuf = Oplog.allocateWriteBuf(prevOlf);
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.Oplog_CREATE_0_1_2, new Object[]{this.toString(), Oplog.getFileType(this.crf), this.getParent().getName()}));
        this.crf.channel = this.crf.raf.getChannel();
        this.stats.incOpenOplogs();
        this.writeDiskStoreRecord(this.crf, OPLOG_TYPE.CRF);
        this.writeGemfireVersionRecord(this.crf);
        this.writeRVVRecord(this.crf, false);
        this.maxCrfSize += this.crf.currSize;
    }

    private static ByteBuffer allocateWriteBuf(OplogFile prevOlf) {
        if (prevOlf != null && prevOlf.writeBuf != null) {
            ByteBuffer result = prevOlf.writeBuf;
            prevOlf.writeBuf = null;
            return result;
        }
        return ByteBuffer.allocateDirect(Integer.getInteger("WRITE_BUF_SIZE", 32768));
    }

    private void createDrf(OplogFile prevOlf) throws IOException {
        File f;
        this.drf.f = f = new File(this.diskFile.getPath() + DRF_FILE_EXT);
        if (logger.isDebugEnabled()) {
            logger.debug("Creating operation log file {}", (Object)f);
        }
        this.preblow(this.drf, this.getMaxDrfSize());
        this.drf.raf = new UninterruptibleRandomAccessFile(f, SYNC_WRITES ? "rwd" : "rw");
        this.drf.RAFClosed = false;
        this.oplogSet.drfCreate(this.oplogId);
        this.drf.writeBuf = Oplog.allocateWriteBuf(prevOlf);
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.Oplog_CREATE_0_1_2, new Object[]{this.toString(), Oplog.getFileType(this.drf), this.getParent().getName()}));
        this.drf.channel = this.drf.raf.getChannel();
        this.writeDiskStoreRecord(this.drf, OPLOG_TYPE.DRF);
        this.writeGemfireVersionRecord(this.drf);
        this.writeRVVRecord(this.drf, true);
    }

    public DiskStoreStats getStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getOplogFile() throws SyncFailedException, IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.crf.RAFClosed) {
                this.crf.raf.getFD().sync();
            }
            return this.crf.f;
        }
    }

    Set<String> gatherMatchingOplogFiles(Set<String> oplogFileNames) {
        File krfFile;
        HashSet<String> matchingFiles = new HashSet<String>();
        if (null != this.crf.f && this.crf.f.exists() && oplogFileNames.contains(this.crf.f.getName())) {
            matchingFiles.add(this.crf.f.getName());
        }
        if (null != this.drf.f && this.drf.f.exists() && oplogFileNames.contains(this.drf.f.getName())) {
            matchingFiles.add(this.drf.f.getName());
        }
        if (this.getParent().getDiskInitFile().hasKrf(this.oplogId) && (krfFile = this.getKrfFile()).exists() && oplogFileNames.contains(krfFile.getName())) {
            matchingFiles.add(krfFile.getName());
        }
        return matchingFiles;
    }

    Map<File, File> mapBaseline(Collection<File> baselineOplogFiles) {
        File krfFile;
        Map<String, File> baselineOplogMap = TransformUtils.transformAndMap(baselineOplogFiles, TransformUtils.fileNameTransformer);
        HashMap<File, File> baselineToOplogMap = new HashMap<File, File>();
        if (null != this.crf.f && this.crf.f.exists() && baselineOplogMap.containsKey(this.crf.f.getName())) {
            baselineToOplogMap.put(baselineOplogMap.get(this.crf.f.getName()), IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(this.crf.f));
        }
        if (null != this.drf.f && this.drf.f.exists() && baselineOplogMap.containsKey(this.drf.f.getName())) {
            baselineToOplogMap.put(baselineOplogMap.get(this.drf.f.getName()), IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(this.drf.f));
        }
        if (this.getParent().getDiskInitFile().hasKrf(this.oplogId) && (krfFile = this.getKrfFile()).exists() && baselineOplogMap.containsKey(krfFile.getName())) {
            baselineToOplogMap.put(baselineOplogMap.get(krfFile.getName()), IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(krfFile));
        }
        return baselineToOplogMap;
    }

    public long getOplogId() {
        return this.oplogId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BytesAndBits getBytesAndBits(DiskRegionView dr, DiskId id, boolean faultingIn, boolean bitOnly) {
        Oplog retryOplog = null;
        long offset = 0L;
        DiskId diskId = id;
        synchronized (diskId) {
            long opId = id.getOplogId();
            if (opId != this.getOplogId()) {
                retryOplog = this.getOplogSet().getChild(opId);
            } else {
                offset = id.getOffsetInOplog();
            }
        }
        if (retryOplog != null) {
            return retryOplog.getBytesAndBits(dr, id, faultingIn, bitOnly);
        }
        BytesAndBits bb = null;
        long start = this.stats.startRead();
        if (offset == -1L) {
            offset = id.getOffsetInOplog();
        }
        try {
            bb = this.basicGet(dr, offset, bitOnly, id.getValueLength(), id.getUserBits());
        }
        catch (DiskAccessException dae) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.Oplog_OPLOGBASICGET_ERROR_IN_READING_THE_DATA_FROM_DISK_FOR_DISK_ID_HAVING_DATA_AS_0, id), (Throwable)dae);
            throw dae;
        }
        if (bb == null) {
            throw new EntryDestroyedException(LocalizedStrings.Oplog_NO_VALUE_WAS_FOUND_FOR_ENTRY_WITH_DISK_ID_0_ON_A_REGION_WITH_SYNCHRONOUS_WRITING_SET_TO_1.toLocalizedString(id, dr.isSync()));
        }
        if (bitOnly) {
            dr.endRead(start, this.stats.endRead(start, 1L), 1L);
        } else {
            dr.endRead(start, this.stats.endRead(start, bb.getBytes().length), bb.getBytes().length);
        }
        return bb;
    }

    @Override
    public BytesAndBits getNoBuffer(DiskRegion dr, DiskId id) {
        if (logger.isDebugEnabled()) {
            logger.debug("Oplog::getNoBuffer:Before invoking Oplog.basicGet for DiskID ={}", (Object)id);
        }
        try {
            return this.basicGet(dr, id.getOffsetInOplog(), false, id.getValueLength(), id.getUserBits());
        }
        catch (DiskAccessException dae) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.Oplog_OPLOGGETNOBUFFEREXCEPTION_IN_RETRIEVING_VALUE_FROM_DISK_FOR_DISKID_0, id), (Throwable)dae);
            throw dae;
        }
        catch (IllegalStateException ise) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.Oplog_OPLOGGETNOBUFFEREXCEPTION_IN_RETRIEVING_VALUE_FROM_DISK_FOR_DISKID_0, id), (Throwable)ise);
            throw ise;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(DiskRegion dr) {
        this.lockCompactor();
        try {
            this.addUnrecoveredRegion(dr.getId());
            DiskRegionInfo dri = this.getDRI(dr);
            if (dri != null) {
                long clearCount = dri.clear(null);
                if (clearCount != 0L) {
                    this.totalLiveCount.addAndGet(-clearCount);
                }
                this.regionMap.remove(dr.getId(), dri);
            }
        }
        finally {
            this.unlockCompactor();
        }
    }

    void clear(DiskRegion dr, RegionVersionVector rvv) {
        long clearCount;
        DiskRegionInfo dri = this.getDRI(dr);
        if (dri != null && (clearCount = dri.clear(rvv)) != 0L) {
            this.totalLiveCount.addAndGet(-clearCount);
            if (!this.isCompacting() || this.calledByCompactorThread()) {
                this.handleNoLiveValues();
            }
        }
    }

    void destroy(DiskRegion dr) {
        DiskRegionInfo dri = this.getDRI(dr);
        if (dri != null) {
            long clearCount = dri.clear(null);
            if (clearCount != 0L) {
                this.totalLiveCount.addAndGet(-clearCount);
                if (!this.isCompacting() || this.calledByCompactorThread()) {
                    this.handleNoLiveValues();
                }
            }
            this.regionMap.remove(dr.getId(), dri);
        }
    }

    long getMaxRecoveredOplogEntryId() {
        long result = this.recoverNewEntryId;
        if (this.recoverModEntryIdHWM > result) {
            result = this.recoverModEntryIdHWM;
        }
        if (this.recoverDelEntryIdHWM > result) {
            result = this.recoverDelEntryIdHWM;
        }
        return result;
    }

    private void setRecoverNewEntryId(long v) {
        this.recoverNewEntryId = v;
    }

    private long incRecoverNewEntryId() {
        ++this.recoverNewEntryId;
        return this.recoverNewEntryId;
    }

    public long calcModEntryId(long delta) {
        long oplogKeyId = this.recoverModEntryId + delta;
        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
            logger.trace(LogMarker.PERSIST_RECOVERY, "calcModEntryId delta={} recoverModEntryId={}  oplogKeyId={}", (Object)delta, (Object)this.recoverModEntryId, (Object)oplogKeyId);
        }
        this.recoverModEntryId = oplogKeyId;
        if (oplogKeyId > this.recoverModEntryIdHWM) {
            this.recoverModEntryIdHWM = oplogKeyId;
        }
        return oplogKeyId;
    }

    public long calcDelEntryId(long delta) {
        long oplogKeyId = this.recoverDelEntryId + delta;
        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
            logger.trace(LogMarker.PERSIST_RECOVERY, "calcDelEntryId delta={} recoverModEntryId={}  oplogKeyId={}", (Object)delta, (Object)this.recoverModEntryId, (Object)oplogKeyId);
        }
        this.recoverDelEntryId = oplogKeyId;
        if (oplogKeyId > this.recoverDelEntryIdHWM) {
            this.recoverDelEntryIdHWM = oplogKeyId;
        }
        return oplogKeyId;
    }

    boolean isCrashed() {
        return this.crashed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long recoverDrf(DiskStoreImpl.OplogEntryIdSet deletedIds, boolean alreadyRecoveredOnce, boolean latestOplog) {
        File drfFile = this.drf.f;
        if (drfFile == null) {
            this.haveRecoveredDrf = true;
            return 0L;
        }
        this.lockCompactor();
        try {
            if (this.haveRecoveredDrf && !this.getHasDeletes()) {
                long l = 0L;
                return l;
            }
            if (!this.haveRecoveredDrf) {
                this.haveRecoveredDrf = true;
            }
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DiskRegion_RECOVERING_OPLOG_0_1_2, new Object[]{this.toString(), drfFile.getAbsolutePath(), this.getParent().getName()}));
            this.recoverDelEntryId = 0L;
            boolean readLastRecord = true;
            CountingDataInputStream dis = null;
            try {
                int recordCount = 0;
                boolean foundDiskStoreRecord = false;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(drfFile);
                    dis = new CountingDataInputStream(new BufferedInputStream(fis, 32768), drfFile.length());
                    boolean endOfLog = false;
                    while (!endOfLog) {
                        if (dis.atEndOfFile()) {
                            endOfLog = true;
                            break;
                        }
                        readLastRecord = false;
                        byte opCode = dis.readByte();
                        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                            logger.trace(LogMarker.PERSIST_RECOVERY, "drf byte={} location={}", (Object)opCode, (Object)Long.toHexString(dis.getCount()));
                        }
                        switch (opCode) {
                            case 0: {
                                dis.decrementCount();
                                endOfLog = true;
                                break;
                            }
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: {
                                this.readDelEntry(dis, opCode, deletedIds, this.parent);
                                ++recordCount;
                                break;
                            }
                            case 62: {
                                this.readDiskStoreRecord(dis, this.drf.f);
                                foundDiskStoreRecord = true;
                                ++recordCount;
                                break;
                            }
                            case 92: {
                                this.readOplogMagicSeqRecord(dis, this.drf.f, OPLOG_TYPE.DRF);
                                break;
                            }
                            case 91: {
                                this.readGemfireVersionRecord(dis, this.drf.f);
                                ++recordCount;
                                break;
                            }
                            case 89: {
                                long idx = dis.getCount();
                                this.readRVVRecord(dis, this.drf.f, true, latestOplog);
                                ++recordCount;
                                break;
                            }
                            default: {
                                throw new DiskAccessException(LocalizedStrings.Oplog_UNKNOWN_OPCODE_0_FOUND_IN_DISK_OPERATION_LOG.toLocalizedString(opCode), this.getParent());
                            }
                        }
                        readLastRecord = true;
                    }
                }
                finally {
                    if (dis != null) {
                        dis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                if (!foundDiskStoreRecord && recordCount > 0) {
                    throw new DiskAccessException("The oplog file \"" + this.drf.f + "\" does not belong to the init file \"" + this.getParent().getInitFile() + "\". Drf did not contain a disk store id.", this.getParent());
                }
            }
            catch (EOFException recordCount) {
            }
            catch (IOException ex) {
                this.getParent().getCancelCriterion().checkCancelInProgress(ex);
                throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_READING_FILE_DURING_RECOVERY_FROM_0.toLocalizedString(drfFile.getPath()), (Throwable)ex, this.getParent());
            }
            catch (CancelException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Oplog::readOplog:Error in recovery as Cache was closed", (Throwable)e);
                }
            }
            catch (RegionDestroyedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Oplog::readOplog:Error in recovery as Region was destroyed", (Throwable)e);
                }
            }
            catch (IllegalStateException e) {
                throw e;
            }
            long byteCount = 0L;
            if (!readLastRecord) {
                this.crashed = true;
                if (dis != null) {
                    byteCount = dis.getFileLength();
                }
            } else if (dis != null) {
                byteCount = dis.getCount();
            }
            if (!alreadyRecoveredOnce) {
                this.setRecoveredDrfSize(byteCount);
                this.dirHolder.incrementTotalOplogSize(byteCount);
            }
            long l = byteCount;
            return l;
        }
        finally {
            this.unlockCompactor();
        }
    }

    private OplogEntryIdMap getRecoveryMap() {
        return this.kvMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readKrf(DiskStoreImpl.OplogEntryIdSet deletedIds, boolean recoverValues, boolean recoverValuesSync, Set<Oplog> oplogsNeedingValueRecovery, boolean latestOplog) {
        FileInputStream fis;
        File f = new File(this.diskFile.getPath() + KRF_FILE_EXT);
        if (!f.exists()) {
            return false;
        }
        if (!this.getParent().getDiskInitFile().hasKrf(this.oplogId)) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.Oplog_REMOVING_INCOMPLETE_KRF, new Object[]{f.getName(), this.oplogId, this.getParent().getName()}));
            f.delete();
        }
        this.krfCreated.set(true);
        if (recoverValuesSync) {
            return false;
        }
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException ignore) {
            return false;
        }
        try {
            if (this.getParent().isOffline() && !this.getParent().FORCE_KRF_RECOVERY) {
                boolean ignore = false;
                return ignore;
            }
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DiskRegion_RECOVERING_OPLOG_0_1_2, new Object[]{this.toString(), f.getAbsolutePath(), this.getParent().getName()}));
            this.recoverNewEntryId = 0L;
            this.recoverModEntryId = 0L;
            this.recoverModEntryIdHWM = 0L;
            long oplogKeyIdHWM = 0L;
            int krfEntryCount = 0;
            DataInputStream dis = new DataInputStream(new BufferedInputStream(fis, 0x100000));
            Version version = this.getProductVersionIfOld();
            ByteArrayDataInput in = new ByteArrayDataInput();
            try {
                try {
                    this.validateOpcode(dis, (byte)92);
                    this.readOplogMagicSeqRecord(dis, f, OPLOG_TYPE.KRF);
                    this.validateOpcode(dis, (byte)62);
                    this.readDiskStoreRecord(dis, f);
                }
                catch (DiskAccessException ignore) {
                    fis.close();
                    fis = new FileInputStream(f);
                    dis = new DataInputStream(new BufferedInputStream(fis, 0x100000));
                    this.readDiskStoreRecord(dis, f);
                }
                catch (IllegalStateException ignore) {
                    fis.close();
                    fis = new FileInputStream(f);
                    dis = new DataInputStream(new BufferedInputStream(fis, 0x100000));
                    this.readDiskStoreRecord(dis, f);
                }
                this.readGemfireVersionRecord(dis, f);
                this.readTotalCountRecord(dis, f);
                this.readRVVRecord(dis, f, false, latestOplog);
                long lastOffset = 0L;
                byte[] keyBytes = DataSerializer.readByteArray(dis);
                while (keyBytes != null) {
                    long oplogOffset;
                    byte userBits = dis.readByte();
                    int valueLength = InternalDataSerializer.readArrayLength(dis);
                    byte[] valueBytes = null;
                    long drId = DiskInitFile.readDiskRegionID(dis);
                    DiskRecoveryStore drs = this.getOplogSet().getCurrentlyRecovering(drId);
                    VersionTag tag = null;
                    if (EntryBits.isWithVersions(userBits)) {
                        tag = this.readVersionsFromOplog(dis);
                        if (drs != null && !drs.getDiskRegionView().getFlags().contains((Object)DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING)) {
                            tag = null;
                            userBits = EntryBits.setWithVersions(userBits, false);
                        } else if (drs != null) {
                            drs.recordRecoveredVersionTag(tag);
                        }
                    }
                    long oplogKeyId = InternalDataSerializer.readVLOld(dis);
                    if (EntryBits.isAnyInvalid(userBits) || EntryBits.isTombstone(userBits)) {
                        oplogOffset = -1L;
                    } else {
                        lastOffset = oplogOffset = lastOffset + InternalDataSerializer.readVLOld(dis);
                    }
                    if (oplogKeyId > oplogKeyIdHWM) {
                        oplogKeyIdHWM = oplogKeyId;
                    }
                    if (this.okToSkipModifyRecord(deletedIds, drId, drs, oplogKeyId, true, tag).skip()) {
                        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                            logger.trace(LogMarker.PERSIST_RECOVERY, "readNewEntry skipping oplogKeyId=<{}> drId={} userBits={} oplogOffset={} valueLen={}", (Object)oplogKeyId, (Object)drId, (Object)userBits, (Object)oplogOffset, (Object)valueLength);
                        }
                        this.stats.incRecoveryRecordsSkipped();
                        this.incSkipped();
                    } else {
                        if (EntryBits.isAnyInvalid(userBits)) {
                            valueBytes = EntryBits.isInvalid(userBits) ? DiskEntry.INVALID_BYTES : DiskEntry.LOCAL_INVALID_BYTES;
                        } else if (EntryBits.isTombstone(userBits)) {
                            valueBytes = DiskEntry.TOMBSTONE_BYTES;
                        }
                        Object key = this.deserializeKey(keyBytes, version, in);
                        Object oldValue = this.getRecoveryMap().put(oplogKeyId, key);
                        if (oldValue != null) {
                            throw new AssertionError((Object)LocalizedStrings.Oplog_DUPLICATE_CREATE.toLocalizedString(oplogKeyId));
                        }
                        DiskEntry de = drs.getDiskEntry(key);
                        if (de == null) {
                            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                                logger.trace(LogMarker.PERSIST_RECOVERY, "readNewEntry oplogKeyId=<{}> drId={} userBits={} oplogOffset={} valueLen={}", (Object)oplogKeyId, (Object)drId, (Object)userBits, (Object)oplogOffset, (Object)valueLength);
                            }
                            DiskEntry.RecoveredEntry re = this.createRecoveredEntry(valueBytes, valueLength, userBits, this.getOplogId(), oplogOffset, oplogKeyId, false, version, in);
                            if (tag != null) {
                                re.setVersionTag(tag);
                            }
                            this.initRecoveredEntry(drs.getDiskRegionView(), drs.initializeRecoveredEntry(key, re));
                            drs.getDiskRegionView().incRecoveredEntryCount();
                            this.stats.incRecoveredEntryCreates();
                            ++krfEntryCount;
                        } else {
                            DiskId curdid = de.getDiskId();
                            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                                logger.trace(LogMarker.PERSIST_RECOVERY, "ignore readNewEntry because getOplogId()={} != curdid.getOplogId()={} for drId={} key={}", (Object)this.getOplogId(), (Object)curdid.getOplogId(), (Object)drId, key);
                            }
                        }
                    }
                    keyBytes = DataSerializer.readByteArray(dis);
                }
                this.setRecoverNewEntryId(oplogKeyIdHWM);
            }
            catch (IOException ex) {
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new DiskAccessException("Unable to recover from krf file for oplogId=" + this.oplogId + ", file=" + f.getName() + ". This file is corrupt, but may be safely deleted.", (Throwable)ex, this.getParent());
            }
            if (recoverValues && krfEntryCount > 0) {
                oplogsNeedingValueRecovery.add(this);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private void validateOpcode(DataInputStream dis, byte expect) throws IOException {
        byte opCode = dis.readByte();
        if (opCode != expect) {
            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                logger.trace(LogMarker.PERSIST_RECOVERY, "expected opcode id absent: {}", (Object)expect);
            }
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readCrf(DiskStoreImpl.OplogEntryIdSet deletedIds, boolean recoverValues, boolean latestOplog) {
        this.recoverNewEntryId = 0L;
        this.recoverModEntryId = 0L;
        this.recoverModEntryIdHWM = 0L;
        boolean readLastRecord = true;
        CountingDataInputStream dis = null;
        try {
            LocalRegion currentRegion = LocalRegion.getInitializingRegion();
            Version version = this.getProductVersionIfOld();
            ByteArrayDataInput in = new ByteArrayDataInput();
            HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
            int recordCount = 0;
            boolean foundDiskStoreRecord = false;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.crf.f);
                dis = new CountingDataInputStream(new BufferedInputStream(fis, 0x100000), this.crf.f.length());
                boolean endOfLog = false;
                while (!endOfLog) {
                    if (dis.atEndOfFile()) {
                        endOfLog = true;
                        break;
                    }
                    readLastRecord = false;
                    byte opCode = dis.readByte();
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "Oplog opCode={}", (Object)opCode);
                    }
                    switch (opCode) {
                        case 0: {
                            dis.decrementCount();
                            endOfLog = true;
                            break;
                        }
                        case 90: {
                            this.readVersionTagOnlyEntry(dis, opCode);
                            break;
                        }
                        case 63: {
                            long newEntryBase = dis.readLong();
                            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                                logger.trace(LogMarker.PERSIST_RECOVERY, "newEntryBase={}", (Object)newEntryBase);
                            }
                            this.readEndOfRecord(dis);
                            this.setRecoverNewEntryId(newEntryBase);
                            ++recordCount;
                            break;
                        }
                        case 64: {
                            this.readNewEntry(dis, opCode, deletedIds, recoverValues, currentRegion, version, in, hdos);
                            ++recordCount;
                            break;
                        }
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: {
                            this.readModifyEntry(dis, opCode, deletedIds, recoverValues, currentRegion, version, in, hdos);
                            ++recordCount;
                            break;
                        }
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: {
                            this.readModifyEntryWithKey(dis, opCode, deletedIds, recoverValues, currentRegion, version, in, hdos);
                            ++recordCount;
                            break;
                        }
                        case 62: {
                            this.readDiskStoreRecord(dis, this.crf.f);
                            foundDiskStoreRecord = true;
                            ++recordCount;
                            break;
                        }
                        case 92: {
                            this.readOplogMagicSeqRecord(dis, this.crf.f, OPLOG_TYPE.CRF);
                            break;
                        }
                        case 91: {
                            this.readGemfireVersionRecord(dis, this.crf.f);
                            ++recordCount;
                            break;
                        }
                        case 89: {
                            this.readRVVRecord(dis, this.drf.f, false, latestOplog);
                            ++recordCount;
                            break;
                        }
                        default: {
                            throw new DiskAccessException(LocalizedStrings.Oplog_UNKNOWN_OPCODE_0_FOUND_IN_DISK_OPERATION_LOG.toLocalizedString(opCode), this.getParent());
                        }
                    }
                    readLastRecord = true;
                }
            }
            finally {
                if (dis != null) {
                    dis.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            if (!foundDiskStoreRecord && recordCount > 0) {
                throw new DiskAccessException("The oplog file \"" + this.crf.f + "\" does not belong to the init file \"" + this.getParent().getInitFile() + "\". Crf did not contain a disk store id.", this.getParent());
            }
        }
        catch (EOFException currentRegion) {
        }
        catch (IOException ex) {
            this.getParent().getCancelCriterion().checkCancelInProgress(ex);
            throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_READING_FILE_DURING_RECOVERY_FROM_0.toLocalizedString(this.crf.f.getPath()), (Throwable)ex, this.getParent());
        }
        catch (CancelException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Oplog::readOplog:Error in recovery as Cache was closed", (Throwable)e);
            }
        }
        catch (RegionDestroyedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Oplog::readOplog:Error in recovery as Region was destroyed", (Throwable)e);
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        long byteCount = 0L;
        if (!readLastRecord) {
            this.crashed = true;
            if (dis != null) {
                byteCount = dis.getFileLength();
            }
        } else if (dis != null) {
            byteCount = dis.getCount();
        }
        return byteCount;
    }

    private void readDiskStoreRecord(DataInput dis, File f) throws IOException {
        long leastSigBits = dis.readLong();
        long mostSigBits = dis.readLong();
        DiskStoreID readDSID = new DiskStoreID(mostSigBits, leastSigBits);
        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
            logger.trace(LogMarker.PERSIST_RECOVERY, "diskStoreId={}", (Object)readDSID);
        }
        this.readEndOfRecord(dis);
        DiskStoreID dsid = this.getParent().getDiskStoreID();
        if (!readDSID.equals(dsid)) {
            throw new DiskAccessException("The oplog file \"" + f + "\" does not belong to the init file \"" + this.getParent().getInitFile() + "\".", this.getParent());
        }
    }

    private void readOplogMagicSeqRecord(DataInput dis, File f, OPLOG_TYPE type) throws IOException {
        byte[] seq = new byte[OPLOG_TYPE.getLen()];
        dis.readFully(seq);
        for (int i = 0; i < OPLOG_TYPE.getLen(); ++i) {
            if (seq[i] == type.getBytes()[i]) continue;
            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                logger.trace(LogMarker.PERSIST_RECOVERY, "oplog magic code mismatched at byte:{}, value:{}", (Object)(i + 1), (Object)seq[i]);
            }
            throw new DiskAccessException("Invalid oplog (" + type.name() + ") file provided: " + f, this.getParent());
        }
        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < OPLOG_TYPE.getLen(); ++i) {
                sb.append(" ").append(seq[i]);
            }
            logger.trace(LogMarker.PERSIST_RECOVERY, "oplog magic code: {}", (Object)sb);
        }
        this.readEndOfRecord(dis);
    }

    private void readGemfireVersionRecord(DataInput dis, File f) throws IOException {
        byte opCode;
        Version recoveredGFVersion = this.readProductVersionRecord(dis, f);
        boolean hasDataVersion = recoveredGFVersion == Version.TOKEN;
        if (hasDataVersion) {
            opCode = dis.readByte();
            if (opCode != 91) {
                throw new DiskAccessException(LocalizedStrings.Oplog_UNKNOWN_OPCODE_0_FOUND_IN_DISK_OPERATION_LOG.toLocalizedString(opCode), this.getParent());
            }
            recoveredGFVersion = this.readProductVersionRecord(dis, f);
        }
        if (this.gfversion == null) {
            this.gfversion = recoveredGFVersion;
        } else assert (this.gfversion == recoveredGFVersion);
        if (hasDataVersion) {
            opCode = dis.readByte();
            if (opCode != 91) {
                throw new DiskAccessException(LocalizedStrings.Oplog_UNKNOWN_OPCODE_0_FOUND_IN_DISK_OPERATION_LOG.toLocalizedString(opCode), this.getParent());
            }
            recoveredGFVersion = this.readProductVersionRecord(dis, f);
            if (this.dataVersion == null) {
                this.dataVersion = recoveredGFVersion;
            } else assert (this.dataVersion == recoveredGFVersion);
        }
    }

    private Version readProductVersionRecord(DataInput dis, File f) throws IOException {
        Version recoveredGFVersion;
        short ver = Version.readOrdinal(dis);
        try {
            recoveredGFVersion = Version.fromOrdinal(ver, false);
        }
        catch (UnsupportedVersionException e) {
            throw new DiskAccessException(LocalizedStrings.Oplog_UNEXPECTED_PRODUCT_VERSION_0.toLocalizedString(ver), (Throwable)e, this.getParent());
        }
        logger.trace(LogMarker.PERSIST_RECOVERY, "version={}", (Object)recoveredGFVersion);
        this.readEndOfRecord(dis);
        return recoveredGFVersion;
    }

    private void readTotalCountRecord(DataInput dis, File f) throws IOException {
        long recoveredCount = InternalDataSerializer.readUnsignedVL(dis);
        this.totalCount.set(recoveredCount);
        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
            logger.trace(LogMarker.PERSIST_RECOVERY, "totalCount={}", (Object)this.totalCount);
        }
        this.readEndOfRecord(dis);
    }

    private void readRVVRecord(DataInput dis, File f, boolean gcRVV, boolean latestOplog) throws IOException {
        boolean isPersistRecoveryDebugEnabled = logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY);
        long numRegions = InternalDataSerializer.readUnsignedVL(dis);
        if (isPersistRecoveryDebugEnabled) {
            logger.trace(LogMarker.PERSIST_RECOVERY, "readRVV entry numRegions={}", (Object)numRegions);
        }
        int region = 0;
        while ((long)region < numRegions) {
            Object member;
            long drId = InternalDataSerializer.readUnsignedVL(dis);
            DiskRecoveryStore drs = this.getOplogSet().getCurrentlyRecovering(drId);
            if (isPersistRecoveryDebugEnabled) {
                logger.trace(LogMarker.PERSIST_RECOVERY, "readRVV drId={} region={}", (Object)drId, (Object)drs);
            }
            if (gcRVV) {
                long rvvSize = InternalDataSerializer.readUnsignedVL(dis);
                int memberNum = 0;
                while ((long)memberNum < rvvSize) {
                    long memberId = InternalDataSerializer.readUnsignedVL(dis);
                    long gcVersion = InternalDataSerializer.readUnsignedVL(dis);
                    if (drs != null) {
                        member = this.getParent().getDiskInitFile().getCanonicalObject((int)memberId);
                        drs.recordRecoveredGCVersion((VersionSource)member, gcVersion);
                        if (isPersistRecoveryDebugEnabled) {
                            logger.trace(LogMarker.PERSIST_RECOVERY, "adding gcRVV entry drId={}, member={}, version={}", (Object)drId, (Object)memberId, (Object)gcVersion);
                        }
                    } else if (isPersistRecoveryDebugEnabled) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "skipping gcRVV entry drId={}, member={}, version={}", (Object)drId, (Object)memberId, (Object)gcVersion);
                    }
                    ++memberNum;
                }
            } else {
                boolean rvvTrusted = DataSerializer.readBoolean(dis);
                if (drs != null && latestOplog) {
                    drs.setRVVTrusted(rvvTrusted);
                    if (isPersistRecoveryDebugEnabled) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "marking RVV trusted drId={},tvvTrusted={}", (Object)drId, (Object)rvvTrusted);
                    }
                }
                long rvvSize = InternalDataSerializer.readUnsignedVL(dis);
                int memberNum = 0;
                while ((long)memberNum < rvvSize) {
                    long memberId = InternalDataSerializer.readUnsignedVL(dis);
                    RegionVersionHolder versionHolder = new RegionVersionHolder(dis);
                    if (drs != null) {
                        member = this.getParent().getDiskInitFile().getCanonicalObject((int)memberId);
                        drs.recordRecoveredVersonHolder((VersionSource)member, versionHolder, latestOplog);
                        if (isPersistRecoveryDebugEnabled) {
                            logger.trace(LogMarker.PERSIST_RECOVERY, "adding RVV entry drId={},member={},versionHolder={},latestOplog={},oplogId={}", (Object)drId, (Object)memberId, versionHolder, (Object)latestOplog, (Object)this.getOplogId());
                        }
                    } else if (isPersistRecoveryDebugEnabled) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "skipping RVV entry drId={}, member={}, versionHolder={}", (Object)drId, (Object)memberId, versionHolder);
                    }
                    ++memberNum;
                }
            }
            ++region;
        }
        this.readEndOfRecord(dis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long recoverCrf(DiskStoreImpl.OplogEntryIdSet deletedIds, boolean recoverValues, boolean recoverValuesSync, boolean alreadyRecoveredOnce, Set<Oplog> oplogsNeedingValueRecovery, boolean latestOplog) {
        this.diskFile = new File(this.drf.f.getParentFile(), this.oplogSet.getPrefix() + this.getParent().getName() + "_" + this.oplogId);
        File crfFile = this.crf.f;
        if (crfFile == null) {
            this.haveRecoveredCrf = true;
            return 0L;
        }
        this.lockCompactor();
        this.kvMap = new OplogEntryIdMap();
        this.skippedKeyBytes = new OplogEntryIdMap();
        try {
            long byteCount;
            if (this.haveRecoveredCrf && this.isDeleted()) {
                long l = 0L;
                return l;
            }
            if (!this.haveRecoveredCrf) {
                this.haveRecoveredCrf = true;
            }
            if (!this.readKrf(deletedIds, recoverValues, recoverValuesSync, oplogsNeedingValueRecovery, latestOplog)) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DiskRegion_RECOVERING_OPLOG_0_1_2, new Object[]{this.toString(), crfFile.getAbsolutePath(), this.getParent().getName()}));
                byteCount = this.readCrf(deletedIds, recoverValues, latestOplog);
            } else {
                byteCount = this.crf.f.length();
            }
            if (!this.isPhase2()) {
                if (this.getParent().isOfflineCompacting()) {
                    this.getParent().incLiveEntryCount(this.getRecoveryMap().size());
                }
                this.getParent().incDeadRecordCount(this.getRecordsSkipped());
            }
            if (this.getParent().isOfflineCompacting()) {
                this.offlineCompact(deletedIds, latestOplog);
            }
            if (!alreadyRecoveredOnce) {
                this.setRecoveredCrfSize(byteCount);
                this.dirHolder.incrementTotalOplogSize(byteCount);
            }
            if (this.getParent().isOfflineCompacting() && this.isOplogEmpty()) {
                this.deleted.set(false);
                this.destroy();
            }
            long l = byteCount;
            return l;
        }
        finally {
            this.kvMap = null;
            this.skippedKeyBytes = null;
            this.unlockCompactor();
        }
    }

    private boolean isPhase1() {
        return !this.offlineCompactPhase2;
    }

    private boolean isPhase2() {
        return this.offlineCompactPhase2;
    }

    private void offlineCompact(DiskStoreImpl.OplogEntryIdSet deletedIds, boolean latestOplog) {
        if (this.getRecordsSkipped() > 0 || this.getHasDeletes() || this.getParent().isUpgradeVersionOnly()) {
            this.offlineCompactPhase2 = true;
            if (this.getOplogSet().getChild() == null) {
                this.getOplogSet().initChild();
            }
            this.readCrf(deletedIds, true, latestOplog);
            this.deleted.set(false);
            this.destroyCrfOnly();
        } else {
            OplogEntryIdMap.Iterator it = this.getRecoveryMap().iterator();
            while (it.hasNext()) {
                it.advance();
                deletedIds.add(it.key());
            }
            this.close();
        }
    }

    public DiskEntry.RecoveredEntry createRecoveredEntry(byte[] valueBytes, int valueLength, byte userBits, long oplogId, long offsetInOplog, long oplogKeyId, boolean recoverValue, Version version, ByteArrayDataInput in) {
        DiskEntry.RecoveredEntry re = null;
        if (recoverValue || EntryBits.isAnyInvalid(userBits) || EntryBits.isTombstone(userBits)) {
            Object value;
            if (EntryBits.isLocalInvalid(userBits)) {
                value = Token.LOCAL_INVALID;
                valueLength = 0;
            } else if (EntryBits.isInvalid(userBits)) {
                value = Token.INVALID;
                valueLength = 0;
            } else {
                value = EntryBits.isSerialized(userBits) ? DiskEntry.Helper.readSerializedValue(valueBytes, version, in, false) : (EntryBits.isTombstone(userBits) ? Token.TOMBSTONE : (Object)valueBytes);
            }
            re = new DiskEntry.RecoveredEntry(oplogKeyId, oplogId, offsetInOplog, userBits, valueLength, value);
        } else {
            re = new DiskEntry.RecoveredEntry(oplogKeyId, oplogId, offsetInOplog, userBits, valueLength);
        }
        return re;
    }

    private void readEndOfRecord(DataInput di) throws IOException {
        byte b = di.readByte();
        if (b != 21) {
            if (b == 0) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.Oplog_PARTIAL_RECORD));
                throw new EOFException("found partial last record");
            }
            throw new IllegalStateException("expected end of record (byte==21) or zero but found " + b);
        }
    }

    private static void forceSkipBytes(CountingDataInputStream dis, int len) throws IOException {
        for (int skipped = dis.skipBytes(len); skipped < len; ++skipped) {
            dis.readByte();
        }
    }

    private void incSkipped() {
        ++this.recordsSkippedDuringRecovery;
    }

    int getRecordsSkipped() {
        return this.recordsSkippedDuringRecovery;
    }

    private VersionTag readVersionsFromOplog(DataInput dis) throws IOException {
        if (Version.GFE_70.compareTo(this.currentRecoveredGFVersion()) <= 0) {
            int entryVersion = (int)InternalDataSerializer.readSignedVL(dis);
            long regionVersion = InternalDataSerializer.readUnsignedVL(dis);
            int memberId = (int)InternalDataSerializer.readUnsignedVL(dis);
            Object member = this.getParent().getDiskInitFile().getCanonicalObject(memberId);
            long timestamp = InternalDataSerializer.readUnsignedVL(dis);
            int dsId = (int)InternalDataSerializer.readSignedVL(dis);
            VersionTag vt = VersionTag.create((VersionSource)member);
            vt.setEntryVersion(entryVersion);
            vt.setRegionVersion(regionVersion);
            vt.setMemberID((VersionSource)member);
            vt.setVersionTimeStamp(timestamp);
            vt.setDistributedSystemId(dsId);
            return vt;
        }
        return null;
    }

    private synchronized VersionTag createDummyTag(DiskRecoveryStore drs) {
        DiskStoreID member = this.getParent().getDiskStoreID();
        int memberid = this.getParent().getDiskInitFile().getOrCreateCanonicalId(member);
        long regionVersion = drs.getVersionForMember(member);
        VersionTag vt = VersionTag.create(member);
        vt.setEntryVersion(1);
        vt.setRegionVersion(regionVersion + 1L);
        vt.setMemberID(member);
        vt.setVersionTimeStamp(this.getParent().getCache().cacheTimeMillis());
        vt.setDistributedSystemId(-1);
        return vt;
    }

    private boolean recoverLruValue(DiskRecoveryStore drs) {
        if (this.isLruValueRecoveryDisabled(drs)) {
            return false;
        }
        if (drs.lruLimitExceeded()) {
            this.stats.incRecoveredValuesSkippedDueToLRU();
            return false;
        }
        return true;
    }

    private boolean isLruValueRecoveryDisabled(DiskRecoveryStore store) {
        return !store.getDiskStore().isOffline() && !this.getParent().RECOVER_LRU_VALUES && !store.getEvictionAttributes().getAlgorithm().isNone();
    }

    private void readNewEntry(CountingDataInputStream dis, byte opcode, DiskStoreImpl.OplogEntryIdSet deletedIds, boolean recoverValue, LocalRegion currentRegion, Version version, ByteArrayDataInput in, HeapDataOutputStream hdos) throws IOException {
        byte[] keyBytes;
        int len;
        long crOffset;
        OkToSkipResult skipResult;
        boolean isPersistRecoveryDebugEnabled = logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY);
        long oplogOffset = -1L;
        byte userBits = dis.readByte();
        byte[] objValue = null;
        int valueLength = 0;
        long oplogKeyId = this.incRecoverNewEntryId();
        long drId = DiskInitFile.readDiskRegionID(dis);
        DiskRecoveryStore drs = this.getOplogSet().getCurrentlyRecovering(drId);
        VersionTag tag = null;
        boolean isDummy = false;
        if (EntryBits.isWithVersions(userBits)) {
            tag = this.readVersionsFromOplog(dis);
            isDummy = false;
        } else if (this.getParent().isUpgradeVersionOnly() && drs != null) {
            tag = this.createDummyTag(drs);
            userBits = EntryBits.setWithVersions(userBits, true);
            isDummy = true;
        }
        if (drs != null && !drs.getDiskRegionView().getFlags().contains((Object)DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING)) {
            tag = null;
            userBits = EntryBits.setWithVersions(userBits, false);
        }
        if ((skipResult = this.okToSkipModifyRecord(deletedIds, drId, drs, oplogKeyId, true, tag)).skip()) {
            if (!this.isPhase2()) {
                this.stats.incRecoveryRecordsSkipped();
                this.incSkipped();
            }
        } else if (recoverValue && !this.getParent().isOfflineCompacting()) {
            recoverValue = this.recoverLruValue(drs);
        }
        CompactionRecord p2cr = null;
        if (EntryBits.isAnyInvalid(userBits) || EntryBits.isTombstone(userBits)) {
            objValue = EntryBits.isInvalid(userBits) ? DiskEntry.INVALID_BYTES : (EntryBits.isTombstone(userBits) ? DiskEntry.TOMBSTONE_BYTES : DiskEntry.LOCAL_INVALID_BYTES);
            crOffset = dis.getCount();
            if (!skipResult.skip() && this.isPhase2() && (p2cr = (CompactionRecord)this.getRecoveryMap().get(oplogKeyId)) != null && p2cr.getOffset() != crOffset) {
                skipResult = OkToSkipResult.SKIP_RECORD;
            }
        } else {
            len = dis.readInt();
            crOffset = oplogOffset = dis.getCount();
            valueLength = len;
            if (!skipResult.skip() && this.isPhase2() && (p2cr = (CompactionRecord)this.getRecoveryMap().get(oplogKeyId)) != null && p2cr.getOffset() != crOffset) {
                skipResult = OkToSkipResult.SKIP_RECORD;
            }
            if (recoverValue && !skipResult.skip()) {
                byte[] valueBytes = new byte[len];
                dis.readFully(valueBytes);
                objValue = valueBytes;
                this.validateValue(valueBytes, userBits, version, in);
            } else {
                Oplog.forceSkipBytes(dis, len);
            }
        }
        len = dis.readInt();
        this.incTotalCount();
        if (skipResult.skip()) {
            if (skipResult.skipKey()) {
                Oplog.forceSkipBytes(dis, len);
            } else {
                keyBytes = new byte[len];
                dis.readFully(keyBytes);
                this.skippedKeyBytes.put(oplogKeyId, keyBytes);
            }
            this.readEndOfRecord(dis);
            if (drs != null && tag != null) {
                drs.recordRecoveredVersionTag(tag);
            }
            if (isPersistRecoveryDebugEnabled) {
                logger.trace(LogMarker.PERSIST_RECOVERY, "readNewEntry SKIPPING oplogKeyId=<{}> drId={} userBits={} keyLen={} valueLen={} tag={}", (Object)oplogKeyId, (Object)drId, (Object)userBits, (Object)len, (Object)valueLength, (Object)tag);
            }
        } else {
            keyBytes = null;
            if (this.isPhase2()) {
                Oplog.forceSkipBytes(dis, len);
            } else {
                keyBytes = new byte[len];
                dis.readFully(keyBytes);
            }
            this.readEndOfRecord(dis);
            if (drs != null && tag != null) {
                drs.recordRecoveredVersionTag(tag);
            }
            if (this.getParent().isOfflineCompacting()) {
                if (this.isPhase1()) {
                    CompactionRecord cr = new CompactionRecord(keyBytes, crOffset);
                    this.getRecoveryMap().put(oplogKeyId, cr);
                    drs.getDiskRegionView().incRecoveredEntryCount();
                    this.stats.incRecoveredEntryCreates();
                } else {
                    Assert.assertTrue(p2cr != null, "First pass did not find create a compaction record");
                    this.getOplogSet().getChild().copyForwardForOfflineCompact(oplogKeyId, p2cr.getKeyBytes(), objValue, userBits, drId, tag);
                    if (isPersistRecoveryDebugEnabled) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "readNewEntry copyForward oplogKeyId=<{}>", (Object)oplogKeyId);
                    }
                    deletedIds.add(oplogKeyId);
                }
            } else {
                Object key = this.deserializeKey(keyBytes, version, in);
                Object oldValue = this.getRecoveryMap().put(oplogKeyId, key);
                if (oldValue != null) {
                    throw new AssertionError((Object)LocalizedStrings.Oplog_DUPLICATE_CREATE.toLocalizedString(oplogKeyId));
                }
                DiskEntry de = drs.getDiskEntry(key);
                if (de == null) {
                    if (isPersistRecoveryDebugEnabled) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "readNewEntry oplogKeyId=<{}> drId={} key={} userBits={} oplogOffset={} valueLen={} tag={}", (Object)oplogKeyId, (Object)drId, key, (Object)userBits, (Object)oplogOffset, (Object)valueLength, (Object)tag);
                    }
                    DiskEntry.RecoveredEntry re = this.createRecoveredEntry(objValue, valueLength, userBits, this.getOplogId(), oplogOffset, oplogKeyId, recoverValue, version, in);
                    if (tag != null) {
                        re.setVersionTag(tag);
                    }
                    this.initRecoveredEntry(drs.getDiskRegionView(), drs.initializeRecoveredEntry(key, re));
                    drs.getDiskRegionView().incRecoveredEntryCount();
                    this.stats.incRecoveredEntryCreates();
                } else {
                    DiskId curdid = de.getDiskId();
                    assert (curdid.getOplogId() != this.getOplogId());
                    if (isPersistRecoveryDebugEnabled) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "ignore readNewEntry because getOplogId()={} != curdid.getOplogId()={} for drId={} key={}", (Object)this.getOplogId(), (Object)curdid.getOplogId(), (Object)drId, key);
                    }
                }
            }
        }
    }

    private void readModifyEntry(CountingDataInputStream dis, byte opcode, DiskStoreImpl.OplogEntryIdSet deletedIds, boolean recoverValue, LocalRegion currentRegion, Version version, ByteArrayDataInput in, HeapDataOutputStream hdos) throws IOException {
        long crOffset;
        OkToSkipResult skipResult;
        boolean isPersistRecoveryDebugEnabled = logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY);
        long oplogOffset = -1L;
        byte userBits = dis.readByte();
        int idByteCount = opcode - 65 + 1;
        long oplogKeyId = this.getModEntryId(dis, idByteCount);
        long drId = DiskInitFile.readDiskRegionID(dis);
        DiskRecoveryStore drs = this.getOplogSet().getCurrentlyRecovering(drId);
        VersionTag tag = null;
        if (EntryBits.isWithVersions(userBits)) {
            tag = this.readVersionsFromOplog(dis);
        } else if (this.getParent().isUpgradeVersionOnly() && drs != null) {
            tag = this.createDummyTag(drs);
            userBits = EntryBits.setWithVersions(userBits, true);
        }
        if (drs != null && !drs.getDiskRegionView().getFlags().contains((Object)DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING)) {
            tag = null;
            userBits = EntryBits.setWithVersions(userBits, false);
        }
        if ((skipResult = this.okToSkipModifyRecord(deletedIds, drId, drs, oplogKeyId, false, tag)).skip()) {
            if (!this.isPhase2()) {
                this.incSkipped();
                this.stats.incRecoveryRecordsSkipped();
            }
        } else if (recoverValue && !this.getParent().isOfflineCompacting()) {
            recoverValue = this.recoverLruValue(drs);
        }
        byte[] objValue = null;
        int valueLength = 0;
        CompactionRecord p2cr = null;
        if (EntryBits.isAnyInvalid(userBits) || EntryBits.isTombstone(userBits)) {
            objValue = EntryBits.isInvalid(userBits) ? DiskEntry.INVALID_BYTES : (EntryBits.isTombstone(userBits) ? DiskEntry.TOMBSTONE_BYTES : DiskEntry.LOCAL_INVALID_BYTES);
            crOffset = dis.getCount();
            if (!skipResult.skip() && this.isPhase2() && (p2cr = (CompactionRecord)this.getRecoveryMap().get(oplogKeyId)) != null && p2cr.getOffset() != crOffset) {
                skipResult = OkToSkipResult.SKIP_RECORD;
            }
        } else {
            int len = dis.readInt();
            crOffset = oplogOffset = dis.getCount();
            valueLength = len;
            if (!skipResult.skip() && this.isPhase2() && (p2cr = (CompactionRecord)this.getRecoveryMap().get(oplogKeyId)) != null && p2cr.getOffset() != crOffset) {
                skipResult = OkToSkipResult.SKIP_RECORD;
            }
            if (!skipResult.skip() && recoverValue) {
                byte[] valueBytes = new byte[len];
                dis.readFully(valueBytes);
                objValue = valueBytes;
                this.validateValue(valueBytes, userBits, version, in);
            } else {
                Oplog.forceSkipBytes(dis, len);
            }
        }
        this.readEndOfRecord(dis);
        if (drs != null && tag != null) {
            drs.recordRecoveredVersionTag(tag);
        }
        this.incTotalCount();
        if (!skipResult.skip()) {
            byte[] keyBytes;
            Object key = this.getRecoveryMap().get(oplogKeyId);
            if (key == null && (keyBytes = (byte[])this.skippedKeyBytes.get(oplogKeyId)) != null) {
                key = this.deserializeKey(keyBytes, version, in);
            }
            if (isPersistRecoveryDebugEnabled) {
                logger.trace(LogMarker.PERSIST_RECOVERY, "readModifyEntry oplogKeyId=<{}> drId={} key=<{}> userBits={} oplogOffset={} tag={} valueLen={}", (Object)oplogKeyId, (Object)drId, key, (Object)userBits, (Object)oplogOffset, (Object)tag, (Object)valueLength);
            }
            assert (key != null);
            if (this.getParent().isOfflineCompacting()) {
                if (this.isPhase1()) {
                    CompactionRecord cr = (CompactionRecord)key;
                    this.incSkipped();
                    cr.update(crOffset);
                } else {
                    Assert.assertTrue(p2cr != null, "First pass did not find create a compaction record");
                    this.getOplogSet().getChild().copyForwardForOfflineCompact(oplogKeyId, p2cr.getKeyBytes(), objValue, userBits, drId, tag);
                    if (isPersistRecoveryDebugEnabled) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "readModifyEntry copyForward oplogKeyId=<{}>", (Object)oplogKeyId);
                    }
                    deletedIds.add(oplogKeyId);
                }
            } else {
                DiskEntry de = drs.getDiskEntry(key);
                if (de == null) {
                    DiskRegionView drv = drs.getDiskRegionView();
                    DiskEntry.RecoveredEntry re = this.createRecoveredEntry(objValue, valueLength, userBits, this.getOplogId(), oplogOffset, oplogKeyId, recoverValue, version, in);
                    if (tag != null) {
                        re.setVersionTag(tag);
                    }
                    if (isPersistRecoveryDebugEnabled) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "readModEntryWK init oplogKeyId=<{}> drId={} key=<{}> oplogOffset={} userBits={} valueLen={} tag={}", (Object)oplogKeyId, (Object)drId, key, (Object)oplogOffset, (Object)userBits, (Object)valueLength, (Object)tag);
                    }
                    this.initRecoveredEntry(drv, drs.initializeRecoveredEntry(key, re));
                    drs.getDiskRegionView().incRecoveredEntryCount();
                    this.stats.incRecoveredEntryCreates();
                } else {
                    DiskEntry.RecoveredEntry re = this.createRecoveredEntry(objValue, valueLength, userBits, this.getOplogId(), oplogOffset, oplogKeyId, recoverValue, version, in);
                    if (tag != null) {
                        re.setVersionTag(tag);
                    }
                    de = drs.updateRecoveredEntry(key, re);
                    this.updateRecoveredEntry(drs.getDiskRegionView(), de, re);
                    this.stats.incRecoveredEntryUpdates();
                }
            }
        } else if (isPersistRecoveryDebugEnabled) {
            logger.trace(LogMarker.PERSIST_RECOVERY, "skipping readModifyEntry oplogKeyId=<{}> drId={}", (Object)oplogKeyId, (Object)drId);
        }
    }

    private void readVersionTagOnlyEntry(CountingDataInputStream dis, byte opcode) throws IOException {
        long oplogOffset = -1L;
        long drId = DiskInitFile.readDiskRegionID(dis);
        DiskRecoveryStore drs = this.getOplogSet().getCurrentlyRecovering(drId);
        VersionTag tag = this.readVersionsFromOplog(dis);
        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
            logger.trace(LogMarker.PERSIST_RECOVERY, "readVersionTagOnlyEntry drId={} tag={}", (Object)drId, (Object)tag);
        }
        this.readEndOfRecord(dis);
        if (drs != null) {
            drs.recordRecoveredVersionTag(tag);
        }
    }

    private void validateValue(byte[] valueBytes, byte userBits, Version version, ByteArrayDataInput in) {
        block3: {
            if (this.getParent().isValidating() && EntryBits.isSerialized(userBits) && !PdxWriterImpl.isPdx(valueBytes)) {
                try {
                    DiskEntry.Helper.readSerializedValue(valueBytes, version, in, true);
                }
                catch (SerializationException ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Could not deserialize recovered value: {}", (Object)ex.getCause(), (Object)ex);
                }
            }
        }
    }

    private void readModifyEntryWithKey(CountingDataInputStream dis, byte opcode, DiskStoreImpl.OplogEntryIdSet deletedIds, boolean recoverValue, LocalRegion currentRegion, Version version, ByteArrayDataInput in, HeapDataOutputStream hdos) throws IOException {
        byte[] keyBytes;
        long crOffset;
        OkToSkipResult skipResult;
        long oplogOffset = -1L;
        byte userBits = dis.readByte();
        int idByteCount = opcode - 73 + 1;
        long oplogKeyId = this.getModEntryId(dis, idByteCount);
        long drId = DiskInitFile.readDiskRegionID(dis);
        DiskRecoveryStore drs = this.getOplogSet().getCurrentlyRecovering(drId);
        VersionTag tag = null;
        if (EntryBits.isWithVersions(userBits)) {
            tag = this.readVersionsFromOplog(dis);
        } else if (this.getParent().isUpgradeVersionOnly() && drs != null) {
            tag = this.createDummyTag(drs);
            userBits = EntryBits.setWithVersions(userBits, true);
        }
        if (drs != null && !drs.getDiskRegionView().getFlags().contains((Object)DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING)) {
            tag = null;
            userBits = EntryBits.setWithVersions(userBits, false);
        }
        if ((skipResult = this.okToSkipModifyRecord(deletedIds, drId, drs, oplogKeyId, true, tag)).skip()) {
            if (!this.isPhase2()) {
                this.incSkipped();
                this.stats.incRecoveryRecordsSkipped();
            }
        } else if (recoverValue && !this.getParent().isOfflineCompacting()) {
            recoverValue = this.recoverLruValue(drs);
        }
        byte[] objValue = null;
        int valueLength = 0;
        CompactionRecord p2cr = null;
        if (EntryBits.isAnyInvalid(userBits) || EntryBits.isTombstone(userBits)) {
            objValue = EntryBits.isInvalid(userBits) ? DiskEntry.INVALID_BYTES : (EntryBits.isTombstone(userBits) ? DiskEntry.TOMBSTONE_BYTES : DiskEntry.LOCAL_INVALID_BYTES);
            crOffset = dis.getCount();
            if (!skipResult.skip() && this.isPhase2() && (p2cr = (CompactionRecord)this.getRecoveryMap().get(oplogKeyId)) != null && p2cr.getOffset() != crOffset) {
                skipResult = OkToSkipResult.SKIP_RECORD;
            }
        } else {
            int len = dis.readInt();
            crOffset = oplogOffset = dis.getCount();
            valueLength = len;
            if (!skipResult.skip() && this.isPhase2() && (p2cr = (CompactionRecord)this.getRecoveryMap().get(oplogKeyId)) != null && p2cr.getOffset() != crOffset) {
                skipResult = OkToSkipResult.SKIP_RECORD;
            }
            if (!skipResult.skip() && recoverValue) {
                byte[] valueBytes = new byte[len];
                dis.readFully(valueBytes);
                objValue = valueBytes;
                this.validateValue(valueBytes, userBits, version, in);
            } else {
                Oplog.forceSkipBytes(dis, len);
            }
        }
        int keyLen = dis.readInt();
        this.incTotalCount();
        if (skipResult.skip()) {
            if (skipResult.skipKey()) {
                Oplog.forceSkipBytes(dis, keyLen);
            } else {
                keyBytes = new byte[keyLen];
                dis.readFully(keyBytes);
                this.skippedKeyBytes.put(oplogKeyId, keyBytes);
            }
            this.readEndOfRecord(dis);
            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                logger.trace(LogMarker.PERSIST_RECOVERY, "skipping readModEntryWK init oplogKeyId=<{}> drId={}", (Object)oplogKeyId, (Object)drId);
            }
        } else {
            keyBytes = null;
            if (this.isPhase2()) {
                Oplog.forceSkipBytes(dis, keyLen);
            } else {
                keyBytes = new byte[keyLen];
                dis.readFully(keyBytes);
            }
            this.readEndOfRecord(dis);
            if (drs != null && tag != null) {
                drs.recordRecoveredVersionTag(tag);
            }
            assert (oplogKeyId >= 0L);
            if (this.getParent().isOfflineCompacting()) {
                if (this.isPhase1()) {
                    CompactionRecord cr = new CompactionRecord(keyBytes, crOffset);
                    this.getRecoveryMap().put(oplogKeyId, cr);
                    drs.getDiskRegionView().incRecoveredEntryCount();
                    this.stats.incRecoveredEntryCreates();
                } else {
                    Assert.assertTrue(p2cr != null, "First pass did not find create a compaction record");
                    this.getOplogSet().getChild().copyForwardForOfflineCompact(oplogKeyId, p2cr.getKeyBytes(), objValue, userBits, drId, tag);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "readModifyEntryWithKey copyForward oplogKeyId=<{}>", (Object)oplogKeyId);
                    }
                    deletedIds.add(oplogKeyId);
                }
            } else {
                Object key = this.deserializeKey(keyBytes, version, in);
                Object oldValue = this.getRecoveryMap().put(oplogKeyId, key);
                if (oldValue != null) {
                    throw new AssertionError((Object)LocalizedStrings.Oplog_DUPLICATE_CREATE.toLocalizedString(oplogKeyId));
                }
                DiskEntry de = drs.getDiskEntry(key);
                if (de == null) {
                    DiskRegionView drv = drs.getDiskRegionView();
                    DiskEntry.RecoveredEntry re = this.createRecoveredEntry(objValue, valueLength, userBits, this.getOplogId(), oplogOffset, oplogKeyId, recoverValue, version, in);
                    if (tag != null) {
                        re.setVersionTag(tag);
                    }
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "readModEntryWK init oplogKeyId=<{}> drId={} key={} oplogOffset={} userBits={} valueLen={} tag={}", (Object)oplogKeyId, (Object)drId, key, (Object)oplogOffset, (Object)userBits, (Object)valueLength, (Object)tag);
                    }
                    this.initRecoveredEntry(drv, drs.initializeRecoveredEntry(key, re));
                    drs.getDiskRegionView().incRecoveredEntryCount();
                    this.stats.incRecoveredEntryCreates();
                } else {
                    DiskId curdid = de.getDiskId();
                    assert (curdid.getOplogId() != this.getOplogId()) : "Mutiple ModEntryWK in the same oplog for getOplogId()=" + this.getOplogId() + " , curdid.getOplogId()=" + curdid.getOplogId() + " , for drId=" + drId + " , key=" + key;
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "ignore readModEntryWK because getOplogId()={} != curdid.getOplogId()={} for drId={} key={}", (Object)this.getOplogId(), (Object)curdid.getOplogId(), (Object)drId, key);
                    }
                }
            }
        }
    }

    private void readDelEntry(CountingDataInputStream dis, byte opcode, DiskStoreImpl.OplogEntryIdSet deletedIds, DiskStoreImpl parent) throws IOException {
        int idByteCount = opcode - 81 + 1;
        long oplogKeyId = this.getDelEntryId(dis, idByteCount);
        this.readEndOfRecord(dis);
        deletedIds.add(oplogKeyId);
        this.setHasDeletes(true);
        this.stats.incRecoveredEntryDestroys();
        if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
            logger.trace(LogMarker.PERSIST_RECOVERY, "readDelEntry oplogKeyId=<{}>", (Object)oplogKeyId);
        }
    }

    private void addUnrecoveredRegion(long drId) {
        DiskRegionInfo dri = this.getOrCreateDRI(drId);
        if (dri.testAndSetUnrecovered()) {
            this.unrecoveredRegionCount.incrementAndGet();
        }
    }

    void checkForRecoverableRegion(DiskRegionView dr) {
        DiskRegionInfo dri;
        if (this.unrecoveredRegionCount.get() > 0 && (dri = this.getDRI(dr)) != null && dri.testAndSetRecovered(dr)) {
            this.unrecoveredRegionCount.decrementAndGet();
        }
    }

    void updateDiskRegion(DiskRegionView dr) {
        DiskRegionInfo dri = this.getDRI(dr);
        if (dri != null) {
            dri.setDiskRegion(dr);
        }
    }

    private OkToSkipResult okToSkipModifyRecord(DiskStoreImpl.OplogEntryIdSet deletedIds, long drId, DiskRecoveryStore drs, long oplogEntryId, boolean checkRecoveryMap, VersionTag tag) {
        DiskId curdid;
        DiskEntry de;
        Object key;
        if (deletedIds.contains(oplogEntryId)) {
            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                logger.trace(LogMarker.PERSIST_RECOVERY, "okToSkip because oplogEntryId={} was deleted for drId={}", (Object)oplogEntryId, (Object)drId);
            }
            return OkToSkipResult.SKIP_RECORD;
        }
        if (drs == null) {
            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                logger.trace(LogMarker.PERSIST_RECOVERY, "okToSkip because drs is null for drId={}", (Object)drId);
            }
            return OkToSkipResult.SKIP_RECORD;
        }
        if (!checkRecoveryMap && (key = this.getRecoveryMap().get(oplogEntryId)) != null && (de = drs.getDiskEntry(key)) != null && (curdid = de.getDiskId()) != null && curdid.getOplogId() != this.getOplogId()) {
            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                logger.trace(LogMarker.PERSIST_RECOVERY, "okToSkip because getOplogId()={} != curdid.getOplogId()={} for drId={} key={}", (Object)this.getOplogId(), (Object)curdid.getOplogId(), (Object)drId, key);
            }
            return OkToSkipResult.SKIP_RECORD;
        }
        return this.okToSkipRegion(drs.getDiskRegionView(), oplogEntryId, tag);
    }

    private OkToSkipResult okToSkipRegion(DiskRegionView drv, long oplogKeyId, VersionTag tag) {
        RegionVersionVector clearRVV;
        long lastClearKeyId = drv.getClearOplogEntryId();
        if (lastClearKeyId != 0L) {
            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                logger.trace(LogMarker.PERSIST_RECOVERY, "lastClearKeyId={} oplogKeyId={}", (Object)lastClearKeyId, (Object)oplogKeyId);
            }
            if (lastClearKeyId >= 0L) {
                if (oplogKeyId <= lastClearKeyId) {
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        logger.trace(LogMarker.PERSIST_RECOVERY, "okToSkip because oplogKeyId={} <= lastClearKeyId={} for drId={}", (Object)oplogKeyId, (Object)lastClearKeyId, (Object)drv.getId());
                    }
                    return OkToSkipResult.SKIP_RECORD;
                }
            } else if (oplogKeyId > 0L || oplogKeyId <= lastClearKeyId) {
                if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                    logger.trace(LogMarker.PERSIST_RECOVERY, "okToSkip because oplogKeyId={} <= lastClearKeyId={} for drId={}", (Object)oplogKeyId, (Object)lastClearKeyId, (Object)drv.getId());
                }
                return OkToSkipResult.SKIP_RECORD;
            }
        }
        if ((clearRVV = drv.getClearRVV()) != null) {
            if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                logger.trace(LogMarker.PERSIST_RECOVERY, "clearRVV={} tag={}", (Object)clearRVV, (Object)tag);
            }
            if (clearRVV.contains(tag.getMemberID(), tag.getRegionVersion())) {
                if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                    logger.trace(LogMarker.PERSIST_RECOVERY, "okToSkip because tag={} <= clearRVV={} for drId={}", (Object)tag, (Object)clearRVV, (Object)drv.getId());
                }
                return OkToSkipResult.SKIP_VALUE;
            }
        }
        return OkToSkipResult.DONT_SKIP;
    }

    private long getModEntryId(CountingDataInputStream dis, int idByteCount) throws IOException {
        return this.calcModEntryId(Oplog.getEntryIdDelta(dis, idByteCount));
    }

    private long getDelEntryId(CountingDataInputStream dis, int idByteCount) throws IOException {
        return this.calcDelEntryId(Oplog.getEntryIdDelta(dis, idByteCount));
    }

    private static long getEntryIdDelta(CountingDataInputStream dis, int idByteCount) throws IOException {
        assert (idByteCount >= 1 && idByteCount <= 8) : idByteCount;
        long delta = dis.readByte();
        --idByteCount;
        while (idByteCount > 0) {
            delta <<= 8;
            delta |= (long)(0xFF & dis.readByte());
            --idByteCount;
        }
        return delta;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Oplog::close: Store name ={} Oplog ID = {}", (Object)this.parent.getName(), (Object)this.oplogId);
        }
        this.basicClose(false);
    }

    public void testClose() {
        try {
            this.crf.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.crf.raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.crf.RAFClosed = true;
        try {
            this.drf.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.drf.raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.drf.RAFClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicClose(boolean forceDelete) {
        this.flushAll();
        Object object = this.lock;
        synchronized (object) {
            this.unpreblow(this.crf, this.getMaxCrfSize());
            if (!this.crf.RAFClosed) {
                try {
                    this.crf.channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.crf.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.crf.RAFClosed = true;
                this.stats.decOpenOplogs();
            }
            this.closed = true;
        }
        object = this.lock;
        synchronized (object) {
            this.unpreblow(this.drf, this.getMaxDrfSize());
            if (!this.drf.RAFClosed) {
                try {
                    this.drf.channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.drf.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.drf.RAFClosed = true;
            }
        }
        if (forceDelete) {
            this.deleteFiles(false);
        }
    }

    boolean testConfirmCompacted() {
        return this.closed && this.deleted.get() && this.getOplogSize() == 0L;
    }

    boolean isDeleted() {
        return this.deleted.get();
    }

    public void destroy() {
        this.lockCompactor();
        try {
            if (!this.closed) {
                this.basicClose(true);
            } else {
                this.deleteFiles(false);
            }
        }
        finally {
            this.unlockCompactor();
        }
    }

    public void destroyCrfOnly() {
        this.lockCompactor();
        try {
            if (!this.closed) {
                this.basicClose(true);
            } else {
                this.deleteFiles(true);
            }
        }
        finally {
            this.unlockCompactor();
        }
    }

    private void checkClosed() {
        this.getParent().getCancelCriterion().checkCancelInProgress(null);
        if (!this.closed) {
            return;
        }
        throw new OplogCancelledException("This Oplog has been closed.");
    }

    static int bytesNeeded(long v) {
        if (v < 0L) {
            v ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return (64 - Long.numberOfLeadingZeros(v)) / 8 + 1;
    }

    static long abs(long v) {
        if (v < 0L) {
            return -v;
        }
        return v;
    }

    private long calcDelta(long opLogKeyID, byte opCode) {
        long delta;
        if (opCode == 81) {
            delta = opLogKeyID - this.writeDelEntryId;
            this.writeDelEntryId = opLogKeyID;
        } else {
            delta = opLogKeyID - this.writeModEntryId;
            this.writeModEntryId = opLogKeyID;
        }
        return delta;
    }

    private void initOpState(byte opCode, DiskRegionView dr, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, byte userBits, boolean notToUseUserBits) throws IOException {
        this.opState.initialize(opCode, dr, entry, value, userBits, notToUseUserBits);
    }

    private void clearOpState() {
        this.opState.clear();
    }

    private int getOpStateSize() {
        return this.opState.getSize();
    }

    private int getOpStateValueOffset() {
        return this.opState.getValueOffset();
    }

    private byte calcUserBits(DiskEntry.Helper.ValueWrapper vw) {
        return vw.getUserBits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modNeedsKey(DiskEntry entry) {
        DiskId did;
        DiskId diskId = did = entry.getDiskId();
        synchronized (diskId) {
            return did.getOplogId() != this.getOplogId();
            {
            }
        }
    }

    public void create(LocalRegion region, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, boolean async) {
        if (this != this.getOplogSet().getChild()) {
            this.getOplogSet().getChild().create(region, entry, value, async);
        } else {
            DiskId did = entry.getDiskId();
            boolean exceptionOccurred = false;
            byte prevUsrBit = did.getUserBits();
            int len = did.getValueLength();
            try {
                byte userBits = this.calcUserBits(value);
                if (entry.getVersionStamp() != null) {
                    if (entry.getVersionStamp().getMemberID() == null) {
                        throw new AssertionError((Object)("Version stamp should have a member at this point for entry " + entry));
                    }
                    userBits = EntryBits.setWithVersions(userBits, true);
                }
                this.basicCreate(region.getDiskRegion(), entry, value, userBits, async);
            }
            catch (IOException ex) {
                exceptionOccurred = true;
                region.getCancelCriterion().checkCancelInProgress(ex);
                throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0.toLocalizedString(this.diskFile.getPath()), (Throwable)ex, region.getFullPath());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                exceptionOccurred = true;
                region.getCancelCriterion().checkCancelInProgress(ie);
                throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0_DUE_TO_FAILURE_IN_ACQUIRING_READ_LOCK_FOR_ASYNCH_WRITING.toLocalizedString(this.diskFile.getPath()), (Throwable)ie, region.getFullPath());
            }
            finally {
                if (exceptionOccurred) {
                    did.setValueLength(len);
                    did.setUserBits(prevUsrBit);
                }
            }
        }
    }

    private boolean isFirstRecord() {
        return this.firstRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicCreate(DiskRegion dr, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, byte userBits, boolean async) throws IOException, InterruptedException {
        DiskId id = entry.getDiskId();
        boolean useNextOplog = false;
        long startPosForSynchOp = -1L;
        if (DiskStoreImpl.KRF_DEBUG) {
            System.out.println("basicCreate KRF_DEBUG");
            Thread.sleep(1000L);
        }
        this.getParent().getBackupLock().lock();
        try {
            Object object = this.lock;
            synchronized (object) {
                this.initOpState((byte)64, dr, entry, value, userBits, false);
                long temp = (long)this.getOpStateSize() + this.crf.currSize;
                if (!this.wroteNewEntryBase) {
                    temp += 10L;
                }
                if (this != this.getOplogSet().getChild()) {
                    useNextOplog = true;
                } else if (temp > this.getMaxCrfSize() && !this.isFirstRecord()) {
                    this.switchOpLog(dr, this.getOpStateSize(), entry);
                    useNextOplog = true;
                } else {
                    if (this.lockedForKRFcreate) {
                        CacheClosedException cce = new CacheClosedException("The disk store is closed.");
                        dr.getCancelCriterion().checkCancelInProgress(cce);
                        throw cce;
                    }
                    this.firstRecord = false;
                    this.writeNewEntryBaseRecord(async);
                    long createOplogEntryId = this.getOplogSet().newOplogEntryId();
                    id.setKeyId(createOplogEntryId);
                    int dataLength = this.getOpStateSize();
                    id.setOplogId(this.getOplogId());
                    startPosForSynchOp = this.writeOpLogBytes(this.crf, async, true);
                    this.crf.currSize = temp;
                    if (EntryBits.isNeedsValue(userBits)) {
                        id.setValueLength(value.getLength());
                    } else {
                        id.setValueLength(0);
                    }
                    id.setUserBits(userBits);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Oplog::basicCreate:Release dByteBuffer with data for Disk ID = {}", (Object)id);
                    }
                    startPosForSynchOp += (long)this.getOpStateValueOffset();
                    if (logger.isTraceEnabled(LogMarker.PERSIST_WRITES)) {
                        VersionTag tag = null;
                        if (entry.getVersionStamp() != null) {
                            tag = entry.getVersionStamp().asVersionTag();
                        }
                        logger.trace(LogMarker.PERSIST_WRITES, "basicCreate: id=<{}> key=<{}> valueOffset={} userBits={} valueLen={} valueBytes={} drId={} versionTag={} oplog#{}", (Object)Oplog.abs(id.getKeyId()), entry.getKey(), (Object)startPosForSynchOp, (Object)userBits, (Object)(value != null ? value.getLength() : 0), (Object)value.getBytesAsString(), (Object)dr.getId(), tag, (Object)this.getOplogId());
                    }
                    id.setOffsetInOplog(startPosForSynchOp);
                    this.addLive(dr, entry);
                    this.dirHolder.incrementTotalOplogSize(dataLength);
                    this.incTotalCount();
                    RegionVersionVector rvv = dr.getRegionVersionVector();
                    if (rvv != null && entry.getVersionStamp() != null) {
                        rvv.recordVersion(entry.getVersionStamp().getMemberID(), entry.getVersionStamp().getRegionVersion());
                    }
                    EntryLogger.logPersistPut(dr.getName(), entry.getKey(), dr.getDiskStoreID());
                }
                this.clearOpState();
            }
        }
        finally {
            this.getParent().getBackupLock().unlock();
        }
        if (useNextOplog) {
            if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                CacheObserverHolder.getInstance().afterSwitchingOplog();
            }
            Assert.assertTrue(this != this.getOplogSet().getChild());
            this.getOplogSet().getChild().basicCreate(dr, entry, value, userBits, async);
        } else if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
            CacheObserverHolder.getInstance().afterSettingOplogOffSet(startPosForSynchOp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceRolling(DiskRegion dr) {
        if (this.getOplogSet().getChild() == this) {
            this.getParent().getBackupLock().lock();
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (this.getOplogSet().getChild() == this) {
                        this.switchOpLog(dr, 0, null);
                    }
                }
            }
            finally {
                this.getParent().getBackupLock().unlock();
            }
            if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                CacheObserverHolder.getInstance().afterSwitchingOplog();
            }
        }
    }

    private boolean isCompactionPossible() {
        return this.getOplogSet().isCompactionPossible();
    }

    private void switchOpLog(DiskRegionView dr, int lengthOfOperationCausingSwitch, DiskEntry entryCausingSwitch) {
        String drName = dr != null ? dr.getName() : this.getParent().getName();
        this.flushAll();
        lengthOfOperationCausingSwitch += 20;
        if (logger.isDebugEnabled()) {
            logger.debug("Oplog::switchOpLog: Entry causing Oplog switch has diskID={}", entryCausingSwitch != null ? entryCausingSwitch.getDiskId() : "Entry is null");
        }
        if ((long)lengthOfOperationCausingSwitch > this.getParent().getMaxDirSize()) {
            throw new DiskAccessException(LocalizedStrings.Oplog_OPERATION_SIZE_CANNOT_EXCEED_THE_MAXIMUM_DIRECTORY_SIZE_SWITCHING_PROBLEM_FOR_ENTRY_HAVING_DISKID_0.toLocalizedString(entryCausingSwitch != null ? entryCausingSwitch.getDiskId().toString() : "\"null Entry\""), drName);
        }
        if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
            CacheObserverHolder.getInstance().beforeSwitchingOplog();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Oplog::switchOpLog: About to add the Oplog = {} for compaction. Entry causing the switch is having DiskID = {}", (Object)this.oplogId, entryCausingSwitch != null ? entryCausingSwitch.getDiskId() : "null Entry");
        }
        if (this.needsCompaction()) {
            this.addToBeCompacted();
        } else {
            this.getOplogSet().addInactive(this);
        }
        try {
            DirectoryHolder nextDirHolder = this.getOplogSet().getNextDir(lengthOfOperationCausingSwitch, true);
            Oplog newOplog = new Oplog(this.oplogId + 1L, nextDirHolder, this);
            newOplog.firstRecord = true;
            this.getOplogSet().setChild(newOplog);
            this.finishedAppending();
            this.getParent().executeDelayedExpensiveWrite(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Oplog.this.unpreblow(Oplog.this.crf, Oplog.this.getMaxCrfSize());
                    Oplog.this.unpreblow(Oplog.this.drf, Oplog.this.getMaxDrfSize());
                    Oplog.this.closeRAF();
                    Object object = Oplog.this.lock;
                    synchronized (object) {
                        if (!((Oplog)Oplog.this).drf.RAFClosed) {
                            try {
                                ((Oplog)Oplog.this).drf.channel.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            try {
                                ((Oplog)Oplog.this).drf.raf.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            ((Oplog)Oplog.this).drf.RAFClosed = true;
                        }
                    }
                }
            });
            if (this.getParent().isOfflineCompacting()) {
                this.krfClose();
            } else {
                this.createKrfAsync();
            }
        }
        catch (DiskAccessException dae) {
            this.getOplogSet().removeOplog(this.oplogId);
            throw dae;
        }
    }

    protected void createKrfAsync() {
        this.getParent().executeDiskStoreTask(new Runnable(){

            @Override
            public void run() {
                Oplog.this.createKrf(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOneKeyEntryForKRF(KRFEntry ke) throws IOException {
        Object deKey;
        int valueLength;
        long valueOffset;
        long oplogKeyId;
        byte userBits;
        DiskEntry de = ke.getDiskEntry();
        long diskRegionId = ke.getDiskRegionView().getId();
        VersionTag tag = ke.versionTag;
        DiskEntry diskEntry = de;
        synchronized (diskEntry) {
            DiskId di = de.getDiskId();
            if (di == null) {
                return;
            }
            if (de.isRemovedFromDisk()) {
                return;
            }
            DiskId diskId = di;
            synchronized (diskId) {
                if (di.getOplogId() != this.getOplogId()) {
                    return;
                }
                userBits = di.getUserBits();
                oplogKeyId = di.getKeyId();
                valueOffset = di.getOffsetInOplog();
                valueLength = di.getValueLength();
                deKey = de.getKey();
                if (valueOffset < 0L) assert (EntryBits.isAnyInvalid(userBits) || EntryBits.isTombstone(userBits));
            }
            if (tag == null) {
                if (EntryBits.isWithVersions(userBits) && de.getVersionStamp() != null) {
                    tag = de.getVersionStamp().asVersionTag();
                } else if (de.getVersionStamp() != null) {
                    throw new AssertionError((Object)("No version bits on entry we're writing to the krf " + de));
                }
            }
        }
        if (logger.isTraceEnabled(LogMarker.PERSIST_WRITES)) {
            logger.trace(LogMarker.PERSIST_WRITES, "krf oplogId={} key={} oplogKeyId={} de={} vo={} vl={} diskRegionId={} version tag={}", (Object)this.oplogId, deKey, (Object)oplogKeyId, (Object)System.identityHashCode(de), (Object)valueOffset, (Object)valueLength, (Object)diskRegionId, tag);
        }
        byte[] keyBytes = EntryEventImpl.serialize(deKey);
        this.writeOneKeyEntryForKRF(keyBytes, userBits, valueLength, diskRegionId, oplogKeyId, valueOffset, tag);
    }

    private void writeOneKeyEntryForKRF(byte[] keyBytes, byte userBits, int valueLength, long diskRegionId, long oplogKeyId, long valueOffset, VersionHolder tag) throws IOException {
        if (this.getParent().isValidating()) {
            return;
        }
        if (!this.getParent().isOfflineCompacting()) {
            assert (this.krf.dos != null);
        } else if (this.krf.dos == null) {
            return;
        }
        DataSerializer.writeByteArray(keyBytes, this.krf.dos);
        this.krf.dos.writeByte(EntryBits.getPersistentBits(userBits));
        InternalDataSerializer.writeArrayLength(valueLength, this.krf.dos);
        DiskInitFile.writeDiskRegionID(this.krf.dos, diskRegionId);
        if (EntryBits.isWithVersions(userBits) && tag != null) {
            this.serializeVersionTag(tag, this.krf.dos);
        }
        InternalDataSerializer.writeVLOld(oplogKeyId, this.krf.dos);
        if (!EntryBits.isAnyInvalid(userBits) && !EntryBits.isTombstone(userBits)) {
            InternalDataSerializer.writeVLOld(valueOffset - this.krf.lastOffset, this.krf.dos);
            this.krf.lastOffset = valueOffset;
        }
        ++this.krf.keyNum;
    }

    public void krfFileCreate() throws IOException {
        assert (!this.getParent().isValidating());
        this.krf.f = new File(this.diskFile.getPath() + KRF_FILE_EXT);
        if (this.krf.f.exists()) {
            throw new IllegalStateException("krf file " + this.krf.f + " already exists.");
        }
        this.krf.fos = new FileOutputStream(this.krf.f);
        this.krf.bos = new BufferedOutputStream(this.krf.fos, 32768);
        this.krf.dos = new DataOutputStream(this.krf.bos);
        this.krf.dos.writeByte(92);
        this.krf.dos.write(OPLOG_TYPE.KRF.getBytes(), 0, OPLOG_TYPE.getLen());
        this.krf.dos.writeByte(21);
        this.krf.dos.writeByte(62);
        this.krf.dos.writeLong(this.getParent().getDiskStoreID().getLeastSignificantBits());
        this.krf.dos.writeLong(this.getParent().getDiskStoreID().getMostSignificantBits());
        this.krf.dos.writeByte(21);
        assert (this.gfversion != null);
        Version dataVersion = this.getDataVersionIfOld();
        if (dataVersion == null) {
            dataVersion = Version.CURRENT;
        }
        if (this.gfversion == dataVersion) {
            this.gfversion.writeOrdinal(this.krf.dos, false);
        } else {
            Version.TOKEN.writeOrdinal(this.krf.dos, false);
            this.krf.dos.writeByte(21);
            this.krf.dos.writeByte(91);
            this.gfversion.writeOrdinal(this.krf.dos, false);
            this.krf.dos.writeByte(21);
            this.krf.dos.writeByte(91);
            dataVersion.writeOrdinal(this.krf.dos, false);
        }
        this.krf.dos.writeByte(21);
        InternalDataSerializer.writeUnsignedVL(this.totalCount.get(), this.krf.dos);
        this.krf.dos.writeByte(21);
        Map<Long, AbstractDiskRegion> drMap = this.getParent().getAllDiskRegions();
        byte[] rvvBytes = this.serializeRVVs(drMap, false);
        this.krf.dos.write(rvvBytes);
        this.krf.dos.writeByte(21);
    }

    private void closeAndDeleteKrf() {
        try {
            if (this.krf.dos != null) {
                this.krf.dos.close();
                this.krf.dos = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.krf.bos != null) {
                this.krf.bos.close();
                this.krf.bos = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.krf.fos != null) {
                this.krf.fos.close();
                this.krf.fos = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.krf.f.exists()) {
            this.krf.f.delete();
        }
    }

    public void krfClose() {
        boolean allClosed = false;
        try {
            if (this.krf.fos == null) {
                return;
            }
            DataSerializer.writeByteArray(null, this.krf.dos);
            this.krf.dos.flush();
            this.krf.fos.getChannel().force(true);
            this.krf.dos.close();
            this.krf.dos = null;
            this.krf.bos.close();
            this.krf.bos = null;
            this.krf.fos.close();
            this.krf.fos = null;
            if (this.krf.keyNum == 0) {
                this.krf.f.delete();
                assert (!this.krf.f.exists());
            } else {
                this.getParent().getDiskInitFile().krfCreate(this.oplogId);
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.Oplog_CREATE_0_1_2, new Object[]{this.toString(), "krf", this.getParent().getName()}));
            }
            allClosed = true;
        }
        catch (IOException e) {
            if (this.getParent().getDiskAccessException() == null) {
                throw new DiskAccessException("Fail to close krf file " + this.krf.f, (Throwable)e, this.getParent());
            }
            logger.info("Fail to close krf file " + this.krf.f + ", but a DiskAccessException happened ealier", (Throwable)this.getParent().getDiskAccessException());
        }
        finally {
            if (!allClosed) {
                this.closeAndDeleteKrf();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void createKrf(boolean cancel) {
        if (cancel) {
            this.krfCreated.compareAndSet(false, true);
            return;
        }
        if (!this.couldHaveKrf()) {
            return;
        }
        this.getParent().acquireCompactorReadLock();
        try {
            block35: {
                if (!this.getParent().allowKrfCreation()) {
                    return;
                }
                this.lockCompactor();
                Object object = this.lock;
                // MONITORENTER : object
                this.lockedForKRFcreate = true;
                // MONITOREXIT : object
                object = this.krfCreated;
                // MONITORENTER : object
                if (this.krfCreated.get()) {
                    // MONITOREXIT : object
                    this.unlockCompactor();
                    return;
                }
                this.krfCreated.set(true);
                if (this.unrecoveredRegionCount.get() <= 0) break block35;
                // MONITOREXIT : object
                this.unlockCompactor();
                return;
            }
            int tlc = (int)this.totalLiveCount.get();
            if (tlc <= 0) {
                // MONITOREXIT : object
                this.unlockCompactor();
                return;
            }
            Collection<DiskRegionInfo> regions = this.regionMap.values();
            List<KRFEntry> sortedLiveEntries = this.getSortedLiveEntries(regions);
            if (sortedLiveEntries == null) {
                // MONITOREXIT : object
                this.unlockCompactor();
                return;
            }
            try {
                boolean krfCreateSuccess = false;
                try {
                    this.krfFileCreate();
                    for (KRFEntry ke : sortedLiveEntries) {
                        this.writeOneKeyEntryForKRF(ke);
                    }
                    this.krfClose();
                    krfCreateSuccess = true;
                    for (DiskRegionInfo dri : regions) {
                        dri.afterKrfCreated();
                    }
                    if (!LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) return;
                    CacheObserverHolder.getInstance().afterKrfCreated();
                    return;
                }
                catch (FileNotFoundException ex) {
                    throw new IllegalStateException("could not create krf " + this.krf.f, ex);
                }
                catch (IOException ex) {
                    throw new IllegalStateException("failed writing krf " + this.krf.f, ex);
                }
                finally {
                    if (!krfCreateSuccess) {
                        this.closeAndDeleteKrf();
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.unlockCompactor();
            }
        }
        finally {
            this.getParent().releaseCompactorReadLock();
        }
    }

    private File getKrfFile() {
        return new File(this.diskFile.getPath() + KRF_FILE_EXT);
    }

    public List<KRFEntry> getSortedLiveEntries(Collection<DiskRegionInfo> targetRegions) {
        int tlc = (int)this.totalLiveCount.get();
        if (tlc <= 0) {
            return null;
        }
        KRFEntry[] sortedLiveEntries = new KRFEntry[tlc];
        int idx = 0;
        for (DiskRegionInfo dri : targetRegions) {
            if (dri.getDiskRegion() == null) continue;
            idx = dri.addLiveEntriesToList(sortedLiveEntries, idx);
        }
        Arrays.sort(sortedLiveEntries, 0, idx, new Comparator<KRFEntry>(){

            @Override
            public int compare(KRFEntry o1, KRFEntry o2) {
                long val1 = o1.getOffsetInOplogForSorting();
                long val2 = o2.getOffsetInOplogForSorting();
                return Long.signum(val1 - val2);
            }
        });
        return Arrays.asList(sortedLiveEntries).subList(0, idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getBytesAndBitsForCompaction(DiskRegionView dr, DiskEntry entry, BytesAndBitsForCompactor wrapper) {
        DiskId did = entry.getDiskId();
        byte userBits = 0;
        long oplogOffset = did.getOffsetInOplog();
        ReferenceCountHelper.skipRefCountTracking();
        Object value = entry._getValueRetain(dr, true);
        ReferenceCountHelper.unskipRefCountTracking();
        boolean foundData = false;
        if (value == null) {
            foundData = this.basicGetForCompactor(dr, oplogOffset, false, did.getValueLength(), did.getUserBits(), wrapper);
            if (did.getOplogId() != this.getOplogId()) {
                return false;
            }
            assert (foundData) : "compactor get failed on oplog#" + this.getOplogId();
            userBits = wrapper.getBits();
            if (EntryBits.isAnyInvalid(userBits)) {
                if (EntryBits.isInvalid(userBits)) {
                    wrapper.setData(DiskEntry.INVALID_BYTES, userBits, DiskEntry.INVALID_BYTES.length, false);
                } else {
                    wrapper.setData(DiskEntry.LOCAL_INVALID_BYTES, userBits, DiskEntry.LOCAL_INVALID_BYTES.length, false);
                }
            } else if (EntryBits.isTombstone(userBits)) {
                wrapper.setData(DiskEntry.TOMBSTONE_BYTES, userBits, DiskEntry.TOMBSTONE_BYTES.length, false);
            }
            if (EntryBits.isWithVersions(did.getUserBits())) {
                userBits = EntryBits.setWithVersions(userBits, true);
            }
        } else {
            foundData = true;
            userBits = 0;
            if (EntryBits.isRecoveredFromDisk(did.getUserBits())) {
                userBits = EntryBits.setRecoveredFromDisk(userBits, true);
            }
            if (EntryBits.isWithVersions(did.getUserBits())) {
                userBits = EntryBits.setWithVersions(userBits, true);
            }
            if (value == Token.INVALID) {
                userBits = EntryBits.setInvalid(userBits, true);
                wrapper.setData(DiskEntry.INVALID_BYTES, userBits, DiskEntry.INVALID_BYTES.length, false);
            } else if (value == Token.LOCAL_INVALID) {
                userBits = EntryBits.setLocalInvalid(userBits, true);
                wrapper.setData(DiskEntry.LOCAL_INVALID_BYTES, userBits, DiskEntry.LOCAL_INVALID_BYTES.length, false);
            } else if (value == Token.TOMBSTONE) {
                userBits = EntryBits.setTombstone(userBits, true);
                wrapper.setData(DiskEntry.TOMBSTONE_BYTES, userBits, DiskEntry.TOMBSTONE_BYTES.length, false);
            } else if (value instanceof CachedDeserializable) {
                CachedDeserializable proxy = (CachedDeserializable)value;
                if (proxy instanceof StoredObject) {
                    StoredObject ohproxy = (StoredObject)proxy;
                    try {
                        ohproxy.fillSerializedValue(wrapper, userBits);
                    }
                    finally {
                        OffHeapHelper.releaseWithNoTracking(ohproxy);
                    }
                } else {
                    userBits = EntryBits.setSerialized(userBits, true);
                    proxy.fillSerializedValue(wrapper, userBits);
                }
            } else if (value instanceof byte[]) {
                byte[] valueBytes = (byte[])value;
                wrapper.setData(valueBytes, userBits, valueBytes.length, false);
            } else if (Token.isRemoved(value) && value != Token.TOMBSTONE) {
                if (entry.getDiskId().isPendingAsync()) {
                    entry.getDiskId().setPendingAsync(false);
                    try {
                        this.getOplogSet().getChild().basicRemove(dr, entry, false, false);
                    }
                    catch (IOException ex) {
                        this.getParent().getCancelCriterion().checkCancelInProgress(ex);
                        throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0.toLocalizedString(this.diskFile.getPath()), (Throwable)ex, dr.getName());
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.getParent().getCache().getCancelCriterion().checkCancelInProgress(ie);
                        throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0_DUE_TO_FAILURE_IN_ACQUIRING_READ_LOCK_FOR_ASYNCH_WRITING.toLocalizedString(this.diskFile.getPath()), (Throwable)ie, dr.getName());
                    }
                } else {
                    this.rmLive(dr, entry);
                }
                foundData = false;
            } else {
                userBits = EntryBits.setSerialized(userBits, true);
                EntryEventImpl.fillSerializedValue(wrapper, value, userBits);
            }
        }
        if (foundData) {
            entry.getDiskId().setPendingAsync(false);
        }
        return foundData;
    }

    public void modify(LocalRegion region, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, boolean async) {
        if (this.getOplogSet().getChild() != this) {
            this.getOplogSet().getChild().modify(region, entry, value, async);
        } else {
            DiskId did = entry.getDiskId();
            boolean exceptionOccurred = false;
            byte prevUsrBit = did.getUserBits();
            int len = did.getValueLength();
            try {
                byte userBits = this.calcUserBits(value);
                if (entry.getVersionStamp() != null) {
                    if (entry.getVersionStamp().getMemberID() == null) {
                        throw new AssertionError((Object)("Version stamp should have a member at this point for entry " + entry));
                    }
                    userBits = EntryBits.setWithVersions(userBits, true);
                }
                this.basicModify(region.getDiskRegion(), entry, value, userBits, async, false);
            }
            catch (IOException ex) {
                exceptionOccurred = true;
                region.getCancelCriterion().checkCancelInProgress(ex);
                throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0.toLocalizedString(this.diskFile.getPath()), (Throwable)ex, region.getFullPath());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                exceptionOccurred = true;
                region.getCancelCriterion().checkCancelInProgress(ie);
                throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0_DUE_TO_FAILURE_IN_ACQUIRING_READ_LOCK_FOR_ASYNCH_WRITING.toLocalizedString(this.diskFile.getPath()), (Throwable)ie, region.getFullPath());
            }
            finally {
                if (exceptionOccurred) {
                    did.setValueLength(len);
                    did.setUserBits(prevUsrBit);
                }
            }
        }
    }

    public void offlineModify(DiskRegionView drv, DiskEntry entry, byte[] value, boolean isSerializedObject) {
        try {
            DiskEntry.Helper.ByteArrayValueWrapper vw = new DiskEntry.Helper.ByteArrayValueWrapper(isSerializedObject, value);
            byte userBits = this.calcUserBits(vw);
            VersionStamp vs = entry.getVersionStamp();
            if (vs != null) {
                if (vs.getMemberID() == null) {
                    throw new AssertionError((Object)("Version stamp should have a member at this point for entry " + entry));
                }
                vs.setMemberID(this.getParent().getDiskStoreID());
                VersionTag vt = vs.asVersionTag();
                vt.setRegionVersion(drv.getRegionVersionVector().getNextVersion());
                vt.setEntryVersion(vt.getEntryVersion() + 1);
                vt.setVersionTimeStamp(System.currentTimeMillis());
                vs.setVersions(vt);
                userBits = EntryBits.setWithVersions(userBits, true);
            }
            this.basicModify(drv, entry, vw, userBits, false, false);
        }
        catch (IOException ex) {
            throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0.toLocalizedString(this.diskFile.getPath()), (Throwable)ex, drv.getName());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0_DUE_TO_FAILURE_IN_ACQUIRING_READ_LOCK_FOR_ASYNCH_WRITING.toLocalizedString(this.diskFile.getPath()), (Throwable)ie, drv.getName());
        }
    }

    public void saveConflictVersionTag(LocalRegion region, VersionTag tag, boolean async) {
        if (this.getOplogSet().getChild() != this) {
            this.getOplogSet().getChild().saveConflictVersionTag(region, tag, async);
        } else {
            try {
                this.basicSaveConflictVersionTag(region.getDiskRegion(), tag, async);
            }
            catch (IOException ex) {
                region.getCancelCriterion().checkCancelInProgress(ex);
                throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_CONFLICT_VERSION_TAG_0.toLocalizedString(this.diskFile.getPath()), (Throwable)ex, region.getFullPath());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                region.getCancelCriterion().checkCancelInProgress(ie);
                throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_CONFLICT_VERSION_TAG_0.toLocalizedString(this.diskFile.getPath()), (Throwable)ie, region.getFullPath());
            }
        }
    }

    private void copyForwardForOfflineCompact(long oplogKeyId, byte[] keyBytes, byte[] valueBytes, byte userBits, long drId, VersionTag tag) {
        try {
            this.basicCopyForwardForOfflineCompact(oplogKeyId, keyBytes, valueBytes, userBits, drId, tag);
        }
        catch (IOException ex) {
            this.getParent().getCancelCriterion().checkCancelInProgress(ex);
            throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0.toLocalizedString(this.diskFile.getPath()), (Throwable)ex, this.getParent());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            this.getParent().getCancelCriterion().checkCancelInProgress(ie);
            throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0_DUE_TO_FAILURE_IN_ACQUIRING_READ_LOCK_FOR_ASYNCH_WRITING.toLocalizedString(this.diskFile.getPath()), (Throwable)ie, this.getParent());
        }
    }

    private void copyForwardModifyForCompact(DiskRegionView dr, DiskEntry entry, BytesAndBitsForCompactor wrapper) {
        if (this.getOplogSet().getChild() != this) {
            this.getOplogSet().getChild().copyForwardModifyForCompact(dr, entry, wrapper);
        } else {
            DiskId did = entry.getDiskId();
            boolean exceptionOccurred = false;
            int len = did.getValueLength();
            try {
                byte userBits = wrapper.getBits();
                DiskEntry.Helper.ValueWrapper vw = wrapper.getOffHeapData() != null ? new DiskEntry.Helper.OffHeapValueWrapper(wrapper.getOffHeapData()) : new DiskEntry.Helper.CompactorValueWrapper(wrapper.getBytes(), wrapper.getValidLength());
                this.basicModify(dr, entry, vw, userBits, true, true);
            }
            catch (IOException ex) {
                exceptionOccurred = true;
                this.getParent().getCancelCriterion().checkCancelInProgress(ex);
                throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0.toLocalizedString(this.diskFile.getPath()), (Throwable)ex, this.getParent());
            }
            catch (InterruptedException ie) {
                exceptionOccurred = true;
                Thread.currentThread().interrupt();
                this.getParent().getCancelCriterion().checkCancelInProgress(ie);
                throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0_DUE_TO_FAILURE_IN_ACQUIRING_READ_LOCK_FOR_ASYNCH_WRITING.toLocalizedString(this.diskFile.getPath()), (Throwable)ie, this.getParent());
            }
            finally {
                if (wrapper.getOffHeapData() != null) {
                    wrapper.setOffHeapData(null, (byte)0);
                }
                if (exceptionOccurred) {
                    did.setValueLength(len);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicModify(DiskRegionView dr, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, byte userBits, boolean async, boolean calledByCompactor) throws IOException, InterruptedException {
        DiskId id = entry.getDiskId();
        boolean useNextOplog = false;
        long startPosForSynchOp = -1L;
        int adjustment = 0;
        Oplog emptyOplog = null;
        if (DiskStoreImpl.KRF_DEBUG) {
            System.out.println("basicModify KRF_DEBUG");
            Thread.sleep(1000L);
        }
        this.getParent().getBackupLock().lock();
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.getOplogSet().getChild() != this) {
                    useNextOplog = true;
                } else {
                    this.initOpState((byte)65, dr, entry, value, userBits, false);
                    adjustment = this.getOpStateSize();
                    assert (adjustment > 0);
                    long temp = this.crf.currSize + (long)adjustment;
                    if (temp > this.getMaxCrfSize() && !this.isFirstRecord()) {
                        this.switchOpLog(dr, adjustment, entry);
                        useNextOplog = true;
                    } else {
                        long oldOplogId;
                        Object tag;
                        if (this.lockedForKRFcreate) {
                            CacheClosedException cce = new CacheClosedException("The disk store is closed.");
                            dr.getCancelCriterion().checkCancelInProgress(cce);
                            throw cce;
                        }
                        this.firstRecord = false;
                        startPosForSynchOp = this.writeOpLogBytes(this.crf, async, true);
                        this.crf.currSize = temp;
                        startPosForSynchOp += (long)this.getOpStateValueOffset();
                        if (logger.isTraceEnabled(LogMarker.PERSIST_WRITES)) {
                            tag = null;
                            if (entry.getVersionStamp() != null) {
                                tag = entry.getVersionStamp().asVersionTag();
                            }
                            logger.trace(LogMarker.PERSIST_WRITES, "basicModify: id=<{}> key=<{}> valueOffset={} userBits={} valueLen={} valueBytes=<{}> drId={} versionStamp={} oplog#{}", (Object)Oplog.abs(id.getKeyId()), entry.getKey(), (Object)startPosForSynchOp, (Object)userBits, (Object)value.getLength(), (Object)value.getBytesAsString(), (Object)dr.getId(), tag, (Object)this.getOplogId());
                        }
                        if (EntryBits.isNeedsValue(userBits)) {
                            id.setValueLength(value.getLength());
                        } else {
                            id.setValueLength(0);
                        }
                        id.setUserBits(userBits);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Oplog::basicModify:Released ByteBuffer with data for Disk ID = {}", (Object)id);
                        }
                        tag = id;
                        synchronized (tag) {
                            oldOplogId = id.setOplogId(this.getOplogId());
                            if (EntryBits.isAnyInvalid(userBits) || EntryBits.isTombstone(userBits)) {
                                id.setOffsetInOplog(-1L);
                            } else {
                                id.setOffsetInOplog(startPosForSynchOp);
                            }
                        }
                        this.dirHolder.incrementTotalOplogSize(adjustment);
                        this.incTotalCount();
                        EntryLogger.logPersistPut(dr.getName(), entry.getKey(), dr.getDiskStoreID());
                        if (oldOplogId != this.getOplogId()) {
                            Oplog oldOplog = this.getOplogSet().getChild(oldOplogId);
                            if (oldOplog != null) {
                                oldOplog.rmLive(dr, entry);
                                emptyOplog = oldOplog;
                            }
                            this.addLive(dr, entry);
                        } else {
                            this.getOrCreateDRI(dr).update(entry);
                        }
                        RegionVersionVector rvv = dr.getRegionVersionVector();
                        if (rvv != null && entry.getVersionStamp() != null) {
                            rvv.recordVersion(entry.getVersionStamp().getMemberID(), entry.getVersionStamp().getRegionVersion());
                        }
                    }
                    this.clearOpState();
                }
            }
        }
        finally {
            this.getParent().getBackupLock().unlock();
        }
        if (useNextOplog) {
            if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                CacheObserverHolder.getInstance().afterSwitchingOplog();
            }
            Assert.assertTrue(this.getOplogSet().getChild() != this);
            this.getOplogSet().getChild().basicModify(dr, entry, value, userBits, async, calledByCompactor);
        } else {
            if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                CacheObserverHolder.getInstance().afterSettingOplogOffSet(startPosForSynchOp);
            }
            if (emptyOplog != null && (!super.isCompacting() || emptyOplog.calledByCompactorThread())) {
                if (calledByCompactor && emptyOplog.hasNoLiveValues()) {
                    this.flushAll(true);
                }
                emptyOplog.handleNoLiveValues();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicSaveConflictVersionTag(DiskRegionView dr, VersionTag tag, boolean async) throws IOException, InterruptedException {
        boolean useNextOplog = false;
        int adjustment = 0;
        this.getParent().getBackupLock().lock();
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.getOplogSet().getChild() != this) {
                    useNextOplog = true;
                } else {
                    this.opState.initialize((byte)90, dr.getId(), tag);
                    adjustment = this.getOpStateSize();
                    assert (adjustment > 0);
                    long temp = this.crf.currSize + (long)adjustment;
                    if (temp > this.getMaxCrfSize() && !this.isFirstRecord()) {
                        this.switchOpLog(dr, adjustment, null);
                        useNextOplog = true;
                    } else {
                        if (this.lockedForKRFcreate) {
                            CacheClosedException cce = new CacheClosedException("The disk store is closed.");
                            dr.getCancelCriterion().checkCancelInProgress(cce);
                            throw cce;
                        }
                        this.firstRecord = false;
                        this.writeOpLogBytes(this.crf, async, true);
                        this.crf.currSize = temp;
                        if (logger.isTraceEnabled(LogMarker.PERSIST_WRITES)) {
                            logger.trace(LogMarker.PERSIST_WRITES, "basicSaveConflictVersionTag: drId={} versionStamp={} oplog#{}", (Object)dr.getId(), (Object)tag, (Object)this.getOplogId());
                        }
                        this.dirHolder.incrementTotalOplogSize(adjustment);
                        RegionVersionVector rvv = dr.getRegionVersionVector();
                        if (rvv != null && dr.getFlags().contains((Object)DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING)) {
                            rvv.recordVersion(tag.getMemberID(), tag.getRegionVersion());
                        }
                    }
                    this.clearOpState();
                }
            }
        }
        finally {
            this.getParent().getBackupLock().unlock();
        }
        if (useNextOplog) {
            if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                CacheObserverHolder.getInstance().afterSwitchingOplog();
            }
            Assert.assertTrue(this.getOplogSet().getChild() != this);
            this.getOplogSet().getChild().basicSaveConflictVersionTag(dr, tag, async);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicCopyForwardForOfflineCompact(long oplogKeyId, byte[] keyBytes, byte[] valueBytes, byte userBits, long drId, VersionTag tag) throws IOException, InterruptedException {
        boolean useNextOplog = false;
        long startPosForSynchOp = -1L;
        int adjustment = 0;
        Object object = this.lock;
        synchronized (object) {
            if (this.getOplogSet().getChild() != this) {
                useNextOplog = true;
            } else {
                this.opState.initialize(oplogKeyId, keyBytes, valueBytes, userBits, drId, tag, false);
                adjustment = this.getOpStateSize();
                assert (adjustment > 0);
                long temp = this.crf.currSize + (long)adjustment;
                if (temp > this.getMaxCrfSize() && !this.isFirstRecord()) {
                    this.switchOpLog(null, adjustment, null);
                    useNextOplog = true;
                } else {
                    this.firstRecord = false;
                    startPosForSynchOp = this.writeOpLogBytes(this.crf, true, true);
                    this.crf.currSize = temp;
                    this.getOplogSet().getChild().writeOneKeyEntryForKRF(keyBytes, userBits, valueBytes.length, drId, oplogKeyId, startPosForSynchOp += (long)this.getOpStateValueOffset(), tag);
                    if (logger.isTraceEnabled(LogMarker.PERSIST_WRITES)) {
                        logger.trace(LogMarker.PERSIST_WRITES, "basicCopyForwardForOfflineCompact: id=<{}> keyBytes=<{}> valueOffset={} userBits={} valueLen={} valueBytes=<{}> drId={} oplog#{}", (Object)oplogKeyId, (Object)Oplog.baToString(keyBytes), (Object)startPosForSynchOp, (Object)userBits, (Object)valueBytes.length, (Object)Oplog.baToString(valueBytes), (Object)drId, (Object)this.getOplogId());
                    }
                    this.dirHolder.incrementTotalOplogSize(adjustment);
                    this.incTotalCount();
                }
                this.clearOpState();
            }
        }
        if (useNextOplog) {
            if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                CacheObserverHolder.getInstance().afterSwitchingOplog();
            }
            Assert.assertTrue(this.getOplogSet().getChild() != this);
            this.getOplogSet().getChild().basicCopyForwardForOfflineCompact(oplogKeyId, keyBytes, valueBytes, userBits, drId, tag);
        }
    }

    private boolean isCompacting() {
        return this.compacting;
    }

    private void addLive(DiskRegionView dr, DiskEntry de) {
        this.getOrCreateDRI(dr).addLive(de);
        this.incLiveCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rmLive(DiskRegionView dr, DiskEntry de) {
        DiskRegionInfo dri;
        DiskRegionInfo diskRegionInfo = dri = this.getOrCreateDRI(dr);
        synchronized (diskRegionInfo) {
            dri.rmLive(de, this);
        }
    }

    private DiskRegionInfo getDRI(long drId) {
        return (DiskRegionInfo)this.regionMap.get(drId);
    }

    private DiskRegionInfo getDRI(DiskRegionView dr) {
        return this.getDRI(dr.getId());
    }

    private DiskRegionInfo getOrCreateDRI(DiskRegionView dr) {
        DiskRegionInfo dri = this.getDRI(dr);
        if (dri == null) {
            dri = this.isCompactionPossible() || this.couldHaveKrf() ? new DiskRegionInfoWithList(dr, this.couldHaveKrf(), this.krfCreated.get()) : new DiskRegionInfoNoList(dr);
            DiskRegionInfo oldDri = this.regionMap.putIfAbsent(dr.getId(), dri);
            if (oldDri != null) {
                dri = oldDri;
            }
        }
        return dri;
    }

    public boolean needsKrf() {
        return this.couldHaveKrf() && !this.krfCreated.get();
    }

    private boolean couldHaveKrf() {
        return this.getOplogSet().couldHaveKrf();
    }

    private DiskRegionInfo getOrCreateDRI(long drId) {
        DiskRegionInfo dri = this.getDRI(drId);
        if (dri == null) {
            dri = this.isCompactionPossible() || this.couldHaveKrf() ? new DiskRegionInfoWithList(null, this.couldHaveKrf(), this.krfCreated.get()) : new DiskRegionInfoNoList(null);
            DiskRegionInfo oldDri = this.regionMap.putIfAbsent(drId, dri);
            if (oldDri != null) {
                dri = oldDri;
            }
        }
        return dri;
    }

    public void remove(LocalRegion region, DiskEntry entry, boolean async, boolean isClear) {
        DiskRegion dr = region.getDiskRegion();
        if (this.getOplogSet().getChild() != this) {
            this.getOplogSet().getChild().remove(region, entry, async, isClear);
        } else {
            DiskId did = entry.getDiskId();
            boolean exceptionOccurred = false;
            byte prevUsrBit = did.getUserBits();
            int len = did.getValueLength();
            try {
                this.basicRemove(dr, entry, async, isClear);
            }
            catch (IOException ex) {
                exceptionOccurred = true;
                this.getParent().getCancelCriterion().checkCancelInProgress(ex);
                throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0.toLocalizedString(this.diskFile.getPath()), (Throwable)ex, dr.getName());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                region.getCancelCriterion().checkCancelInProgress(ie);
                exceptionOccurred = true;
                throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0_DUE_TO_FAILURE_IN_ACQUIRING_READ_LOCK_FOR_ASYNCH_WRITING.toLocalizedString(this.diskFile.getPath()), (Throwable)ie, dr.getName());
            }
            finally {
                if (exceptionOccurred) {
                    did.setValueLength(len);
                    did.setUserBits(prevUsrBit);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGCRVV(DiskRegion dr) {
        boolean useNextOplog = false;
        this.getParent().getBackupLock().lock();
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.getOplogSet().getChild() != this) {
                    useNextOplog = true;
                } else {
                    try {
                        this.writeRVVRecord(this.drf, Collections.singletonMap(dr.getId(), dr), true);
                    }
                    catch (IOException ex) {
                        dr.getCancelCriterion().checkCancelInProgress(ex);
                        throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_RECORDING_RVV_BECAUSE_OF_0.toLocalizedString(this.diskFile.getPath()), (Throwable)ex, dr.getName());
                    }
                }
            }
        }
        finally {
            this.getParent().getBackupLock().unlock();
        }
        if (useNextOplog) {
            this.getOplogSet().getChild().writeGCRVV(dr);
        } else {
            DiskStoreObserver.endWriteGCRVV(dr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeRVV(DiskRegion dr, RegionVersionVector sourceRVV, Boolean isRVVTrusted) {
        boolean useNextOplog;
        block14: {
            useNextOplog = false;
            this.getParent().getBackupLock().lock();
            try {
                Object object = this.lock;
                synchronized (object) {
                    block15: {
                        if (this.getOplogSet().getChild() == this) break block15;
                        useNextOplog = true;
                        break block14;
                    }
                    try {
                        if (sourceRVV != null) {
                            dr.getRegionVersionVector().recordVersions(sourceRVV);
                        } else if (dr.getRVVTrusted()) {
                            return;
                        }
                    }
                    catch (IOException ex) {
                        dr.getCancelCriterion().checkCancelInProgress(ex);
                        throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_RECORDING_RVV_BECAUSE_OF_0.toLocalizedString(this.diskFile.getPath()), (Throwable)ex, dr.getName());
                    }
                    {
                        if (isRVVTrusted != null) {
                            dr.setRVVTrusted(isRVVTrusted);
                        }
                        this.writeRVVRecord(this.crf, Collections.singletonMap(dr.getId(), dr), false);
                    }
                }
            }
            finally {
                this.getParent().getBackupLock().unlock();
            }
        }
        if (!useNextOplog) return;
        this.getOplogSet().getChild().writeRVV(dr, sourceRVV, isRVVTrusted);
    }

    private long getMaxCrfSize() {
        return this.maxCrfSize;
    }

    private long getMaxDrfSize() {
        return this.maxDrfSize;
    }

    private void setMaxCrfDrfSize() {
        int crfPct = Integer.getInteger("gemfire.CRF_MAX_PERCENTAGE", 90);
        if (crfPct > 100 || crfPct < 0) {
            crfPct = 90;
        }
        this.maxCrfSize = (long)((double)this.maxOplogSize * ((double)crfPct / 100.0));
        this.maxDrfSize = this.maxOplogSize - this.maxCrfSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicRemove(DiskRegionView dr, DiskEntry entry, boolean async, boolean isClear) throws IOException, InterruptedException {
        DiskId id = entry.getDiskId();
        boolean useNextOplog = false;
        long startPosForSynchOp = -1L;
        Oplog emptyOplog = null;
        if (DiskStoreImpl.KRF_DEBUG) {
            System.out.println("basicRemove KRF_DEBUG");
            Thread.sleep(1000L);
        }
        this.getParent().getBackupLock().lock();
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.getOplogSet().getChild() != this) {
                    useNextOplog = true;
                } else if (this.drf.currSize + 10L > this.getMaxDrfSize() && !this.isFirstRecord()) {
                    this.switchOpLog(dr, 10, entry);
                    useNextOplog = true;
                } else {
                    if (this.lockedForKRFcreate) {
                        CacheClosedException cce = new CacheClosedException("The disk store is closed.");
                        dr.getCancelCriterion().checkCancelInProgress(cce);
                        throw cce;
                    }
                    long oldOplogId = id.setOplogId(this.getOplogId());
                    if (!isClear) {
                        this.firstRecord = false;
                        this.initOpState((byte)81, dr, entry, null, (byte)0, true);
                        int adjustment = this.getOpStateSize();
                        this.drf.currSize += (long)adjustment;
                        if (logger.isTraceEnabled()) {
                            logger.trace("Oplog::basicRemove: Recording the Deletion of entry in the Oplog with id = {} The Oplog Disk ID for the entry being deleted = {} Mode is Synch", (Object)this.getOplogId(), (Object)id);
                        }
                        startPosForSynchOp = this.writeOpLogBytes(this.drf, async, true);
                        this.setHasDeletes(true);
                        if (logger.isDebugEnabled(LogMarker.PERSIST_WRITES)) {
                            logger.debug("basicRemove: id=<{}> key=<{}> drId={} oplog#{}", (Object)Oplog.abs(id.getKeyId()), entry.getKey(), (Object)dr.getId(), (Object)this.getOplogId());
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace("Oplog::basicRemove:Released ByteBuffer for Disk ID = {}", (Object)id);
                        }
                        this.dirHolder.incrementTotalOplogSize(adjustment);
                    }
                    id.setOffsetInOplog(-1L);
                    EntryLogger.logPersistDestroy(dr.getName(), entry.getKey(), dr.getDiskStoreID());
                    Oplog rmOplog = null;
                    rmOplog = oldOplogId == this.getOplogId() ? this : this.getOplogSet().getChild(oldOplogId);
                    if (rmOplog != null) {
                        rmOplog.rmLive(dr, entry);
                        emptyOplog = rmOplog;
                    }
                    this.clearOpState();
                }
            }
        }
        finally {
            this.getParent().getBackupLock().unlock();
        }
        if (useNextOplog) {
            if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                CacheObserverHolder.getInstance().afterSwitchingOplog();
            }
            Assert.assertTrue(this.getOplogSet().getChild() != this);
            this.getOplogSet().getChild().basicRemove(dr, entry, async, isClear);
        } else {
            if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                CacheObserverHolder.getInstance().afterSettingOplogOffSet(startPosForSynchOp);
            }
            if (emptyOplog != null && (!super.isCompacting() || emptyOplog.calledByCompactorThread())) {
                emptyOplog.handleNoLiveValues();
            }
        }
    }

    ByteBuffer getWriteBuf() {
        return this.crf.writeBuf;
    }

    private void flushNoSync(OplogFile olf) throws IOException {
        this.flushAllNoSync(false);
    }

    @Override
    public void flush() throws IOException {
        this.flushAllNoSync(false);
    }

    @Override
    public void flush(ByteBuffer b1, ByteBuffer b2) throws IOException {
        if (b1 == this.drf.writeBuf) {
            this.flush(this.drf, b1, b2);
            this.flush(this.crf, false);
        } else {
            this.flush(this.drf, false);
            this.flush(this.crf, b1, b2);
        }
    }

    private void flushAndSync(OplogFile olf) throws IOException {
        this.flushAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(OplogFile olf, boolean doSync) throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (olf.RAFClosed) {
                    return;
                }
                ByteBuffer bb = olf.writeBuf;
                if (bb != null && bb.position() != 0) {
                    bb.flip();
                    int flushed = 0;
                    int numChannelRetries = 0;
                    do {
                        int channelBytesWritten = 0;
                        int bbStartPos = bb.position();
                        long channelStartPos = olf.channel.position();
                        channelBytesWritten = olf.channel.write(bb);
                        if (channelBytesWritten != bb.position() - bbStartPos) {
                            if (numChannelRetries++ < 5) {
                                channelBytesWritten = (int)(olf.channel.position() - channelStartPos);
                                bb.position(bbStartPos + channelBytesWritten);
                            } else {
                                throw new IOException("Failed to write Oplog entry to" + olf.f.getName() + ": channel.write() returned " + channelBytesWritten + ", change in channel position = " + (olf.channel.position() - channelStartPos) + ", change in source buffer position = " + (bb.position() - bbStartPos));
                            }
                        }
                        flushed += channelBytesWritten;
                    } while (bb.hasRemaining());
                    olf.bytesFlushed += (long)flushed;
                    bb.clear();
                }
                if (doSync && SYNC_WRITES) {
                    olf.channel.force(true);
                }
            }
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(OplogFile olf, ByteBuffer b1, ByteBuffer b2) throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (olf.RAFClosed) {
                    return;
                }
                this.bbArray[0] = b1;
                this.bbArray[1] = b2;
                b1.flip();
                long flushed = 0L;
                do {
                    flushed += olf.channel.write(this.bbArray);
                } while (b2.hasRemaining());
                this.bbArray[0] = null;
                this.bbArray[1] = null;
                olf.bytesFlushed += flushed;
                b1.clear();
            }
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    public void flushAll() {
        this.flushAll(false);
    }

    public void flushAllNoSync(boolean skipDrf) {
        this.flushAll(skipDrf, false);
    }

    public void flushAll(boolean skipDrf) {
        this.flushAll(skipDrf, true);
    }

    public void flushAll(boolean skipDrf, boolean doSync) {
        try {
            this.flush(this.drf, doSync);
            this.flush(this.crf, doSync);
        }
        catch (IOException ex) {
            this.getParent().getCancelCriterion().checkCancelInProgress(ex);
            throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_WRITING_KEY_TO_0.toLocalizedString(this.diskFile.getPath()), (Throwable)ex, this.getParent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeOpLogBytes(OplogFile olf, boolean async, boolean doFlushIfSync) throws IOException {
        long startPos = -1L;
        this.getParent().getBackupLock().lock();
        try {
            Object object = this.lock;
            synchronized (object) {
                Assert.assertTrue(!this.doneAppending);
                if (this.closed) {
                    Assert.assertTrue(false, "The Oplog " + this.oplogId + " for store " + this.getParent().getName() + " has been closed for synch mode while writing is going on. This should not happen");
                }
                startPos = olf.channel.position() + (long)olf.writeBuf.position();
                long bytesWritten = this.opState.write(olf);
                if (!async && doFlushIfSync) {
                    this.flushAndSync(olf);
                }
                this.getStats().incWrittenBytes(bytesWritten, async);
            }
        }
        finally {
            this.getParent().getBackupLock().unlock();
        }
        return startPos;
    }

    boolean isRAFOpen() {
        return !this.crf.RAFClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean closeRAF() {
        if (this.beingRead) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.beingRead) {
                return false;
            }
            if (!this.doneAppending) {
                return false;
            }
            if (this.crf.RAFClosed) {
                return false;
            }
            try {
                this.crf.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.crf.RAFClosed = true;
            this.okToReopen = true;
            this.stats.decOpenOplogs();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reopenFileIfClosed() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean result;
            boolean bl = result = !this.crf.RAFClosed;
            if (!result && this.okToReopen) {
                result = true;
                this.crf.raf = new UninterruptibleRandomAccessFile(this.crf.f, "r");
                this.stats.incOpenOplogs();
                this.crf.RAFClosed = false;
                this.okToReopen = false;
            }
            return result;
        }
    }

    /*
     * Exception decompiling
     */
    private BytesAndBits attemptGet(DiskRegionView dr, long offsetInOplog, boolean bitOnly, int valueLength, byte userBits) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BytesAndBits basicGet(DiskRegionView dr, long offsetInOplog, boolean bitOnly, int valueLength, byte userBits) {
        BytesAndBits bb = null;
        if (EntryBits.isAnyInvalid(userBits) || EntryBits.isTombstone(userBits) || bitOnly || valueLength == 0) {
            bb = EntryBits.isInvalid(userBits) ? new BytesAndBits(DiskEntry.INVALID_BYTES, userBits) : (EntryBits.isTombstone(userBits) ? new BytesAndBits(DiskEntry.TOMBSTONE_BYTES, userBits) : new BytesAndBits(DiskEntry.LOCAL_INVALID_BYTES, userBits));
        } else {
            if (offsetInOplog == -1L) {
                return null;
            }
            try {
                while (true) {
                    dr.getCancelCriterion().checkCancelInProgress(null);
                    boolean interrupted = Thread.interrupted();
                    try {
                        bb = this.attemptGet(dr, offsetInOplog, bitOnly, valueLength, userBits);
                        break;
                    }
                    catch (InterruptedIOException interruptedIOException) {}
                    continue;
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ex) {
                this.getParent().getCancelCriterion().checkCancelInProgress(ex);
                throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_READING_FROM_0_OPLOGID_1_OFFSET_BEING_READ_2_CURRENT_OPLOG_SIZE_3_ACTUAL_FILE_SIZE_4_IS_ASYNCH_MODE_5_IS_ASYNCH_WRITER_ALIVE_6.toLocalizedString(this.diskFile.getPath(), this.oplogId, offsetInOplog, this.crf.currSize, this.crf.bytesFlushed, !dr.isSync(), Boolean.FALSE), (Throwable)ex, dr.getName());
            }
            catch (IllegalStateException ex) {
                this.checkClosed();
                throw ex;
            }
        }
        return bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean basicGetForCompactor(DiskRegionView dr, long offsetInOplog, boolean bitOnly, int valueLength, byte userBits, BytesAndBitsForCompactor wrapper) {
        if (EntryBits.isAnyInvalid(userBits) || EntryBits.isTombstone(userBits) || bitOnly || valueLength == 0) {
            if (EntryBits.isInvalid(userBits)) {
                wrapper.setData(DiskEntry.INVALID_BYTES, userBits, DiskEntry.INVALID_BYTES.length, false);
            } else if (EntryBits.isTombstone(userBits)) {
                wrapper.setData(DiskEntry.TOMBSTONE_BYTES, userBits, DiskEntry.TOMBSTONE_BYTES.length, false);
            } else {
                wrapper.setData(DiskEntry.LOCAL_INVALID_BYTES, userBits, DiskEntry.LOCAL_INVALID_BYTES.length, false);
            }
        } else {
            try {
                Object object = this.lock;
                synchronized (object) {
                    long writePosition;
                    if (offsetInOplog + (long)valueLength > this.crf.bytesFlushed && !this.closed) {
                        this.flushAllNoSync(true);
                    }
                    if (!this.reopenFileIfClosed()) {
                        return false;
                    }
                    long l = writePosition = this.doneAppending ? this.crf.bytesFlushed : this.crf.raf.getFilePointer();
                    if (offsetInOplog + (long)valueLength > writePosition) {
                        throw new DiskAccessException(LocalizedStrings.Oplog_TRIED_TO_SEEK_TO_0_BUT_THE_FILE_LENGTH_IS_1_OPLOG_FILE_OBJECT_USED_FOR_READING_2.toLocalizedString(offsetInOplog + (long)valueLength, writePosition, this.crf.raf), dr.getName());
                    }
                    if (offsetInOplog < 0L) {
                        throw new DiskAccessException(LocalizedStrings.Oplog_CANNOT_FIND_RECORD_0_WHEN_READING_FROM_1.toLocalizedString(offsetInOplog, this.diskFile.getPath()), dr.getName());
                    }
                    try {
                        this.crf.raf.seek(offsetInOplog);
                        this.stats.incOplogSeeks();
                        byte[] valueBytes = null;
                        if (wrapper.getBytes().length < valueLength) {
                            valueBytes = new byte[valueLength];
                            this.crf.raf.readFully(valueBytes);
                        } else {
                            valueBytes = wrapper.getBytes();
                            this.crf.raf.readFully(valueBytes, 0, valueLength);
                        }
                        this.stats.incOplogReads();
                        wrapper.setData(valueBytes, userBits, valueLength, true);
                    }
                    finally {
                        if (!this.doneAppending) {
                            this.crf.raf.seek(writePosition);
                            this.stats.incOplogSeeks();
                        }
                    }
                }
            }
            catch (IOException ex) {
                this.getParent().getCancelCriterion().checkCancelInProgress(ex);
                throw new DiskAccessException(LocalizedStrings.Oplog_FAILED_READING_FROM_0_OPLOG_DETAILS_1_2_3_4_5_6.toLocalizedString(this.diskFile.getPath(), this.oplogId, offsetInOplog, this.crf.currSize, this.crf.bytesFlushed, Boolean.FALSE, Boolean.FALSE), (Throwable)ex, dr.getName());
            }
            catch (IllegalStateException ex) {
                this.checkClosed();
                throw ex;
            }
        }
        return true;
    }

    void deleteFiles(boolean crfOnly) {
        boolean needsDestroy = this.deleted.compareAndSet(false, true);
        if (needsDestroy) {
            this.deleteCRF();
            if (!crfOnly || !this.getHasDeletes()) {
                this.setHasDeletes(false);
                this.deleteDRF();
            }
            boolean addToDrfOnly = crfOnly && this.getHasDeletes();
            this.getOplogSet().removeOplog(this.getOplogId(), true, addToDrfOnly ? this : null);
        } else if (!crfOnly && this.getHasDeletes()) {
            this.setHasDeletes(false);
            this.deleteDRF();
            this.getOplogSet().removeDrf(this);
        }
    }

    public void deleteCRF() {
        this.oplogSet.crfDelete(this.oplogId);
        BackupManager backupManager = this.getInternalCache().getBackupManager();
        DiskStoreBackup inProgressBackup = this.getParent().getInProgressBackup();
        if (inProgressBackup == null || !inProgressBackup.deferCrfDelete(this)) {
            this.deleteCRFFileOnly();
        }
    }

    public void deleteCRFFileOnly() {
        this.deleteFile(this.crf);
        if (this.crf.f != null) {
            final File krf = new File(this.crf.f.getAbsolutePath().replaceFirst("\\.crf$", KRF_FILE_EXT));
            if (!krf.exists()) {
                return;
            }
            this.getParent().executeDelayedExpensiveWrite(new Runnable(){

                @Override
                public void run() {
                    if (!krf.delete()) {
                        if (krf.exists()) {
                            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.Oplog_DELETE_FAIL_0_1_2, new Object[]{Oplog.this.toString(), "krf", Oplog.this.getParent().getName()}));
                        }
                    } else {
                        logger.info((Message)LocalizedMessage.create(LocalizedStrings.Oplog_DELETE_0_1_2, new Object[]{Oplog.this.toString(), "krf", Oplog.this.getParent().getName()}));
                    }
                }
            });
        }
    }

    public void deleteDRF() {
        this.getOplogSet().drfDelete(this.oplogId);
        DiskStoreBackup inProgressBackup = this.getParent().getInProgressBackup();
        if (inProgressBackup == null || !inProgressBackup.deferDrfDelete(this)) {
            this.deleteDRFFileOnly();
        }
    }

    public void deleteDRFFileOnly() {
        this.deleteFile(this.drf);
    }

    public void copyTo(File targetDir) throws IOException {
        if (this.crf.f != null && this.crf.f.exists()) {
            FileUtils.copyFileToDirectory((File)this.crf.f, (File)targetDir);
        }
        if (this.drf.f.exists()) {
            FileUtils.copyFileToDirectory((File)this.drf.f, (File)targetDir);
        }
        if (this.getParent().getDiskInitFile().hasKrf(this.oplogId) && this.getKrfFile().exists()) {
            FileUtils.copyFileToDirectory((File)this.getKrfFile(), (File)targetDir);
        }
    }

    private static String getFileType(OplogFile olf) {
        String name = olf.f.getName();
        int index = name.lastIndexOf(46);
        return name.substring(index + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFile(final OplogFile olf) {
        Object object = this.lock;
        synchronized (object) {
            if (olf.currSize != 0L) {
                this.dirHolder.decrementTotalOplogSize(olf.currSize);
                olf.currSize = 0L;
            }
            if (olf.f == null) {
                return;
            }
            if (!olf.f.exists()) {
                return;
            }
            assert (olf.RAFClosed);
            if (!olf.RAFClosed || olf.raf != null) {
                try {
                    olf.raf.close();
                    olf.RAFClosed = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.getParent().executeDelayedExpensiveWrite(new Runnable(){

                @Override
                public void run() {
                    if (!olf.f.delete() && olf.f.exists()) {
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.Oplog_DELETE_FAIL_0_1_2, new Object[]{Oplog.this.toString(), Oplog.getFileType(olf), Oplog.this.getParent().getName()}));
                    } else {
                        logger.info((Message)LocalizedMessage.create(LocalizedStrings.Oplog_DELETE_0_1_2, new Object[]{Oplog.this.toString(), Oplog.getFileType(olf), Oplog.this.getParent().getName()}));
                    }
                }
            });
        }
    }

    UninterruptibleFileChannel getFileChannel() {
        return this.crf.channel;
    }

    DirectoryHolder getDirectoryHolder() {
        return this.dirHolder;
    }

    long getOplogSize() {
        return this.crf.currSize + this.drf.currSize;
    }

    boolean isOplogEmpty() {
        return this.crf.currSize <= (long)(18 + OPLOG_MAGIC_SEQ_REC_SIZE) && this.drf.currSize <= (long)(18 + OPLOG_MAGIC_SEQ_REC_SIZE);
    }

    void incLiveCount() {
        this.totalLiveCount.incrementAndGet();
    }

    private void decLiveCount() {
        this.totalLiveCount.decrementAndGet();
    }

    boolean hasBeenUsed() {
        return this.hasDeletes.get() || this.totalCount.get() > 0L;
    }

    void incTotalCount() {
        if (!this.isPhase2()) {
            this.totalCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishedAppending() {
        Object object = this.lock;
        synchronized (object) {
            this.doneAppending = true;
        }
        this.handleNoLiveValues();
    }

    boolean needsCompaction() {
        if (!this.isCompactionPossible()) {
            return false;
        }
        if (this.unrecoveredRegionCount.get() > 0) {
            return false;
        }
        if (this.parent.getCompactionThreshold() == 100) {
            return true;
        }
        if (this.parent.getCompactionThreshold() == 0) {
            return false;
        }
        long rvHWMtmp = this.totalCount.get();
        if (rvHWMtmp > 0L) {
            double rv;
            long tlc = this.totalLiveCount.get();
            if (tlc < 0L) {
                tlc = 0L;
            }
            return (rv = (double)tlc) / (double)rvHWMtmp * 100.0 <= (double)this.parent.getCompactionThreshold();
        }
        return true;
    }

    public boolean hadLiveEntries() {
        return this.totalCount.get() != 0L;
    }

    public boolean hasNoLiveValues() {
        return this.totalLiveCount.get() <= 0L && this.unrecoveredRegionCount.get() == 0 && !this.getParent().isOfflineCompacting();
    }

    private void handleEmptyAndOldest(boolean calledByCompactor) {
        if (!calledByCompactor && logger.isDebugEnabled()) {
            logger.debug("Deleting oplog early because it is empty. It is for disk store {} and has oplog#{}", (Object)this.getParent().getName(), (Object)this.oplogId);
        }
        this.destroy();
        this.getOplogSet().destroyOldestReadyToCompact();
    }

    private void handleEmpty(boolean calledByCompactor) {
        this.lockCompactor();
        try {
            if (!calledByCompactor) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.Oplog_CLOSING_EMPTY_OPLOG_0_1, new Object[]{this.getParent().getName(), this.toString()}));
            }
            this.cancelKrf();
            this.close();
            this.deleteFiles(this.getHasDeletes());
        }
        finally {
            this.unlockCompactor();
        }
    }

    void cancelKrf() {
        this.createKrf(true);
    }

    private boolean calledByCompactorThread() {
        if (!this.compacting) {
            return false;
        }
        Object v = isCompactorThread.get();
        return v != null && v == Boolean.TRUE;
    }

    private void handleNoLiveValues() {
        if (!this.doneAppending) {
            return;
        }
        if (this.hasNoLiveValues()) {
            if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                if (this.calledByCompactorThread()) {
                    CacheObserverHolder.getInstance().beforeDeletingCompactedOplog(this);
                } else {
                    CacheObserverHolder.getInstance().beforeDeletingEmptyOplog(this);
                }
            }
            if (this.isOldest()) {
                if (this.calledByCompactorThread()) {
                    this.handleEmptyAndOldest(true);
                } else {
                    this.getParent().executeDiskStoreTask(new Runnable(){

                        @Override
                        public void run() {
                            Oplog.this.handleEmptyAndOldest(false);
                        }
                    });
                }
            } else if (this.calledByCompactorThread()) {
                this.handleEmpty(true);
            } else {
                this.getParent().executeDiskStoreTask(new Runnable(){

                    @Override
                    public void run() {
                        Oplog.this.handleEmpty(false);
                    }
                });
            }
        } else if (this.needsCompaction()) {
            this.addToBeCompacted();
        }
    }

    private InternalCache getInternalCache() {
        return this.getParent().getCache();
    }

    private boolean isOldest() {
        long myId = this.getOplogId();
        return this.getOplogSet().isOldestExistingOplog(myId);
    }

    private synchronized void addToBeCompacted() {
        if (this.added) {
            return;
        }
        this.added = true;
        this.getOplogSet().addToBeCompacted(this);
        if (logger.isDebugEnabled()) {
            logger.debug("Oplog::switchOpLog: Added the Oplog = {} for compacting.", (Object)this.oplogId);
        }
    }

    private void initRecoveredEntry(DiskRegionView drv, DiskEntry de) {
        this.addLive(drv, de);
    }

    private void updateRecoveredEntry(DiskRegionView drv, DiskEntry de, DiskEntry.RecoveredEntry re) {
        if (this.getOplogId() != re.getOplogId()) {
            Oplog oldOplog = this.getOplogSet().getChild(re.getOplogId());
            oldOplog.rmLive(drv, de);
            this.initRecoveredEntry(drv, de);
        } else {
            this.getDRI(drv).update(de);
        }
    }

    @Override
    public void prepareForCompact() {
        this.compacting = true;
    }

    private void lockCompactor() {
        this.compactorLock.lock();
    }

    private void unlockCompactor() {
        this.compactorLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compact(DiskStoreImpl.OplogCompactor compactor) {
        if (!this.needsCompaction()) {
            return 0;
        }
        isCompactorThread.set(Boolean.TRUE);
        assert (this.calledByCompactorThread());
        this.getParent().acquireCompactorReadLock();
        try {
            block33: {
                if (!compactor.keepCompactorRunning()) {
                    int n = 0;
                    return n;
                }
                this.lockCompactor();
                if (!this.hasNoLiveValues()) break block33;
                this.handleNoLiveValues();
                int n = 0;
                this.unlockCompactor();
                return n;
            }
            try {
                long opStart = this.getStats().getStatTime();
                BytesAndBitsForCompactor wrapper = new BytesAndBitsForCompactor();
                DiskEntry lastDe = null;
                boolean compactFailed = !compactor.keepCompactorRunning();
                int totalCount = 0;
                block15: for (DiskRegionInfo dri : this.regionMap.values()) {
                    DiskEntry de;
                    DiskRegionView dr = dri.getDiskRegion();
                    if (dr == null) continue;
                    boolean didCompact = false;
                    while ((de = dri.getNextLiveEntry()) != null) {
                        if (!compactor.keepCompactorRunning()) {
                            compactFailed = true;
                            continue block15;
                        }
                        if (lastDe != null) {
                            if (lastDe == de) {
                                throw new IllegalStateException("compactor would have gone into infinite loop");
                            }
                            assert (lastDe != de);
                        }
                        lastDe = de;
                        didCompact = false;
                        DiskEntry diskEntry = de;
                        synchronized (diskEntry) {
                            DiskId did = de.getDiskId();
                            assert (did != null);
                            DiskId diskId = did;
                            synchronized (diskId) {
                                long oplogId = did.getOplogId();
                                if (oplogId != this.getOplogId()) {
                                    continue;
                                }
                                boolean toCompact = this.getBytesAndBitsForCompaction(dr, de, wrapper);
                                if (toCompact) {
                                    if (oplogId != did.getOplogId()) {
                                        if (!wrapper.isReusable()) {
                                            wrapper = new BytesAndBitsForCompactor();
                                        } else if (wrapper.getOffHeapData() != null) {
                                            wrapper.setOffHeapData(null, (byte)0);
                                        }
                                        continue;
                                    }
                                    this.getOplogSet().getChild().copyForwardModifyForCompact(dr, de, wrapper);
                                    didCompact = true;
                                }
                            }
                        }
                        if (!didCompact) continue;
                        ++totalCount;
                        this.getStats().endCompactionUpdate(opStart);
                        opStart = this.getStats().getStatTime();
                        if (wrapper.isReusable()) continue;
                        wrapper = new BytesAndBitsForCompactor();
                    }
                }
                if (!compactFailed) {
                    this.handleNoLiveValues();
                }
                int n = totalCount;
                this.unlockCompactor();
                return n;
            }
            catch (Throwable throwable) {
                this.unlockCompactor();
                throw throwable;
            }
        }
        finally {
            this.getParent().releaseCompactorReadLock();
            assert (this.calledByCompactorThread());
            isCompactorThread.remove();
        }
    }

    public static boolean isCRFFile(String filename) {
        return filename.endsWith(CRF_FILE_EXT);
    }

    public static boolean isDRFFile(String filename) {
        return filename.endsWith(DRF_FILE_EXT);
    }

    public static String getKRFFilenameFromCRFFilename(String crfFilename) {
        return crfFilename.substring(0, crfFilename.length() - CRF_FILE_EXT.length()) + KRF_FILE_EXT;
    }

    long testGetOplogFileLength() throws IOException {
        long result = 0L;
        if (this.crf.raf != null) {
            result += this.crf.raf.length();
        }
        if (this.drf.raf != null) {
            result += this.drf.raf.length();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverValuesIfNeeded(Map<Long, DiskRecoveryStore> diskRecoveryStores) {
        if (this.getParent().isClosing()) {
            return;
        }
        HashMap<Long, DiskRegionInfo> targetRegions = new HashMap<Long, DiskRegionInfo>(this.regionMap);
        Map<Long, DiskRecoveryStore> map = diskRecoveryStores;
        synchronized (map) {
            Iterator<DiskRecoveryStore> itr = diskRecoveryStores.values().iterator();
            while (itr.hasNext()) {
                DiskRecoveryStore store = itr.next();
                if (!this.isLruValueRecoveryDisabled(store) && !store.lruLimitExceeded()) continue;
                itr.remove();
            }
            targetRegions.keySet().retainAll(diskRecoveryStores.keySet());
        }
        List<KRFEntry> sortedLiveEntries = this.getSortedLiveEntries(targetRegions.values());
        if (sortedLiveEntries == null) {
            return;
        }
        ByteArrayDataInput in = new ByteArrayDataInput();
        for (KRFEntry entry : sortedLiveEntries) {
            if (this.getParent().isClosing()) {
                return;
            }
            DiskEntry diskEntry = entry.getDiskEntry();
            DiskRegionView diskRegionView = entry.getDiskRegionView();
            long diskRegionId = diskRegionView.getId();
            Map<Long, DiskRecoveryStore> map2 = diskRecoveryStores;
            synchronized (map2) {
                DiskRecoveryStore diskRecoveryStore = diskRecoveryStores.get(diskRegionId);
                if (diskRecoveryStore == null) {
                    continue;
                }
                diskRegionView = diskRecoveryStore.getDiskRegionView();
                if (diskRegionView == null) {
                    continue;
                }
                if (diskRecoveryStore.lruLimitExceeded()) {
                    diskRecoveryStores.remove(diskRegionId);
                    continue;
                }
                if (diskRegionView.isEntriesMapIncompatible() && (diskEntry = (DiskEntry)diskRecoveryStore.getRegionMap().getEntryInVM(diskEntry.getKey())) == null) {
                    continue;
                }
                DiskEntry diskEntry2 = diskEntry;
                synchronized (diskEntry2) {
                    if (diskEntry.getDiskId() != null && diskEntry.getDiskId().getOplogId() == this.oplogId) {
                        try {
                            DiskEntry.Helper.recoverValue(diskEntry, this.getOplogId(), diskRecoveryStore, in);
                        }
                        catch (RegionDestroyedException ignore) {
                            diskRecoveryStores.remove(diskRegionId);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeRVVs(Map<Long, AbstractDiskRegion> drMap, boolean gcRVV) throws IOException {
        HeapDataOutputStream out = new HeapDataOutputStream(Version.CURRENT);
        drMap = new HashMap<Long, AbstractDiskRegion>(drMap);
        Iterator<Map.Entry<Long, AbstractDiskRegion>> itr = drMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Long, AbstractDiskRegion> regionEntry = itr.next();
            AbstractDiskRegion dr = regionEntry.getValue();
            if (dr.getFlags().contains((Object)DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING)) continue;
            itr.remove();
        }
        InternalDataSerializer.writeUnsignedVL(drMap.size(), out);
        for (Map.Entry<Long, AbstractDiskRegion> regionEntry : drMap.entrySet()) {
            int id;
            VersionSource member;
            Map memberToVersion;
            Long diskRegionID = regionEntry.getKey();
            AbstractDiskRegion dr = regionEntry.getValue();
            RegionVersionVector rvv = dr.getRegionVersionVector();
            if (logger.isTraceEnabled(LogMarker.PERSIST_WRITES)) {
                logger.trace(LogMarker.PERSIST_WRITES, "serializeRVVs: isGCRVV={} drId={} rvv={} oplog#{}", (Object)gcRVV, (Object)diskRegionID, (Object)rvv.fullToString(), (Object)this.getOplogId());
            }
            InternalDataSerializer.writeUnsignedVL(diskRegionID, out);
            if (gcRVV) {
                memberToVersion = rvv.getMemberToGCVersion();
                InternalDataSerializer.writeUnsignedVL(memberToVersion.size(), out);
                for (Map.Entry memberEntry : memberToVersion.entrySet()) {
                    member = (VersionSource)memberEntry.getKey();
                    Long gcVersion = (Long)memberEntry.getValue();
                    id = this.getParent().getDiskInitFile().getOrCreateCanonicalId(member);
                    InternalDataSerializer.writeUnsignedVL(id, out);
                    InternalDataSerializer.writeUnsignedVL(gcVersion, out);
                }
                continue;
            }
            DataSerializer.writeBoolean(dr.getRVVTrusted(), out);
            memberToVersion = rvv.getMemberToVersion();
            InternalDataSerializer.writeUnsignedVL(memberToVersion.size(), out);
            for (Map.Entry memberEntry : memberToVersion.entrySet()) {
                member = (VersionSource)memberEntry.getKey();
                RegionVersionHolder versionHolder = (RegionVersionHolder)memberEntry.getValue();
                id = this.getParent().getDiskInitFile().getOrCreateCanonicalId(member);
                InternalDataSerializer.writeUnsignedVL(id, out);
                RegionVersionHolder regionVersionHolder = versionHolder;
                synchronized (regionVersionHolder) {
                    InternalDataSerializer.invokeToData(versionHolder, out);
                }
            }
        }
        return out.toByteArray();
    }

    public String toString() {
        return "oplog#" + this.getOplogId();
    }

    UninterruptibleFileChannel testSetCrfChannel(UninterruptibleFileChannel ch) {
        UninterruptibleFileChannel chPrev = this.crf.channel;
        this.crf.channel = ch;
        return chPrev;
    }

    private static String baToString(byte[] ba) {
        return Oplog.baToString(ba, ba != null ? ba.length : 0);
    }

    private static String baToString(byte[] ba, int len) {
        if (ba == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(ba[i]).append(", ");
        }
        return sb.toString();
    }

    void serializeVersionTag(VersionHolder tag, DataOutput out) throws IOException {
        int entryVersion = tag.getEntryVersion();
        long regionVersion = tag.getRegionVersion();
        Object versionMember = tag.getMemberID();
        long timestamp = tag.getVersionTimeStamp();
        int dsId = tag.getDistributedSystemId();
        this.serializeVersionTag(entryVersion, regionVersion, (VersionSource)versionMember, timestamp, dsId, out);
    }

    byte[] serializeVersionTag(VersionTag tag) throws IOException {
        int entryVersion = tag.getEntryVersion();
        long regionVersion = tag.getRegionVersion();
        Object versionMember = tag.getMemberID();
        long timestamp = tag.getVersionTimeStamp();
        int dsId = tag.getDistributedSystemId();
        return this.serializeVersionTag(entryVersion, regionVersion, (VersionSource)versionMember, timestamp, dsId);
    }

    byte[] serializeVersionTag(VersionStamp stamp) throws IOException {
        int entryVersion = stamp.getEntryVersion();
        long regionVersion = stamp.getRegionVersion();
        Object versionMember = stamp.getMemberID();
        long timestamp = stamp.getVersionTimeStamp();
        int dsId = stamp.getDistributedSystemId();
        return this.serializeVersionTag(entryVersion, regionVersion, (VersionSource)versionMember, timestamp, dsId);
    }

    private byte[] serializeVersionTag(int entryVersion, long regionVersion, VersionSource versionMember, long timestamp, int dsId) throws IOException {
        HeapDataOutputStream out = new HeapDataOutputStream(28, Version.CURRENT);
        this.serializeVersionTag(entryVersion, regionVersion, versionMember, timestamp, dsId, out);
        return out.toByteArray();
    }

    private void serializeVersionTag(int entryVersion, long regionVersion, VersionSource versionMember, long timestamp, int dsId, DataOutput out) throws IOException {
        int memberId = this.getParent().getDiskInitFile().getOrCreateCanonicalId(versionMember);
        InternalDataSerializer.writeSignedVL(entryVersion, out);
        InternalDataSerializer.writeUnsignedVL(regionVersion, out);
        InternalDataSerializer.writeUnsignedVL(memberId, out);
        InternalDataSerializer.writeUnsignedVL(timestamp, out);
        InternalDataSerializer.writeSignedVL(dsId, out);
    }

    void finishKrf() {
        this.createKrf(false);
    }

    void prepareForClose() {
        block2: {
            try {
                this.finishKrf();
            }
            catch (CancelException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Got a cancel exception while creating a krf during shutown", (Throwable)e);
            }
        }
    }

    private Object deserializeKey(byte[] keyBytes, Version version, ByteArrayDataInput in) {
        if (!this.getParent().isOffline() || !PdxWriterImpl.isPdx(keyBytes)) {
            return EntryEventImpl.deserialize(keyBytes, version, in);
        }
        return new RawByteKey(keyBytes);
    }

    public Version getProductVersionIfOld() {
        Version version = this.gfversion;
        if (version == null) {
            if (this.getParent().isUpgradeVersionOnly()) {
                return Version.GFE_66;
            }
            return null;
        }
        if (version == Version.CURRENT) {
            return null;
        }
        return version;
    }

    public Version getDataVersionIfOld() {
        Version version = this.dataVersion;
        if (version == null) {
            if (this.getParent().isUpgradeVersionOnly()) {
                return Version.GFE_66;
            }
            return null;
        }
        if (version == Version.CURRENT) {
            return null;
        }
        return version;
    }

    static {
        try {
            TOMBSTONE_BYTES = BlobHelper.serializeToBlob(Token.TOMBSTONE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        isCompactorThread = new ThreadLocal();
    }

    private static enum OkToSkipResult {
        SKIP_RECORD,
        SKIP_VALUE,
        DONT_SKIP;


        public boolean skip() {
            return this != DONT_SKIP;
        }

        public boolean skipKey() {
            return this == SKIP_RECORD;
        }
    }

    static enum OplogFileType {
        OPLOG_CRF,
        OPLOG_DRF,
        OPLOG_KRF;

    }

    private static class RawByteKey
    implements Sendable {
        final byte[] bytes;
        final int hashCode;

        public RawByteKey(byte[] keyBytes) {
            this.bytes = keyBytes;
            this.hashCode = Arrays.hashCode(keyBytes);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RawByteKey)) {
                return false;
            }
            return Arrays.equals(this.bytes, ((RawByteKey)other).bytes);
        }

        @Override
        public void sendTo(DataOutput out) throws IOException {
            out.write(this.bytes);
        }
    }

    static class OplogEntryIdMap {
        private final Int2ObjectOpenHashMap ints = new Int2ObjectOpenHashMap(0);
        private final Long2ObjectOpenHashMap longs = new Long2ObjectOpenHashMap(0);

        OplogEntryIdMap() {
        }

        public Object put(long id, Object v) {
            if (id == 0L) {
                throw new IllegalArgumentException();
            }
            Object result = id > 0L && id <= 0xFFFFFFFFL ? this.ints.put((int)id, v) : this.longs.put(id, v);
            return result;
        }

        public int size() {
            return this.ints.size() + this.longs.size();
        }

        public Object get(long id) {
            Object result = id >= 0L && id <= 0xFFFFFFFFL ? this.ints.get((int)id) : this.longs.get(id);
            return result;
        }

        public Iterator iterator() {
            return new Iterator();
        }

        static /* synthetic */ Int2ObjectOpenHashMap access$2000(OplogEntryIdMap x0) {
            return x0.ints;
        }

        static /* synthetic */ Long2ObjectOpenHashMap access$2100(OplogEntryIdMap x0) {
            return x0.longs;
        }

        public class Iterator {
            private boolean doingInt = true;
            ObjectIterator<Int2ObjectMap.Entry<?>> intIt = OplogEntryIdMap.access$2000(OplogEntryIdMap.this).int2ObjectEntrySet().fastIterator();
            ObjectIterator<Long2ObjectMap.Entry<?>> longIt = OplogEntryIdMap.access$2100(OplogEntryIdMap.this).long2ObjectEntrySet().fastIterator();
            Int2ObjectMap.Entry<?> nextIntEntry;
            Long2ObjectMap.Entry<?> nextLongEntry;

            public boolean hasNext() {
                if (this.intIt.hasNext()) {
                    return true;
                }
                this.doingInt = false;
                return this.longIt.hasNext();
            }

            public void advance() {
                if (this.doingInt) {
                    this.nextIntEntry = (Int2ObjectMap.Entry)this.intIt.next();
                } else {
                    this.nextLongEntry = (Long2ObjectMap.Entry)this.longIt.next();
                }
            }

            public long key() {
                if (this.doingInt) {
                    return this.nextIntEntry.getKey().intValue();
                }
                return this.nextLongEntry.getKey();
            }

            public Object value() {
                if (this.doingInt) {
                    return this.nextIntEntry.getValue();
                }
                return this.nextLongEntry.getValue();
            }
        }
    }

    private static class CompactionRecord {
        private final byte[] keyBytes;
        private long offset;

        public CompactionRecord(byte[] kb, long offset) {
            this.keyBytes = kb;
            this.offset = offset;
        }

        public void update(long offset) {
            this.offset = offset;
        }

        public byte[] getKeyBytes() {
            return this.keyBytes;
        }

        public long getOffset() {
            return this.offset;
        }
    }

    public static class DiskRegionInfoWithList
    extends AbstractDiskRegionInfo {
        private final OplogDiskEntry liveEntries = new OplogDiskEntry();
        private Map<DiskEntry, VersionHolder> pendingKrfTags;

        public DiskRegionInfoWithList(DiskRegionView dr, boolean couldHaveKrf, boolean krfExists) {
            super(dr);
            this.pendingKrfTags = !krfExists && couldHaveKrf ? new HashMap<DiskEntry, VersionHolder>(200) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLive(DiskEntry de) {
            OplogDiskEntry oplogDiskEntry = this.liveEntries;
            synchronized (oplogDiskEntry) {
                this.liveEntries.insert(de);
                if (this.pendingKrfTags != null && de.getVersionStamp() != null) {
                    this.pendingKrfTags.put(de, new CompactVersionHolder(de.getVersionStamp()));
                }
            }
        }

        @Override
        public void update(DiskEntry de) {
            if (this.pendingKrfTags != null && de.getVersionStamp() != null) {
                this.pendingKrfTags.put(de, new CompactVersionHolder(de.getVersionStamp()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceLive(DiskEntry old, DiskEntry de) {
            OplogDiskEntry oplogDiskEntry = this.liveEntries;
            synchronized (oplogDiskEntry) {
                this.liveEntries.replace(old, de);
                if (this.pendingKrfTags != null && de.getVersionStamp() != null) {
                    this.pendingKrfTags.remove(old);
                    this.pendingKrfTags.put(de, new CompactVersionHolder(de.getVersionStamp()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean rmLive(DiskEntry de, Oplog oplog) {
            OplogDiskEntry oplogDiskEntry = this.liveEntries;
            synchronized (oplogDiskEntry) {
                boolean removed = this.liveEntries.remove(de);
                if (removed && this.pendingKrfTags != null) {
                    this.pendingKrfTags.remove(de);
                }
                if (removed) {
                    oplog.decLiveCount();
                }
                return removed;
            }
        }

        @Override
        public DiskEntry getNextLiveEntry() {
            DiskEntry result = this.liveEntries.getPrev();
            if (result == this.liveEntries) {
                result = null;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long clear(RegionVersionVector rvv) {
            OplogDiskEntry oplogDiskEntry = this.liveEntries;
            synchronized (oplogDiskEntry) {
                return this.liveEntries.clear(rvv, this.pendingKrfTags);
            }
        }

        @Override
        public synchronized boolean testAndSetUnrecovered() {
            boolean result = super.testAndSetUnrecovered();
            if (result) {
                this.liveEntries.clear();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addLiveEntriesToList(KRFEntry[] liveEntries, int idx) {
            KRFEntry[] kRFEntryArray = liveEntries;
            synchronized (liveEntries) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.liveEntries.addLiveEntriesToList(liveEntries, idx, this.getDiskRegion(), this.pendingKrfTags);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterKrfCreated() {
            OplogDiskEntry oplogDiskEntry = this.liveEntries;
            synchronized (oplogDiskEntry) {
                this.pendingKrfTags = null;
            }
        }
    }

    public static class DiskRegionInfoNoList
    extends AbstractDiskRegionInfo {
        private final AtomicInteger liveCount = new AtomicInteger();

        public DiskRegionInfoNoList(DiskRegionView dr) {
            super(dr);
        }

        @Override
        public void addLive(DiskEntry de) {
            this.liveCount.incrementAndGet();
        }

        @Override
        public void update(DiskEntry entry) {
        }

        @Override
        public void replaceLive(DiskEntry old, DiskEntry de) {
        }

        @Override
        public boolean rmLive(DiskEntry de, Oplog oplog) {
            return this.liveCount.decrementAndGet() >= 0;
        }

        @Override
        public DiskEntry getNextLiveEntry() {
            return null;
        }

        @Override
        public long clear(RegionVersionVector rvv) {
            return this.liveCount.getAndSet(0);
        }

        @Override
        public int addLiveEntriesToList(KRFEntry[] liveEntries, int idx) {
            return idx;
        }

        @Override
        public void afterKrfCreated() {
        }
    }

    public static abstract class AbstractDiskRegionInfo
    implements DiskRegionInfo {
        private DiskRegionView dr;
        private boolean unrecovered = false;

        public AbstractDiskRegionInfo(DiskRegionView dr) {
            this.dr = dr;
        }

        @Override
        public abstract void addLive(DiskEntry var1);

        @Override
        public abstract DiskEntry getNextLiveEntry();

        @Override
        public abstract long clear(RegionVersionVector var1);

        @Override
        public DiskRegionView getDiskRegion() {
            return this.dr;
        }

        @Override
        public void setDiskRegion(DiskRegionView dr) {
            this.dr = dr;
        }

        @Override
        public synchronized boolean testAndSetUnrecovered() {
            boolean result;
            boolean bl = result = !this.unrecovered;
            if (result) {
                this.unrecovered = true;
                this.dr = null;
            }
            return result;
        }

        @Override
        public synchronized boolean getUnrecovered() {
            return this.unrecovered;
        }

        @Override
        public synchronized boolean testAndSetRecovered(DiskRegionView dr) {
            boolean result = this.unrecovered;
            if (result) {
                this.unrecovered = false;
                this.dr = dr;
            }
            return result;
        }
    }

    public static interface DiskRegionInfo {
        public DiskRegionView getDiskRegion();

        public int addLiveEntriesToList(KRFEntry[] var1, int var2);

        public void addLive(DiskEntry var1);

        public void update(DiskEntry var1);

        public void replaceLive(DiskEntry var1, DiskEntry var2);

        public boolean rmLive(DiskEntry var1, Oplog var2);

        public DiskEntry getNextLiveEntry();

        public void setDiskRegion(DiskRegionView var1);

        public long clear(RegionVersionVector var1);

        public boolean testAndSetUnrecovered();

        public boolean getUnrecovered();

        public boolean testAndSetRecovered(DiskRegionView var1);

        public void afterKrfCreated();
    }

    static class OplogDiskEntry
    implements DiskEntry,
    RegionEntry {
        private DiskEntry next = this;
        private DiskEntry prev = this;

        OplogDiskEntry() {
        }

        @Override
        public synchronized DiskEntry getPrev() {
            return this.prev;
        }

        @Override
        public synchronized void setPrev(DiskEntry v) {
            this.prev = v;
        }

        @Override
        public synchronized DiskEntry getNext() {
            return this.next;
        }

        @Override
        public synchronized void setNext(DiskEntry v) {
            this.next = v;
        }

        public synchronized int clear(RegionVersionVector rvv, Map<DiskEntry, VersionHolder> pendingKrfTags) {
            if (rvv == null) {
                if (pendingKrfTags != null) {
                    pendingKrfTags.clear();
                }
                return this.clear();
            }
            return 0;
        }

        private int clearWithRVV(RegionVersionVector rvv, Map<DiskEntry, VersionTag> pendingKrfTags) {
            return 0;
        }

        private int clear() {
            int result = 0;
            this.setNext(this);
            this.setPrev(this);
            for (DiskEntry n = this.getNext(); n != this; n = n.getNext()) {
                ++result;
                n.setPrev(null);
            }
            return result;
        }

        public synchronized boolean remove(DiskEntry v) {
            DiskEntry p = v.getPrev();
            if (p != null) {
                v.setPrev(null);
                DiskEntry n = v.getNext();
                v.setNext(null);
                n.setPrev(p);
                p.setNext(n);
                return true;
            }
            return false;
        }

        public synchronized void insert(DiskEntry v) {
            assert (v.getPrev() == null);
            DiskEntry n = this.getNext();
            this.setNext(v);
            n.setPrev(v);
            v.setNext(n);
            v.setPrev(this);
        }

        public synchronized void replace(DiskEntry old, DiskEntry v) {
            DiskEntry n;
            DiskEntry p = old.getPrev();
            if (p != null) {
                old.setPrev(null);
                v.setPrev(p);
                p.setNext(v);
            }
            if ((n = old.getNext()) != null) {
                old.setNext(null);
                v.setNext(n);
                n.setPrev(v);
            }
            if (this.getNext() == old) {
                this.setNext(v);
            }
        }

        @Override
        public Object getKey() {
            throw new IllegalStateException();
        }

        @Override
        public Object _getValue() {
            throw new IllegalStateException();
        }

        @Override
        public Token getValueAsToken() {
            throw new IllegalStateException();
        }

        @Override
        public void handleValueOverflow(RegionEntryContext context) {
            throw new IllegalStateException();
        }

        @Override
        public Object prepareValueForCache(RegionEntryContext r, Object val, boolean isEntryUpdate) {
            throw new IllegalStateException("Should never be called");
        }

        @Override
        public Object _getValueRetain(RegionEntryContext context, boolean decompress) {
            throw new IllegalStateException();
        }

        @Override
        public void setValueWithContext(RegionEntryContext context, Object value) {
            throw new IllegalStateException();
        }

        public void _removePhase1() {
            throw new IllegalStateException();
        }

        @Override
        public DiskId getDiskId() {
            throw new IllegalStateException();
        }

        @Override
        public long getLastModified() {
            throw new IllegalStateException();
        }

        public boolean isRecovered() {
            throw new IllegalStateException();
        }

        @Override
        public boolean isValueNull() {
            throw new IllegalStateException();
        }

        @Override
        public boolean isRemovedFromDisk() {
            throw new IllegalStateException();
        }

        @Override
        public int updateAsyncEntrySize(EnableLRU capacityController) {
            throw new IllegalStateException();
        }

        public synchronized int addLiveEntriesToList(KRFEntry[] liveEntries, int idx, DiskRegionView drv, Map<DiskEntry, VersionHolder> pendingKrfTags) {
            for (DiskEntry de = this.getPrev(); de != this; de = de.getPrev()) {
                VersionHolder tag = null;
                if (pendingKrfTags != null) {
                    tag = pendingKrfTags.get(de);
                }
                liveEntries[idx] = new KRFEntry(drv, de, tag);
                ++idx;
            }
            return idx;
        }

        @Override
        public VersionStamp getVersionStamp() {
            return null;
        }

        @Override
        public boolean hasStats() {
            return false;
        }

        @Override
        public long getLastAccessed() throws InternalStatisticsDisabledException {
            return 0L;
        }

        @Override
        public long getHitCount() throws InternalStatisticsDisabledException {
            return 0L;
        }

        @Override
        public long getMissCount() throws InternalStatisticsDisabledException {
            return 0L;
        }

        @Override
        public void updateStatsForPut(long lastModifiedTime, long lastAccessedTime) {
        }

        @Override
        public VersionTag generateVersionTag(VersionSource member, boolean withDelta, LocalRegion region, EntryEventImpl event) {
            return null;
        }

        @Override
        public boolean dispatchListenerEvents(EntryEventImpl event) throws InterruptedException {
            return false;
        }

        @Override
        public void setRecentlyUsed() {
        }

        @Override
        public void updateStatsForGet(boolean hit, long time) {
        }

        @Override
        public void txDidDestroy(long currTime) {
        }

        @Override
        public void resetCounts() throws InternalStatisticsDisabledException {
        }

        @Override
        public void makeTombstone(LocalRegion r, VersionTag version) throws RegionClearedException {
        }

        @Override
        public void removePhase1(LocalRegion r, boolean clear) throws RegionClearedException {
        }

        @Override
        public void removePhase2() {
        }

        @Override
        public boolean isRemoved() {
            return false;
        }

        @Override
        public boolean isRemovedPhase2() {
            return false;
        }

        @Override
        public boolean isTombstone() {
            return false;
        }

        @Override
        public boolean fillInValue(LocalRegion r, InitialImageOperation.Entry entry, ByteArrayDataInput in, DM mgr, Version version) {
            return false;
        }

        @Override
        public boolean isOverflowedToDisk(LocalRegion r, DistributedRegion.DiskPosition dp) {
            return false;
        }

        @Override
        public Object getValue(RegionEntryContext context) {
            return null;
        }

        @Override
        public Object getValueRetain(RegionEntryContext context) {
            return null;
        }

        @Override
        public void setValue(RegionEntryContext context, Object value) throws RegionClearedException {
        }

        @Override
        public void setValueWithTombstoneCheck(Object value, EntryEvent event) throws RegionClearedException {
        }

        @Override
        public Object getTransformedValue() {
            return null;
        }

        @Override
        public Object getValueInVM(RegionEntryContext context) {
            return null;
        }

        @Override
        public Object getValueOnDisk(LocalRegion r) throws EntryNotFoundException {
            return null;
        }

        @Override
        public Object getValueOnDiskOrBuffer(LocalRegion r) throws EntryNotFoundException {
            return null;
        }

        @Override
        public boolean initialImagePut(LocalRegion region, long lastModified, Object newValue, boolean wasRecovered, boolean acceptedVersionTag) throws RegionClearedException {
            return false;
        }

        @Override
        public boolean initialImageInit(LocalRegion region, long lastModified, Object newValue, boolean create, boolean wasRecovered, boolean acceptedVersionTag) throws RegionClearedException {
            return false;
        }

        @Override
        public boolean destroy(LocalRegion region, EntryEventImpl event, boolean inTokenMode, boolean cacheWrite, Object expectedOldValue, boolean forceDestroy, boolean removeRecoveredEntry) throws CacheWriterException, EntryNotFoundException, TimeoutException, RegionClearedException {
            return false;
        }

        @Override
        public boolean getValueWasResultOfSearch() {
            return false;
        }

        @Override
        public void setValueResultOfSearch(boolean v) {
        }

        @Override
        public Object getSerializedValueOnDisk(LocalRegion localRegion) {
            return null;
        }

        @Override
        public Object getValueInVMOrDiskWithoutFaultIn(LocalRegion owner) {
            return null;
        }

        @Override
        public Object getValueOffHeapOrDiskWithoutFaultIn(LocalRegion owner) {
            return null;
        }

        @Override
        public boolean isUpdateInProgress() {
            return false;
        }

        @Override
        public void setUpdateInProgress(boolean underUpdate) {
        }

        @Override
        public boolean isInvalid() {
            return false;
        }

        @Override
        public boolean isDestroyed() {
            return false;
        }

        @Override
        public boolean isDestroyedOrRemoved() {
            return false;
        }

        @Override
        public boolean isDestroyedOrRemovedButNotTombstone() {
            return false;
        }

        @Override
        public boolean isInvalidOrRemoved() {
            return false;
        }

        @Override
        public void setValueToNull() {
        }

        @Override
        public void returnToPool() {
        }

        @Override
        public boolean isCacheListenerInvocationInProgress() {
            return false;
        }

        @Override
        public void setCacheListenerInvocationInProgress(boolean isListenerInvoked) {
        }

        @Override
        public void setValue(RegionEntryContext context, Object value, EntryEventImpl event) throws RegionClearedException {
        }

        @Override
        public boolean isInUseByTransaction() {
            return false;
        }

        @Override
        public void setInUseByTransaction(boolean v) {
        }

        @Override
        public void incRefCount() {
        }

        @Override
        public void decRefCount(NewLRUClockHand lruList, LocalRegion lr) {
        }

        @Override
        public void resetRefCount(NewLRUClockHand lruList) {
        }

        @Override
        public Object prepareValueForCache(RegionEntryContext r, Object val, EntryEventImpl event, boolean isEntryUpdate) {
            throw new IllegalStateException("Should never be called");
        }
    }

    private class OpState {
        private byte opCode;
        private byte userBits;
        private boolean notToUseUserBits;
        private int size;
        private boolean needsValue;
        private DiskEntry.Helper.ValueWrapper value;
        private int drIdLength;
        private final byte[] drIdBytes = new byte[9];
        private byte[] keyBytes;
        private final byte[] deltaIdBytes = new byte[8];
        private int deltaIdBytesLength;
        private long newEntryBase;
        private DiskStoreID diskStoreId;
        private OPLOG_TYPE magic;
        private byte[] versionsBytes;
        private short gfversion;

        private OpState() {
        }

        public int getSize() {
            return this.size;
        }

        public String debugStr() {
            StringBuilder sb = new StringBuilder();
            sb.append(" opcode=").append(this.opCode).append(" len=").append(this.value.getLength()).append(" vb=").append(this.value.getBytesAsString());
            return sb.toString();
        }

        private void write(OplogFile olf, DiskEntry.Helper.ValueWrapper vw) throws IOException {
            vw.sendTo(olf.writeBuf, Oplog.this);
        }

        private void write(OplogFile olf, byte[] bytes, int byteLength) throws IOException {
            int bytesThisTime;
            ByteBuffer bb = olf.writeBuf;
            for (int offset = 0; offset < byteLength; offset += bytesThisTime) {
                bytesThisTime = byteLength - offset;
                boolean needsFlush = false;
                if (bytesThisTime > bb.remaining()) {
                    needsFlush = true;
                    bytesThisTime = bb.remaining();
                }
                bb.put(bytes, offset, bytesThisTime);
                if (!needsFlush) continue;
                Oplog.this.flushNoSync(olf);
            }
        }

        private void writeByte(OplogFile olf, byte v) throws IOException {
            ByteBuffer bb = olf.writeBuf;
            if (1 > bb.remaining()) {
                Oplog.this.flushNoSync(olf);
            }
            bb.put(v);
        }

        private void writeOrdinal(OplogFile olf, short ordinal) throws IOException {
            ByteBuffer bb = olf.writeBuf;
            if (3 > bb.remaining()) {
                Oplog.this.flushNoSync(olf);
            }
            Version.writeOrdinal(bb, ordinal, false);
        }

        private void writeInt(OplogFile olf, int v) throws IOException {
            ByteBuffer bb = olf.writeBuf;
            if (4 > bb.remaining()) {
                Oplog.this.flushNoSync(olf);
            }
            bb.putInt(v);
        }

        private void writeLong(OplogFile olf, long v) throws IOException {
            ByteBuffer bb = olf.writeBuf;
            if (8 > bb.remaining()) {
                Oplog.this.flushNoSync(olf);
            }
            bb.putLong(v);
        }

        public void initialize(long newEntryBase) {
            this.opCode = (byte)63;
            this.newEntryBase = newEntryBase;
            this.size = 10;
        }

        public void initialize(short gfversion) {
            this.opCode = (byte)91;
            this.gfversion = gfversion;
            this.size = 5;
        }

        public void initialize(DiskStoreID diskStoreId) {
            this.opCode = (byte)62;
            this.diskStoreId = diskStoreId;
            this.size = 18;
        }

        public void initialize(OPLOG_TYPE magic) {
            this.opCode = (byte)92;
            this.magic = magic;
            this.size = OPLOG_MAGIC_SEQ_REC_SIZE;
        }

        public void initialize(Map<Long, AbstractDiskRegion> drMap, boolean gcRVV) throws IOException {
            this.opCode = (byte)89;
            byte[] rvvBytes = Oplog.this.serializeRVVs(drMap, gcRVV);
            this.value = new DiskEntry.Helper.ByteArrayValueWrapper(true, rvvBytes);
            this.size = 1 + rvvBytes.length + 1;
        }

        public void initialize(long oplogKeyId, byte[] keyBytes, byte[] valueBytes, byte userBits, long drId, VersionTag tag, boolean notToUseUserBits) throws IOException {
            this.opCode = (byte)73;
            this.size = 1;
            this.saveUserBits(notToUseUserBits, userBits);
            this.keyBytes = keyBytes;
            this.value = new DiskEntry.Helper.CompactorValueWrapper(valueBytes, valueBytes.length);
            if (this.userBits == 1 && this.value.getLength() == 0) {
                throw new IllegalStateException("userBits==1 and valueLength is 0");
            }
            this.needsValue = EntryBits.isNeedsValue(this.userBits);
            this.size += 4 + this.keyBytes.length;
            this.saveDrId(drId);
            this.initVersionsBytes(tag);
            if (this.needsValue) {
                this.size += 4 + this.value.getLength();
            }
            this.deltaIdBytesLength = 0;
            long delta = Oplog.this.calcDelta(oplogKeyId, this.opCode);
            this.deltaIdBytesLength = Oplog.bytesNeeded(delta);
            this.size += this.deltaIdBytesLength;
            this.opCode = (byte)(this.opCode + (this.deltaIdBytesLength - 1));
            for (int i = this.deltaIdBytesLength - 1; i >= 0; --i) {
                this.deltaIdBytes[i] = (byte)(delta & 0xFFL);
                delta >>= 8;
            }
            ++this.size;
        }

        private void initVersionsBytes(VersionTag tag) throws IOException {
            if (EntryBits.isWithVersions(this.userBits)) {
                this.versionsBytes = Oplog.this.serializeVersionTag(tag);
                this.size += this.versionsBytes.length;
            }
        }

        private void initVersionsBytes(DiskEntry entry) throws IOException {
            VersionStamp stamp = entry.getVersionStamp();
            if (EntryBits.isWithVersions(this.userBits)) {
                assert (stamp != null);
                this.versionsBytes = Oplog.this.serializeVersionTag(stamp);
                this.size += this.versionsBytes.length;
            }
        }

        public void initialize(byte opCode, DiskRegionView dr, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, byte userBits, boolean notToUseUserBits) throws IOException {
            this.opCode = opCode;
            this.size = 1;
            this.saveUserBits(notToUseUserBits, userBits);
            this.value = value;
            if (this.userBits == 1 && this.value.getLength() == 0) {
                throw new IllegalStateException("userBits==1 and valueLength is 0");
            }
            boolean needsKey = false;
            if (this.opCode == 65) {
                if (Oplog.this.modNeedsKey(entry)) {
                    needsKey = true;
                    this.opCode = (byte)73;
                }
                this.needsValue = EntryBits.isNeedsValue(this.userBits);
                this.initVersionsBytes(entry);
            } else if (this.opCode == 64) {
                needsKey = true;
                this.needsValue = EntryBits.isNeedsValue(this.userBits);
                this.initVersionsBytes(entry);
            } else if (this.opCode == 81) {
                needsKey = false;
                this.needsValue = false;
            }
            if (needsKey) {
                Object key = entry.getKey();
                this.keyBytes = EntryEventImpl.serialize(key);
                this.size += 4 + this.keyBytes.length;
            } else {
                this.keyBytes = null;
            }
            if (this.opCode == 81) {
                this.drIdLength = 0;
            } else {
                long drId = dr.getId();
                this.saveDrId(drId);
            }
            if (this.needsValue) {
                this.size += 4 + this.value.getLength();
            }
            this.deltaIdBytesLength = 0;
            if (this.opCode != 64) {
                long keyId = entry.getDiskId().getKeyId();
                if (keyId == 0L) {
                    Assert.fail("Attempting to write an entry with keyId=0 to oplog. Entry key=" + entry.getKey() + " diskId=" + entry.getDiskId() + " region=" + dr);
                }
                long delta = Oplog.this.calcDelta(keyId, this.opCode);
                this.deltaIdBytesLength = Oplog.bytesNeeded(delta);
                this.size += this.deltaIdBytesLength;
                this.opCode = (byte)(this.opCode + (this.deltaIdBytesLength - 1));
                for (int i = this.deltaIdBytesLength - 1; i >= 0; --i) {
                    this.deltaIdBytes[i] = (byte)(delta & 0xFFL);
                    delta >>= 8;
                }
            }
            ++this.size;
        }

        private void saveUserBits(boolean notToUseUserBits, byte userBits) {
            this.notToUseUserBits = notToUseUserBits;
            if (notToUseUserBits) {
                this.userBits = 0;
            } else {
                this.userBits = EntryBits.getPersistentBits(userBits);
                ++this.size;
            }
        }

        private void saveDrId(long drId) {
            if (drId >= 0L && drId <= 255L) {
                this.drIdLength = 1;
                this.drIdBytes[0] = (byte)drId;
            } else {
                int bytesNeeded = Oplog.bytesNeeded(drId);
                this.drIdLength = bytesNeeded + 1;
                this.drIdBytes[0] = bytesNeeded;
                for (int i = bytesNeeded; i >= 1; --i) {
                    this.drIdBytes[i] = (byte)(drId & 0xFFL);
                    drId >>= 8;
                }
            }
            this.size += this.drIdLength;
        }

        public void initialize(byte opCode, long drId, VersionTag tag) throws IOException {
            this.opCode = opCode;
            assert (this.opCode == 90);
            this.size = 1;
            this.saveDrId(drId);
            this.versionsBytes = Oplog.this.serializeVersionTag(tag);
            this.size += this.versionsBytes.length;
            ++this.size;
        }

        public int getValueOffset() {
            if (!this.needsValue) {
                return 0;
            }
            int result = this.deltaIdBytesLength + this.drIdLength + 1 + 4;
            if (!this.notToUseUserBits) {
                ++result;
            }
            if (EntryBits.isWithVersions(this.userBits) && this.versionsBytes != null) {
                result += this.versionsBytes.length;
            }
            return result;
        }

        public long write(OplogFile olf) throws IOException {
            long bytesWritten = 0L;
            this.writeByte(olf, this.opCode);
            ++bytesWritten;
            if (this.opCode == 63) {
                this.writeLong(olf, this.newEntryBase);
                bytesWritten += 8L;
            } else if (this.opCode == 62) {
                this.writeLong(olf, this.diskStoreId.getLeastSignificantBits());
                this.writeLong(olf, this.diskStoreId.getMostSignificantBits());
                bytesWritten += 16L;
            } else if (this.opCode == 92) {
                this.write(olf, this.magic.getBytes(), OPLOG_TYPE.getLen());
                bytesWritten += (long)OPLOG_TYPE.getLen();
            } else if (this.opCode == 89) {
                this.write(olf, this.value);
                bytesWritten += (long)this.value.getLength();
            } else if (this.opCode == 91) {
                this.writeOrdinal(olf, this.gfversion);
                ++bytesWritten;
            } else if (this.opCode == 90) {
                if (this.drIdLength > 0) {
                    this.write(olf, this.drIdBytes, this.drIdLength);
                    bytesWritten += (long)this.drIdLength;
                }
                assert (this.versionsBytes.length > 0);
                this.write(olf, this.versionsBytes, this.versionsBytes.length);
                bytesWritten += (long)this.versionsBytes.length;
            } else {
                if (!this.notToUseUserBits) {
                    this.writeByte(olf, this.userBits);
                    ++bytesWritten;
                }
                if (this.deltaIdBytesLength > 0) {
                    this.write(olf, this.deltaIdBytes, this.deltaIdBytesLength);
                    bytesWritten += (long)this.deltaIdBytesLength;
                }
                if (this.drIdLength > 0) {
                    this.write(olf, this.drIdBytes, this.drIdLength);
                    bytesWritten += (long)this.drIdLength;
                }
                if (EntryBits.isWithVersions(this.userBits) && this.versionsBytes != null && this.opCode != 81) {
                    this.write(olf, this.versionsBytes, this.versionsBytes.length);
                    bytesWritten += (long)this.versionsBytes.length;
                }
                if (this.needsValue) {
                    int len = this.value.getLength();
                    this.writeInt(olf, len);
                    bytesWritten += 4L;
                    if (len > 0) {
                        this.write(olf, this.value);
                        bytesWritten += (long)len;
                    }
                }
                if (this.keyBytes != null) {
                    this.writeInt(olf, this.keyBytes.length);
                    bytesWritten += 4L;
                    if (this.keyBytes.length > 0) {
                        this.write(olf, this.keyBytes, this.keyBytes.length);
                        bytesWritten += (long)this.keyBytes.length;
                    }
                }
            }
            this.writeByte(olf, (byte)21);
            return ++bytesWritten;
        }

        public void clear() {
            this.value = null;
            this.keyBytes = null;
            this.notToUseUserBits = false;
            this.versionsBytes = null;
        }
    }

    private static class KRFile {
        public File f;
        FileOutputStream fos;
        BufferedOutputStream bos;
        DataOutputStream dos;
        long lastOffset = 0L;
        int keyNum = 0;

        private KRFile() {
        }
    }

    private static class OplogFile {
        public File f;
        public UninterruptibleRandomAccessFile raf;
        public volatile boolean RAFClosed = true;
        public UninterruptibleFileChannel channel;
        public ByteBuffer writeBuf;
        public long currSize;
        public long bytesFlushed;
        public boolean unpreblown;

        private OplogFile() {
        }
    }

    private static class KRFEntry {
        private final DiskEntry de;
        private final DiskRegionView drv;
        private final long offsetInOplog;
        private VersionHolder versionTag;

        public KRFEntry(DiskRegionView drv, DiskEntry de, VersionHolder tag) {
            this.de = de;
            this.drv = drv;
            DiskId diskId = de.getDiskId();
            this.offsetInOplog = diskId != null ? diskId.getOffsetInOplog() : 0L;
            this.versionTag = tag;
        }

        public DiskEntry getDiskEntry() {
            return this.de;
        }

        public DiskRegionView getDiskRegionView() {
            return this.drv;
        }

        public long getOffsetInOplogForSorting() {
            return this.offsetInOplog;
        }
    }

    public static enum OPLOG_TYPE {
        CRF(new byte[]{71, 70, 67, 82, 70, 49}),
        DRF(new byte[]{71, 70, 68, 82, 70, 49}),
        IRF(new byte[]{71, 70, 73, 82, 70, 49}),
        KRF(new byte[]{71, 70, 75, 82, 70, 49}),
        IF(new byte[]{71, 70, 73, 70, 48, 49});

        private final byte[] bytes;

        private OPLOG_TYPE(byte[] byteSeq) {
            this.bytes = byteSeq;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public static int getLen() {
            return 6;
        }
    }
}

