/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.RemoteOperationMessage;
import org.apache.geode.internal.cache.RemoteOperationMessageWithDirectReply;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.logging.log4j.Logger;

public class RemoteGetMessage
extends RemoteOperationMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private Object cbArg;
    private ClientProxyMembershipID context;

    public RemoteGetMessage() {
    }

    private RemoteGetMessage(InternalDistributedMember recipient, String regionPath, DirectReplyProcessor processor, Object key, Object aCallbackArgument, ClientProxyMembershipID context) {
        super(recipient, regionPath, processor);
        this.key = key;
        this.cbArg = aCallbackArgument;
        this.context = context;
    }

    @Override
    public int getProcessorType() {
        return 74;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.key).append("; callback arg=").append(this.cbArg);
    }

    @Override
    public int getDSFID() {
        return -24;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
        this.cbArg = DataSerializer.readObject(in);
        this.context = (ClientProxyMembershipID)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.key, out);
        DataSerializer.writeObject(this.cbArg, out);
        DataSerializer.writeObject(this.context, out);
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public static RemoteGetResponse send(InternalDistributedMember recipient, LocalRegion r, Object key, Object aCallbackArgument, ClientProxyMembershipID requestingClient) throws RemoteOperationException {
        Assert.assertTrue(recipient != null, "PRDistribuedGetReplyMessage NULL reply message");
        RemoteGetResponse p = new RemoteGetResponse(r.getSystem(), Collections.singleton(recipient), key);
        RemoteGetMessage m = new RemoteGetMessage(recipient, r.getFullPath(), p, key, aCallbackArgument, requestingClient);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.GetMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    public static class RemoteGetResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile GetReplyMessage getReply;
        private volatile boolean returnValueReceived;
        private volatile long start;
        final Object key;

        public RemoteGetResponse(InternalDistributedSystem ds, Set recipients, Object key) {
            super(ds, (Collection)recipients, false);
            this.key = key;
        }

        @Override
        public void process(DistributionMessage msg) {
            if (DistributionStats.enableClockStats) {
                this.start = DistributionStats.getStatTime();
            }
            if (msg instanceof GetReplyMessage) {
                GetReplyMessage reply = (GetReplyMessage)msg;
                if (reply.valueInBytes != null) {
                    this.getReply = reply;
                }
                this.returnValueReceived = true;
            }
            super.process(msg);
        }

        public Object getValue(boolean preferCD) throws RemoteOperationException {
            GetReplyMessage reply = this.getReply;
            try {
                if (reply != null) {
                    if (reply.valueIsByteArray) {
                        return reply.valueInBytes;
                    }
                    if (preferCD) {
                        return CachedDeserializableFactory.create(reply.valueInBytes);
                    }
                    return BlobHelper.deserializeBlob(reply.valueInBytes, reply.remoteVersion, null);
                }
                return null;
            }
            catch (IOException e) {
                throw new RemoteOperationException(LocalizedStrings.GetMessage_UNABLE_TO_DESERIALIZE_VALUE_IOEXCEPTION.toLocalizedString(), e);
            }
            catch (ClassNotFoundException e) {
                throw new RemoteOperationException(LocalizedStrings.GetMessage_UNABLE_TO_DESERIALIZE_VALUE_CLASSNOTFOUNDEXCEPTION.toLocalizedString(), e);
            }
        }

        public Object waitForResponse(boolean preferCD) throws RemoteOperationException {
            try {
                this.waitForCacheException();
                if (DistributionStats.enableClockStats) {
                    this.getDistributionManager().getStats().incReplyHandOffTime(this.start);
                }
            }
            catch (RemoteOperationException e) {
                e.checkKey(this.key);
                String msg = "RemoteGetResponse got RemoteOperationException; rethrowing";
                logger.debug("RemoteGetResponse got RemoteOperationException; rethrowing", (Throwable)e);
                throw e;
            }
            catch (TransactionDataNotColocatedException e) {
                throw e;
            }
            if (!this.returnValueReceived) {
                throw new RemoteOperationException(LocalizedStrings.GetMessage_NO_RETURN_VALUE_RECEIVED.toLocalizedString());
            }
            return this.getValue(preferCD);
        }
    }

    public static class GetReplyMessage
    extends ReplyMessage {
        private transient BucketRegion.RawValue rawVal;
        public boolean valueIsByteArray;
        public transient byte[] valueInBytes;
        public transient Version remoteVersion;

        public GetReplyMessage() {
        }

        private GetReplyMessage(int processorId, BucketRegion.RawValue val) {
            this.setProcessorId(processorId);
            this.rawVal = val;
            this.valueIsByteArray = val.isValueByteArray();
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public static void send(InternalDistributedMember recipient, int processorId, BucketRegion.RawValue val, ReplySender replySender) throws RemoteOperationException {
            Assert.assertTrue(recipient != null, "PRDistribuedGetReplyMessage NULL reply message");
            GetReplyMessage m = new GetReplyMessage(processorId, val);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.DM);
            long startTime = this.getTimestamp();
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM, "GetReplyMessage process invoking reply processor with processorId:{}", (Object)this.processorId);
            }
            if (processor == null) {
                if (isDebugEnabled) {
                    logger.trace(LogMarker.DM, "GetReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM, "{} Processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -25;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeByte(this.valueIsByteArray ? 1 : 0);
            this.rawVal.writeAsByteArray(out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.valueIsByteArray = in.readByte() == 1;
            this.valueInBytes = DataSerializer.readByteArray(in);
            if (!this.valueIsByteArray) {
                this.remoteVersion = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            }
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GetReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning serialized value=").append(this.rawVal);
            return sb.toString();
        }
    }
}

