/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.RemoteOperationMessage;
import org.apache.geode.internal.cache.RemoteOperationMessageWithDirectReply;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class RemoteRegionOperation
extends RemoteOperationMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private transient DistributedRegion region;
    private Operation op;

    public RemoteRegionOperation() {
    }

    public static RemoteRegionOperation clear(InternalDistributedMember recipient, DistributedRegion region) {
        return new RemoteRegionOperation(recipient, region, Operation.CLEAR);
    }

    private RemoteRegionOperation(InternalDistributedMember recipient, DistributedRegion region, Operation op) {
        super(recipient, region.getFullPath(), (DirectReplyProcessor)new RemoteOperationMessage.RemoteOperationResponse(region.getSystem(), Collections.singleton(recipient)));
        this.op = op;
        this.region = region;
    }

    public void distribute() throws RemoteOperationException {
        RemoteOperationMessage.RemoteOperationResponse p = (RemoteOperationMessage.RemoteOperationResponse)this.processor;
        Set failures = this.region.getDistributionManager().putOutgoing(this);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.FAILED_SENDING_0.toLocalizedString(this));
        }
        p.waitForCacheException();
    }

    @Override
    protected boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws CacheException, RemoteOperationException {
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "DistributedRemoteRegionOperation operateOnRegion: {}", (Object)r.getFullPath());
        }
        if (!(r instanceof PartitionedRegion)) {
            r.waitOnInitialization();
        }
        if (this.op.equals((Object)Operation.CLEAR)) {
            r.clear();
        }
        RemoteRegionOperationReplyMessage.send(this.getSender(), this.getProcessorId(), this.getReplySender(dm));
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; operation=").append((Object)this.op);
    }

    @Override
    public int getDSFID() {
        return -131;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.op = Operation.values()[in.readByte()];
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeByte(this.op.ordinal());
    }

    public static class RemoteRegionOperationReplyMessage
    extends ReplyMessage {
        public RemoteRegionOperationReplyMessage() {
        }

        private RemoteRegionOperationReplyMessage(int processorId) {
            this.processorId = processorId;
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender replySender) {
            Assert.assertTrue(recipient != null, "RemoteRegionOperationReplyMessage NULL reply message");
            RemoteRegionOperationReplyMessage m = new RemoteRegionOperationReplyMessage(processorId);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "RemoteRegionOperationReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -132;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("RemoteRegionOperationReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }
    }

    private static enum Operation {
        CLEAR;

    }
}

