/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RoleEvent;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.Role;
import org.apache.geode.distributed.internal.membership.InternalRole;
import org.apache.geode.internal.cache.RegionEventImpl;

public class RoleEventImpl
extends RegionEventImpl
implements RoleEvent,
DataSerializable {
    private static final long serialVersionUID = 1306615015229258945L;
    private Set requiredRoles;

    public RoleEventImpl() {
    }

    RoleEventImpl(Region region, Operation op, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, Set requiredRoles) {
        super(region, op, callbackArgument, originRemote, distributedMember);
        this.requiredRoles = Collections.unmodifiableSet(requiredRoles);
    }

    public Set getRequiredRoles() {
        return this.requiredRoles;
    }

    @Override
    public int getDSFID() {
        return 19;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        String[] requiredRoleNames = new String[this.requiredRoles.size()];
        Iterator iter = this.requiredRoles.iterator();
        for (int i = 0; i < requiredRoleNames.length; ++i) {
            Role role = (Role)iter.next();
            requiredRoleNames[i] = role.getName();
        }
        DataSerializer.writeStringArray(requiredRoleNames, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        String[] requiredRoleNames = DataSerializer.readStringArray(in);
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>(requiredRoleNames.length);
        for (int i = 0; i < requiredRoleNames.length; ++i) {
            InternalRole role = InternalRole.getRole(requiredRoleNames[i]);
            requiredRolesSet.add(role);
        }
        this.requiredRoles = Collections.unmodifiableSet(requiredRolesSet);
    }
}

