/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.VMStatsLRURegionEntryOffHeap;
import org.apache.geode.internal.cache.lru.EnableLRU;
import org.apache.geode.internal.cache.lru.LRUClockNode;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMStatsLRURegionEntryOffHeapIntKey
extends VMStatsLRURegionEntryOffHeap {
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> next;
    private volatile long lastModified;
    private static final AtomicLongFieldUpdater<VMStatsLRURegionEntryOffHeapIntKey> lastModifiedUpdater = AtomicLongFieldUpdater.newUpdater(VMStatsLRURegionEntryOffHeapIntKey.class, "lastModified");
    private volatile long ohAddress;
    private static final AtomicLongFieldUpdater<VMStatsLRURegionEntryOffHeapIntKey> ohAddrUpdater = AtomicLongFieldUpdater.newUpdater(VMStatsLRURegionEntryOffHeapIntKey.class, "ohAddress");
    private LRUClockNode nextLRU;
    private LRUClockNode prevLRU;
    private int size;
    private volatile long lastAccessed;
    private volatile int hitCount;
    private volatile int missCount;
    private static final AtomicIntegerFieldUpdater<VMStatsLRURegionEntryOffHeapIntKey> hitCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VMStatsLRURegionEntryOffHeapIntKey.class, "hitCount");
    private static final AtomicIntegerFieldUpdater<VMStatsLRURegionEntryOffHeapIntKey> missCountUpdater = AtomicIntegerFieldUpdater.newUpdater(VMStatsLRURegionEntryOffHeapIntKey.class, "missCount");
    private final int key;

    public VMStatsLRURegionEntryOffHeapIntKey(RegionEntryContext context, int key, Object value) {
        super(context, value);
        this.key = key;
    }

    @Override
    public Token getValueAsToken() {
        return OffHeapRegionEntryHelper.getValueAsToken(this);
    }

    @Override
    protected Object getValueField() {
        return OffHeapRegionEntryHelper._getValue(this);
    }

    @Override
    protected void setValueField(Object v) {
        OffHeapRegionEntryHelper.setValue(this, v);
    }

    @Override
    public Object _getValueRetain(RegionEntryContext context, boolean decompress) {
        return OffHeapRegionEntryHelper._getValueRetain(this, decompress, context);
    }

    @Override
    public long getAddress() {
        return ohAddrUpdater.get(this);
    }

    @Override
    public boolean setAddress(long expectedAddr, long newAddr) {
        return ohAddrUpdater.compareAndSet(this, expectedAddr, newAddr);
    }

    @Override
    public void release() {
        OffHeapRegionEntryHelper.releaseEntry(this);
    }

    @Override
    public void returnToPool() {
    }

    @Override
    protected long getLastModifiedField() {
        return lastModifiedUpdater.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return lastModifiedUpdater.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int v) {
        this.hash = v;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.next;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> n) {
        this.next = n;
    }

    @Override
    public void setDelayedDiskId(LocalRegion r) {
    }

    @Override
    public synchronized int updateEntrySize(EnableLRU capacityController) {
        return this.updateEntrySize(capacityController, this._getValue());
    }

    @Override
    public synchronized int updateEntrySize(EnableLRU capacityController, Object value) {
        int oldSize = this.getEntrySize();
        int newSize = capacityController.entrySize(this.getKeyForSizing(), value);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public boolean testRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public void setRecentlyUsed() {
        this.setBits(0x1000000000000000L);
    }

    @Override
    public void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public boolean testEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public void setNextLRUNode(LRUClockNode next) {
        this.nextLRU = next;
    }

    @Override
    public LRUClockNode nextLRUNode() {
        return this.nextLRU;
    }

    @Override
    public void setPrevLRUNode(LRUClockNode prev) {
        this.prevLRU = prev;
    }

    @Override
    public LRUClockNode prevLRUNode() {
        return this.prevLRU;
    }

    @Override
    public int getEntrySize() {
        return this.size;
    }

    protected void setEntrySize(int size) {
        this.size = size;
    }

    @Override
    public Object getKeyForSizing() {
        return null;
    }

    @Override
    public void updateStatsForGet(boolean hit, long time) {
        this.setLastAccessed(time);
        if (hit) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
    }

    @Override
    protected void setLastModifiedAndAccessedTimes(long lastModified, long lastAccessed) {
        this._setLastModified(lastModified);
        if (!DISABLE_ACCESS_TIME_UPDATE_ON_PUT) {
            this.setLastAccessed(lastAccessed);
        }
    }

    @Override
    public long getLastAccessed() throws InternalStatisticsDisabledException {
        return this.lastAccessed;
    }

    private void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    @Override
    public long getHitCount() throws InternalStatisticsDisabledException {
        return (long)this.hitCount & 0xFFFFFFFFL;
    }

    @Override
    public long getMissCount() throws InternalStatisticsDisabledException {
        return (long)this.missCount & 0xFFFFFFFFL;
    }

    private void incrementHitCount() {
        hitCountUpdater.incrementAndGet(this);
    }

    private void incrementMissCount() {
        missCountUpdater.incrementAndGet(this);
    }

    @Override
    public void resetCounts() throws InternalStatisticsDisabledException {
        hitCountUpdater.set(this, 0);
        missCountUpdater.set(this, 0);
    }

    @Override
    public void txDidDestroy(long currTime) {
        this.setLastModified(currTime);
        this.setLastAccessed(currTime);
        this.hitCount = 0;
        this.missCount = 0;
    }

    @Override
    public boolean hasStats() {
        return true;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public boolean isKeyEqual(Object k) {
        if (k instanceof Integer) {
            return (Integer)k == this.key;
        }
        return false;
    }
}

