/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.FunctionRemoteContext;
import org.apache.geode.internal.cache.execute.FunctionStreamingResultCollector;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionResultSender;
import org.apache.geode.internal.cache.execute.StreamingFunctionOperation;
import org.apache.geode.internal.cache.partitioned.PRFunctionStreamingResultCollector;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionFunctionStreamingMessage;

public class PartitionedRegionFunctionResultWaiter
extends StreamingFunctionOperation {
    private ResultCollector reply;
    private final int regionId;
    private Set<InternalDistributedMember> recipients = null;

    public PartitionedRegionFunctionResultWaiter(InternalDistributedSystem sys, int regionId, ResultCollector rc, Function function, PartitionedRegionFunctionResultSender sender) {
        super(sys, rc, function, sender);
        this.regionId = regionId;
    }

    @Override
    public DistributionMessage createRequestMessage(Set<InternalDistributedMember> singleton, FunctionStreamingResultCollector processor, boolean isReExecute, boolean isFnSerializationReqd) {
        return null;
    }

    public ResultCollector getPartitionedDataFrom(Map<InternalDistributedMember, FunctionRemoteContext> recipMap, PartitionedRegion pr, AbstractExecution execution) {
        if (recipMap.isEmpty()) {
            return this.rc;
        }
        HashSet<InternalDistributedMember> recipientsSet = new HashSet<InternalDistributedMember>();
        for (InternalDistributedMember member : recipMap.keySet()) {
            recipientsSet.add(member);
        }
        this.recipients = recipientsSet;
        PRFunctionStreamingResultCollector processor = new PRFunctionStreamingResultCollector(this, this.sys, recipientsSet, this.rc, this.functionObject, pr, execution);
        this.reply = processor;
        for (Map.Entry<InternalDistributedMember, FunctionRemoteContext> entry : recipMap.entrySet()) {
            FunctionRemoteContext context = entry.getValue();
            DistributionMessage m = this.createRequestMessage(entry.getKey(), processor, context);
            this.sys.getDistributionManager().putOutgoing(m);
        }
        return processor;
    }

    protected DistributionMessage createRequestMessage(InternalDistributedMember recipient, ReplyProcessor21 processor, FunctionRemoteContext context) {
        PartitionedRegionFunctionStreamingMessage msg = new PartitionedRegionFunctionStreamingMessage(recipient, this.regionId, processor, context);
        return msg;
    }

    @Override
    public void processData(Object result, boolean lastMsg, DistributedMember memberID) {
        boolean completelyDone = false;
        if (lastMsg) {
            ++this.totalLastMsgRecieved;
        }
        if (this.totalLastMsgRecieved == this.recipients.size()) {
            completelyDone = true;
        }
        ((PartitionedRegionFunctionResultSender)this.resultSender).lastResult(result, completelyDone, this.reply, memberID);
    }
}

