/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute.util;

import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.internal.RestAgent;

public class FindRestEnabledServersFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 7851518767859544678L;
    public static final String FIND_REST_ENABLED_SERVERS_FUNCTION_ID = FindRestEnabledServersFunction.class.getName();

    public void execute(FunctionContext context) {
        try {
            String protocolType;
            InternalCache cache = (InternalCache)CacheFactory.getAnyInstance();
            DistributionConfig config = InternalDistributedSystem.getAnyInstance().getConfig();
            String bindAddress = RestAgent.getBindAddressForHttpService(config);
            String string = protocolType = config.getHttpServiceSSLEnabled() ? "https" : "http";
            if (cache.isRESTServiceRunning()) {
                context.getResultSender().lastResult(protocolType + "://" + bindAddress + ":" + config.getHttpServicePort());
            } else {
                context.getResultSender().lastResult("");
            }
        }
        catch (CacheClosedException ex) {
            context.getResultSender().lastResult("");
        }
    }

    @Override
    public String getId() {
        return FIND_REST_ENABLED_SERVERS_FUNCTION_ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

