/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.lru;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.CacheCallback;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.lru.EnableLRU;
import org.apache.geode.internal.cache.lru.LRUStatistics;
import org.apache.geode.internal.i18n.LocalizedStrings;

public abstract class LRUAlgorithm
implements CacheCallback,
Serializable,
Cloneable {
    public static final String EVICTION_ACTION = "eviction-action";
    protected EvictionAction evictionAction;
    protected transient LRUStatistics stats;
    private transient EnableLRU helper;
    protected BucketRegion bucketRegion;

    protected LRUAlgorithm(EvictionAction evictionAction, Region region) {
        this.bucketRegion = (BucketRegion)(region instanceof BucketRegion ? region : null);
        this.setEvictionAction(evictionAction);
        this.helper = this.createLRUHelper();
    }

    public void setBucketRegion(Region r) {
        if (r instanceof BucketRegion) {
            this.bucketRegion = (BucketRegion)r;
            this.bucketRegion.setLimit(this.getLimit());
        }
    }

    protected void setEvictionAction(EvictionAction evictionAction) {
        this.evictionAction = evictionAction;
    }

    public EvictionAction getEvictionAction() {
        return this.evictionAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnableLRU getLRUHelper() {
        LRUAlgorithm lRUAlgorithm = this;
        synchronized (lRUAlgorithm) {
            return this.helper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        LRUAlgorithm lRUAlgorithm = this;
        synchronized (lRUAlgorithm) {
            out.writeObject(this.evictionAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LRUAlgorithm lRUAlgorithm = this;
        synchronized (lRUAlgorithm) {
            this.evictionAction = (EvictionAction)in.readObject();
            this.helper = this.createLRUHelper();
        }
    }

    protected abstract EnableLRU createLRUHelper();

    public abstract long getLimit();

    public abstract void setLimit(int var1);

    public abstract Properties getProperties();

    @Override
    public void close() {
        if (this.stats != null) {
            if (this.bucketRegion != null) {
                this.stats.incEvictions(this.bucketRegion.getEvictions() * -1L);
                this.stats.decrementCounter(this.bucketRegion.getCounter());
                this.bucketRegion.close();
            } else {
                this.stats.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        LRUAlgorithm lRUAlgorithm = this;
        synchronized (lRUAlgorithm) {
            LRUAlgorithm clone = (LRUAlgorithm)super.clone();
            clone.stats = null;
            LRUAlgorithm lRUAlgorithm2 = clone;
            synchronized (lRUAlgorithm2) {
                clone.helper = clone.createLRUHelper();
            }
            return clone;
        }
    }

    public boolean equals(Object cc) {
        if (cc == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(cc.getClass())) {
            return false;
        }
        LRUAlgorithm other = (LRUAlgorithm)cc;
        return other.evictionAction.equals(this.evictionAction);
    }

    public int hashCode() {
        return this.evictionAction.hashCode();
    }

    public abstract String toString();

    protected abstract class AbstractEnableLRU
    implements EnableLRU {
        private volatile transient String regionName;

        protected AbstractEnableLRU() {
        }

        @Override
        public long limit() {
            if (LRUAlgorithm.this.stats == null) {
                throw new InternalGemFireException(LocalizedStrings.LRUAlgorithm_LRU_STATS_IN_EVICTION_CONTROLLER_INSTANCE_SHOULD_NOT_BE_NULL.toLocalizedString());
            }
            if (LRUAlgorithm.this.bucketRegion != null) {
                return LRUAlgorithm.this.bucketRegion.getLimit();
            }
            return LRUAlgorithm.this.stats.getLimit();
        }

        public String getRegionName() {
            return this.regionName;
        }

        public void setRegionName(Object region) {
            String fullPathName;
            if (region instanceof Region) {
                fullPathName = ((Region)region).getFullPath();
            } else if (region instanceof PlaceHolderDiskRegion) {
                PlaceHolderDiskRegion phdr = (PlaceHolderDiskRegion)region;
                fullPathName = phdr.isBucket() ? phdr.getPrName() : phdr.getName();
            } else {
                throw new IllegalStateException("expected Region or PlaceHolderDiskRegion");
            }
            if (this.regionName != null && !this.regionName.equals(fullPathName)) {
                throw new IllegalArgumentException(LocalizedStrings.LRUAlgorithm_LRU_EVICTION_CONTROLLER_0_ALREADY_CONTROLS_THE_CAPACITY_OF_1_IT_CANNOT_ALSO_CONTROL_THE_CAPACITY_OF_REGION_2.toLocalizedString(LRUAlgorithm.this, this.regionName, fullPathName));
            }
            this.regionName = fullPathName;
        }

        protected void setStats(LRUStatistics stats) {
            LRUAlgorithm.this.stats = stats;
        }

        @Override
        public LRUStatistics initStats(Object region, StatisticsFactory sf) {
            this.setRegionName(region);
            LRUStatistics stats = new LRUStatistics(sf, this.getRegionName(), this);
            stats.setLimit(LRUAlgorithm.this.getLimit());
            stats.setDestroysLimit(1000L);
            this.setStats(stats);
            return stats;
        }

        @Override
        public LRUStatistics getStats() {
            return LRUAlgorithm.this.stats;
        }

        @Override
        public EvictionAction getEvictionAction() {
            return LRUAlgorithm.this.evictionAction;
        }

        @Override
        public void afterEviction() {
        }
    }
}

