/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class DestroyRegionOnDataStoreMessage
extends PartitionMessage {
    private Object callbackArg;

    public DestroyRegionOnDataStoreMessage() {
    }

    private DestroyRegionOnDataStoreMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 rp, Object callbackArg) {
        super(recipient, regionId, rp);
        this.callbackArg = callbackArg;
    }

    public static void send(InternalDistributedMember recipient, PartitionedRegion r, Object callbackArg) {
        DM dm = r.getDistributionManager();
        ReplyProcessor21 rp = new ReplyProcessor21(dm, recipient);
        int procId = rp.getProcessorId();
        DestroyRegionOnDataStoreMessage m = new DestroyRegionOnDataStoreMessage(recipient, r.getPRId(), rp, callbackArg);
        r.getDistributionManager().putOutgoing(m);
        rp.waitForRepliesUninterruptibly();
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException {
        if (pr == null || !pr.isInitialized()) {
            return true;
        }
        Logger logger = pr.getLogger();
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace("DestroyRegionOnDataStore operateOnRegion: " + pr.getFullPath());
        }
        pr.destroyRegion(this.callbackArg);
        return true;
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    @Override
    public int getDSFID() {
        return 2165;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.callbackArg = DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.callbackArg, out);
    }
}

