/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.TransactionMessage;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class PartitionMessage
extends DistributionMessage
implements MessageWithReply,
TransactionMessage {
    private static final Logger logger = LogService.getLogger();
    static final ForceReattemptException UNHANDLED_EXCEPTION = (ForceReattemptException)new ForceReattemptException(LocalizedStrings.PartitionMessage_UNKNOWN_EXCEPTION.toLocalizedString()).fillInStackTrace();
    int regionId;
    int processorId;
    boolean notificationOnly;
    protected short flags = 0;
    protected static final short NOTIFICATION_ONLY = 64;
    protected static final short IF_NEW = 128;
    protected static final short IF_OLD = 256;
    protected static final short REQUIRED_OLD_VAL = 512;
    protected static final short HAS_FILTER_INFO = 1024;
    protected static final short HAS_DELTA = 2048;
    protected static final short UNRESERVED_FLAGS_START = 4096;
    private InternalDistributedMember txMemberId = null;
    private int txUniqId = -1;
    protected boolean sendDeltaWithFullValue = true;
    protected boolean isTransactionDistributed = false;
    public static final String PN_TOKEN = ".cache.";

    public PartitionMessage() {
    }

    public PartitionMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor) {
        Assert.assertTrue(recipient != null, "PartitionMesssage recipient can not be null");
        this.setRecipient(recipient);
        this.regionId = regionId;
        int n = this.processorId = processor == null ? 0 : processor.getProcessorId();
        if (processor != null && this.isSevereAlertCompatible()) {
            processor.enableSevereAlertProcessing();
        }
        this.initTxMemberId();
        this.setIfTransactionDistributed();
    }

    public PartitionMessage(Collection<InternalDistributedMember> recipients, int regionId, ReplyProcessor21 processor) {
        this.setRecipients(recipients);
        this.regionId = regionId;
        int n = this.processorId = processor == null ? 0 : processor.getProcessorId();
        if (processor != null && this.isSevereAlertCompatible()) {
            processor.enableSevereAlertProcessing();
        }
        this.initTxMemberId();
        this.setIfTransactionDistributed();
    }

    public void initTxMemberId() {
        this.txUniqId = TXManagerImpl.getCurrentTXUniqueId();
        TXStateProxy txState = TXManagerImpl.getCurrentTXState();
        if (txState != null) {
            if (this.canStartRemoteTransaction() && txState.isRealDealLocal() && !txState.isDistTx()) {
                throw new IllegalStateException("Sending remote txId even though transaction is local. This should never happen: txState=" + txState);
            }
            this.txMemberId = txState.getTxId().getMemberId();
        }
    }

    public PartitionMessage(PartitionMessage other) {
        this.regionId = other.regionId;
        this.processorId = other.processorId;
        this.notificationOnly = other.notificationOnly;
        this.txUniqId = other.getTXUniqId();
        this.txMemberId = other.getTXOriginatorClient();
        this.isTransactionDistributed = other.isTransactionDistributed;
    }

    @Override
    public InternalDistributedMember getTXOriginatorClient() {
        return this.txMemberId;
    }

    @Override
    public InternalDistributedMember getMemberToMasqueradeAs() {
        if (this.txMemberId == null) {
            return this.getSender();
        }
        return this.txMemberId;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    public int getProcessorType() {
        if (this.notificationOnly) {
            return 74;
        }
        return 78;
    }

    public int getRegionId() {
        return this.regionId;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    public void registerProcessor(int processorId1) {
        this.processorId = processorId1;
    }

    public PartitionMessage getMessageForRelayToListeners(EntryEventImpl event, Set recipients) {
        return null;
    }

    public boolean checkCacheClosing(DistributionManager dm) {
        InternalCache cache = this.getInternalCache();
        return cache == null || cache.isClosed();
    }

    public boolean checkDSClosing(DistributionManager dm) {
        InternalDistributedSystem ds = dm.getSystem();
        return ds == null || ds.isDisconnecting();
    }

    PartitionedRegion getPartitionedRegion() throws PRLocallyDestroyedException {
        return PartitionedRegion.getPRFromId(this.regionId);
    }

    InternalCache getInternalCache() {
        return GemFireCacheImpl.getInstance();
    }

    TXManagerImpl getTXManagerImpl(InternalCache cache) {
        return cache.getTxManager();
    }

    long getStartPartitionMessageProcessingTime(PartitionedRegion pr) {
        return pr.getPrStats().startPartitionMessageProcessing();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void process(DistributionManager dm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, PartitionedRegion pr, long startTime) {
        if (pr != null && startTime > 0L) {
            pr.getPrStats().endPartitionMessagesProcessing(startTime);
        }
        ReplyMessage.send(member, procId, ex, this.getReplySender(dm), pr != null && pr.isInternalRegion());
    }

    protected boolean failIfRegionMissing() {
        return true;
    }

    public Set relayToListeners(Set cacheOpRecipients, Set adjunctRecipients, FilterRoutingInfo filterRoutingInfo, EntryEventImpl event, PartitionedRegion r, DirectReplyProcessor processor) {
        this.processorId = processor == null ? 0 : processor.getProcessorId();
        this.notificationOnly = true;
        this.setFilterInfo(filterRoutingInfo);
        Set failures1 = null;
        if (!adjunctRecipients.isEmpty()) {
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "Relaying partition message to other processes for listener notification");
            }
            this.resetRecipients();
            this.setRecipients(adjunctRecipients);
            failures1 = r.getDistributionManager().putOutgoing(this);
        }
        return failures1;
    }

    PartitionResponse createReplyProcessor(PartitionedRegion r, Set recipients) {
        return new PartitionResponse(r.getSystem(), recipients);
    }

    protected boolean operateOnRegion(DistributionManager dm, PartitionedRegion pr) {
        throw new InternalGemFireError(LocalizedStrings.PartitionMessage_SORRY_USE_OPERATEONPARTITIONEDREGION_FOR_PR_MESSAGES.toLocalizedString());
    }

    protected abstract boolean operateOnPartitionedRegion(DistributionManager var1, PartitionedRegion var2, long var3) throws CacheException, QueryException, DataLocationException, InterruptedException, IOException;

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.flags = in.readShort();
        this.setBooleans(this.flags, in);
        this.regionId = in.readInt();
        if (InternalDataSerializer.getVersionForDataStream(in).compareTo(Version.GFE_90) >= 0) {
            this.isTransactionDistributed = in.readBoolean();
        }
    }

    protected void setBooleans(short s, DataInput in) throws IOException, ClassNotFoundException {
        if ((s & 1) != 0) {
            this.processorId = in.readInt();
            ReplyProcessor21.setMessageRPId(this.processorId);
        }
        if ((s & 0x40) != 0) {
            this.notificationOnly = true;
        }
        if ((s & 4) != 0) {
            this.txUniqId = in.readInt();
        }
        if ((s & 2) != 0) {
            this.txMemberId = (InternalDistributedMember)DataSerializer.readObject(in);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        short compressedShort = 0;
        compressedShort = this.computeCompressedShort(compressedShort);
        out.writeShort(compressedShort);
        if (this.processorId != 0) {
            out.writeInt(this.processorId);
        }
        if (this.txUniqId != -1) {
            out.writeInt(this.txUniqId);
        }
        if (this.txMemberId != null) {
            DataSerializer.writeObject(this.txMemberId, out);
        }
        out.writeInt(this.regionId);
        if (InternalDataSerializer.getVersionForDataStream(out).compareTo(Version.GFE_90) >= 0) {
            out.writeBoolean(this.isTransactionDistributed);
        }
    }

    protected short computeCompressedShort(short s) {
        if (this.processorId != 0) {
            s = (short)(s | 1);
        }
        if (this.notificationOnly) {
            s = (short)(s | 0x40);
        }
        if (this.getTXUniqId() != -1) {
            s = (short)(s | 4);
            if (this.txMemberId != null) {
                s = (short)(s | 2);
            }
        }
        return s;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        String className = this.getClass().getName();
        buff.append(className.substring(className.indexOf(PN_TOKEN) + PN_TOKEN.length()));
        buff.append("(prid=");
        buff.append(this.regionId);
        String name = null;
        try {
            PartitionedRegion pr = PartitionedRegion.getPRFromId(this.regionId);
            if (pr != null) {
                name = pr.getFullPath();
            }
        }
        catch (Exception ignore) {
            name = null;
        }
        if (name != null) {
            buff.append(" (name = \"").append(name).append("\")");
        }
        this.appendFields(buff);
        buff.append(" ,distTx=");
        buff.append(this.isTransactionDistributed);
        buff.append(")");
        return buff.toString();
    }

    protected void appendFields(StringBuilder buff) {
        buff.append(" processorId=").append(this.processorId);
        if (this.notificationOnly) {
            buff.append(" notificationOnly=").append(this.notificationOnly);
        }
        if (this.txUniqId != -1) {
            buff.append(" txId=").append(this.txUniqId);
        }
        if (this.txMemberId != null) {
            buff.append(" txMemberId=").append(this.txMemberId);
        }
    }

    public InternalDistributedMember getRecipient() {
        return this.getRecipients()[0];
    }

    public void setOperation(Operation op) {
    }

    public void setHasOldValue(boolean value) {
    }

    public void setFilterInfo(FilterRoutingInfo filterInfo) {
    }

    @Override
    public int getTXUniqId() {
        return this.txUniqId;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return false;
    }

    public void setSendDeltaWithFullValue(boolean bool) {
        this.sendDeltaWithFullValue = bool;
    }

    @Override
    public boolean canParticipateInTransaction() {
        return true;
    }

    protected boolean _mayAddToMultipleSerialGateways(DistributionManager dm) {
        try {
            PartitionedRegion pr = PartitionedRegion.getPRFromId(this.regionId);
            if (pr == null) {
                return false;
            }
            return pr.notifiesMultipleSerialGateways();
        }
        catch (PRLocallyDestroyedException ignore) {
            return false;
        }
        catch (RuntimeException ignore) {
            return false;
        }
    }

    @Override
    public boolean isTransactionDistributed() {
        return this.isTransactionDistributed;
    }

    public void setTransactionDistributed(boolean isDistTx) {
        this.isTransactionDistributed = isDistTx;
    }

    private void setIfTransactionDistributed() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && cache.getTxManager() != null) {
            this.isTransactionDistributed = cache.getTxManager().isDistributed();
        }
    }

    public static class PartitionResponse
    extends DirectReplyProcessor {
        volatile ForceReattemptException prce;
        volatile boolean responseReceived;
        boolean responseRequired;

        public PartitionResponse(InternalDistributedSystem dm, Set initMembers) {
            this(dm, initMembers, true);
        }

        public PartitionResponse(InternalDistributedSystem dm, Set initMembers, boolean register) {
            super(dm, (Collection)initMembers);
            if (register) {
                this.register();
            }
        }

        public PartitionResponse(InternalDistributedSystem dm, InternalDistributedMember member) {
            this(dm, member, true);
        }

        public PartitionResponse(InternalDistributedSystem dm, InternalDistributedMember member, boolean register) {
            super(dm, member);
            if (register) {
                this.register();
            }
        }

        public void requireResponse() {
            this.responseRequired = true;
        }

        @Override
        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            if (id != null) {
                if (this.removeMember(id, true)) {
                    this.prce = new ForceReattemptException(LocalizedStrings.PartitionMessage_PARTITIONRESPONSE_GOT_MEMBERDEPARTED_EVENT_FOR_0_CRASHED_1.toLocalizedString(id, crashed));
                }
                this.checkIfDone();
            } else {
                Exception e = new Exception(LocalizedStrings.PartitionMessage_MEMBERDEPARTED_GOT_NULL_MEMBERID.toLocalizedString());
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionMessage_MEMBERDEPARTED_GOT_NULL_MEMBERID_CRASHED_0, crashed), (Throwable)e);
            }
        }

        public void waitForCacheException() throws CacheException, ForceReattemptException, PrimaryBucketException {
            try {
                this.waitForRepliesUninterruptibly();
                if (this.prce != null || this.responseRequired && !this.responseReceived) {
                    throw new ForceReattemptException(LocalizedStrings.PartitionMessage_ATTEMPT_FAILED.toLocalizedString(), this.prce);
                }
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CacheException) {
                    throw (CacheException)t;
                }
                if (t instanceof ForceReattemptException) {
                    ForceReattemptException ft = (ForceReattemptException)t;
                    ForceReattemptException fre = new ForceReattemptException(LocalizedStrings.PartitionMessage_PEER_REQUESTS_REATTEMPT.toLocalizedString(), t);
                    if (ft.hasHash()) {
                        fre.setHash(ft.getHash());
                    }
                    throw fre;
                }
                if (t instanceof PrimaryBucketException) {
                    throw new PrimaryBucketException(LocalizedStrings.PartitionMessage_PEER_FAILED_PRIMARY_TEST.toLocalizedString(), t);
                }
                if (t instanceof CancelException) {
                    logger.debug("PartitionResponse got CacheClosedException from {}, throwing ForceReattemptException", (Object)e.getSender(), (Object)t);
                    throw new ForceReattemptException(LocalizedStrings.PartitionMessage_PARTITIONRESPONSE_GOT_REMOTE_CACHECLOSEDEXCEPTION.toLocalizedString(), t);
                }
                if (t instanceof DiskAccessException) {
                    logger.debug("PartitionResponse got DiskAccessException from {}, throwing ForceReattemptException", (Object)e.getSender(), (Object)t);
                    throw new ForceReattemptException(LocalizedStrings.PartitionMessage_PARTITIONRESPONSE_GOT_REMOTE_CACHECLOSEDEXCEPTION.toLocalizedString(), t);
                }
                if (t instanceof LowMemoryException) {
                    logger.debug("PartitionResponse re-throwing remote LowMemoryException from {}", (Object)e.getSender(), (Object)t);
                    throw (LowMemoryException)t;
                }
                e.handleAsUnexpected();
            }
        }

        @Override
        public void process(DistributionMessage msg) {
            this.responseReceived = true;
            super.process(msg);
        }
    }
}

