/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.geode.internal.cache.persistence.ScriptGenerator;
import org.apache.geode.internal.cache.persistence.UnixScriptGenerator;
import org.apache.geode.internal.cache.persistence.WindowsScriptGenerator;
import org.apache.geode.internal.lang.SystemUtils;

public class RestoreScript {
    static final String INCREMENTAL_MARKER_COMMENT = "Incremental backup.  Restore baseline originals from previous backups.";
    static final String REFUSE_TO_OVERWRITE_MESSAGE = "Backup not restored. Refusing to overwrite ";
    private static final String[] ABOUT_SCRIPT_COMMENT = new String[]{"Restore a backup of gemfire persistent data to the location it was backed up", "from. This script will refuse to restore if the original data still exists.", "This script was automatically generated by the gemfire backup utility."};
    private static final String EXISTENCE_CHECK_COMMENT = "Test for existing originals.  If they exist, do not restore the backup.";
    private static final String RESTORE_DATA_COMMENT = "Restore data";
    private final ScriptGenerator generator;
    private final Map<File, File> baselineFiles = new HashMap<File, File>();
    private final Map<File, File> backedUpFiles = new LinkedHashMap<File, File>();
    private final List<File> existenceTests = new ArrayList<File>();
    private PrintWriter writer;
    private File outputDir;

    public RestoreScript() {
        this(SystemUtils.isWindows() ? new WindowsScriptGenerator() : new UnixScriptGenerator());
    }

    RestoreScript(ScriptGenerator generator) {
        this.generator = generator;
    }

    public void addBaselineFiles(Map<File, File> baselineFiles) {
        this.baselineFiles.putAll(baselineFiles);
    }

    public void addFile(File originalFile, File backupFile) {
        this.backedUpFiles.put(backupFile, originalFile.getAbsoluteFile());
    }

    public void addExistenceTest(File originalFile) {
        this.existenceTests.add(originalFile.getAbsoluteFile());
    }

    public void generate(File outputDir) throws FileNotFoundException {
        this.outputDir = outputDir;
        File outputFile = new File(outputDir, this.generator.getScriptName());
        this.generateScript(outputFile);
    }

    private void generateScript(File outputFile) throws FileNotFoundException {
        this.writer = new PrintWriter(outputFile);
        try {
            this.writePreamble();
            this.writeAbout();
            this.writeExistenceTest();
            this.writeRestoreData();
            this.writeIncrementalData();
            this.generator.writeExit(this.writer);
        }
        finally {
            this.writer.close();
        }
        outputFile.setExecutable(true, true);
    }

    private void writePreamble() {
        this.generator.writePreamble(this.writer);
        this.writer.println();
    }

    private void writeAbout() {
        for (String comment : ABOUT_SCRIPT_COMMENT) {
            this.generator.writeComment(this.writer, comment);
        }
        this.writer.println();
    }

    private void writeExistenceTest() {
        this.generator.writeComment(this.writer, EXISTENCE_CHECK_COMMENT);
        for (File file : this.existenceTests) {
            this.generator.writeExistenceTest(this.writer, file);
        }
        this.writer.println();
    }

    private void writeRestoreData() {
        this.generator.writeComment(this.writer, RESTORE_DATA_COMMENT);
        for (Map.Entry<File, File> entry : this.backedUpFiles.entrySet()) {
            File backup = entry.getKey();
            boolean backupHasFiles = backup.isDirectory() && backup.list().length != 0;
            backup = this.outputDir.toPath().relativize(backup.toPath()).toFile();
            File original = entry.getValue();
            if (original.isDirectory()) {
                this.generator.writeCopyDirectoryContents(this.writer, backup, original, backupHasFiles);
                continue;
            }
            this.generator.writeCopyFile(this.writer, backup, original);
        }
    }

    private void writeIncrementalData() {
        if (this.baselineFiles.isEmpty()) {
            return;
        }
        this.writer.println();
        this.generator.writeComment(this.writer, INCREMENTAL_MARKER_COMMENT);
        for (Map.Entry<File, File> entry : this.baselineFiles.entrySet()) {
            this.generator.writeCopyFile(this.writer, entry.getKey(), entry.getValue());
        }
    }
}

