/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.apache.geode.internal.cache.persistence.BackupInspector;

class UnixBackupInspector
extends BackupInspector {
    private static final String RESTORE_FILE = "restore.sh";

    UnixBackupInspector(File backupDir) throws IOException {
        super(backupDir);
    }

    @Override
    public String getCopyFromForOplogFile(String oplogFileName) {
        String line = (String)this.oplogLineMap.get(oplogFileName);
        if (line == null) {
            return null;
        }
        String[] parts = line.split("\\s");
        return parts[2].substring(1, parts[2].length() - 1);
    }

    @Override
    public String getCopyToForOplogFile(String oplogFileName) {
        String line = (String)this.oplogLineMap.get(oplogFileName);
        if (line == null) {
            return null;
        }
        String[] parts = line.split("\\s");
        return parts[3].substring(1, parts[3].length() - 1);
    }

    @Override
    protected void parseOplogLines(BufferedReader reader) throws IOException {
        String line = null;
        while (null != (line = reader.readLine())) {
            int beginIndex = line.lastIndexOf(File.separator) + 1;
            int endIndex = line.length() - 1;
            String oplogName = line.substring(beginIndex, endIndex);
            this.oplogFileNames.add(oplogName);
            this.oplogLineMap.put(oplogName, line);
        }
    }

    @Override
    protected File getRestoreFile(File backupDir) {
        return new File(backupDir, RESTORE_FILE);
    }
}

