/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.File;
import java.io.PrintWriter;
import org.apache.geode.internal.cache.persistence.ScriptGenerator;

class UnixScriptGenerator
implements ScriptGenerator {
    private static final String SCRIPT_FILE_NAME = "restore.sh";

    UnixScriptGenerator() {
    }

    @Override
    public void writePreamble(PrintWriter writer) {
        writer.println("#!/bin/bash -e");
        writer.println("cd `dirname $0`");
    }

    @Override
    public void writeComment(PrintWriter writer, String string) {
        writer.println("# " + string);
    }

    @Override
    public void writeCopyDirectoryContents(PrintWriter writer, File backup, File original, boolean backupHasFiles) {
        writer.println("mkdir -p '" + original + "'");
        if (backupHasFiles) {
            writer.println("cp -rp '" + backup + "'/* '" + original + "'");
        }
    }

    @Override
    public void writeCopyFile(PrintWriter writer, File backup, File original) {
        writer.println("cp -p '" + backup + "' '" + original + "'");
    }

    @Override
    public void writeExistenceTest(PrintWriter writer, File file) {
        writer.println("test -e '" + file + "' && echo '" + "Backup not restored. Refusing to overwrite " + file + "' && exit 1 ");
    }

    @Override
    public void writeExit(PrintWriter writer) {
    }

    @Override
    public String getScriptName() {
        return SCRIPT_FILE_NAME;
    }
}

