/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.apache.geode.internal.cache.persistence.BackupInspector;

class WindowsBackupInspector
extends BackupInspector {
    private static final String RESTORE_FILE = "restore.bat";

    WindowsBackupInspector(File backupDir) throws IOException {
        super(backupDir);
    }

    @Override
    public String getCopyFromForOplogFile(String oplogFileName) {
        String line = (String)this.oplogLineMap.get(oplogFileName);
        if (line == null) {
            return null;
        }
        String[] parts = line.split("\\s");
        return parts[1].substring(1, parts[1].length() - 1) + File.separator + parts[3];
    }

    @Override
    public String getCopyToForOplogFile(String oplogFileName) {
        String line = (String)this.oplogLineMap.get(oplogFileName);
        if (line == null) {
            return null;
        }
        String[] parts = line.split("\\s");
        return parts[2].substring(1, parts[2].length() - 1) + File.separator + parts[3];
    }

    @Override
    protected void parseOplogLines(BufferedReader reader) throws IOException {
        String line = null;
        String oplogName = "";
        while (null != (line = reader.readLine())) {
            if (line.startsWith("IF")) continue;
            if (line.contains("Exit Functions")) break;
            int beginIndex = line.lastIndexOf("\"") + 1;
            int endIndex = line.indexOf("/njh", beginIndex) - 1;
            oplogName = line.substring(beginIndex, endIndex).trim();
            this.oplogFileNames.add(oplogName);
            this.oplogLineMap.put(oplogName, line);
        }
    }

    @Override
    protected File getRestoreFile(File backupDir) {
        return new File(backupDir, RESTORE_FILE);
    }
}

