/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.File;
import java.io.PrintWriter;
import org.apache.geode.internal.cache.persistence.ScriptGenerator;

class WindowsScriptGenerator
implements ScriptGenerator {
    static final String ROBOCOPY_NO_JOB_HEADER = "/njh";
    static final String EXIT_MARKER = "Exit Functions";
    private static final String ERROR_CHECK = "IF %ERRORLEVEL% GEQ 4 GOTO Exit_Bad";
    private static final String ROBOCOPY_COMMAND = "Robocopy.exe";
    private static final String ROBOCOPY_NO_JOB_SUMMARY = "/njs";
    private static final String ROBOCOPY_COPY_SUBDIRS = "/e";
    private static final String SCRIPT_FILE_NAME = "restore.bat";
    private static final String ECHO_OFF = "echo off";
    private static final String CD_TO_SCRIPT_DIR = "cd %~dp0";
    private static final String MKDIR = "mkdir";
    private static final String EXIT_BLOCK = ":Exit_Good\nexit /B 0\n\n:Exit_Bad\nexit /B 1";

    WindowsScriptGenerator() {
    }

    @Override
    public void writePreamble(PrintWriter writer) {
        writer.println(ECHO_OFF);
        writer.println(CD_TO_SCRIPT_DIR);
    }

    @Override
    public void writeComment(PrintWriter writer, String string) {
        writer.println("rem " + string);
    }

    @Override
    public void writeCopyDirectoryContents(PrintWriter writer, File backup, File original, boolean backupHasFiles) {
        writer.println("mkdir \"" + original + "\"");
        writer.println("Robocopy.exe \"" + backup + "\" \"" + original + "\" " + ROBOCOPY_COPY_SUBDIRS + " " + ROBOCOPY_NO_JOB_HEADER + " " + ROBOCOPY_NO_JOB_SUMMARY);
        writer.println(ERROR_CHECK);
    }

    @Override
    public void writeCopyFile(PrintWriter writer, File source, File destination) {
        String fileName = source.getName();
        String sourcePath = source.getParent() == null ? "." : source.getParent();
        String destinationPath = destination.getParent() == null ? "." : destination.getParent();
        writer.println("Robocopy.exe \"" + sourcePath + "\" \"" + destinationPath + "\" " + fileName + " " + ROBOCOPY_NO_JOB_HEADER + " " + ROBOCOPY_NO_JOB_SUMMARY);
        writer.println(ERROR_CHECK);
    }

    @Override
    public void writeExistenceTest(PrintWriter writer, File file) {
        writer.println("IF EXIST \"" + file + "\" echo \"" + "Backup not restored. Refusing to overwrite " + file + "\" && exit /B 1 ");
    }

    @Override
    public void writeExit(PrintWriter writer) {
        this.writeComment(writer, EXIT_MARKER);
        writer.println(EXIT_BLOCK);
    }

    @Override
    public String getScriptName() {
        return SCRIPT_FILE_NAME;
    }
}

