/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.snapshot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.geode.admin.RegionNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.snapshot.CacheSnapshotService;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.snapshot.GFSnapshot;
import org.apache.geode.internal.cache.snapshot.SnapshotOptionsImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class CacheSnapshotServiceImpl
implements CacheSnapshotService {
    private final InternalCache cache;

    public CacheSnapshotServiceImpl(InternalCache cache) {
        this.cache = cache;
    }

    @Override
    public SnapshotOptions<Object, Object> createOptions() {
        return new SnapshotOptionsImpl<Object, Object>();
    }

    @Override
    public void save(File dir, SnapshotOptions.SnapshotFormat format) throws IOException {
        this.save(dir, format, this.createOptions());
    }

    @Override
    public void save(File dir, SnapshotOptions.SnapshotFormat format, SnapshotOptions<Object, Object> options) throws IOException {
        this.createDirectoryIfNeeded(dir);
        for (Region<?, ?> region : this.cache.rootRegions()) {
            for (Region<?, ?> subRegion : region.subregions(true)) {
                this.saveRegion(subRegion, dir, format, options);
            }
            this.saveRegion(region, dir, format, options);
        }
    }

    private void createDirectoryIfNeeded(File dir) throws IOException {
        boolean created;
        if (!dir.exists() && !(created = dir.mkdirs())) {
            throw new IOException(LocalizedStrings.Snapshot_UNABLE_TO_CREATE_DIR_0.toLocalizedString(dir));
        }
    }

    @Override
    public void load(File dir, SnapshotOptions.SnapshotFormat format) throws IOException, ClassNotFoundException {
        if (!dir.exists() || !dir.isDirectory()) {
            throw new FileNotFoundException("Unable to load snapshot from " + dir.getCanonicalPath() + " as the file does not exist or is not a directory");
        }
        File[] snapshotFiles = this.getSnapshotFiles(dir);
        this.load(snapshotFiles, format, this.createOptions());
    }

    private File[] getSnapshotFiles(File dir) throws IOException {
        File[] snapshotFiles = dir.listFiles(pathname -> pathname.getName().endsWith(".gfd"));
        if (snapshotFiles == null) {
            throw new IOException("Unable to access " + dir.getCanonicalPath());
        }
        if (snapshotFiles.length == 0) {
            throw new FileNotFoundException(LocalizedStrings.Snapshot_NO_SNAPSHOT_FILES_FOUND_0.toLocalizedString(dir));
        }
        return snapshotFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(File[] snapshotFiles, SnapshotOptions.SnapshotFormat format, SnapshotOptions<Object, Object> options) throws IOException, ClassNotFoundException {
        for (File file : snapshotFiles) {
            try (GFSnapshot.GFSnapshotImporter in = new GFSnapshot.GFSnapshotImporter(file);){
                byte version = in.getVersion();
                if (version == 1) {
                    throw new IOException(LocalizedStrings.Snapshot_UNSUPPORTED_SNAPSHOT_VERSION_0.toLocalizedString(version));
                }
                String regionName = in.getRegionName();
                Region region = this.cache.getRegion(regionName);
                if (region == null) {
                    throw new RegionNotFoundException(LocalizedStrings.Snapshot_COULD_NOT_FIND_REGION_0_1.toLocalizedString(regionName, file));
                }
                RegionSnapshotService<Object, Object> rs = region.getSnapshotService();
                rs.load(file, format, options);
            }
        }
    }

    private void saveRegion(Region<?, ?> region, File dir, SnapshotOptions.SnapshotFormat format, SnapshotOptions options) throws IOException {
        RegionSnapshotService<?, ?> regionSnapshotService = region.getSnapshotService();
        String name = "snapshot" + region.getFullPath().replace('/', '-') + ".gfd";
        File f = new File(dir, name);
        regionSnapshotService.save(f, format, options);
    }
}

