/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.snapshot;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.ProxyRegion;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalDataSet;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.snapshot.ClientExporter;
import org.apache.geode.internal.cache.snapshot.GFSnapshot;
import org.apache.geode.internal.cache.snapshot.LocalExporter;
import org.apache.geode.internal.cache.snapshot.SnapshotFileMapper;
import org.apache.geode.internal.cache.snapshot.SnapshotOptionsImpl;
import org.apache.geode.internal.cache.snapshot.SnapshotPacket;
import org.apache.geode.internal.cache.snapshot.WindowedExporter;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.logging.log4j.LogManager;

public class RegionSnapshotServiceImpl<K, V>
implements RegionSnapshotService<K, V> {
    private static final int IMPORT_CONCURRENCY = Integer.getInteger("gemfire.RegionSnapshotServiceImpl.IMPORT_CONCURRENCY", 10);
    static final int BUFFER_SIZE = Integer.getInteger("gemfire.RegionSnapshotServiceImpl.BUFFER_SIZE", 0x100000);
    static final SnapshotFileMapper LOCAL_MAPPER = new SnapshotFileMapper(){
        private static final long serialVersionUID = 1L;

        @Override
        public File mapExportPath(DistributedMember member, File snapshot) {
            return snapshot;
        }

        @Override
        public File[] mapImportPath(DistributedMember member, File snapshot) {
            if (!snapshot.isDirectory()) {
                return new File[]{snapshot};
            }
            return snapshot.listFiles(pathname -> !pathname.isDirectory());
        }
    };
    private final Region<K, V> region;

    public RegionSnapshotServiceImpl(Region<K, V> region) {
        this.region = region;
    }

    @Override
    public SnapshotOptions<K, V> createOptions() {
        return new SnapshotOptionsImpl();
    }

    @Override
    public void save(File snapshot, SnapshotOptions.SnapshotFormat format) throws IOException {
        this.save(snapshot, format, this.createOptions());
    }

    @Override
    public void save(File snapshot, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) throws IOException {
        if (this.region.getCache().getCacheTransactionManager().exists()) {
            throw new IllegalStateException("Unable to save snapshot during a transaction");
        }
        if (this.shouldRunInParallel(options)) {
            this.snapshotInParallel(new ParallelArgs<K, V>(snapshot, format, options), new ParallelExportFunction());
        } else {
            this.exportOnMember(snapshot, format, options);
        }
    }

    @Override
    public void load(File snapshot, SnapshotOptions.SnapshotFormat format) throws IOException, ClassNotFoundException {
        this.load(snapshot, format, this.createOptions());
    }

    @Override
    public void load(File snapshot, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) throws IOException, ClassNotFoundException {
        if (this.shouldRunInParallel(options)) {
            this.snapshotInParallel(new ParallelArgs<K, V>(snapshot, format, options), new ParallelImportFunction());
        } else {
            this.importOnMember(snapshot, format, options);
        }
    }

    private boolean shouldRunInParallel(SnapshotOptions<K, V> options) {
        return options.isParallelMode() && this.region.getAttributes().getDataPolicy().withPartitioning() && !(this.region instanceof LocalDataSet);
    }

    private void snapshotInParallel(ParallelArgs<K, V> args, Function fn) throws IOException {
        try {
            ResultCollector rc = FunctionService.onRegion(this.region).setArguments(args).execute(fn);
            List result = (List)rc.getResult();
            for (Object obj : result) {
                if (!(obj instanceof Exception)) continue;
                throw new IOException((Exception)obj);
            }
            return;
        }
        catch (FunctionException e) {
            throw new IOException(e);
        }
    }

    private void importOnMember(File snapshot, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) throws IOException, ClassNotFoundException {
        LocalRegion local = RegionSnapshotServiceImpl.getLocalRegion(this.region);
        if (InternalDistributedSystem.getLoggerI18n().infoEnabled()) {
            InternalDistributedSystem.getLoggerI18n().info(LocalizedStrings.Snapshot_IMPORT_BEGIN_0, this.region.getName());
        }
        if (snapshot.isDirectory()) {
            File[] snapshots = snapshot.listFiles(f -> f.getName().endsWith(".gfd"));
            if (snapshots == null) {
                throw new IOException("Unable to access " + snapshot.getCanonicalPath());
            }
            if (snapshots.length == 0) {
                throw new IllegalArgumentException("Failure to import snapshot: " + snapshot.getAbsolutePath() + " contains no valid .gfd snapshot files");
            }
            for (File snapshotFile : snapshots) {
                this.importSnapshotFile(snapshotFile, options, local);
            }
        } else if (snapshot.getName().endsWith(".gfd")) {
            this.importSnapshotFile(snapshot, options, local);
        } else {
            throw new IllegalArgumentException("Failure to import snapshot: " + snapshot.getCanonicalPath() + " is not .gfd file or directory containing .gfd files");
        }
    }

    private void importSnapshotFile(File snapshot, SnapshotOptions<K, V> options, LocalRegion local) throws IOException, ClassNotFoundException {
        long count = 0L;
        long bytes = 0L;
        long start = CachePerfStats.getStatTime();
        LinkedList puts = new LinkedList();
        GFSnapshot.GFSnapshotImporter in = new GFSnapshot.GFSnapshotImporter(snapshot);
        try {
            SnapshotPacket.SnapshotRecord record;
            int bufferSize = 0;
            HashMap buffer = new HashMap();
            while ((record = in.readSnapshotRecord()) != null) {
                bytes += (long)record.getSize();
                Object key = record.getKeyObject();
                Object val = Token.INVALID;
                if (record.hasValue()) {
                    byte[] data = record.getValue();
                    val = data.length > 0 && data[0] == 46 ? record.getValueObject() : CachedDeserializableFactory.create(record.getValue());
                }
                if (!this.includeEntry(options, key, val)) continue;
                buffer.put(key, (Token.Invalid)val);
                ++count;
                if ((bufferSize += record.getSize()) <= BUFFER_SIZE) continue;
                if (puts.size() == IMPORT_CONCURRENCY) {
                    ((Future)puts.removeFirst()).get();
                }
                HashMap copy = new HashMap(buffer);
                Future<?> f = GemFireCacheImpl.getExisting("Importing region from snapshot").getDistributionManager().getWaitingThreadPool().submit(() -> local.basicImportPutAll(copy, !options.shouldInvokeCallbacks()));
                puts.addLast(f);
                buffer.clear();
                bufferSize = 0;
            }
            if (!buffer.isEmpty()) {
                local.basicImportPutAll(buffer, !options.shouldInvokeCallbacks());
            }
            while (!puts.isEmpty()) {
                ((Future)puts.removeFirst()).get();
            }
            if (InternalDistributedSystem.getLoggerI18n().infoEnabled()) {
                InternalDistributedSystem.getLoggerI18n().info(LocalizedStrings.Snapshot_IMPORT_END_0_1_2_3, new Object[]{count, bytes, this.region.getName(), snapshot.getAbsolutePath()});
            }
        }
        catch (InterruptedException e) {
            while (!puts.isEmpty()) {
                ((Future)puts.removeFirst()).cancel(true);
            }
            Thread.currentThread().interrupt();
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            while (!puts.isEmpty()) {
                ((Future)puts.removeFirst()).cancel(true);
            }
            throw new IOException(e);
        }
        finally {
            in.close();
            local.getCachePerfStats().endImport(count, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportOnMember(File snapshot, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) throws IOException {
        if (!snapshot.getName().endsWith(".gfd")) {
            throw new IllegalArgumentException("Failure to export snapshot: " + snapshot.getCanonicalPath() + " is not a valid .gfd file");
        }
        File directory = snapshot.getAbsoluteFile().getParentFile();
        if (directory == null) {
            throw new IllegalArgumentException("Failure to export snapshot: " + snapshot.getCanonicalPath() + " is not a valid location");
        }
        directory.mkdirs();
        LocalRegion local = RegionSnapshotServiceImpl.getLocalRegion(this.region);
        Exporter<K, V> exp = RegionSnapshotServiceImpl.createExporter(this.region, options);
        if (InternalDistributedSystem.getLoggerI18n().fineEnabled()) {
            InternalDistributedSystem.getLoggerI18n().fine("Writing to snapshot " + snapshot.getAbsolutePath());
        }
        long count = 0L;
        long start = CachePerfStats.getStatTime();
        GFSnapshot.SnapshotWriter writer = GFSnapshot.create(snapshot, this.region.getFullPath());
        try {
            if (InternalDistributedSystem.getLoggerI18n().infoEnabled()) {
                InternalDistributedSystem.getLoggerI18n().info(LocalizedStrings.Snapshot_EXPORT_BEGIN_0, this.region.getName());
            }
            SnapshotWriterSink sink = new SnapshotWriterSink(writer);
            count = exp.export(this.region, sink, options);
            if (InternalDistributedSystem.getLoggerI18n().infoEnabled()) {
                InternalDistributedSystem.getLoggerI18n().info(LocalizedStrings.Snapshot_EXPORT_END_0_1_2_3, new Object[]{count, sink.getBytesWritten(), this.region.getName(), snapshot.getAbsolutePath()});
            }
        }
        finally {
            writer.snapshotComplete();
            local.getCachePerfStats().endExport(count, start);
        }
    }

    private boolean includeEntry(SnapshotOptions<K, V> options, final K key, final V val) {
        if (options.getFilter() != null) {
            Map.Entry entry = new Map.Entry<K, V>(){

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    if (val instanceof CachedDeserializable) {
                        return ((CachedDeserializable)val).getDeserializedForReading();
                    }
                    return null;
                }
            };
            return options.getFilter().accept(entry);
        }
        return true;
    }

    static <K, V> Exporter<K, V> createExporter(Region<?, ?> region, SnapshotOptions<K, V> options) {
        String pool = region.getAttributes().getPoolName();
        if (pool != null) {
            return new ClientExporter(PoolManager.find(pool));
        }
        if (InternalDistributedSystem.getAnyInstance().isLoner() || region.getAttributes().getDataPolicy().equals(DataPolicy.NORMAL) || region.getAttributes().getDataPolicy().equals(DataPolicy.PRELOADED) || region instanceof LocalDataSet || options.isParallelMode() && region.getAttributes().getDataPolicy().withPartitioning()) {
            return new LocalExporter();
        }
        return new WindowedExporter();
    }

    static LocalRegion getLocalRegion(Region<?, ?> region) {
        if (region instanceof LocalDataSet) {
            return ((LocalDataSet)region).getProxy();
        }
        if (region instanceof ProxyRegion) {
            return (LocalRegion)((ProxyRegion)region).getRealRegion();
        }
        return (LocalRegion)region;
    }

    private static class ParallelImportFunction<K, V>
    implements Function {
        private ParallelImportFunction() {
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        public void execute(FunctionContext context) {
            try {
                Region local = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)context);
                ParallelArgs args = (ParallelArgs)context.getArguments();
                File[] files = args.getOptions().getMapper().mapImportPath(local.getCache().getDistributedSystem().getDistributedMember(), args.getFile());
                if (files != null) {
                    for (File f : files) {
                        if (f.exists()) {
                            local.getSnapshotService().load(f, args.getFormat(), args.getOptions());
                            continue;
                        }
                        LogManager.getLogger(RegionSnapshotServiceImpl.class).info("Nothing to import as location does not exist: " + f.getAbsolutePath());
                    }
                }
                context.getResultSender().lastResult(Boolean.TRUE);
            }
            catch (Exception e) {
                context.getResultSender().sendException(e);
            }
        }

        @Override
        public String getId() {
            return "org.apache.geode.cache.snapshot.ParallelImport";
        }

        @Override
        public boolean optimizeForWrite() {
            return true;
        }

        @Override
        public boolean isHA() {
            return false;
        }
    }

    private static class ParallelExportFunction<K, V>
    implements Function {
        private ParallelExportFunction() {
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        public void execute(FunctionContext context) {
            try {
                Region local = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)context);
                ParallelArgs args = (ParallelArgs)context.getArguments();
                File f = args.getOptions().getMapper().mapExportPath(local.getCache().getDistributedSystem().getDistributedMember(), args.getFile());
                if (f == null || f.isDirectory()) {
                    throw new IOException(LocalizedStrings.Snapshot_INVALID_EXPORT_FILE.toLocalizedString(f));
                }
                local.getSnapshotService().save(f, args.getFormat(), args.getOptions());
                context.getResultSender().lastResult(Boolean.TRUE);
            }
            catch (Exception e) {
                context.getResultSender().sendException(e);
            }
        }

        @Override
        public String getId() {
            return "org.apache.geode.cache.snapshot.ParallelExport";
        }

        @Override
        public boolean optimizeForWrite() {
            return true;
        }

        @Override
        public boolean isHA() {
            return false;
        }
    }

    private static class ParallelArgs<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final File file;
        private final SnapshotOptions.SnapshotFormat format;
        private final SnapshotOptionsImpl<K, V> options;

        public ParallelArgs(File f, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) {
            this.file = f;
            this.format = format;
            this.options = (SnapshotOptionsImpl)options;
        }

        public File getFile() {
            return this.file;
        }

        public SnapshotOptions.SnapshotFormat getFormat() {
            return this.format;
        }

        public SnapshotOptionsImpl<K, V> getOptions() {
            return this.options;
        }
    }

    static class ResultSenderSink
    implements ExportSink {
        private final ResultSender<SnapshotPacket.SnapshotRecord[]> sender;

        public ResultSenderSink(ResultSender<SnapshotPacket.SnapshotRecord[]> sender) {
            this.sender = sender;
        }

        @Override
        public void write(SnapshotPacket.SnapshotRecord ... records) throws IOException {
            this.sender.sendResult(records);
        }
    }

    static class SnapshotWriterSink
    implements ExportSink {
        private final GFSnapshot.SnapshotWriter writer;
        private long bytes;

        public SnapshotWriterSink(GFSnapshot.SnapshotWriter writer) {
            this.writer = writer;
        }

        @Override
        public void write(SnapshotPacket.SnapshotRecord ... records) throws IOException {
            for (SnapshotPacket.SnapshotRecord rec : records) {
                this.writer.snapshotEntry(rec);
                this.bytes += (long)rec.getSize();
            }
        }

        public long getBytesWritten() {
            return this.bytes;
        }
    }

    public static interface Exporter<K, V> {
        public long export(Region<K, V> var1, ExportSink var2, SnapshotOptions<K, V> var3) throws IOException;
    }

    public static interface ExportSink {
        public void write(SnapshotPacket.SnapshotRecord ... var1) throws IOException;
    }
}

