/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier;

public enum CommunicationMode {
    ClientToServer(100, "client"),
    PrimaryServerToClient(101, "primary server to client"),
    SecondaryServerToClient(102, "secondary server to client"),
    GatewayToGateway(103, "gateway"),
    MonitorToServer(104, "monitor"),
    SuccessfulServerToClient(105, "successful server to client"),
    UnsuccessfulServerToClient(106, "unsucessful server to client"),
    ClientToServerForQueue(107, "clientToServerForQueue"),
    ProtobufClientServerProtocol(110, "Protobuf client");

    private byte modeNumber;
    private String description;

    public boolean isClientOperations() {
        return this == ClientToServer || this == ProtobufClientServerProtocol;
    }

    public boolean isClientToServerOrSubscriptionFeed() {
        return this == ClientToServer || this == PrimaryServerToClient || this == SecondaryServerToClient || this == ClientToServerForQueue || this == ProtobufClientServerProtocol;
    }

    public boolean isSubscriptionFeed() {
        return this == PrimaryServerToClient || this == SecondaryServerToClient;
    }

    public boolean isCountedAsClientServerConnection() {
        return this == ClientToServer || this == MonitorToServer || this == ProtobufClientServerProtocol;
    }

    public boolean isWAN() {
        return this == GatewayToGateway;
    }

    public boolean expectsConnectionRefusalMessage() {
        return this != ProtobufClientServerProtocol;
    }

    private CommunicationMode(byte mode, String description) {
        this.modeNumber = mode;
        this.description = description;
    }

    public byte getModeNumber() {
        return this.modeNumber;
    }

    public static boolean isValidMode(int mode) {
        return 100 <= mode && mode <= 110;
    }

    public static CommunicationMode fromModeNumber(byte modeNumber) {
        switch (modeNumber) {
            case 100: {
                return ClientToServer;
            }
            case 101: {
                return PrimaryServerToClient;
            }
            case 102: {
                return SecondaryServerToClient;
            }
            case 103: {
                return GatewayToGateway;
            }
            case 104: {
                return MonitorToServer;
            }
            case 105: {
                return SuccessfulServerToClient;
            }
            case 106: {
                return UnsuccessfulServerToClient;
            }
            case 107: {
                return ClientToServerForQueue;
            }
            case 110: {
                return ProtobufClientServerProtocol;
            }
        }
        throw new IllegalArgumentException("unknown communications mode: " + modeNumber);
    }

    public String toString() {
        return this.description;
    }
}

