/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProtocolProcessor;
import org.apache.geode.internal.cache.tier.sockets.ClientProtocolService;
import org.apache.geode.internal.cache.tier.sockets.ClientProtocolServiceLoader;
import org.apache.geode.internal.cache.tier.sockets.GenericProtocolServerConnection;
import org.apache.geode.internal.cache.tier.sockets.LegacyServerConnection;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.ServiceLoadingFailureException;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.internal.server.Authenticator;

public class ServerConnectionFactory {
    private volatile ClientProtocolService clientProtocolService;
    private Map<String, Class<? extends Authenticator>> authenticators = null;

    private synchronized void initializeAuthenticatorsMap() {
        if (this.authenticators != null) {
            return;
        }
        HashMap<String, Class<? extends Authenticator>> tmp = new HashMap<String, Class<? extends Authenticator>>();
        ServiceLoader<Authenticator> loader = ServiceLoader.load(Authenticator.class);
        for (Authenticator streamAuthenticator : loader) {
            tmp.put(streamAuthenticator.implementationID(), streamAuthenticator.getClass());
        }
        this.authenticators = tmp;
    }

    private synchronized ClientProtocolService initializeClientProtocolService(StatisticsFactory statisticsFactory, String statisticsName) {
        if (this.clientProtocolService != null) {
            return this.clientProtocolService;
        }
        ClientProtocolService tmp = new ClientProtocolServiceLoader().loadService();
        tmp.initializeStatistics(statisticsName, statisticsFactory);
        this.clientProtocolService = tmp;
        return this.clientProtocolService;
    }

    private Authenticator findStreamAuthenticator(String implementationID) {
        Class<? extends Authenticator> streamAuthenticatorClass;
        if (this.authenticators == null) {
            this.initializeAuthenticatorsMap();
        }
        if ((streamAuthenticatorClass = this.authenticators.get(implementationID)) == null) {
            throw new ServiceLoadingFailureException("Could not find implementation for Authenticator with implementation ID " + implementationID);
        }
        try {
            return streamAuthenticatorClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServiceLoadingFailureException("Unable to instantiate authenticator for ID " + implementationID, e);
        }
    }

    private ClientProtocolService getOrCreateClientProtocolService(StatisticsFactory statisticsFactory, String serverName) {
        if (this.clientProtocolService == null) {
            return this.initializeClientProtocolService(statisticsFactory, serverName);
        }
        return this.clientProtocolService;
    }

    public ServerConnection makeServerConnection(Socket socket, InternalCache cache, CachedRegionHelper helper, CacheServerStats stats, int hsTimeout, int socketBufferSize, String communicationModeStr, byte communicationMode, Acceptor acceptor, SecurityService securityService) throws IOException {
        if (communicationMode == CommunicationMode.ProtobufClientServerProtocol.getModeNumber()) {
            if (!Boolean.getBoolean("geode.feature-protobuf-protocol")) {
                throw new IOException("Server received unknown communication mode: " + communicationMode);
            }
            try {
                String authenticationMode = System.getProperty("geode.protocol-authentication-mode", "NOOP");
                return this.createGenericProtocolServerConnection(socket, cache, helper, stats, hsTimeout, socketBufferSize, communicationModeStr, communicationMode, acceptor, securityService, authenticationMode);
            }
            catch (ServiceLoadingFailureException ex) {
                throw new IOException("Could not load protobuf client protocol", ex);
            }
        }
        return new LegacyServerConnection(socket, cache, helper, stats, hsTimeout, socketBufferSize, communicationModeStr, communicationMode, acceptor, securityService);
    }

    private ServerConnection createGenericProtocolServerConnection(Socket socket, InternalCache cache, CachedRegionHelper helper, CacheServerStats stats, int hsTimeout, int socketBufferSize, String communicationModeStr, byte communicationMode, Acceptor acceptor, SecurityService securityService, String authenticationMode) {
        ClientProtocolService service = this.getOrCreateClientProtocolService(cache.getDistributedSystem(), acceptor.getServerName());
        ClientProtocolProcessor processor = service.createProcessorForCache(cache, this.findStreamAuthenticator(authenticationMode), securityService);
        return new GenericProtocolServerConnection(socket, cache, helper, stats, hsTimeout, socketBufferSize, communicationModeStr, communicationMode, acceptor, processor, securityService);
    }
}

