/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.geode.GemFireException;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.TransactionDataNodeHasDepartedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.TransactionInDoubtException;
import org.apache.geode.cache.client.internal.ServerRegionDataAccess;
import org.apache.geode.cache.client.internal.ServerRegionProxy;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXLockRequest;
import org.apache.geode.internal.cache.TXRegionLockRequestImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.TXStateStub;
import org.apache.geode.internal.cache.locks.TXRegionLockRequest;
import org.apache.geode.internal.cache.tx.ClientTXRegionStub;
import org.apache.geode.internal.cache.tx.TXRegionStub;
import org.apache.geode.internal.cache.tx.TransactionalOperation;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class ClientTXStateStub
extends TXStateStub {
    private static final Logger logger = LogService.getLogger();
    private static ThreadLocal<List<TransactionalOperation>> recordedTransactionalOperations = null;
    private final ServerRegionProxy firstProxy;
    private ServerLocation serverAffinityLocation;
    private List<TransactionalOperation> recordedOperations = Collections.synchronizedList(new LinkedList());
    private TXLockRequest lockReq;
    private Runnable internalAfterLocalLocks;
    private static final boolean DISABLE_CONFLICT_CHECK_ON_CLIENT = Boolean.getBoolean("gemfire.disableConflictChecksOnClient");
    private boolean txRolledback = false;

    public static boolean transactionRecordingEnabled() {
        return !DISABLE_CONFLICT_CHECK_ON_CLIENT || recordedTransactionalOperations != null;
    }

    public static void setTransactionalOperationContainer(ThreadLocal<List<TransactionalOperation>> t) {
        recordedTransactionalOperations = t;
    }

    public ClientTXStateStub(TXStateProxy stateProxy, DistributedMember target, LocalRegion firstRegion) {
        super(stateProxy, target);
        this.firstProxy = firstRegion.getServerProxy();
        this.firstProxy.getPool().setupServerAffinity(true);
        if (recordedTransactionalOperations != null) {
            recordedTransactionalOperations.set(this.recordedOperations);
        }
    }

    @Override
    public void commit() throws CommitConflictException {
        this.obtainLocalLocks();
        try {
            TXCommitMessage txcm = this.firstProxy.commit(this.proxy.getTxId().getUniqId());
            this.afterServerCommit(txcm);
        }
        catch (TransactionDataNodeHasDepartedException e) {
            throw new TransactionInDoubtException(e);
        }
        finally {
            this.lockReq.releaseLocal();
            this.firstProxy.getPool().releaseServerAffinity();
        }
    }

    private void obtainLocalLocks() {
        this.lockReq = new TXLockRequest();
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting("");
        for (TransactionalOperation txOp : this.recordedOperations) {
            if (!TransactionalOperation.ServerRegionOperation.lockKeyForTx(txOp.getOperation())) continue;
            TXRegionLockRequest rlr = this.lockReq.getRegionLockRequest(txOp.getRegionName());
            if (rlr == null) {
                rlr = new TXRegionLockRequestImpl(cache.getRegionByPath(txOp.getRegionName()));
                this.lockReq.addLocalRequest(rlr);
            }
            if (txOp.getOperation() == TransactionalOperation.ServerRegionOperation.PUT_ALL || txOp.getOperation() == TransactionalOperation.ServerRegionOperation.REMOVE_ALL) {
                rlr.addEntryKeys(txOp.getKeys());
                continue;
            }
            rlr.addEntryKey(txOp.getKey());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("TX: client localLockRequest: {}", (Object)this.lockReq);
        }
        try {
            this.lockReq.obtain();
        }
        catch (CommitConflictException e) {
            this.rollback();
            throw e;
        }
        if (this.internalAfterLocalLocks != null) {
            this.internalAfterLocalLocks.run();
        }
    }

    private void afterServerCommit(TXCommitMessage txcm) {
        GemFireCacheImpl cache;
        if (this.internalAfterSendCommit != null) {
            this.internalAfterSendCommit.run();
        }
        if ((cache = GemFireCacheImpl.getInstance()) == null) {
            return;
        }
        cache.getCancelCriterion().checkCancelInProgress(null);
        InternalDistributedSystem ds = cache.getInternalDistributedSystem();
        DM dm = ds.getDistributionManager();
        txcm.setDM(dm);
        txcm.setAckRequired(false);
        txcm.setDisableListeners(true);
        cache.getTxManager().setTXState(null);
        txcm.hookupRegions(dm);
        txcm.basicProcess();
    }

    @Override
    protected TXRegionStub generateRegionStub(LocalRegion region) {
        return new ClientTXRegionStub(region);
    }

    @Override
    protected void validateRegionCanJoinTransaction(LocalRegion region) throws TransactionException {
        if (!region.hasServerProxy()) {
            throw new TransactionException("Region " + region.getName() + " is local to this client and cannot be used in a transaction.");
        }
        if (this.firstProxy != null && this.firstProxy.getPool() != region.getServerProxy().getPool()) {
            throw new TransactionException("Region " + region.getName() + " is using a different server pool than other regions in this transaction.");
        }
    }

    @Override
    public void rollback() {
        if (this.internalAfterSendRollback != null) {
            this.internalAfterSendRollback.run();
        }
        try {
            this.txRolledback = true;
            this.firstProxy.rollback(this.proxy.getTxId().getUniqId());
        }
        finally {
            this.firstProxy.getPool().releaseServerAffinity();
        }
    }

    @Override
    public void afterCompletion(int status) {
        try {
            if (this.txRolledback) {
                return;
            }
            TXCommitMessage txcm = this.firstProxy.afterCompletion(status, this.proxy.getTxId().getUniqId());
            if (status == 3) {
                if (txcm == null) {
                    throw new TransactionInDoubtException(LocalizedStrings.ClientTXStateStub_COMMIT_FAILED_ON_SERVER.toLocalizedString());
                }
                this.afterServerCommit(txcm);
            } else if (status == 4) {
                if (this.internalAfterSendRollback != null) {
                    this.internalAfterSendRollback.run();
                }
                this.firstProxy.getPool().releaseServerAffinity();
            }
        }
        finally {
            if (status == 3) {
                this.lockReq.releaseLocal();
            }
            this.firstProxy.getPool().releaseServerAffinity();
        }
    }

    @Override
    public void beforeCompletion() {
        this.obtainLocalLocks();
        try {
            this.firstProxy.beforeCompletion(this.proxy.getTxId().getUniqId());
        }
        catch (GemFireException e) {
            this.lockReq.releaseLocal();
            this.firstProxy.getPool().releaseServerAffinity();
            throw e;
        }
    }

    @Override
    public InternalDistributedMember getOriginatingMember() {
        return null;
    }

    @Override
    public boolean isMemberIdForwardingRequired() {
        return false;
    }

    @Override
    public TXCommitMessage getCommitMessage() {
        return null;
    }

    @Override
    public void suspend() {
        this.serverAffinityLocation = this.firstProxy.getPool().getServerAffinityLocation();
        this.firstProxy.getPool().releaseServerAffinity();
        if (logger.isDebugEnabled()) {
            logger.debug("TX: suspending transaction: {} server delegate: {}", (Object)this.getTransactionId(), (Object)this.serverAffinityLocation);
        }
    }

    @Override
    public void resume() {
        this.firstProxy.getPool().setupServerAffinity(true);
        this.firstProxy.getPool().setServerAffinityLocation(this.serverAffinityLocation);
        if (logger.isDebugEnabled()) {
            logger.debug("TX: resuming transaction: {} server delegate: {}", (Object)this.getTransactionId(), (Object)this.serverAffinityLocation);
        }
    }

    @Override
    public void recordTXOperation(ServerRegionDataAccess region, TransactionalOperation.ServerRegionOperation op, Object key, Object[] arguments) {
        if (ClientTXStateStub.transactionRecordingEnabled()) {
            this.recordedOperations.add(new TransactionalOperation(this, region.getRegionName(), op, key, arguments));
        }
    }

    public void setAfterLocalLocks(Runnable afterLocalLocks) {
        this.internalAfterLocalLocks = afterLocalLocks;
    }
}

