/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.versions;

import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import java.util.NoSuchElementException;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.versions.RVVException;
import org.apache.geode.internal.cache.versions.RVVExceptionT;

public class RVVExceptionB
extends RVVException {
    BitSet received;
    private long receivedBaseVersion;

    public RVVExceptionB(long previousVersion, long nextVersion) {
        super(previousVersion, nextVersion);
    }

    @Override
    public void add(long receivedVersion) {
        if (receivedVersion == this.previousVersion + 1L) {
            this.previousVersion = receivedVersion;
            if (this.received != null) {
                this.addReceived(receivedVersion);
                this.consumeReceivedVersions();
            }
        } else if (receivedVersion == this.nextVersion - 1L) {
            this.nextVersion = receivedVersion;
            if (this.received != null) {
                this.addReceived(receivedVersion);
                this.consumeReceivedVersions();
            }
        } else if (this.previousVersion < receivedVersion && receivedVersion < this.nextVersion) {
            this.addReceived(receivedVersion);
        }
    }

    @Override
    protected void addReceived(long rv) {
        if (this.received == null) {
            this.receivedBaseVersion = this.previousVersion + 1L;
            if (this.nextVersion > this.previousVersion) {
                long size = this.nextVersion - this.previousVersion;
                this.received = new BitSet((int)size);
            } else {
                this.received = new BitSet();
            }
        }
        this.received.set((int)(rv - this.receivedBaseVersion));
    }

    private void consumeReceivedVersions() {
        int idx = (int)(this.previousVersion - this.receivedBaseVersion + 1L);
        while (this.previousVersion < this.nextVersion && this.received.get(idx)) {
            ++idx;
            ++this.previousVersion;
        }
        if (this.previousVersion < this.nextVersion) {
            idx = (int)(this.nextVersion - this.receivedBaseVersion) - 1;
            while (this.previousVersion < this.nextVersion && this.received.get(idx)) {
                --idx;
                --this.nextVersion;
            }
        }
    }

    @Override
    public int compareTo(RVVException o) {
        long thisVal = this.previousVersion;
        long anotherVal = o.previousVersion;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    @Override
    public RVVExceptionB clone() {
        RVVExceptionB clone = new RVVExceptionB(this.previousVersion, this.nextVersion);
        if (this.received != null) {
            clone.received = (BitSet)this.received.clone();
            clone.receivedBaseVersion = this.receivedBaseVersion;
        }
        return clone;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        InternalDataSerializer.writeUnsignedVL(this.previousVersion, out);
        this.writeReceived(out);
    }

    @Override
    protected void writeReceived(DataOutput out) throws IOException {
        int size = 0;
        long[] deltas = null;
        long last = this.previousVersion;
        RVVException.ReceivedVersionsIterator it = this.receivedVersionsIterator();
        while (it.hasNext()) {
            Long version = it.next();
            long delta = version - last;
            if (deltas == null) {
                deltas = new long[this.received.length()];
            }
            deltas[size++] = delta;
            last = version;
        }
        InternalDataSerializer.writeUnsignedVL(size, out);
        for (int i = 0; i < size; ++i) {
            InternalDataSerializer.writeUnsignedVL((long)deltas[i], out);
        }
        long delta = this.nextVersion - last;
        InternalDataSerializer.writeUnsignedVL(delta, out);
    }

    public String toString() {
        if (this.received != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("e(n=").append(this.nextVersion).append("; p=").append(this.previousVersion);
            if (this.receivedBaseVersion != this.previousVersion + 1L) {
                sb.append("; b=").append(this.receivedBaseVersion);
            }
            int lastBit = (int)(this.nextVersion - this.receivedBaseVersion);
            sb.append("; rb=[");
            int i = this.received.nextSetBit((int)(this.previousVersion - this.receivedBaseVersion + 1L));
            if (i >= 0) {
                sb.append(i);
                i = this.received.nextSetBit(i + 1);
                while (0 < i && i < lastBit) {
                    sb.append(',').append(i);
                    i = this.received.nextSetBit(i + 1);
                }
            }
            sb.append(']');
            return sb.toString();
        }
        return "e(n=" + this.nextVersion + " p=" + this.previousVersion + "; rb=[])";
    }

    @Override
    public boolean sameAs(RVVException ex) {
        if (ex instanceof RVVExceptionT) {
            return ((RVVExceptionT)ex).sameAs(this);
        }
        if (!super.sameAs(ex)) {
            return false;
        }
        RVVExceptionB other = (RVVExceptionB)ex;
        return !(this.received == null ? other.received != null && !other.received.isEmpty() : !this.received.equals(other.received));
    }

    @Override
    public boolean contains(long version) {
        if (version <= this.previousVersion) {
            return false;
        }
        return this.received != null && this.received.get((int)(version - this.receivedBaseVersion));
    }

    @Override
    public boolean isEmpty() {
        return this.received == null || this.received.isEmpty();
    }

    @Override
    public RVVException.ReceivedVersionsIterator receivedVersionsIterator() {
        ReceivedVersionsIteratorB result = new ReceivedVersionsIteratorB();
        result.initForForwardIteration();
        return result;
    }

    @Override
    public long getHighestReceivedVersion() {
        if (this.isEmpty()) {
            return this.previousVersion;
        }
        return this.receivedBaseVersion + (long)this.received.length() - 1L;
    }

    protected class ReceivedVersionsIteratorB
    extends RVVException.ReceivedVersionsIterator {
        int index;
        int nextIndex;

        protected ReceivedVersionsIteratorB() {
        }

        void initForForwardIteration() {
            this.index = -1;
            if (RVVExceptionB.this.received == null) {
                this.nextIndex = -1;
            } else {
                this.nextIndex = RVVExceptionB.this.received.nextSetBit((int)(RVVExceptionB.this.previousVersion - RVVExceptionB.this.receivedBaseVersion + 1L));
                if ((long)this.nextIndex + RVVExceptionB.this.receivedBaseVersion >= RVVExceptionB.this.nextVersion) {
                    this.nextIndex = -1;
                }
            }
        }

        @Override
        boolean hasNext() {
            return this.nextIndex >= 0;
        }

        @Override
        long next() {
            this.index = this.nextIndex;
            if (this.index < 0) {
                throw new NoSuchElementException("no more elements available");
            }
            this.advance();
            return (long)this.index + RVVExceptionB.this.receivedBaseVersion;
        }

        @Override
        void remove() {
            if (this.index < 0) {
                throw new NoSuchElementException("no more elements available");
            }
            RVVExceptionB.this.received.clear(this.index);
        }

        private void advance() {
            this.nextIndex = RVVExceptionB.this.received.nextSetBit(this.index + 1);
            if ((long)this.nextIndex + RVVExceptionB.this.receivedBaseVersion >= RVVExceptionB.this.nextVersion) {
                this.nextIndex = -1;
            }
        }
    }
}

