/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.TransactionWriter;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class CacheTransactionManagerCreation
implements CacheTransactionManager {
    private final ArrayList txListeners = new ArrayList();
    private TransactionWriter writer = null;

    @Override
    public TransactionListener setListener(TransactionListener newListener) {
        TransactionListener result = this.getListener();
        this.txListeners.clear();
        if (newListener != null) {
            this.txListeners.add(newListener);
        }
        return result;
    }

    @Override
    public void initListeners(TransactionListener[] newListeners) {
        this.txListeners.clear();
        if (newListeners != null && newListeners.length > 0) {
            this.txListeners.addAll(Arrays.asList(newListeners));
        }
    }

    @Override
    public void addListener(TransactionListener newListener) {
        if (!this.txListeners.contains(newListener)) {
            this.txListeners.add(newListener);
        }
    }

    @Override
    public void removeListener(TransactionListener newListener) {
        this.txListeners.remove(newListener);
    }

    @Override
    public TransactionListener[] getListeners() {
        TransactionListener[] result = new TransactionListener[this.txListeners.size()];
        this.txListeners.toArray(result);
        return result;
    }

    @Override
    public TransactionListener getListener() {
        if (this.txListeners.isEmpty()) {
            return null;
        }
        if (this.txListeners.size() == 1) {
            return (TransactionListener)this.txListeners.get(0);
        }
        throw new IllegalStateException(LocalizedStrings.CacheTransactionManagerCreation_MORE_THAN_ONE_TRANSACTION_LISTENER_EXISTS.toLocalizedString());
    }

    @Override
    public TransactionId getTransactionId() {
        throw new UnsupportedOperationException(LocalizedStrings.CacheTransactionManagerCreation_GETTING_A_TRANSACTIONID_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public void begin() {
        throw new UnsupportedOperationException(LocalizedStrings.CacheTransactionManagerCreation_TRANSACTIONS_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public void commit() throws CommitConflictException {
        throw new UnsupportedOperationException(LocalizedStrings.CacheTransactionManagerCreation_TRANSACTIONS_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public void rollback() {
        throw new UnsupportedOperationException(LocalizedStrings.CacheTransactionManagerCreation_TRANSACTIONS_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public boolean exists() {
        throw new UnsupportedOperationException(LocalizedStrings.CacheTransactionManagerCreation_TRANSACTIONS_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public void setWriter(TransactionWriter writer) {
        this.writer = writer;
    }

    @Override
    public TransactionWriter getWriter() {
        return this.writer;
    }

    @Override
    public TransactionId suspend() {
        throw new UnsupportedOperationException(LocalizedStrings.CacheTransactionManagerCreation_TRANSACTIONS_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public void resume(TransactionId transactionId) {
        throw new UnsupportedOperationException(LocalizedStrings.CacheTransactionManagerCreation_TRANSACTIONS_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public boolean isSuspended(TransactionId transactionId) {
        throw new UnsupportedOperationException(LocalizedStrings.CacheTransactionManagerCreation_TRANSACTIONS_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public boolean tryResume(TransactionId transactionId) {
        throw new UnsupportedOperationException(LocalizedStrings.CacheTransactionManagerCreation_TRANSACTIONS_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public boolean tryResume(TransactionId transactionId, long time, TimeUnit unit) {
        throw new UnsupportedOperationException(LocalizedStrings.CacheTransactionManagerCreation_TRANSACTIONS_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public boolean exists(TransactionId transactionId) {
        throw new UnsupportedOperationException(LocalizedStrings.CacheTransactionManagerCreation_TRANSACTIONS_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public void setDistributed(boolean distributed) {
        throw new UnsupportedOperationException(LocalizedStrings.CacheTransactionManagerCreation_TRANSACTIONS_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public boolean isDistributed() {
        throw new UnsupportedOperationException(LocalizedStrings.CacheTransactionManagerCreation_TRANSACTIONS_NOT_SUPPORTED.toLocalizedString());
    }
}

