/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.jta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.jta.TransactionManagerImpl;
import org.apache.geode.internal.jta.TransactionUtils;
import org.apache.geode.internal.jta.XidImpl;

@Deprecated
public class GlobalTransaction {
    public static boolean DISABLE_TRANSACTION_TIMEOUT_SETTING = false;
    private final byte[] GTid;
    private final Xid xid;
    private int status = 5;
    private Map resourceMap = Collections.synchronizedMap(new HashMap());
    private List transactions = Collections.synchronizedList(new ArrayList());
    private static long mCounter = 1L;
    private boolean timedOut = false;
    private volatile long expirationTime;
    private static boolean VERBOSE = Boolean.getBoolean("jta.VERBOSE");
    private static String DMid = null;
    private static InternalDistributedSystem IdsForId = null;
    private static final Object DmidMutex = new Object();

    public GlobalTransaction() throws SystemException {
        try {
            this.GTid = GlobalTransaction.generateGTid();
            this.xid = XidImpl.createXid(this.GTid);
        }
        catch (Exception e) {
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (writer.severeEnabled()) {
                writer.severe(LocalizedStrings.GlobalTransaction_GLOBALTRANSACTION_CONSTRUCTOR_ERROR_WHILE_TRYING_TO_CREATE_XID_DUE_TO_0, e, (Throwable)e);
            }
            String exception = LocalizedStrings.GlobalTransaction_GLOBALTRANSACTION_CONSTRUCTOR_ERROR_WHILE_TRYING_TO_CREATE_XID_DUE_TO_0.toLocalizedString(e);
            throw new SystemException(exception);
        }
    }

    public void addTransaction(Transaction txn) throws SystemException {
        if (txn == null) {
            String exception = LocalizedStrings.GlobalTransaction_GLOBALTRANSACTION_ADDTRANSACTION_CANNOT_ADD_A_NULL_TRANSACTION.toLocalizedString();
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (VERBOSE) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
        this.transactions.add(txn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
        try {
            XAResource xar = null;
            XAResource xar1 = null;
            int loop = 0;
            Boolean isActive = Boolean.FALSE;
            Map map = this.resourceMap;
            synchronized (map) {
                Iterator iterator = this.resourceMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    try {
                        Map.Entry entry = iterator.next();
                        xar = (XAResource)entry.getKey();
                        isActive = (Boolean)entry.getValue();
                        if (loop == 0) {
                            xar1 = xar;
                        }
                        ++loop;
                        if (!isActive.booleanValue()) continue;
                        xar.end(this.xid, 0x4000000);
                        entry.setValue(Boolean.FALSE);
                    }
                    catch (Exception e) {
                        if (!VERBOSE) continue;
                        writer.info(LocalizedStrings.ONE_ARG, "GlobalTransaction::commit:Exception in delisting XAResource", (Throwable)e);
                    }
                }
            }
            if (xar1 != null) {
                xar1.commit(this.xid, true);
            }
            this.status = 3;
            if (VERBOSE) {
                writer.fine("GlobalTransaction::commit:Transaction committed successfully");
            }
        }
        catch (Exception e) {
            this.status = 9;
            try {
                this.rollback();
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.status = 4;
                String exception = LocalizedStrings.GlobalTransaction_GLOBALTRANSACTION_COMMIT_ERROR_IN_COMMITTING_BUT_TRANSACTION_COULD_NOT_BE_ROLLED_BACK_DUE_TO_EXCEPTION_0.toLocalizedString(t);
                if (VERBOSE) {
                    writer.fine(exception, t);
                }
                SystemException sysEx = new SystemException(exception);
                sysEx.initCause(t);
                throw sysEx;
            }
            String exception = LocalizedStrings.GlobalTransaction_GLOBALTRANSACTION_COMMIT_ERROR_IN_COMMITTING_THE_TRANSACTION_TRANSACTION_ROLLED_BACK_EXCEPTION_0_1.toLocalizedString(e, " " + (e instanceof XAException ? "Error Code =" + ((XAException)e).errorCode : ""));
            if (VERBOSE) {
                writer.fine(exception, e);
            }
            RollbackException rbEx = new RollbackException(exception);
            rbEx.initCause((Throwable)e);
            throw rbEx;
        }
        finally {
            TransactionManagerImpl.getTransactionManager().cleanGlobalTransactionMap(this.transactions);
            this.transactions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SystemException {
        LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
        try {
            XAResource xar = null;
            XAResource xar1 = null;
            int loop = 0;
            Map map = this.resourceMap;
            synchronized (map) {
                Iterator iterator = this.resourceMap.entrySet().iterator();
                Boolean isActive = Boolean.FALSE;
                while (iterator.hasNext()) {
                    try {
                        Map.Entry entry = iterator.next();
                        xar = (XAResource)entry.getKey();
                        isActive = (Boolean)entry.getValue();
                        if (loop == 0) {
                            xar1 = xar;
                        }
                        ++loop;
                        if (!isActive.booleanValue()) continue;
                        xar.end(this.xid, 0x4000000);
                        entry.setValue(Boolean.FALSE);
                    }
                    catch (Exception e) {
                        if (!VERBOSE) continue;
                        writer.info(LocalizedStrings.ONE_ARG, "GlobalTransaction::rollback:Exception in delisting XAResource", (Throwable)e);
                    }
                }
            }
            if (xar1 != null) {
                xar1.rollback(this.xid);
            }
            this.status = 4;
            if (VERBOSE) {
                writer.fine("Transaction rolled back successfully");
            }
        }
        catch (Exception e) {
            this.status = 4;
            String exception = LocalizedStrings.GlobalTransaction_GLOBALTRANSACTION_ROLLBACK_ROLLBACK_NOT_SUCCESSFUL_DUE_TO_EXCEPTION_0_1.toLocalizedString(e, " " + (e instanceof XAException ? "Error Code =" + ((XAException)e).errorCode : ""));
            if (VERBOSE) {
                writer.fine(exception);
            }
            SystemException sysEx = new SystemException(exception);
            sysEx.initCause((Throwable)e);
            throw sysEx;
        }
        finally {
            TransactionManagerImpl.getTransactionManager().cleanGlobalTransactionMap(this.transactions);
            this.transactions.clear();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.setStatus(1);
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        XAResource xar = null;
        try {
            GlobalTransaction globalTransaction = this;
            synchronized (globalTransaction) {
                if (this.status == 1) {
                    String exception = "GlobalTransaction::enlistResource::Cannot enlist resource as the transaction has been marked for rollback";
                    LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
                    if (VERBOSE) {
                        writer.fine(exception);
                    }
                    throw new RollbackException(exception);
                }
                if (this.status != 0) {
                    String exception = LocalizedStrings.GlobalTransaction_GLOBALTRANSACTION_ENLISTRESOURCE_CANNOT_ENLIST_A_RESOURCE_TO_A_TRANSACTION_WHICH_IS_NOT_ACTIVE.toLocalizedString();
                    LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
                    if (VERBOSE) {
                        writer.fine(exception);
                    }
                    throw new IllegalStateException(exception);
                }
                if (this.resourceMap.isEmpty()) {
                    xaRes.start(this.xid, 0);
                    int delay = (int)((this.expirationTime - System.currentTimeMillis()) / 1000L);
                    try {
                        if (!DISABLE_TRANSACTION_TIMEOUT_SETTING) {
                            xaRes.setTransactionTimeout(delay);
                        }
                    }
                    catch (XAException xe) {
                        String exception = LocalizedStrings.GlobalTransaction_GLOBALTRANSACTION_ENLISTRESOURCE_EXCEPTION_OCCURRED_IN_TRYING_TO_SET_XARESOURCE_TIMEOUT_DUE_TO_0_ERROR_CODE_1.toLocalizedString(xe, xe.errorCode);
                        LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
                        if (VERBOSE) {
                            writer.fine(exception);
                        }
                        throw new SystemException(exception);
                    }
                    this.resourceMap.put(xaRes, Boolean.TRUE);
                } else {
                    Map delay = this.resourceMap;
                    synchronized (delay) {
                        Iterator iterator = this.resourceMap.keySet().iterator();
                        xar = (XAResource)iterator.next();
                    }
                    if (!xar.isSameRM(xaRes)) {
                        LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
                        if (writer.severeEnabled()) {
                            writer.severe(LocalizedStrings.GlobalTransaction_GLOBALTRANSACTIONENLISTRESOURCEONLY_ONE_RESOUCE_MANAGER_SUPPORTED);
                        }
                        throw new SystemException(LocalizedStrings.GlobalTransaction_GLOBALTRANSACTIONENLISTRESOURCEONLY_ONE_RESOUCE_MANAGER_SUPPORTED.toLocalizedString());
                    }
                    xaRes.start(this.xid, 0x200000);
                    this.resourceMap.put(xaRes, Boolean.TRUE);
                }
            }
        }
        catch (Exception e) {
            String addon = e instanceof XAException ? "Error Code =" + ((XAException)e).errorCode : "";
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (VERBOSE) {
                writer.fine(LocalizedStrings.GLOBALTRANSACTION__ENLISTRESOURCE__ERROR_WHILE_ENLISTING_XARESOURCE_0_1.toLocalizedString(e, addon), e);
            }
            SystemException sysEx = new SystemException(LocalizedStrings.GLOBALTRANSACTION__ENLISTRESOURCE__ERROR_WHILE_ENLISTING_XARESOURCE_0_1.toLocalizedString(e, addon));
            sysEx.initCause((Throwable)e);
            throw sysEx;
        }
        return true;
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        try {
            Boolean isActive;
            if (this.resourceMap.containsKey(xaRes) && (isActive = (Boolean)this.resourceMap.get(xaRes)).booleanValue()) {
                xaRes.end(this.xid, flag);
                this.resourceMap.put(xaRes, Boolean.FALSE);
            }
        }
        catch (Exception e) {
            String exception = LocalizedStrings.GlobalTransaction_ERROR_WHILE_DELISTING_XARESOURCE_0_1.toLocalizedString(e, " " + (e instanceof XAException ? "Error Code =" + ((XAException)e).errorCode : ""));
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (VERBOSE) {
                writer.fine(exception, e);
            }
            SystemException se = new SystemException(exception);
            se.initCause((Throwable)e);
        }
        return true;
    }

    public void setStatus(int new_status) {
        this.status = new_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws SystemException {
        XAResource xar = null;
        Map map = this.resourceMap;
        synchronized (map) {
            Iterator iterator = this.resourceMap.entrySet().iterator();
            Boolean isActive = Boolean.FALSE;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                xar = (XAResource)entry.getKey();
                isActive = (Boolean)entry.getValue();
                if (!isActive.booleanValue()) continue;
                try {
                    xar.end(this.xid, 0x2000000);
                    entry.setValue(Boolean.FALSE);
                }
                catch (Exception e) {
                    String exception = LocalizedStrings.GlobalTransaction_ERROR_WHILE_DELISTING_XARESOURCE_0_1.toLocalizedString(e, " " + (e instanceof XAException ? "Error Code =" + ((XAException)e).errorCode : ""));
                    LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
                    if (VERBOSE) {
                        writer.fine(exception);
                    }
                    throw new SystemException(exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws SystemException {
        XAResource xar = null;
        Map map = this.resourceMap;
        synchronized (map) {
            Iterator iterator = this.resourceMap.entrySet().iterator();
            Boolean isActive = Boolean.FALSE;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                xar = (XAResource)entry.getKey();
                isActive = (Boolean)entry.getValue();
                if (isActive.booleanValue()) continue;
                try {
                    xar.start(this.xid, 0x8000000);
                    entry.setValue(Boolean.TRUE);
                }
                catch (Exception e) {
                    String exception = LocalizedStrings.GlobalTransaction_GLOBATRANSACTION_RESUME_RESUME_NOT_SUCCESFUL_DUE_TO_0.toLocalizedString(e);
                    LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
                    if (VERBOSE) {
                        writer.fine(exception, e);
                    }
                    throw new SystemException(exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getId() {
        Object object = DmidMutex;
        synchronized (object) {
            InternalDistributedSystem ids = InternalDistributedSystem.getAnyInstance();
            if (ids == null) {
                throw new DistributedSystemDisconnectedException("No distributed system");
            }
            if (ids == IdsForId) {
                return DMid;
            }
            IdsForId = ids;
            DM dm = ids.getDistributionManager();
            DMid = dm.getId().toString();
            return DMid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] generateGTid() {
        StringBuffer sbuff = new StringBuffer(GlobalTransaction.getId());
        Class<GlobalTransaction> clazz = GlobalTransaction.class;
        synchronized (GlobalTransaction.class) {
            mCounter = mCounter == 99999L ? 1L : ++mCounter;
            sbuff.append(String.valueOf(mCounter));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            sbuff.append('_').append(System.currentTimeMillis());
            byte[] byte_array = sbuff.toString().getBytes();
            return byte_array;
        }
    }

    void expireGTX() {
        block4: {
            if (this.timedOut) {
                return;
            }
            this.timedOut = true;
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            try {
                if (writer.infoEnabled()) {
                    writer.info(LocalizedStrings.GlobalTransaction_TRANSACTION_0_HAS_TIMED_OUT, this);
                }
                TransactionManagerImpl.getTransactionManager().removeTranxnMappings(this.transactions);
                this.setStatus(6);
            }
            catch (Exception e) {
                if (!writer.severeEnabled()) break block4;
                writer.severe(LocalizedStrings.GlobalTransaction_GLOBATRANSACTION_EXPIREGTX_ERROR_OCCURRED_WHILE_REMOVING_TRANSACTIONAL_MAPPINGS_0, e, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long setTransactionTimeoutForXARes(int seconds) throws SystemException {
        XAResource xar = null;
        boolean resetXATimeOut = true;
        Map map = this.resourceMap;
        synchronized (map) {
            for (Map.Entry entry : this.resourceMap.entrySet()) {
                xar = (XAResource)entry.getKey();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                try {
                    resetXATimeOut = xar.setTransactionTimeout(seconds);
                    break;
                }
                catch (XAException e) {
                    String exception = LocalizedStrings.GlobalTransaction_EXCEPTION_OCCURRED_WHILE_TRYING_TO_SET_THE_XARESOURCE_TIMEOUT_DUE_TO_0_ERROR_CODE_1.toLocalizedString(e, e.errorCode);
                    LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
                    if (VERBOSE) {
                        writer.fine(exception);
                    }
                    throw new SystemException(exception);
                }
            }
        }
        long newExp = System.currentTimeMillis() + (long)(seconds * 1000);
        if (!resetXATimeOut) {
            newExp = -1L;
        }
        return newExp;
    }

    int getResourceMapSize() {
        return this.resourceMap.size();
    }

    List getTransactions() {
        return this.transactions;
    }

    long getExpirationTime() {
        return this.expirationTime;
    }

    void setTimeoutValue(long time) {
        this.expirationTime = time;
    }

    boolean isExpired() {
        return this.timedOut;
    }

    public int compare(GlobalTransaction other) {
        int otherId;
        if (this == other) {
            return 0;
        }
        long compare = this.getExpirationTime() - other.getExpirationTime();
        if (compare < 0L) {
            return -1;
        }
        if (compare > 0L) {
            return 1;
        }
        if (this.GTid.length < other.GTid.length) {
            return -1;
        }
        if (this.GTid.length > other.GTid.length) {
            return 1;
        }
        for (int i = 0; i < this.GTid.length; ++i) {
            if (this.GTid[i] < other.GTid[i]) {
                return -1;
            }
            if (this.GTid[i] <= other.GTid[i]) continue;
            return 1;
        }
        int myId = System.identityHashCode(this);
        if (myId < (otherId = System.identityHashCode(other))) {
            return -1;
        }
        if (myId > otherId) {
            return 1;
        }
        throw new IllegalStateException(LocalizedStrings.GlobalTransaction_COULD_NOT_COMPARE_0_TO_1.toLocalizedString(this, other));
    }
}

