/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.memcached.commands;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.memcached.KeyWrapper;
import org.apache.geode.internal.memcached.Reply;
import org.apache.geode.internal.memcached.RequestReader;
import org.apache.geode.internal.memcached.ResponseStatus;
import org.apache.geode.internal.memcached.ValueWrapper;
import org.apache.geode.internal.memcached.commands.AbstractCommand;
import org.apache.geode.internal.memcached.commands.StorageCommand;
import org.apache.geode.memcached.GemFireMemcachedServer;

public class IncrementCommand
extends AbstractCommand {
    private static final int LONG_LENGTH = 8;

    @Override
    public ByteBuffer processCommand(RequestReader request, GemFireMemcachedServer.Protocol protocol, Cache cache) {
        if (protocol == GemFireMemcachedServer.Protocol.ASCII) {
            return this.processAsciiCommand(request.getRequest(), cache);
        }
        return this.processBinaryProtocol(request, cache);
    }

    private ByteBuffer processAsciiCommand(ByteBuffer buffer, Cache cache) {
        ValueWrapper oldValWrapper;
        CharBuffer flb = this.getFirstLineBuffer();
        this.getAsciiDecoder().reset();
        this.getAsciiDecoder().decode(buffer, flb, false);
        flb.flip();
        String firstLine = this.getFirstLine();
        String[] firstLineElements = firstLine.split(" ");
        assert ("incr".equals(firstLineElements[0]));
        String key = firstLineElements[1];
        String incrByStr = this.stripNewline(firstLineElements[2]);
        Long incrBy = Long.parseLong(incrByStr);
        boolean noReply = firstLineElements.length > 3;
        Region<Object, ValueWrapper> r = IncrementCommand.getMemcachedRegion(cache);
        String reply = Reply.NOT_FOUND.toString();
        ByteBuffer newVal = ByteBuffer.allocate(8);
        while ((oldValWrapper = r.get(key)) != null) {
            newVal.clear();
            byte[] oldVal = oldValWrapper.getValue();
            long oldLong = this.getLongFromByteArray(oldVal);
            long newLong = oldLong + incrBy;
            newVal.putLong(0, newLong);
            ValueWrapper newValWrapper = ValueWrapper.getWrappedValue(newVal.array(), 0);
            if (!r.replace(key, oldValWrapper, newValWrapper)) continue;
            reply = newLong + "\r\n";
            break;
        }
        return noReply ? null : asciiCharset.encode(reply);
    }

    private ByteBuffer processBinaryProtocol(RequestReader request, Cache cache) {
        ByteBuffer buffer = request.getRequest();
        byte extrasLength = buffer.get(4);
        final KeyWrapper key = this.getKey(buffer, 24 + extrasLength);
        long incrBy = buffer.getLong(24);
        long initialVal = buffer.getLong(32);
        int expiration = buffer.getInt(40);
        final Region<Object, ValueWrapper> r = IncrementCommand.getMemcachedRegion(cache);
        ByteBuffer newVal = ByteBuffer.allocate(8);
        boolean notFound = false;
        ValueWrapper newValWrapper = null;
        try {
            ValueWrapper oldValWrapper;
            do {
                if ((oldValWrapper = r.get(key)) == null) {
                    if (expiration == -1) {
                        notFound = true;
                    } else {
                        newVal.putLong(0, initialVal);
                        newValWrapper = ValueWrapper.getWrappedValue(newVal.array(), 0);
                        r.put(key, newValWrapper);
                    }
                    break;
                }
                byte[] oldVal = oldValWrapper.getValue();
                long oldLong = this.getLongFromByteArray(oldVal);
                long newLong = oldLong + incrBy;
                newVal.putLong(0, newLong);
            } while (!r.replace(key, oldValWrapper, newValWrapper = ValueWrapper.getWrappedValue(newVal.array(), 0)));
        }
        catch (Exception e) {
            return this.handleBinaryException(key, request, request.getResponse(), "increment", e);
        }
        if (expiration > 0) {
            StorageCommand.getExpiryExecutor().schedule(new Runnable(){

                @Override
                public void run() {
                    r.destroy(key);
                }
            }, (long)expiration, TimeUnit.SECONDS);
        }
        if (this.getLogger().fineEnabled()) {
            this.getLogger().fine("incr:key:" + key + " incrBy:" + incrBy + " initVal:" + initialVal + " exp:" + expiration + " notFound:" + notFound);
        }
        ByteBuffer response = null;
        if (notFound) {
            response = request.getResponse();
            response.putShort(6, ResponseStatus.KEY_NOT_FOUND.asShort());
        } else {
            if (this.isQuiet()) {
                return null;
            }
            response = request.getResponse(32);
            response.putInt(8, 8);
            response.putLong(24, newVal.getLong(0));
            response.putLong(16, newValWrapper.getVersion());
        }
        return response;
    }

    protected boolean isQuiet() {
        return false;
    }
}

