/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.BytesAndBitsForCompactor;
import org.apache.geode.internal.cache.EntryBits;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.offheap.AbstractStoredObject;
import org.apache.geode.internal.offheap.AddressableMemoryManager;
import org.apache.geode.internal.offheap.FreeListManager;
import org.apache.geode.internal.offheap.MemoryAllocatorImpl;
import org.apache.geode.internal.offheap.MemoryBlock;
import org.apache.geode.internal.offheap.OffHeapStoredObjectSlice;
import org.apache.geode.internal.offheap.ReferenceCountHelper;
import org.apache.geode.internal.offheap.StoredObject;

public class OffHeapStoredObject
extends AbstractStoredObject
implements Comparable<OffHeapStoredObject>,
MemoryBlock {
    private final long memoryAddress;
    public static final int HEADER_SIZE = 8;
    public static final int MIN_CHUNK_SIZE = 16;
    private static final int CHUNK_SIZE_OFFSET = 0;
    static final int REF_COUNT_OFFSET = 4;
    static final int IS_SERIALIZED_BIT = Integer.MIN_VALUE;
    static final int IS_COMPRESSED_BIT = 0x40000000;
    static final int MAGIC_MASK = 0x7000000;
    static final int MAGIC_NUMBER = 0x5000000;
    static final int DATA_SIZE_DELTA_MASK = 0xFF0000;
    static final int DATA_SIZE_SHIFT = 16;
    static final int REF_COUNT_MASK = 65535;
    static final int MAX_REF_COUNT = 65535;
    static final long FILL_PATTERN = 0x3C3C3C3C3C3C3C3CL;
    static final byte FILL_BYTE = 60;

    protected OffHeapStoredObject(long memoryAddress, int chunkSize) {
        MemoryAllocatorImpl.validateAddressAndSize(memoryAddress, chunkSize);
        this.memoryAddress = memoryAddress;
        this.setSize(chunkSize);
        AddressableMemoryManager.writeIntVolatile(this.getAddress() + 4L, 0x5000000);
    }

    public void readyForFree() {
        AddressableMemoryManager.writeIntVolatile(this.getAddress() + 4L, 0);
    }

    public void readyForAllocation() {
        if (!AddressableMemoryManager.writeIntVolatile(this.getAddress() + 4L, 0, 0x5000000)) {
            throw new IllegalStateException("Expected 0 but found " + Integer.toHexString(AddressableMemoryManager.readIntVolatile(this.getAddress() + 4L)));
        }
    }

    protected OffHeapStoredObject() {
        this.memoryAddress = 0L;
    }

    protected OffHeapStoredObject(long memoryAddress) {
        MemoryAllocatorImpl.validateAddress(memoryAddress);
        this.memoryAddress = memoryAddress;
    }

    protected OffHeapStoredObject(OffHeapStoredObject chunk) {
        this.memoryAddress = chunk.memoryAddress;
    }

    @Override
    public void fillSerializedValue(BytesAndBitsForCompactor wrapper, byte userBits) {
        if (this.isSerialized()) {
            userBits = EntryBits.setSerialized(userBits, true);
        }
        wrapper.setOffHeapData(this, userBits);
    }

    String getShortClassName() {
        String cname = this.getClass().getName();
        return cname.substring(this.getClass().getPackage().getName().length() + 1);
    }

    @Override
    public boolean checkDataEquals(StoredObject so) {
        int i;
        if (this == so) {
            return true;
        }
        if (this.isSerialized() != so.isSerialized()) {
            return false;
        }
        int mySize = this.getValueSizeInBytes();
        if (mySize != so.getValueSizeInBytes()) {
            return false;
        }
        if (!(so instanceof OffHeapStoredObject)) {
            return false;
        }
        OffHeapStoredObject other = (OffHeapStoredObject)so;
        if (this.getAddress() == other.getAddress()) {
            return true;
        }
        byte[] dataCache1 = new byte[1024];
        byte[] dataCache2 = new byte[dataCache1.length];
        MemoryAllocatorImpl.getAllocator().getStats().incReads();
        MemoryAllocatorImpl.getAllocator().getStats().incReads();
        for (i = 0; i < mySize - (dataCache1.length - 1); i += dataCache1.length) {
            this.readDataBytes(i, dataCache1);
            other.readDataBytes(i, dataCache2);
            for (int j = 0; j < dataCache1.length; ++j) {
                if (dataCache1[j] == dataCache2[j]) continue;
                return false;
            }
        }
        int bytesToRead = mySize - i;
        if (bytesToRead > 0) {
            this.readDataBytes(i, dataCache1, 0, bytesToRead);
            other.readDataBytes(i, dataCache2, 0, bytesToRead);
            for (int j = 0; j < bytesToRead; ++j) {
                if (dataCache1[j] == dataCache2[j]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkDataEquals(byte[] serializedObj) {
        int i;
        int mySize = this.getValueSizeInBytes();
        if (mySize != serializedObj.length) {
            return false;
        }
        byte[] dataCache = new byte[1024];
        int idx = 0;
        MemoryAllocatorImpl.getAllocator().getStats().incReads();
        for (i = 0; i < mySize - (dataCache.length - 1); i += dataCache.length) {
            this.readDataBytes(i, dataCache);
            for (int j = 0; j < dataCache.length; ++j) {
                if (dataCache[j] == serializedObj[idx++]) continue;
                return false;
            }
        }
        int bytesToRead = mySize - i;
        if (bytesToRead > 0) {
            this.readDataBytes(i, dataCache, 0, bytesToRead);
            for (int j = 0; j < bytesToRead; ++j) {
                if (dataCache[j] == serializedObj[idx++]) continue;
                return false;
            }
        }
        return true;
    }

    public void checkIsAllocated() {
        int originalBits = AddressableMemoryManager.readIntVolatile(this.memoryAddress + 4L);
        if ((originalBits & 0x7000000) != 0x5000000) {
            throw new IllegalStateException("It looks like this off heap memory was already freed. rawBits=" + Integer.toHexString(originalBits));
        }
    }

    public void incSize(int inc) {
        this.setSize(this.getSize() + inc);
    }

    protected void beforeReturningToAllocator() {
    }

    @Override
    public int getSize() {
        return OffHeapStoredObject.getSize(this.memoryAddress);
    }

    public void setSize(int size) {
        OffHeapStoredObject.setSize(this.memoryAddress, size);
    }

    @Override
    public long getAddress() {
        return this.memoryAddress;
    }

    @Override
    public int getDataSize() {
        return OffHeapStoredObject.getDataSize(this.memoryAddress);
    }

    protected static int getDataSize(long memoryAdress) {
        int dataSizeDelta = AddressableMemoryManager.readInt(memoryAdress + 4L);
        dataSizeDelta &= 0xFF0000;
        return OffHeapStoredObject.getSize(memoryAdress) - (dataSizeDelta >>= 16);
    }

    protected long getBaseDataAddress() {
        return this.memoryAddress + 8L;
    }

    protected int getBaseDataOffset() {
        return 0;
    }

    @Override
    public ByteBuffer createDirectByteBuffer() {
        return AddressableMemoryManager.createDirectByteBuffer(this.getBaseDataAddress(), this.getDataSize());
    }

    @Override
    public void sendTo(DataOutput out) throws IOException {
        ByteBuffer bb;
        if (!this.isCompressed() && out instanceof HeapDataOutputStream && (bb = this.createDirectByteBuffer()) != null) {
            HeapDataOutputStream hdos = (HeapDataOutputStream)out;
            if (this.isSerialized()) {
                hdos.write(bb);
            } else {
                hdos.writeByte(46);
                InternalDataSerializer.writeArrayLength(bb.remaining(), hdos);
                hdos.write(bb);
            }
            return;
        }
        super.sendTo(out);
    }

    @Override
    public void sendAsByteArray(DataOutput out) throws IOException {
        ByteBuffer bb;
        if (!this.isCompressed() && out instanceof HeapDataOutputStream && (bb = this.createDirectByteBuffer()) != null) {
            HeapDataOutputStream hdos = (HeapDataOutputStream)out;
            InternalDataSerializer.writeArrayLength(bb.remaining(), hdos);
            hdos.write(bb);
            return;
        }
        super.sendAsByteArray(out);
    }

    @Override
    public long getAddressForReadingData(int offset, int size) {
        assert (offset >= 0 && offset + size <= this.getDataSize()) : "Offset=" + offset + ",size=" + size + ",dataSize=" + this.getDataSize() + ", chunkSize=" + this.getSize() + ", but offset + size must be <= " + this.getDataSize();
        assert (size > 0);
        long result = this.getBaseDataAddress() + (long)offset;
        return result;
    }

    @Override
    public byte readDataByte(int offset) {
        assert (offset < this.getDataSize());
        return AddressableMemoryManager.readByte(this.getBaseDataAddress() + (long)offset);
    }

    @Override
    public void writeDataByte(int offset, byte value) {
        assert (offset < this.getDataSize());
        AddressableMemoryManager.writeByte(this.getBaseDataAddress() + (long)offset, value);
    }

    @Override
    public void readDataBytes(int offset, byte[] bytes) {
        this.readDataBytes(offset, bytes, 0, bytes.length);
    }

    @Override
    public void writeDataBytes(int offset, byte[] bytes) {
        this.writeDataBytes(offset, bytes, 0, bytes.length);
    }

    @Override
    public void readDataBytes(int offset, byte[] bytes, int bytesOffset, int size) {
        assert (offset + size <= this.getDataSize());
        AddressableMemoryManager.readBytes(this.getBaseDataAddress() + (long)offset, bytes, bytesOffset, size);
    }

    @Override
    public void writeDataBytes(int offset, byte[] bytes, int bytesOffset, int size) {
        assert (offset + size <= this.getDataSize());
        AddressableMemoryManager.writeBytes(this.getBaseDataAddress() + (long)offset, bytes, bytesOffset, size);
    }

    @Override
    public void release() {
        OffHeapStoredObject.release(this.memoryAddress);
    }

    @Override
    public int compareTo(OffHeapStoredObject o) {
        int result = Integer.signum(this.getSize() - o.getSize());
        if (result == 0) {
            result = Long.signum(this.getAddress() - o.getAddress());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof OffHeapStoredObject) {
            return this.getAddress() == ((OffHeapStoredObject)o).getAddress();
        }
        return false;
    }

    public int hashCode() {
        long value = this.getAddress();
        return (int)(value ^ value >>> 32);
    }

    public void setSerializedValue(byte[] value) {
        this.writeDataBytes(0, value);
    }

    public byte[] getDecompressedBytes(RegionEntryContext context) {
        byte[] result = this.getCompressedBytes();
        long time = context.getCachePerfStats().startDecompression();
        result = context.getCompressor().decompress(result);
        context.getCachePerfStats().endDecompression(time);
        return result;
    }

    public byte[] getCompressedBytes() {
        byte[] result = new byte[this.getDataSize()];
        this.readDataBytes(0, result);
        MemoryAllocatorImpl.getAllocator().getStats().incReads();
        return result;
    }

    protected byte[] getRawBytes() {
        assert (!this.isCompressed());
        return this.getCompressedBytes();
    }

    @Override
    public byte[] getSerializedValue() {
        byte[] result = this.getRawBytes();
        if (!this.isSerialized()) {
            result = EntryEventImpl.serialize(result);
        }
        return result;
    }

    @Override
    public Object getDeserializedValue(Region r, RegionEntry re) {
        if (this.isSerialized()) {
            return EntryEventImpl.deserialize(this.getRawBytes());
        }
        return this.getRawBytes();
    }

    @Override
    public int getSizeInBytes() {
        return this.getSize();
    }

    @Override
    public int getValueSizeInBytes() {
        return this.getDataSize();
    }

    @Override
    public boolean isSerialized() {
        return (AddressableMemoryManager.readInt(this.memoryAddress + 4L) & Integer.MIN_VALUE) != 0;
    }

    @Override
    public boolean isCompressed() {
        return (AddressableMemoryManager.readInt(this.memoryAddress + 4L) & 0x40000000) != 0;
    }

    @Override
    public boolean retain() {
        return OffHeapStoredObject.retain(this.memoryAddress);
    }

    @Override
    public int getRefCount() {
        return OffHeapStoredObject.getRefCount(this.memoryAddress);
    }

    public static int getSize(long memAddr) {
        MemoryAllocatorImpl.validateAddress(memAddr);
        return AddressableMemoryManager.readInt(memAddr + 0L);
    }

    public static void setSize(long memAddr, int size) {
        MemoryAllocatorImpl.validateAddressAndSize(memAddr, size);
        AddressableMemoryManager.writeInt(memAddr + 0L, size);
    }

    public static long getNext(long memAddr) {
        MemoryAllocatorImpl.validateAddress(memAddr);
        return AddressableMemoryManager.readLong(memAddr + 8L);
    }

    public static void setNext(long memAddr, long next) {
        MemoryAllocatorImpl.validateAddress(memAddr);
        AddressableMemoryManager.writeLong(memAddr + 8L, next);
    }

    public static void fill(long baseAddress) {
        long startAddress = baseAddress + 16L;
        int size = OffHeapStoredObject.getSize(baseAddress) - 16;
        AddressableMemoryManager.fill(startAddress, size, (byte)60);
    }

    public void validateFill() {
        assert (FreeListManager.TINY_MULTIPLE == 8);
        long startAddress = this.getAddress() + 16L;
        int size = this.getSize() - 16;
        for (int i = 0; i < size; i += FreeListManager.TINY_MULTIPLE) {
            if (AddressableMemoryManager.readLong(startAddress + (long)i) == 0x3C3C3C3C3C3C3C3CL) continue;
            throw new IllegalStateException("Fill pattern violated for chunk " + this.getAddress() + " with size " + this.getSize());
        }
    }

    public void setSerialized(boolean isSerialized) {
        if (isSerialized) {
            int bits;
            int originalBits;
            do {
                if (((originalBits = AddressableMemoryManager.readIntVolatile(this.memoryAddress + 4L)) & 0x7000000) == 0x5000000) continue;
                throw new IllegalStateException("It looks like this off heap memory was already freed. rawBits=" + Integer.toHexString(originalBits));
            } while (!AddressableMemoryManager.writeIntVolatile(this.memoryAddress + 4L, originalBits, bits = originalBits | Integer.MIN_VALUE));
        }
    }

    public void setCompressed(boolean isCompressed) {
        if (isCompressed) {
            int bits;
            int originalBits;
            do {
                if (((originalBits = AddressableMemoryManager.readIntVolatile(this.memoryAddress + 4L)) & 0x7000000) == 0x5000000) continue;
                throw new IllegalStateException("It looks like this off heap memory was already freed. rawBits=" + Integer.toHexString(originalBits));
            } while (!AddressableMemoryManager.writeIntVolatile(this.memoryAddress + 4L, originalBits, bits = originalBits | 0x40000000));
        }
    }

    public void setDataSize(int dataSize) {
        int originalBits;
        assert (dataSize <= this.getSize());
        int delta = this.getSize() - dataSize;
        assert (delta <= 255);
        delta <<= 16;
        do {
            if (((originalBits = AddressableMemoryManager.readIntVolatile(this.memoryAddress + 4L)) & 0x7000000) != 0x5000000) {
                throw new IllegalStateException("It looks like this off heap memory was already freed. rawBits=" + Integer.toHexString(originalBits));
            }
            int bits = originalBits;
            bits &= 0xFF00FFFF;
        } while (!AddressableMemoryManager.writeIntVolatile(this.memoryAddress + 4L, originalBits, bits |= delta));
    }

    public void initializeUseCount() {
        int rawBits;
        do {
            if (((rawBits = AddressableMemoryManager.readIntVolatile(this.memoryAddress + 4L)) & 0x7000000) != 0x5000000) {
                throw new IllegalStateException("It looks like this off heap memory was already freed. rawBits=" + Integer.toHexString(rawBits));
            }
            int uc = rawBits & 0xFFFF;
            if (uc == 0) continue;
            throw new IllegalStateException("Expected use count to be zero but it was: " + uc + " rawBits=0x" + Integer.toHexString(rawBits));
        } while (!AddressableMemoryManager.writeIntVolatile(this.memoryAddress + 4L, rawBits, rawBits + 1));
    }

    public static int getRefCount(long memAddr) {
        return AddressableMemoryManager.readInt(memAddr + 4L) & 0xFFFF;
    }

    public static boolean retain(long memAddr) {
        int uc;
        int rawBits;
        MemoryAllocatorImpl.validateAddress(memAddr);
        int retryCount = 0;
        do {
            if (((rawBits = AddressableMemoryManager.readIntVolatile(memAddr + 4L)) & 0x7000000) != 0x5000000) {
                return false;
            }
            uc = rawBits & 0xFFFF;
            if (uc == 65535) {
                throw new IllegalStateException("Maximum use count exceeded. rawBits=" + Integer.toHexString(rawBits));
            }
            if (uc == 0) {
                return false;
            }
            if (++retryCount <= 1000) continue;
            throw new IllegalStateException("tried to write " + (rawBits + 1) + " to @" + Long.toHexString(memAddr) + " 1,000 times.");
        } while (!AddressableMemoryManager.writeIntVolatile(memAddr + 4L, rawBits, rawBits + 1));
        if (ReferenceCountHelper.trackReferenceCounts()) {
            ReferenceCountHelper.refCountChanged(memAddr, false, uc + 1);
        }
        return true;
    }

    public static void release(long memAddr) {
        OffHeapStoredObject.release(memAddr, null);
    }

    static void release(long memAddr, FreeListManager freeListManager) {
        boolean returnToAllocator;
        int newCount;
        int rawBits;
        MemoryAllocatorImpl.validateAddress(memAddr);
        do {
            returnToAllocator = false;
            rawBits = AddressableMemoryManager.readIntVolatile(memAddr + 4L);
            if ((rawBits & 0x7000000) != 0x5000000) {
                String msg = "It looks like off heap memory @" + Long.toHexString(memAddr) + " was already freed. rawBits=" + Integer.toHexString(rawBits) + " history=" + ReferenceCountHelper.getFreeRefCountInfo(memAddr);
                throw new IllegalStateException(msg);
            }
            int curCount = rawBits & 0xFFFF;
            if (curCount == 0) {
                throw new IllegalStateException("Memory has already been freed. history=" + ReferenceCountHelper.getFreeRefCountInfo(memAddr));
            }
            if (curCount == 1) {
                newCount = 0;
                returnToAllocator = true;
                continue;
            }
            newCount = rawBits - 1;
        } while (!AddressableMemoryManager.writeIntVolatile(memAddr + 4L, rawBits, newCount));
        if (returnToAllocator) {
            if (ReferenceCountHelper.trackReferenceCounts()) {
                if (ReferenceCountHelper.trackFreedReferenceCounts()) {
                    ReferenceCountHelper.refCountChanged(memAddr, true, newCount & 0xFFFF);
                }
                ReferenceCountHelper.freeRefCountInfo(memAddr);
            }
            if (freeListManager == null) {
                freeListManager = MemoryAllocatorImpl.getAllocator().getFreeListManager();
            }
            freeListManager.free(memAddr);
        } else if (ReferenceCountHelper.trackReferenceCounts()) {
            ReferenceCountHelper.refCountChanged(memAddr, true, newCount & 0xFFFF);
        }
    }

    public String toString() {
        return super.toString() + ":<dataSize=" + this.getDataSize() + " refCount=" + this.getRefCount() + " addr=" + Long.toHexString(this.getAddress()) + ">";
    }

    @Override
    public MemoryBlock.State getState() {
        if (this.getRefCount() > 0) {
            return MemoryBlock.State.ALLOCATED;
        }
        return MemoryBlock.State.DEALLOCATED;
    }

    @Override
    public MemoryBlock getNextBlock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getBlockSize() {
        return this.getSize();
    }

    @Override
    public int getSlabId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFreeListId() {
        return -1;
    }

    @Override
    public String getDataType() {
        return null;
    }

    @Override
    public Object getDataValue() {
        return null;
    }

    @Override
    public StoredObject slice(int position, int limit) {
        return new OffHeapStoredObjectSlice(this, position, limit);
    }

    @Override
    public boolean hasRefCount() {
        return true;
    }
}

