/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security;

import java.io.IOException;
import java.security.AccessController;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.GemFireIOException;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.security.shiro.GeodeAuthenticationToken;
import org.apache.geode.internal.security.shiro.SecurityManagerProvider;
import org.apache.geode.internal.security.shiro.ShiroPrincipal;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.PostProcessor;
import org.apache.geode.security.ResourcePermission;
import org.apache.geode.security.SecurityManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.ShiroException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.support.SubjectThreadState;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.util.ThreadState;

public class IntegratedSecurityService
implements SecurityService {
    private static Logger logger = LogService.getLogger("org.apache.geode.security");
    public static final String CREDENTIALS_SESSION_ATTRIBUTE = "credentials";
    private final PostProcessor postProcessor;
    private final SecurityManager securityManager;

    IntegratedSecurityService(SecurityManagerProvider provider, PostProcessor postProcessor) {
        assert (provider.getShiroSecurityManager() != null);
        SecurityUtils.setSecurityManager((org.apache.shiro.mgt.SecurityManager)provider.getShiroSecurityManager());
        this.securityManager = provider.getSecurityManager();
        this.postProcessor = postProcessor;
    }

    @Override
    public PostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public org.apache.shiro.subject.Subject getSubject() {
        Set<ShiroPrincipal> principals;
        Subject jmxSubject = Subject.getSubject(AccessController.getContext());
        if (jmxSubject != null && !(principals = jmxSubject.getPrincipals(ShiroPrincipal.class)).isEmpty()) {
            ShiroPrincipal principal = principals.iterator().next();
            org.apache.shiro.subject.Subject currentUser = principal.getSubject();
            ThreadContext.bind((org.apache.shiro.subject.Subject)currentUser);
            return currentUser;
        }
        org.apache.shiro.subject.Subject currentUser = SecurityUtils.getSubject();
        if (currentUser == null || currentUser.getPrincipal() == null) {
            throw new GemFireSecurityException("Error: Anonymous User");
        }
        return currentUser;
    }

    @Override
    public org.apache.shiro.subject.Subject login(Properties credentials) {
        if (credentials == null) {
            throw new AuthenticationRequiredException("credentials are null");
        }
        ThreadContext.remove();
        org.apache.shiro.subject.Subject currentUser = SecurityUtils.getSubject();
        GeodeAuthenticationToken token = new GeodeAuthenticationToken(credentials);
        try {
            logger.debug("Logging in " + token.getPrincipal());
            currentUser.login((AuthenticationToken)token);
        }
        catch (ShiroException e) {
            logger.info(e.getMessage(), (Throwable)e);
            throw new AuthenticationFailedException("Authentication error. Please check your credentials.", e);
        }
        Session currentSession = currentUser.getSession();
        currentSession.setAttribute((Object)CREDENTIALS_SESSION_ATTRIBUTE, (Object)credentials);
        return currentUser;
    }

    @Override
    public void logout() {
        org.apache.shiro.subject.Subject currentUser = this.getSubject();
        try {
            logger.debug("Logging out " + currentUser.getPrincipal());
            currentUser.logout();
        }
        catch (ShiroException e) {
            logger.info(e.getMessage(), (Throwable)e);
            throw new GemFireSecurityException(e.getMessage(), e);
        }
        ThreadContext.remove();
    }

    @Override
    public Callable associateWith(Callable callable) {
        org.apache.shiro.subject.Subject currentUser = this.getSubject();
        return currentUser.associateWith(callable);
    }

    @Override
    public ThreadState bindSubject(org.apache.shiro.subject.Subject subject) {
        if (subject == null) {
            throw new GemFireSecurityException("Error: Anonymous User");
        }
        SubjectThreadState threadState = new SubjectThreadState(subject);
        threadState.bind();
        return threadState;
    }

    @Override
    public void authorize(ResourcePermission.Resource resource, ResourcePermission.Operation operation) {
        this.authorize(resource, operation, ResourcePermission.Target.ALL, ResourcePermission.ALL);
    }

    @Override
    public void authorize(ResourcePermission.Resource resource, ResourcePermission.Operation operation, ResourcePermission.Target target) {
        this.authorize(resource, operation, target, ResourcePermission.ALL);
    }

    @Override
    public void authorize(ResourcePermission.Resource resource, ResourcePermission.Operation operation, String target) {
        this.authorize(resource, operation, target, ResourcePermission.ALL);
    }

    @Override
    public void authorize(ResourcePermission.Resource resource, ResourcePermission.Operation operation, ResourcePermission.Target target, String key) {
        this.authorize(new ResourcePermission(resource, operation, target, key));
    }

    @Override
    public void authorize(ResourcePermission.Resource resource, ResourcePermission.Operation operation, String target, String key) {
        this.authorize(new ResourcePermission(resource, operation, target, key));
    }

    @Override
    public void authorize(ResourcePermission context) {
        if (context == null) {
            return;
        }
        if (context.getResource() == ResourcePermission.Resource.NULL && context.getOperation() == ResourcePermission.Operation.NULL) {
            return;
        }
        org.apache.shiro.subject.Subject currentUser = this.getSubject();
        try {
            currentUser.checkPermission((Permission)context);
        }
        catch (ShiroException e) {
            String msg = currentUser.getPrincipal() + " not authorized for " + (Object)((Object)context);
            logger.info(msg);
            throw new NotAuthorizedException(msg, e);
        }
    }

    @Override
    public void close() {
        if (this.securityManager != null) {
            this.securityManager.close();
        }
        if (this.postProcessor != null) {
            this.postProcessor.close();
        }
        ThreadContext.remove();
        SecurityUtils.setSecurityManager(null);
    }

    @Override
    public boolean needPostProcess() {
        return this.postProcessor != null;
    }

    @Override
    public Object postProcess(String regionPath, Object key, Object value, boolean valueIsSerialized) {
        return this.postProcess(null, regionPath, key, value, valueIsSerialized);
    }

    @Override
    public Object postProcess(Object principal, String regionPath, Object key, Object value, boolean valueIsSerialized) {
        Object newValue;
        if (!this.needPostProcess()) {
            return value;
        }
        if (principal == null) {
            principal = this.getSubject().getPrincipal();
        }
        String regionName = StringUtils.stripStart((String)regionPath, (String)"/");
        if (valueIsSerialized && value instanceof byte[]) {
            try {
                Object oldObj = EntryEventImpl.deserialize((byte[])value);
                Object newObj = this.postProcessor.processRegionValue(principal, regionName, key, oldObj);
                newValue = BlobHelper.serializeToBlob(newObj);
            }
            catch (IOException | SerializationException e) {
                throw new GemFireIOException("Exception de/serializing entry value", e);
            }
        } else {
            newValue = this.postProcessor.processRegionValue(principal, regionName, key, value);
        }
        return newValue;
    }

    @Override
    public boolean isIntegratedSecurity() {
        return true;
    }

    @Override
    public boolean isClientSecurityRequired() {
        return true;
    }

    @Override
    public boolean isPeerSecurityRequired() {
        return true;
    }
}

