/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security;

import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.security.SecurityService;

public class LegacySecurityService
implements SecurityService {
    private final boolean hasClientAuthenticator;
    private final boolean hasPeerAuthenticator;

    LegacySecurityService() {
        this.hasClientAuthenticator = false;
        this.hasPeerAuthenticator = false;
    }

    LegacySecurityService(String clientAuthenticator, String peerAuthenticator) {
        this.hasClientAuthenticator = StringUtils.isNotBlank((String)clientAuthenticator);
        this.hasPeerAuthenticator = StringUtils.isNotBlank((String)peerAuthenticator);
    }

    @Override
    public boolean isClientSecurityRequired() {
        return this.hasClientAuthenticator;
    }

    @Override
    public boolean isIntegratedSecurity() {
        return false;
    }

    @Override
    public boolean isPeerSecurityRequired() {
        return this.hasPeerAuthenticator;
    }
}

