/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.cache.CacheConfig;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.security.CallbackInstantiator;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.LegacySecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.security.shiro.SecurityManagerProvider;
import org.apache.geode.security.PostProcessor;
import org.apache.geode.security.SecurityManager;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;

public class SecurityServiceFactory {
    private SecurityServiceFactory() {
    }

    public static SecurityService create() {
        return new LegacySecurityService();
    }

    public static SecurityService create(Properties securityProps) {
        return SecurityServiceFactory.create(securityProps, null, null);
    }

    public static SecurityService create(Properties securityProps, CacheConfig cacheConfig) {
        if (cacheConfig == null) {
            return SecurityServiceFactory.create(securityProps, null, null);
        }
        return SecurityServiceFactory.create(securityProps, cacheConfig.getSecurityManager(), cacheConfig.getPostProcessor());
    }

    public static SecurityService create(Properties securityProps, SecurityManager preferredSecurityManager, PostProcessor preferredPostProcessor) {
        if (securityProps == null) {
            securityProps = new Properties();
        }
        String shiroConfig = securityProps.getProperty("security-shiro-init");
        SecurityManager securityManager = CallbackInstantiator.getSecurityManager(securityProps);
        PostProcessor postProcessor = CallbackInstantiator.getPostProcessor(securityProps);
        if (preferredSecurityManager != null) {
            shiroConfig = null;
            securityManager = preferredSecurityManager;
        }
        if (preferredPostProcessor != null) {
            postProcessor = preferredPostProcessor;
        }
        if (StringUtils.isNotBlank((String)shiroConfig)) {
            return new IntegratedSecurityService(new SecurityManagerProvider(shiroConfig), postProcessor);
        }
        if (securityManager != null) {
            return new IntegratedSecurityService(new SecurityManagerProvider(securityManager), postProcessor);
        }
        if (SecurityServiceFactory.isShiroInUse()) {
            return new IntegratedSecurityService(new SecurityManagerProvider(), postProcessor);
        }
        String clientAuthenticatorConfig = securityProps.getProperty("security-client-authenticator");
        String peerAuthenticatorConfig = securityProps.getProperty("security-peer-authenticator");
        return new LegacySecurityService(clientAuthenticatorConfig, peerAuthenticatorConfig);
    }

    public static SecurityService findSecurityService() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null) {
            return cache.getSecurityService();
        }
        return SecurityServiceFactory.create();
    }

    private static boolean isShiroInUse() {
        try {
            return SecurityUtils.getSecurityManager() != null;
        }
        catch (UnavailableSecurityManagerException ignore) {
            return false;
        }
    }
}

