/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.util.List;
import java.util.Map;

public class ArgumentRedactor {
    private ArgumentRedactor() {
    }

    public static String redact(List<String> args) {
        StringBuilder redacted = new StringBuilder();
        for (String arg : args) {
            redacted.append(ArgumentRedactor.redact(arg)).append(" ");
        }
        return redacted.toString().trim();
    }

    public static String redact(Map<String, String> map) {
        StringBuilder redacted = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            redacted.append(entry.getKey());
            redacted.append("=");
            redacted.append(ArgumentRedactor.redact(entry));
            redacted.append(" ");
        }
        return redacted.toString().trim();
    }

    public static String redact(Map.Entry<String, String> entry) {
        return ArgumentRedactor.redact(entry.getKey(), entry.getValue());
    }

    public static String redact(String line) {
        StringBuilder redacted = new StringBuilder();
        if (line.startsWith("-")) {
            line = " " + line;
            String[] args = line.split(" -");
            StringBuilder param = new StringBuilder();
            for (String arg : args) {
                if (arg.isEmpty()) {
                    param.append("-");
                } else {
                    String[] pair = arg.split("=", 2);
                    param.append(pair[0].trim());
                    if (pair.length == 1) {
                        redacted.append((CharSequence)param);
                    } else {
                        redacted.append((CharSequence)param).append("=").append(ArgumentRedactor.redact(param.toString(), pair[1].trim()));
                    }
                    redacted.append(" ");
                }
                param.setLength(0);
                param.append("-");
            }
        } else {
            String[] args = line.split("=", 2);
            if (args.length == 1) {
                redacted.append(line);
            } else {
                redacted.append(args[0].trim()).append("=").append(ArgumentRedactor.redact(args[0], args[1]));
            }
            redacted.append(" ");
        }
        return redacted.toString().trim();
    }

    public static String redactScriptLine(String line) {
        return line.replaceAll("password=[\\S]+", "password=********");
    }

    public static String redact(String key, String value) {
        if (ArgumentRedactor.shouldBeRedacted(key)) {
            return "********";
        }
        return value.trim();
    }

    private static boolean shouldBeRedacted(String key) {
        if (key == null) {
            return false;
        }
        String compareKey = key;
        if (key.startsWith("-J")) {
            compareKey = key.substring(2);
        }
        if (compareKey.startsWith("-D")) {
            compareKey = compareKey.substring(2);
        }
        return compareKey.toLowerCase().contains("password");
    }
}

