/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.InternalQueryService;
import org.apache.geode.cache.query.internal.QCompiler;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalDataSet;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.ManagementConstants;
import org.apache.geode.management.internal.ManagementStrings;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.beans.BeanUtilFuncs;
import org.apache.geode.management.internal.cli.commands.DataCommandsUtils;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.json.TypedJson;
import org.apache.logging.log4j.Logger;

public class QueryDataFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogService.getLogger();
    private static final String MEMBER_KEY = "member";
    private static final String RESULT_KEY = "result";
    private static final String NO_DATA_FOUND = "No Data Found";
    private static final String QUERY_EXEC_SUCCESS = "Query Executed Successfully";
    private static final int DISPLAY_MEMBERWISE = 0;
    private static final int QUERY = 1;
    private static final int REGION = 2;
    private static final int LIMIT = 3;
    private static final int QUERY_RESULTSET_LIMIT = 4;
    private static final int QUERY_COLLECTIONS_DEPTH = 5;
    private static final String SELECT_EXPR = "\\s*SELECT\\s+.+\\s+FROM.+";
    private static final Pattern SELECT_EXPR_PATTERN = Pattern.compile("\\s*SELECT\\s+.+\\s+FROM.+", 2);
    private static final String SELECT_WITH_LIMIT_EXPR = "\\s*SELECT\\s+.+\\s+FROM(\\s+|(.*\\s+))LIMIT\\s+[0-9]+.*";
    private static final Pattern SELECT_WITH_LIMIT_EXPR_PATTERN = Pattern.compile("\\s*SELECT\\s+.+\\s+FROM(\\s+|(.*\\s+))LIMIT\\s+[0-9]+.*", 2);

    @Override
    public boolean hasResult() {
        return true;
    }

    public void execute(FunctionContext context) {
        Object[] functionArgs = (Object[])context.getArguments();
        boolean showMember = (Boolean)functionArgs[0];
        String queryString = (String)functionArgs[1];
        String regionName = (String)functionArgs[2];
        int limit = (Integer)functionArgs[3];
        int queryResultSetLimit = (Integer)functionArgs[4];
        int queryCollectionsDepth = (Integer)functionArgs[5];
        try {
            context.getResultSender().lastResult(this.selectWithType(context, queryString, showMember, regionName, limit, queryResultSetLimit, queryCollectionsDepth));
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }

    @Override
    public String getId() {
        return ManagementConstants.QUERY_DATA_FUNCTION;
    }

    private QueryDataFunctionResult selectWithType(FunctionContext context, String queryString, boolean showMember, String regionName, int limit, int queryResultSetLimit, int queryCollectionsDepth) throws Exception {
        InternalCache cache = this.getCache();
        LocalQueryFunction localQueryFunc = new LocalQueryFunction("LocalQueryFunction", regionName, showMember).setOptimizeForWrite(true);
        queryString = QueryDataFunction.applyLimitClause(queryString, limit, queryResultSetLimit);
        try {
            TypedJson result = new TypedJson(queryCollectionsDepth);
            Region region = cache.getRegion(regionName);
            if (region == null) {
                throw new Exception(ManagementStrings.QUERY__MSG__REGIONS_NOT_FOUND_ON_MEMBER.toLocalizedString(regionName, cache.getDistributedSystem().getDistributedMember().getId()));
            }
            Object results = null;
            boolean noDataFound = true;
            if (region.getAttributes().getDataPolicy() == DataPolicy.NORMAL) {
                InternalQueryService queryService = cache.getQueryService();
                Query query = queryService.newQuery(queryString);
                results = query.execute();
            } else {
                PartitionedRegion parRegion = PartitionedRegionHelper.getPartitionedRegion(regionName, cache);
                if (parRegion != null && showMember) {
                    if (parRegion.isDataStore()) {
                        Set<BucketRegion> localPrimaryBucketRegions = parRegion.getDataStore().getAllLocalPrimaryBucketRegions();
                        HashSet<Integer> localPrimaryBucketSet = new HashSet<Integer>();
                        for (BucketRegion bRegion : localPrimaryBucketRegions) {
                            localPrimaryBucketSet.add(bRegion.getId());
                        }
                        LocalDataSet lds = new LocalDataSet(parRegion, localPrimaryBucketSet);
                        DefaultQuery query = (DefaultQuery)cache.getQueryService().newQuery(queryString);
                        results = lds.executeQuery(query, null, localPrimaryBucketSet);
                    }
                } else {
                    ResultCollector rcollector = FunctionService.onRegion(cache.getRegion(regionName)).setArguments(queryString).execute(localQueryFunc);
                    results = rcollector.getResult();
                }
            }
            if (results != null && results instanceof SelectResults) {
                SelectResults selectResults = (SelectResults)results;
                for (Object object : selectResults) {
                    result.add(RESULT_KEY, object);
                    noDataFound = false;
                }
            } else if (results != null && results instanceof ArrayList) {
                ArrayList listResults = (ArrayList)results;
                ArrayList actualResult = (ArrayList)listResults.get(0);
                for (Object object : actualResult) {
                    result.add(RESULT_KEY, object);
                    noDataFound = false;
                }
            }
            if (!noDataFound && showMember) {
                result.add(MEMBER_KEY, cache.getDistributedSystem().getDistributedMember().getId());
            }
            if (noDataFound) {
                return new QueryDataFunctionResult(QUERY_EXEC_SUCCESS, BeanUtilFuncs.compress(new JsonisedErrorMessage(NO_DATA_FOUND).toString()));
            }
            return new QueryDataFunctionResult(QUERY_EXEC_SUCCESS, BeanUtilFuncs.compress(result.toString()));
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected static String applyLimitClause(String query, int limit, int queryResultSetLimit) {
        Matcher limit_matcher;
        boolean queryAlreadyHasLimitClause;
        Matcher matcher = SELECT_EXPR_PATTERN.matcher(query);
        if (matcher.matches() && !(queryAlreadyHasLimitClause = (limit_matcher = SELECT_WITH_LIMIT_EXPR_PATTERN.matcher(query)).matches())) {
            if (limit == 0) {
                limit = queryResultSetLimit;
            }
            String result = query;
            result = result + " LIMIT " + limit;
            return result;
        }
        return query;
    }

    private static Object callFunction(Object functionArgs, Set<DistributedMember> members, boolean zipResult) throws Exception {
        try {
            if (members.size() == 1) {
                DistributedMember member = members.iterator().next();
                ResultCollector collector = FunctionService.onMember(member).setArguments(functionArgs).execute(ManagementConstants.QUERY_DATA_FUNCTION);
                List list = (List)collector.getResult();
                Object object = null;
                if (list.size() > 0) {
                    object = list.get(0);
                }
                if (object instanceof Throwable) {
                    throw (Throwable)object;
                }
                QueryDataFunctionResult result = object;
                if (zipResult) {
                    return result.compressedBytes;
                }
                Object[] functionArgsList = (Object[])functionArgs;
                boolean showMember = (Boolean)functionArgsList[0];
                if (showMember) {
                    ArrayList<String> decompressedList = new ArrayList<String>();
                    decompressedList.add(BeanUtilFuncs.decompress(result.compressedBytes));
                    return QueryDataFunction.wrapResult(((Object)decompressedList).toString());
                }
                return BeanUtilFuncs.decompress(result.compressedBytes);
            }
            ResultCollector coll = FunctionService.onMembers(members).setArguments(functionArgs).execute(ManagementConstants.QUERY_DATA_FUNCTION);
            List list = (List)coll.getResult();
            Object object = list.get(0);
            if (object instanceof Throwable) {
                throw (Throwable)object;
            }
            Iterator it = list.iterator();
            ArrayList<String> decompressedList = new ArrayList<String>();
            while (it.hasNext()) {
                String decompressedStr = BeanUtilFuncs.decompress(((QueryDataFunctionResult)it.next()).compressedBytes);
                decompressedList.add(decompressedStr);
            }
            if (zipResult) {
                return BeanUtilFuncs.compress(QueryDataFunction.wrapResult(((Object)decompressedList).toString()));
            }
            return QueryDataFunction.wrapResult(((Object)decompressedList).toString());
        }
        catch (FunctionException fe) {
            throw new Exception(ManagementStrings.QUERY__MSG__QUERY_EXEC.toLocalizedString(fe.getMessage()));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            throw new Exception(ManagementStrings.QUERY__MSG__QUERY_EXEC.toLocalizedString(e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String wrapResult(String str) {
        StringWriter w = new StringWriter();
        StringBuffer stringBuffer = w.getBuffer();
        synchronized (stringBuffer) {
            w.write("{\"result\":");
            w.write(str);
            w.write("}");
            return w.toString();
        }
    }

    public static Object queryData(String query, String members, int limit, boolean zipResult, int queryResultSetLimit, int queryCollectionsDepth) throws Exception {
        if (query == null || query.isEmpty()) {
            return new JsonisedErrorMessage(ManagementStrings.QUERY__MSG__QUERY_EMPTY.toLocalizedString()).toString();
        }
        HashSet<DistributedMember> inputMembers = null;
        if (StringUtils.isNotBlank((String)members)) {
            inputMembers = new HashSet<DistributedMember>();
            StringTokenizer st = new StringTokenizer(members, ",");
            while (st.hasMoreTokens()) {
                String member = st.nextToken();
                DistributedMember distributedMember = BeanUtilFuncs.getDistributedMemberByNameOrId(member);
                inputMembers.add(distributedMember);
                if (distributedMember != null) continue;
                return new JsonisedErrorMessage(ManagementStrings.QUERY__MSG__INVALID_MEMBER.toLocalizedString(member)).toString();
            }
        }
        InternalCache cache = (InternalCache)CacheFactory.getAnyInstance();
        try {
            DistributedRegionMXBean regionMBean;
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
            Set<String> regionsInQuery = QueryDataFunction.compileQuery(cache, query);
            if (regionsInQuery.size() > 0) {
                for (String regionPath : regionsInQuery) {
                    regionMBean = service.getDistributedRegionMXBean(regionPath);
                    if (regionMBean == null) {
                        return new JsonisedErrorMessage(ManagementStrings.QUERY__MSG__REGIONS_NOT_FOUND.toLocalizedString(regionPath)).toString();
                    }
                    Set<DistributedMember> associatedMembers = DataCommandsUtils.getRegionAssociatedMembers(regionPath, cache, true);
                    if (inputMembers == null || inputMembers.size() <= 0 || associatedMembers.containsAll(inputMembers)) continue;
                    return new JsonisedErrorMessage(ManagementStrings.QUERY__MSG__REGIONS_NOT_FOUND_ON_MEMBERS.toLocalizedString(regionPath)).toString();
                }
            } else {
                return new JsonisedErrorMessage(ManagementStrings.QUERY__MSG__INVALID_QUERY.toLocalizedString("Region mentioned in query probably missing /")).toString();
            }
            if (regionsInQuery.size() > 1 && inputMembers == null) {
                for (String regionPath : regionsInQuery) {
                    regionMBean = service.getDistributedRegionMXBean(regionPath);
                    if (!regionMBean.getRegionType().equals(DataPolicy.PARTITION.toString()) && !regionMBean.getRegionType().equals(DataPolicy.PERSISTENT_PARTITION.toString())) continue;
                    return new JsonisedErrorMessage(ManagementStrings.QUERY__MSG__JOIN_OP_EX.toLocalizedString()).toString();
                }
            }
            String randomRegion = regionsInQuery.iterator().next();
            Set<DistributedMember> associatedMembers = DataCommandsUtils.getQueryRegionsAssociatedMembers(regionsInQuery, cache, false);
            if (associatedMembers != null && associatedMembers.size() > 0) {
                Object[] functionArgs = new Object[6];
                if (inputMembers != null && inputMembers.size() > 0) {
                    functionArgs[0] = true;
                    functionArgs[1] = query;
                    functionArgs[2] = randomRegion;
                    functionArgs[3] = limit;
                    functionArgs[4] = queryResultSetLimit;
                    functionArgs[5] = queryCollectionsDepth;
                    return QueryDataFunction.callFunction(functionArgs, inputMembers, zipResult);
                }
                functionArgs[0] = false;
                functionArgs[1] = query;
                functionArgs[2] = randomRegion;
                functionArgs[3] = limit;
                functionArgs[4] = queryResultSetLimit;
                functionArgs[5] = queryCollectionsDepth;
                return QueryDataFunction.callFunction(functionArgs, associatedMembers, zipResult);
            }
            return new JsonisedErrorMessage(ManagementStrings.QUERY__MSG__REGIONS_NOT_FOUND.toLocalizedString(regionsInQuery.toString())).toString();
        }
        catch (QueryInvalidException qe) {
            return new JsonisedErrorMessage(ManagementStrings.QUERY__MSG__INVALID_QUERY.toLocalizedString(qe.getMessage())).toString();
        }
    }

    private InternalCache getCache() {
        return (InternalCache)CacheFactory.getAnyInstance();
    }

    private static Set<String> compileQuery(InternalCache cache, String query) throws QueryInvalidException {
        QCompiler compiler = new QCompiler();
        try {
            CompiledValue compiledQuery = compiler.compileQuery(query);
            HashSet regions = new HashSet();
            compiledQuery.getRegionsInQuery(regions, null);
            Set<String> regionsInQuery = Collections.unmodifiableSet(regions);
            return regionsInQuery;
        }
        catch (QueryInvalidException qe) {
            logger.error("{} Failed, Error {}", (Object)query, (Object)qe.getMessage(), (Object)qe);
            throw qe;
        }
    }

    private static class QueryDataFunctionResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String message;
        private final byte[] compressedBytes;

        public QueryDataFunctionResult(String message, byte[] compressedBytes) {
            this.message = message;
            this.compressedBytes = compressedBytes;
        }

        public String getMessage() {
            return this.message;
        }

        public byte[] getCompressedBytes() {
            return this.compressedBytes;
        }
    }

    private class LocalQueryFunction
    extends FunctionAdapter {
        private static final long serialVersionUID = 1L;
        private final String id;
        private boolean optimizeForWrite = false;
        private boolean showMembers = false;
        private String regionName;

        public LocalQueryFunction(String id, String regionName, boolean showMembers) {
            this.id = id;
            this.regionName = regionName;
            this.showMembers = showMembers;
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public boolean isHA() {
            return false;
        }

        @Override
        public boolean optimizeForWrite() {
            return this.optimizeForWrite;
        }

        public LocalQueryFunction setOptimizeForWrite(boolean optimizeForWrite) {
            this.optimizeForWrite = optimizeForWrite;
            return this;
        }

        public void execute(FunctionContext context) {
            InternalCache cache = this.getCache();
            InternalQueryService queryService = cache.getQueryService();
            String qstr = (String)context.getArguments();
            Region r = cache.getRegion(this.regionName);
            try {
                Query query = queryService.newQuery(qstr);
                if (r.getAttributes().getPartitionAttributes() != null && this.showMembers) {
                    SelectResults sr = (SelectResults)query.execute((RegionFunctionContext)context);
                    context.getResultSender().lastResult(sr.asList());
                } else {
                    SelectResults sr = (SelectResults)query.execute();
                    context.getResultSender().lastResult(sr.asList());
                }
            }
            catch (Exception e) {
                throw new FunctionException(e);
            }
        }

        private InternalCache getCache() {
            return (InternalCache)CacheFactory.getAnyInstance();
        }

        @Override
        public String getId() {
            return this.id;
        }
    }

    private static class JsonisedErrorMessage {
        private static String message = "message";
        private GfJsonObject gFJsonObject = new GfJsonObject();

        public JsonisedErrorMessage(String errorMessage) throws Exception {
            try {
                this.gFJsonObject.put(message, errorMessage);
            }
            catch (GfJsonException e) {
                throw new Exception(e);
            }
        }

        public String toString() {
            return this.gFJsonObject.toString();
        }
    }
}

