/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.lru.LRUStatistics;
import org.apache.geode.management.EvictionAttributesData;
import org.apache.geode.management.FixedPartitionAttributesData;
import org.apache.geode.management.MembershipAttributesData;
import org.apache.geode.management.PartitionAttributesData;
import org.apache.geode.management.RegionAttributesData;
import org.apache.geode.management.internal.ManagementStrings;
import org.apache.geode.management.internal.beans.DiskRegionBridge;
import org.apache.geode.management.internal.beans.PartitionedRegionBridge;
import org.apache.geode.management.internal.beans.RegionMBeanCompositeDataFactory;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;
import org.apache.geode.management.internal.beans.stats.StatType;
import org.apache.geode.management.internal.beans.stats.StatsAverageLatency;
import org.apache.geode.management.internal.beans.stats.StatsRate;

public class RegionMBeanBridge<K, V> {
    private EvictionAttributesData evictionAttributesData;
    private MembershipAttributesData membershipAttributesData;
    private RegionAttributesData regionAttributesData;
    private Region<K, V> region;
    private RegionAttributes<K, V> regAttrs;
    private boolean isStatisticsEnabled = false;
    private MBeanStatsMonitor regionMonitor;
    private StatsRate getRequestRate;
    private StatsRate putRequestRate;
    private StatsRate putAllRate;
    private StatsRate createsRate;
    private StatsAverageLatency listenerCallsAvgLatency;
    private StatsAverageLatency writerCallsAvgLatency;
    private StatsRate destroysRate;
    private StatsRate lruDestroyRate;
    private StatsRate lruEvictionRate;
    private boolean isGatewayEnabled = false;
    private boolean persistentEnabled = false;
    private String member;
    private LRUStatistics lruMemoryStats;
    private CachePerfStats regionStats;
    private DiskRegionBridge diskRegionBridge;
    private StatsRate averageWritesRate;
    private StatsRate averageReadsRate;

    public static <K, V> RegionMBeanBridge<K, V> getInstance(Region<K, V> region) {
        if (region.getAttributes().getPartitionAttributes() != null) {
            PartitionedRegionBridge<K, V> bridge = PartitionedRegionBridge.getInstance(region);
            PartitionedRegion parRegion = (PartitionedRegion)region;
            DiskStoreImpl dsi = parRegion.getDiskStore();
            if (dsi != null) {
                DiskRegionStats stats = parRegion.getDiskRegionStats();
                DiskRegionBridge diskRegionBridge = new DiskRegionBridge(stats);
                bridge.addDiskRegionBridge(diskRegionBridge);
                for (DirectoryHolder dh : dsi.getDirectoryHolders()) {
                    diskRegionBridge.addDirectoryStats(dh.getDiskDirectoryStats());
                }
                bridge.addDiskRegionBridge(diskRegionBridge);
            }
            return bridge;
        }
        RegionMBeanBridge<K, V> bridge = new RegionMBeanBridge<K, V>(region);
        LocalRegion localRegion = (LocalRegion)region;
        DiskStoreImpl dsi = localRegion.getDiskStore();
        if (dsi != null) {
            DiskRegionBridge diskRegionBridge = new DiskRegionBridge(localRegion.getDiskRegion().getStats());
            bridge.addDiskRegionBridge(diskRegionBridge);
            for (DirectoryHolder dh : dsi.getDirectoryHolders()) {
                diskRegionBridge.addDirectoryStats(dh.getDiskDirectoryStats());
            }
        }
        return bridge;
    }

    protected void addDiskRegionBridge(DiskRegionBridge diskRegionBridge) {
        this.diskRegionBridge = diskRegionBridge;
    }

    protected RegionMBeanBridge(Region<K, V> region) {
        LRUStatistics stats;
        LocalRegion l;
        this.region = region;
        this.regAttrs = region.getAttributes();
        this.isStatisticsEnabled = this.regAttrs.getStatisticsEnabled();
        this.regionAttributesData = RegionMBeanCompositeDataFactory.getRegionAttributesData(this.regAttrs);
        this.membershipAttributesData = RegionMBeanCompositeDataFactory.getMembershipAttributesData(this.regAttrs);
        this.evictionAttributesData = RegionMBeanCompositeDataFactory.getEvictionAttributesData(this.regAttrs);
        this.regionMonitor = new MBeanStatsMonitor(ManagementStrings.REGION_MONITOR.toLocalizedString());
        this.configureRegionMetrics();
        this.persistentEnabled = region.getAttributes().getDataPolicy().withPersistence();
        this.regionStats = ((LocalRegion)region).getRegionPerfStats();
        if (this.regionStats != null) {
            this.regionMonitor.addStatisticsToMonitor(this.regionStats.getStats());
        }
        if ((l = (LocalRegion)region).getEvictionController() != null && (stats = l.getEvictionController().getLRUHelper().getStats()) != null) {
            this.regionMonitor.addStatisticsToMonitor(stats.getStats());
            EvictionAttributes ea = region.getAttributes().getEvictionAttributes();
            if (ea != null && ea.getAlgorithm().isLRUMemory()) {
                this.lruMemoryStats = stats;
            }
        }
        if (this.regAttrs.getGatewaySenderIds() != null && this.regAttrs.getGatewaySenderIds().size() > 0) {
            this.isGatewayEnabled = true;
        }
        this.member = GemFireCacheImpl.getInstance().getDistributedSystem().getMemberId();
    }

    public String getRegionType() {
        return this.region.getAttributes().getDataPolicy().toString();
    }

    public String getFullPath() {
        return this.region.getFullPath();
    }

    public String getName() {
        return this.region.getName();
    }

    public EvictionAttributesData listEvictionAttributes() {
        return this.evictionAttributesData;
    }

    public MembershipAttributesData listMembershipAttributes() {
        return this.membershipAttributesData;
    }

    public RegionAttributesData listRegionAttributes() {
        return this.regionAttributesData;
    }

    public String getParentRegion() {
        if (this.region.getParentRegion() != null) {
            return this.region.getParentRegion().getName();
        }
        return null;
    }

    public String[] listSubRegionPaths(boolean recursive) {
        TreeSet<String> subregionPaths = new TreeSet<String>();
        Set<Region<?, ?>> subregions = this.region.subregions(recursive);
        for (Region<?, ?> region : subregions) {
            subregionPaths.add(region.getFullPath());
        }
        return subregionPaths.toArray(new String[subregionPaths.size()]);
    }

    public RegionMBeanBridge(CachePerfStats cachePerfStats) {
        this.regionStats = cachePerfStats;
        this.regionMonitor = new MBeanStatsMonitor(ManagementStrings.REGION_MONITOR.toLocalizedString());
        this.regionMonitor.addStatisticsToMonitor(cachePerfStats.getStats());
        this.configureRegionMetrics();
    }

    public RegionMBeanBridge() {
    }

    public void stopMonitor() {
        this.regionMonitor.stopListener();
        if (this.diskRegionBridge != null) {
            this.diskRegionBridge.stopMonitor();
        }
    }

    private void configureRegionMetrics() {
        this.putAllRate = new StatsRate("putalls", StatType.INT_TYPE, this.regionMonitor);
        this.getRequestRate = new StatsRate("gets", StatType.INT_TYPE, this.regionMonitor);
        this.putRequestRate = new StatsRate("puts", StatType.INT_TYPE, this.regionMonitor);
        this.destroysRate = new StatsRate("destroys", StatType.INT_TYPE, this.regionMonitor);
        this.createsRate = new StatsRate("creates", StatType.INT_TYPE, this.regionMonitor);
        this.listenerCallsAvgLatency = new StatsAverageLatency("cacheListenerCallsCompleted", StatType.INT_TYPE, "cacheListenerCallTime", this.regionMonitor);
        this.writerCallsAvgLatency = new StatsAverageLatency("cacheWriterCallsCompleted", StatType.INT_TYPE, "cacheWriterCallTime", this.regionMonitor);
        this.lruDestroyRate = new StatsRate("lruDestroys", StatType.LONG_TYPE, this.regionMonitor);
        this.lruEvictionRate = new StatsRate("lruEvictions", StatType.LONG_TYPE, this.regionMonitor);
        String[] writesRates = new String[]{"putalls", "puts", "creates"};
        this.averageWritesRate = new StatsRate(writesRates, StatType.INT_TYPE, this.regionMonitor);
        this.averageReadsRate = new StatsRate("gets", StatType.INT_TYPE, this.regionMonitor);
    }

    private Number getRegionStatistic(String statName) {
        if (this.regionStats != null) {
            return this.regionStats.getStats().get(statName);
        }
        return 0;
    }

    public long getEntryCount() {
        return this.getRegionStatistic("entries").longValue();
    }

    public long getCacheListenerCallsAvgLatency() {
        return this.listenerCallsAvgLatency.getAverageLatency();
    }

    public long getCacheWriterCallsAvgLatency() {
        return this.writerCallsAvgLatency.getAverageLatency();
    }

    public float getCreatesRate() {
        return this.createsRate.getRate();
    }

    public float getPutAllRate() {
        return this.putAllRate.getRate();
    }

    public float getPutsRate() {
        return this.putRequestRate.getRate();
    }

    public float getDestroyRate() {
        return this.destroysRate.getRate();
    }

    public float getGetsRate() {
        return this.getRequestRate.getRate();
    }

    public long getHitCount() {
        if (this.isStatisticsEnabled) {
            return this.region.getStatistics().getHitCount();
        }
        return -1L;
    }

    public float getHitRatio() {
        if (this.isStatisticsEnabled) {
            return this.region.getStatistics().getHitRatio();
        }
        return -1.0f;
    }

    public long getLastAccessedTime() {
        if (this.isStatisticsEnabled) {
            return this.region.getStatistics().getLastAccessedTime();
        }
        return -1L;
    }

    public long getLastModifiedTime() {
        if (this.isStatisticsEnabled) {
            return this.region.getStatistics().getLastModifiedTime();
        }
        return -1L;
    }

    public long getMissCount() {
        if (this.isStatisticsEnabled) {
            return this.region.getStatistics().getMissCount();
        }
        return -1L;
    }

    public float getLruDestroyRate() {
        return this.lruDestroyRate.getRate();
    }

    public float getLruEvictionRate() {
        return this.lruEvictionRate.getRate();
    }

    public float getAverageReads() {
        return this.averageReadsRate.getRate();
    }

    public float getAverageWrites() {
        return this.averageWritesRate.getRate();
    }

    public long getEntrySize() {
        if (this.lruMemoryStats != null) {
            return this.lruMemoryStats.getCounter();
        }
        return -1L;
    }

    public boolean isGatewayEnabled() {
        return this.isGatewayEnabled;
    }

    public boolean isPersistenceEnabled() {
        return this.persistentEnabled;
    }

    public String getMember() {
        return this.member;
    }

    public float getPutLocalRate() {
        return -1.0f;
    }

    public float getPutRemoteRate() {
        return -1.0f;
    }

    public long getPutRemoteAvgLatency() {
        return -1L;
    }

    public long getPutRemoteLatency() {
        return -1L;
    }

    public int getActualRedundancy() {
        return -1;
    }

    public int getAvgBucketSize() {
        return -1;
    }

    public int getBucketCount() {
        return -1;
    }

    public int getConfiguredRedundancy() {
        return -1;
    }

    public int getNumBucketsWithoutRedundancy() {
        return -1;
    }

    public int getPrimaryBucketCount() {
        return -1;
    }

    public int getTotalBucketSize() {
        return -1;
    }

    public FixedPartitionAttributesData[] listFixedPartitionAttributes() {
        return null;
    }

    public PartitionAttributesData listPartitionAttributes() {
        return null;
    }

    public long getDiskReadsAverageLatency() {
        if (this.diskRegionBridge != null) {
            return this.diskRegionBridge.getDiskReadsAverageLatency();
        }
        return 0L;
    }

    public float getDiskReadsRate() {
        if (this.diskRegionBridge != null) {
            return this.diskRegionBridge.getDiskReadsRate();
        }
        return 0.0f;
    }

    public long getDiskUsage() {
        if (this.diskRegionBridge != null) {
            return this.diskRegionBridge.getDiskUsage();
        }
        return 0L;
    }

    public long getDiskWritesAverageLatency() {
        if (this.diskRegionBridge != null) {
            return this.diskRegionBridge.getDiskWritesAverageLatency();
        }
        return 0L;
    }

    public float getDiskWritesRate() {
        if (this.diskRegionBridge != null) {
            return this.diskRegionBridge.getDiskWritesRate();
        }
        return 0.0f;
    }

    public long getTotalDiskEntriesInVM() {
        if (this.diskRegionBridge != null) {
            return this.diskRegionBridge.getTotalDiskEntriesInVM();
        }
        return 0L;
    }

    public long getTotalDiskWritesProgress() {
        if (this.diskRegionBridge != null) {
            return this.diskRegionBridge.getTotalDiskWritesProgress();
        }
        return 0L;
    }

    public long getTotalEntriesOnlyOnDisk() {
        if (this.diskRegionBridge != null) {
            return this.diskRegionBridge.getTotalEntriesOnlyOnDisk();
        }
        return 0L;
    }

    public long getDiskTaskWaiting() {
        if (this.diskRegionBridge != null) {
            return this.diskRegionBridge.getDiskTaskWaiting();
        }
        return 0L;
    }

    public int getLocalMaxMemory() {
        return -1;
    }
}

