/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.statistics.StatisticId;
import org.apache.geode.internal.statistics.StatisticNotFoundException;
import org.apache.geode.internal.statistics.StatisticsListener;
import org.apache.geode.internal.statistics.StatisticsNotification;
import org.apache.geode.internal.statistics.ValueMonitor;
import org.apache.logging.log4j.Logger;

public class MBeanStatsMonitor
implements StatisticsListener {
    private static final Logger logger = LogService.getLogger();
    protected ValueMonitor monitor;
    protected DefaultHashMap statsMap;
    protected String monitorName;

    public MBeanStatsMonitor(String name) {
        this(name, new ValueMonitor());
    }

    MBeanStatsMonitor(String name, ValueMonitor monitor) {
        this.monitorName = name;
        this.monitor = monitor;
        this.statsMap = new DefaultHashMap();
    }

    public void addStatisticsToMonitor(Statistics stats) {
        StatisticDescriptor[] descriptors;
        this.monitor.addListener(this);
        StatisticsType type = stats.getType();
        for (StatisticDescriptor d : descriptors = type.getStatistics()) {
            this.statsMap.put(d.getName(), stats.get(d));
        }
        this.monitor.addStatistics(stats);
    }

    public void removeStatisticsFromMonitor(Statistics stats) {
        this.statsMap.clear();
    }

    public void stopListener() {
        this.monitor.removeListener(this);
    }

    public Number getStatistic(String statName) {
        Number value = this.statsMap.get(statName);
        return value != null ? (Number)value : (Number)0;
    }

    @Override
    public void handleNotification(StatisticsNotification notification) {
        for (StatisticId statId : notification) {
            Number value;
            StatisticDescriptor descriptor = statId.getStatisticDescriptor();
            String name = descriptor.getName();
            try {
                value = notification.getValue(statId);
            }
            catch (StatisticNotFoundException e) {
                value = 0;
            }
            this.log(name, value);
            this.statsMap.put(name, value);
        }
    }

    protected void log(String name, Number value) {
        if (logger.isTraceEnabled()) {
            logger.trace("Monitor = {} descriptor = {} And value = {}", (Object)this.monitorName, (Object)name, (Object)value);
        }
    }

    public static class DefaultHashMap {
        private Map<String, Number> internalMap = new HashMap<String, Number>();

        public Number get(String key) {
            return this.internalMap.get(key) != null ? (Number)this.internalMap.get(key) : (Number)0;
        }

        public void put(String key, Number value) {
            this.internalMap.put(key, value);
        }

        public void clear() {
            this.internalMap.clear();
        }

        Map<String, Number> getInternalMap() {
            return this.internalMap;
        }
    }
}

