/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.util.Collections;
import java.util.Map;
import org.apache.geode.annotations.TestingOnly;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.GfshParseResult;

public class CommandRequest {
    private final byte[][] fileData;
    private final GfshParseResult parseResult;
    private final Map<String, String> env;
    private final boolean downloadFile;

    @TestingOnly
    public CommandRequest(Map<String, String> env) {
        this.env = env;
        this.fileData = null;
        this.parseResult = null;
        this.downloadFile = false;
    }

    public CommandRequest(Map<String, String> env, byte[][] fileData) {
        this.env = env;
        this.fileData = fileData;
        this.parseResult = null;
        this.downloadFile = false;
    }

    public CommandRequest(GfshParseResult parseResult, Map<String, String> env, byte[][] fileData) {
        assert (parseResult != null) : "The Gfsh ParseResult cannot be null!";
        assert (env != null) : "The reference to the Gfsh CLI environment cannot be null!";
        this.env = env;
        this.fileData = fileData;
        this.parseResult = parseResult;
        CliMetaData metaData = parseResult.getMethod().getDeclaredAnnotation(CliMetaData.class);
        this.downloadFile = metaData != null && metaData.isFileDownloadOverHttp();
    }

    public boolean isDownloadFile() {
        return this.downloadFile;
    }

    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this.env);
    }

    public byte[][] getFileData() {
        return this.fileData;
    }

    public boolean hasFileData() {
        return this.getFileData() != null;
    }

    protected GfshParseResult getParseResult() {
        return this.parseResult;
    }

    public String getUserInput() {
        return this.getParseResult().getUserInput();
    }

    @TestingOnly
    public Map<String, String> getParameters() {
        return this.getParseResult().getParamValueStrings();
    }
}

