/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.shell.event.ParseResult;

public class GfshParseResult
extends ParseResult {
    private String userInput;
    private String commandName;
    private Map<String, String> paramValueStringMap = new HashMap<String, String>();

    protected GfshParseResult(Method method, Object instance, Object[] arguments, String userInput) {
        super(method, instance, arguments);
        this.userInput = userInput.trim();
        CliCommand cliCommand = method.getAnnotation(CliCommand.class);
        this.commandName = cliCommand.value()[0];
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (arguments == null) {
            return;
        }
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            if (argument == null) continue;
            CliOption cliOption = this.getCliOption(parameterAnnotations, i);
            String argumentAsString = argument instanceof Object[] ? StringUtils.join((Object[])((Object[])argument), (String)",") : argument.toString();
            this.paramValueStringMap.put(cliOption.key()[0], argumentAsString);
        }
    }

    public String getUserInput() {
        return this.userInput;
    }

    public String getParamValue(String param) {
        return this.paramValueStringMap.get(param);
    }

    public Map<String, String> getParamValueStrings() {
        return Collections.unmodifiableMap(this.paramValueStringMap);
    }

    public String getCommandName() {
        return this.commandName;
    }

    private CliOption getCliOption(Annotation[][] parameterAnnotations, int index) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = parameterAnnotations[index]) {
            if (!(annotation instanceof CliOption)) continue;
            return (CliOption)annotation;
        }
        return null;
    }
}

